/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class ShapeDetector {
    private final Predicate<ShapeDetectorBlock>[][][] pattern;
    private final int depth;
    private final int height;
    private final int width;

    public ShapeDetector(Predicate<ShapeDetectorBlock>[][][] var0) {
        this.pattern = var0;
        this.depth = var0.length;
        if (this.depth > 0) {
            this.height = var0[0].length;
            this.width = this.height > 0 ? var0[0][0].length : 0;
        } else {
            this.height = 0;
            this.width = 0;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @VisibleForTesting
    public Predicate<ShapeDetectorBlock>[][][] getPattern() {
        return this.pattern;
    }

    @Nullable
    @VisibleForTesting
    public ShapeDetectorCollection matches(IWorldReader var0, BlockPosition var1, EnumDirection var2, EnumDirection var3) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> var4 = ShapeDetector.createLevelCache(var0, false);
        return this.matches(var1, var2, var3, var4);
    }

    @Nullable
    private ShapeDetectorCollection matches(BlockPosition var0, EnumDirection var1, EnumDirection var2, LoadingCache<BlockPosition, ShapeDetectorBlock> var3) {
        for (int var4 = 0; var4 < this.width; ++var4) {
            for (int var5 = 0; var5 < this.height; ++var5) {
                for (int var6 = 0; var6 < this.depth; ++var6) {
                    if (this.pattern[var6][var5][var4].test((ShapeDetectorBlock)var3.getUnchecked((Object)ShapeDetector.translateAndRotate(var0, var1, var2, var4, var5, var6)))) continue;
                    return null;
                }
            }
        }
        return new ShapeDetectorCollection(var0, var1, var2, var3, this.width, this.height, this.depth);
    }

    @Nullable
    public ShapeDetectorCollection find(IWorldReader var0, BlockPosition var1) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> var2 = ShapeDetector.createLevelCache(var0, false);
        int var3 = Math.max(Math.max(this.width, this.height), this.depth);
        for (BlockPosition var5 : BlockPosition.betweenClosed(var1, var1.offset(var3 - 1, var3 - 1, var3 - 1))) {
            for (EnumDirection var9 : EnumDirection.values()) {
                for (EnumDirection var13 : EnumDirection.values()) {
                    ShapeDetectorCollection var14;
                    if (var13 == var9 || var13 == var9.getOpposite() || (var14 = this.matches(var5, var9, var13, var2)) == null) continue;
                    return var14;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPosition, ShapeDetectorBlock> createLevelCache(IWorldReader var0, boolean var1) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockLoader(var0, var1));
    }

    protected static BlockPosition translateAndRotate(BlockPosition var0, EnumDirection var1, EnumDirection var2, int var3, int var4, int var5) {
        if (var1 == var2 || var1 == var2.getOpposite()) {
            throw new IllegalArgumentException("Invalid forwards & up combination");
        }
        BaseBlockPosition var6 = new BaseBlockPosition(var1.getStepX(), var1.getStepY(), var1.getStepZ());
        BaseBlockPosition var7 = new BaseBlockPosition(var2.getStepX(), var2.getStepY(), var2.getStepZ());
        BaseBlockPosition var8 = var6.cross(var7);
        return var0.offset(var7.getX() * -var4 + var8.getX() * var3 + var6.getX() * var5, var7.getY() * -var4 + var8.getY() * var3 + var6.getY() * var5, var7.getZ() * -var4 + var8.getZ() * var3 + var6.getZ() * var5);
    }

    public static class ShapeDetectorCollection {
        private final BlockPosition frontTopLeft;
        private final EnumDirection forwards;
        private final EnumDirection up;
        private final LoadingCache<BlockPosition, ShapeDetectorBlock> cache;
        private final int width;
        private final int height;
        private final int depth;

        public ShapeDetectorCollection(BlockPosition var0, EnumDirection var1, EnumDirection var2, LoadingCache<BlockPosition, ShapeDetectorBlock> var3, int var4, int var5, int var6) {
            this.frontTopLeft = var0;
            this.forwards = var1;
            this.up = var2;
            this.cache = var3;
            this.width = var4;
            this.height = var5;
            this.depth = var6;
        }

        public BlockPosition getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public EnumDirection getForwards() {
            return this.forwards;
        }

        public EnumDirection getUp() {
            return this.up;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public ShapeDetectorBlock getBlock(int var0, int var1, int var2) {
            return (ShapeDetectorBlock)this.cache.getUnchecked((Object)ShapeDetector.translateAndRotate(this.frontTopLeft, this.getForwards(), this.getUp(), var0, var1, var2));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.up).add("forwards", (Object)this.forwards).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }

    static class BlockLoader
    extends CacheLoader<BlockPosition, ShapeDetectorBlock> {
        private final IWorldReader level;
        private final boolean loadChunks;

        public BlockLoader(IWorldReader var0, boolean var1) {
            this.level = var0;
            this.loadChunks = var1;
        }

        public ShapeDetectorBlock load(BlockPosition var0) {
            return new ShapeDetectorBlock(this.level, var0, this.loadChunks);
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((BlockPosition)object);
        }
    }
}

