/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;

public class NoiseChunk
implements DensityFunction.a,
DensityFunction.b {
    private final NoiseSettings noiseSettings;
    final int cellCountXZ;
    final int cellCountY;
    final int cellNoiseMinY;
    private final int firstCellX;
    private final int firstCellZ;
    final int firstNoiseX;
    final int firstNoiseZ;
    final List<i> interpolators;
    final List<e> cellCaches;
    private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap preliminarySurfaceLevelCache = new Long2IntOpenHashMap();
    private final Aquifer aquifer;
    private final DensityFunction preliminarySurfaceLevel;
    private final c blockStateRule;
    private final Blender blender;
    private final g blendAlpha;
    private final g blendOffset;
    private final DensityFunctions.c beardifier;
    private long lastBlendingDataPos = ChunkCoordIntPair.INVALID_CHUNK_POS;
    private Blender.a lastBlendingOutput = new Blender.a(1.0, 0.0);
    final int noiseSizeXZ;
    final int cellWidth;
    final int cellHeight;
    boolean interpolating;
    boolean fillingCell;
    private int cellStartBlockX;
    int cellStartBlockY;
    private int cellStartBlockZ;
    int inCellX;
    int inCellY;
    int inCellZ;
    long interpolationCounter;
    long arrayInterpolationCounter;
    int arrayIndex;
    private final DensityFunction.a sliceFillingContextProvider = new DensityFunction.a(){

        @Override
        public DensityFunction.b forIndex(int var0) {
            NoiseChunk.this.cellStartBlockY = (var0 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
            ++NoiseChunk.this.interpolationCounter;
            NoiseChunk.this.inCellY = 0;
            NoiseChunk.this.arrayIndex = var0;
            return NoiseChunk.this;
        }

        @Override
        public void fillAllDirectly(double[] var0, DensityFunction var1) {
            for (int var2 = 0; var2 < NoiseChunk.this.cellCountY + 1; ++var2) {
                NoiseChunk.this.cellStartBlockY = (var2 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
                ++NoiseChunk.this.interpolationCounter;
                NoiseChunk.this.inCellY = 0;
                NoiseChunk.this.arrayIndex = var2;
                var0[var2] = var1.compute(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk forChunk(IChunkAccess var0, RandomState var1, DensityFunctions.c var2, GeneratorSettingBase var3, Aquifer.a var4, Blender var5) {
        NoiseSettings var6 = var3.noiseSettings().clampToHeightAccessor(var0);
        ChunkCoordIntPair var7 = var0.getPos();
        int var8 = 16 / var6.getCellWidth();
        return new NoiseChunk(var8, var1, var7.getMinBlockX(), var7.getMinBlockZ(), var6, var2, var3, var4, var5);
    }

    public NoiseChunk(int var0, RandomState var12, int var2, int var3, NoiseSettings var4, DensityFunctions.c var5, GeneratorSettingBase var6, Aquifer.a var7, Blender var8) {
        int var122;
        int var11;
        this.noiseSettings = var4;
        this.cellWidth = var4.getCellWidth();
        this.cellHeight = var4.getCellHeight();
        this.cellCountXZ = var0;
        this.cellCountY = MathHelper.floorDiv(var4.height(), this.cellHeight);
        this.cellNoiseMinY = MathHelper.floorDiv(var4.minY(), this.cellHeight);
        this.firstCellX = Math.floorDiv(var2, this.cellWidth);
        this.firstCellZ = Math.floorDiv(var3, this.cellWidth);
        this.interpolators = Lists.newArrayList();
        this.cellCaches = Lists.newArrayList();
        this.firstNoiseX = QuartPos.fromBlock(var2);
        this.firstNoiseZ = QuartPos.fromBlock(var3);
        this.noiseSizeXZ = QuartPos.fromBlock(var0 * this.cellWidth);
        this.blender = var8;
        this.beardifier = var5;
        this.blendAlpha = new g(new a(), false);
        this.blendOffset = new g(new b(), false);
        if (!var8.isEmpty()) {
            for (int var9 = 0; var9 <= this.noiseSizeXZ; ++var9) {
                int var10 = this.firstNoiseX + var9;
                var11 = QuartPos.toBlock(var10);
                for (var122 = 0; var122 <= this.noiseSizeXZ; ++var122) {
                    int var13 = this.firstNoiseZ + var122;
                    int var14 = QuartPos.toBlock(var13);
                    Blender.a var15 = var8.blendOffsetAndFactor(var11, var14);
                    this.blendAlpha.values[var9 + var122 * this.blendAlpha.sizeXZ] = var15.alpha();
                    this.blendOffset.values[var9 + var122 * this.blendOffset.sizeXZ] = var15.blendingOffset();
                }
            }
        } else {
            Arrays.fill(this.blendAlpha.values, 1.0);
            Arrays.fill(this.blendOffset.values, 0.0);
        }
        NoiseRouter var9 = var12.router();
        NoiseRouter var10 = var9.mapAll(this::wrap);
        this.preliminarySurfaceLevel = var10.preliminarySurfaceLevel();
        if (!var6.isAquifersEnabled()) {
            this.aquifer = Aquifer.createDisabled(var7);
        } else {
            var11 = SectionPosition.blockToSectionCoord(var2);
            var122 = SectionPosition.blockToSectionCoord(var3);
            this.aquifer = Aquifer.create(this, new ChunkCoordIntPair(var11, var122), var10, var12.aquiferRandom(), var4.minY(), var4.height(), var7);
        }
        ArrayList<c> var112 = new ArrayList<c>();
        DensityFunction var123 = DensityFunctions.cacheAllInCell(DensityFunctions.add(var10.finalDensity(), DensityFunctions.b.INSTANCE)).mapAll(this::wrap);
        var112.add(var1 -> this.aquifer.computeSubstance(var1, var123.compute(var1)));
        if (var6.oreVeinsEnabled()) {
            var112.add(OreVeinifier.create(var10.veinToggle(), var10.veinRidged(), var10.veinGap(), var12.oreRandom()));
        }
        this.blockStateRule = new MaterialRuleList(var112.toArray(new c[0]));
    }

    protected Climate.Sampler cachedClimateSampler(NoiseRouter var0, List<Climate.d> var1) {
        return new Climate.Sampler(var0.temperature().mapAll(this::wrap), var0.vegetation().mapAll(this::wrap), var0.continents().mapAll(this::wrap), var0.erosion().mapAll(this::wrap), var0.depth().mapAll(this::wrap), var0.ridges().mapAll(this::wrap), var1);
    }

    @Nullable
    protected IBlockData getInterpolatedState() {
        return this.blockStateRule.calculate(this);
    }

    @Override
    public int blockX() {
        return this.cellStartBlockX + this.inCellX;
    }

    @Override
    public int blockY() {
        return this.cellStartBlockY + this.inCellY;
    }

    @Override
    public int blockZ() {
        return this.cellStartBlockZ + this.inCellZ;
    }

    public int maxPreliminarySurfaceLevel(int var0, int var1, int var2, int var3) {
        int var4 = Integer.MIN_VALUE;
        for (int var5 = var1; var5 <= var3; var5 += 4) {
            for (int var6 = var0; var6 <= var2; var6 += 4) {
                int var7 = this.preliminarySurfaceLevel(var6, var5);
                if (var7 <= var4) continue;
                var4 = var7;
            }
        }
        return var4;
    }

    public int preliminarySurfaceLevel(int var0, int var1) {
        int var2 = QuartPos.toBlock(QuartPos.fromBlock(var0));
        int var3 = QuartPos.toBlock(QuartPos.fromBlock(var1));
        return this.preliminarySurfaceLevelCache.computeIfAbsent(BlockPosition2D.asLong(var2, var3), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long var0) {
        int var2 = BlockPosition2D.getX(var0);
        int var3 = BlockPosition2D.getZ(var0);
        return MathHelper.floor(this.preliminarySurfaceLevel.compute(new DensityFunction.e(var2, 0, var3)));
    }

    @Override
    public Blender getBlender() {
        return this.blender;
    }

    private void fillSlice(boolean var0, int var1) {
        this.cellStartBlockX = var1 * this.cellWidth;
        this.inCellX = 0;
        for (int var2 = 0; var2 < this.cellCountXZ + 1; ++var2) {
            int var3 = this.firstCellZ + var2;
            this.cellStartBlockZ = var3 * this.cellWidth;
            this.inCellZ = 0;
            ++this.arrayInterpolationCounter;
            for (i var5 : this.interpolators) {
                double[] var6 = (var0 ? var5.slice0 : var5.slice1)[var2];
                var5.fillArray(var6, this.sliceFillingContextProvider);
            }
        }
        ++this.arrayInterpolationCounter;
    }

    public void initializeForFirstCellX() {
        if (this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = true;
        this.interpolationCounter = 0L;
        this.fillSlice(true, this.firstCellX);
    }

    public void advanceCellX(int var0) {
        this.fillSlice(false, this.firstCellX + var0 + 1);
        this.cellStartBlockX = (this.firstCellX + var0) * this.cellWidth;
    }

    @Override
    public NoiseChunk forIndex(int var0) {
        int var1 = Math.floorMod(var0, this.cellWidth);
        int var2 = Math.floorDiv(var0, this.cellWidth);
        int var3 = Math.floorMod(var2, this.cellWidth);
        int var4 = this.cellHeight - 1 - Math.floorDiv(var2, this.cellWidth);
        this.inCellX = var3;
        this.inCellY = var4;
        this.inCellZ = var1;
        this.arrayIndex = var0;
        return this;
    }

    @Override
    public void fillAllDirectly(double[] var0, DensityFunction var1) {
        this.arrayIndex = 0;
        for (int var2 = this.cellHeight - 1; var2 >= 0; --var2) {
            this.inCellY = var2;
            for (int var3 = 0; var3 < this.cellWidth; ++var3) {
                this.inCellX = var3;
                int var4 = 0;
                while (var4 < this.cellWidth) {
                    this.inCellZ = var4++;
                    var0[this.arrayIndex++] = var1.compute(this);
                }
            }
        }
    }

    public void selectCellYZ(int var0, int var1) {
        for (i i2 : this.interpolators) {
            i2.selectCellYZ(var0, var1);
        }
        this.fillingCell = true;
        this.cellStartBlockY = (var0 + this.cellNoiseMinY) * this.cellHeight;
        this.cellStartBlockZ = (this.firstCellZ + var1) * this.cellWidth;
        ++this.arrayInterpolationCounter;
        for (e e2 : this.cellCaches) {
            e2.noiseFiller.fillArray(e2.values, this);
        }
        ++this.arrayInterpolationCounter;
        this.fillingCell = false;
    }

    public void updateForY(int var0, double var1) {
        this.inCellY = var0 - this.cellStartBlockY;
        for (i var4 : this.interpolators) {
            var4.updateForY(var1);
        }
    }

    public void updateForX(int var0, double var1) {
        this.inCellX = var0 - this.cellStartBlockX;
        for (i var4 : this.interpolators) {
            var4.updateForX(var1);
        }
    }

    public void updateForZ(int var0, double var1) {
        this.inCellZ = var0 - this.cellStartBlockZ;
        ++this.interpolationCounter;
        for (i var4 : this.interpolators) {
            var4.updateForZ(var1);
        }
    }

    public void stopInterpolation() {
        if (!this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = false;
    }

    public void swapSlices() {
        this.interpolators.forEach(i::swapSlices);
    }

    public Aquifer aquifer() {
        return this.aquifer;
    }

    protected int cellWidth() {
        return this.cellWidth;
    }

    protected int cellHeight() {
        return this.cellHeight;
    }

    Blender.a getOrComputeBlendingOutput(int var0, int var1) {
        Blender.a var4;
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        if (this.lastBlendingDataPos == var2) {
            return this.lastBlendingOutput;
        }
        this.lastBlendingDataPos = var2;
        this.lastBlendingOutput = var4 = this.blender.blendOffsetAndFactor(var0, var1);
        return var4;
    }

    protected DensityFunction wrap(DensityFunction var0) {
        return this.wrapped.computeIfAbsent(var0, this::wrapNew);
    }

    private DensityFunction wrapNew(DensityFunction var0) {
        if (var0 instanceof DensityFunctions.m) {
            DensityFunctions.m var1 = (DensityFunctions.m)var0;
            return switch (var1.type()) {
                default -> throw new MatchException(null, null);
                case DensityFunctions.m.a.Interpolated -> new i(var1.wrapped());
                case DensityFunctions.m.a.FlatCache -> new g(var1.wrapped(), true);
                case DensityFunctions.m.a.Cache2D -> new d(var1.wrapped());
                case DensityFunctions.m.a.CacheOnce -> new f(var1.wrapped());
                case DensityFunctions.m.a.CacheAllInCell -> new e(var1.wrapped());
            };
        }
        if (this.blender != Blender.empty()) {
            if (var0 == DensityFunctions.d.INSTANCE) {
                return this.blendAlpha;
            }
            if (var0 == DensityFunctions.f.INSTANCE) {
                return this.blendOffset;
            }
        }
        if (var0 == DensityFunctions.b.INSTANCE) {
            return this.beardifier;
        }
        if (var0 instanceof DensityFunctions.k) {
            DensityFunctions.k var1 = (DensityFunctions.k)var0;
            return var1.function().value();
        }
        return var0;
    }

    @Override
    public /* synthetic */ DensityFunction.b forIndex(int n2) {
        return this.forIndex(n2);
    }

    class g
    implements DensityFunctions.n,
    h {
        private final DensityFunction noiseFiller;
        final double[] values;
        final int sizeXZ;

        g(DensityFunction var1, boolean var2) {
            this.noiseFiller = var1;
            this.sizeXZ = NoiseChunk.this.noiseSizeXZ + 1;
            this.values = new double[this.sizeXZ * this.sizeXZ];
            if (var2) {
                for (int var3 = 0; var3 <= NoiseChunk.this.noiseSizeXZ; ++var3) {
                    int var4 = NoiseChunk.this.firstNoiseX + var3;
                    int var5 = QuartPos.toBlock(var4);
                    for (int var6 = 0; var6 <= NoiseChunk.this.noiseSizeXZ; ++var6) {
                        int var7 = NoiseChunk.this.firstNoiseZ + var6;
                        int var8 = QuartPos.toBlock(var7);
                        this.values[var3 + var6 * this.sizeXZ] = var1.compute(new DensityFunction.e(var5, 0, var8));
                    }
                }
            }
        }

        @Override
        public double compute(DensityFunction.b var0) {
            int var1 = QuartPos.fromBlock(var0.blockX());
            int var2 = QuartPos.fromBlock(var0.blockZ());
            int var3 = var1 - NoiseChunk.this.firstNoiseX;
            int var4 = var2 - NoiseChunk.this.firstNoiseZ;
            if (var3 >= 0 && var4 >= 0 && var3 < this.sizeXZ && var4 < this.sizeXZ) {
                return this.values[var3 + var4 * this.sizeXZ];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.m.a type() {
            return DensityFunctions.m.a.FlatCache;
        }
    }

    class a
    implements h {
        a() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.d.INSTANCE;
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return this.wrapped().mapAll(var0);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).alpha();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.d.CODEC;
        }
    }

    class b
    implements h {
        b() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.f.INSTANCE;
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return this.wrapped().mapAll(var0);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).blendingOffset();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return DensityFunctions.f.CODEC;
        }
    }

    @FunctionalInterface
    public static interface c {
        @Nullable
        public IBlockData calculate(DensityFunction.b var1);
    }

    public class i
    implements DensityFunctions.n,
    h {
        double[][] slice0;
        double[][] slice1;
        private final DensityFunction noiseFiller;
        private double noise000;
        private double noise001;
        private double noise100;
        private double noise101;
        private double noise010;
        private double noise011;
        private double noise110;
        private double noise111;
        private double valueXZ00;
        private double valueXZ10;
        private double valueXZ01;
        private double valueXZ11;
        private double valueZ0;
        private double valueZ1;
        private double value;

        i(DensityFunction var1) {
            this.noiseFiller = var1;
            this.slice0 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            this.slice1 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            NoiseChunk.this.interpolators.add(this);
        }

        private double[][] allocateSlice(int var0, int var1) {
            int var2 = var1 + 1;
            int var3 = var0 + 1;
            double[][] var4 = new double[var2][var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                var4[var5] = new double[var3];
            }
            return var4;
        }

        void selectCellYZ(int var0, int var1) {
            this.noise000 = this.slice0[var1][var0];
            this.noise001 = this.slice0[var1 + 1][var0];
            this.noise100 = this.slice1[var1][var0];
            this.noise101 = this.slice1[var1 + 1][var0];
            this.noise010 = this.slice0[var1][var0 + 1];
            this.noise011 = this.slice0[var1 + 1][var0 + 1];
            this.noise110 = this.slice1[var1][var0 + 1];
            this.noise111 = this.slice1[var1 + 1][var0 + 1];
        }

        void updateForY(double var0) {
            this.valueXZ00 = MathHelper.lerp(var0, this.noise000, this.noise010);
            this.valueXZ10 = MathHelper.lerp(var0, this.noise100, this.noise110);
            this.valueXZ01 = MathHelper.lerp(var0, this.noise001, this.noise011);
            this.valueXZ11 = MathHelper.lerp(var0, this.noise101, this.noise111);
        }

        void updateForX(double var0) {
            this.valueZ0 = MathHelper.lerp(var0, this.valueXZ00, this.valueXZ10);
            this.valueZ1 = MathHelper.lerp(var0, this.valueXZ01, this.valueXZ11);
        }

        void updateForZ(double var0) {
            this.value = MathHelper.lerp(var0, this.valueZ0, this.valueZ1);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            if (NoiseChunk.this.fillingCell) {
                return MathHelper.lerp3((double)NoiseChunk.this.inCellX / (double)NoiseChunk.this.cellWidth, (double)NoiseChunk.this.inCellY / (double)NoiseChunk.this.cellHeight, (double)NoiseChunk.this.inCellZ / (double)NoiseChunk.this.cellWidth, this.noise000, this.noise100, this.noise010, this.noise110, this.noise001, this.noise101, this.noise011, this.noise111);
            }
            return this.value;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            if (NoiseChunk.this.fillingCell) {
                var1.fillAllDirectly(var0, this);
                return;
            }
            this.wrapped().fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        private void swapSlices() {
            double[][] var0 = this.slice0;
            this.slice0 = this.slice1;
            this.slice1 = var0;
        }

        @Override
        public DensityFunctions.m.a type() {
            return DensityFunctions.m.a.Interpolated;
        }
    }

    class e
    implements DensityFunctions.n,
    h {
        final DensityFunction noiseFiller;
        final double[] values;

        e(DensityFunction var1) {
            this.noiseFiller = var1;
            this.values = new double[NoiseChunk.this.cellWidth * NoiseChunk.this.cellWidth * NoiseChunk.this.cellHeight];
            NoiseChunk.this.cellCaches.add(this);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int var1 = NoiseChunk.this.inCellX;
            int var2 = NoiseChunk.this.inCellY;
            int var3 = NoiseChunk.this.inCellZ;
            if (var1 >= 0 && var2 >= 0 && var3 >= 0 && var1 < NoiseChunk.this.cellWidth && var2 < NoiseChunk.this.cellHeight && var3 < NoiseChunk.this.cellWidth) {
                return this.values[((NoiseChunk.this.cellHeight - 1 - var2) * NoiseChunk.this.cellWidth + var1) * NoiseChunk.this.cellWidth + var3];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.m.a type() {
            return DensityFunctions.m.a.CacheAllInCell;
        }
    }

    static class d
    implements DensityFunctions.n,
    h {
        private final DensityFunction function;
        private long lastPos2D = ChunkCoordIntPair.INVALID_CHUNK_POS;
        private double lastValue;

        d(DensityFunction var0) {
            this.function = var0;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            double var5;
            int var2;
            int var1 = var0.blockX();
            long var3 = ChunkCoordIntPair.asLong(var1, var2 = var0.blockZ());
            if (this.lastPos2D == var3) {
                return this.lastValue;
            }
            this.lastPos2D = var3;
            this.lastValue = var5 = this.function.compute(var0);
            return var5;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.function.fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.m.a type() {
            return DensityFunctions.m.a.Cache2D;
        }
    }

    class f
    implements DensityFunctions.n,
    h {
        private final DensityFunction function;
        private long lastCounter;
        private long lastArrayCounter;
        private double lastValue;
        @Nullable
        private double[] lastArray;

        f(DensityFunction var1) {
            this.function = var1;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            double var1;
            if (var0 != NoiseChunk.this) {
                return this.function.compute(var0);
            }
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                return this.lastArray[NoiseChunk.this.arrayIndex];
            }
            if (this.lastCounter == NoiseChunk.this.interpolationCounter) {
                return this.lastValue;
            }
            this.lastCounter = NoiseChunk.this.interpolationCounter;
            this.lastValue = var1 = this.function.compute(var0);
            return var1;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                System.arraycopy(this.lastArray, 0, var0, 0, var0.length);
                return;
            }
            this.wrapped().fillArray(var0, var1);
            if (this.lastArray != null && this.lastArray.length == var0.length) {
                System.arraycopy(var0, 0, this.lastArray, 0, var0.length);
            } else {
                this.lastArray = (double[])var0.clone();
            }
            this.lastArrayCounter = NoiseChunk.this.arrayInterpolationCounter;
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.m.a type() {
            return DensityFunctions.m.a.CacheOnce;
        }
    }

    static interface h
    extends DensityFunction {
        public DensityFunction wrapped();

        @Override
        default public double minValue() {
            return this.wrapped().minValue();
        }

        @Override
        default public double maxValue() {
            return this.wrapped().maxValue();
        }
    }
}

