/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public class WorldGenFeatureEndPlatform
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final BlockPosition PLATFORM_OFFSET = new BlockPosition(8, 3, 8);
    private static final ChunkCoordIntPair PLATFORM_ORIGIN_CHUNK = new ChunkCoordIntPair(PLATFORM_OFFSET);
    private static final int PLATFORM_RADIUS = 16;
    private static final int PLATFORM_RADIUS_CHUNKS = 1;

    public WorldGenFeatureEndPlatform(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    private static int checkerboardDistance(int var0, int var1, int var2, int var3) {
        return Math.max(Math.abs(var0 - var2), Math.abs(var1 - var3));
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var0.origin());
        if (WorldGenFeatureEndPlatform.checkerboardDistance(var2.x, var2.z, WorldGenFeatureEndPlatform.PLATFORM_ORIGIN_CHUNK.x, WorldGenFeatureEndPlatform.PLATFORM_ORIGIN_CHUNK.z) > 1) {
            return true;
        }
        BlockPosition var3 = PLATFORM_OFFSET.atY(var0.origin().getY() + PLATFORM_OFFSET.getY());
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (int var5 = var2.getMinBlockZ(); var5 <= var2.getMaxBlockZ(); ++var5) {
            for (int var6 = var2.getMinBlockX(); var6 <= var2.getMaxBlockX(); ++var6) {
                if (WorldGenFeatureEndPlatform.checkerboardDistance(var3.getX(), var3.getZ(), var6, var5) > 16) continue;
                var4.set(var6, var3.getY(), var5);
                if (var4.equals(var3)) {
                    var1.setBlock(var4, Blocks.COBBLESTONE.defaultBlockState(), 2);
                    continue;
                }
                var1.setBlock(var4, Blocks.STONE.defaultBlockState(), 2);
            }
        }
        return true;
    }
}

