/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class CreakingHeartDecorator
extends WorldGenFeatureTree {
    public static final MapCodec<CreakingHeartDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CreakingHeartDecorator::new, var0 -> Float.valueOf(var0.probability));
    private final float probability;

    public CreakingHeartDecorator(float var0) {
        this.probability = var0;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.CREAKING_HEART;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        RandomSource var12 = var0.random();
        ObjectArrayList<BlockPosition> var2 = var0.logs();
        if (var2.isEmpty()) {
            return;
        }
        if (var12.nextFloat() >= this.probability) {
            return;
        }
        ArrayList<BlockPosition> var3 = new ArrayList<BlockPosition>((Collection<BlockPosition>)var2);
        SystemUtils.shuffle(var3, var12);
        Optional<BlockPosition> var4 = var3.stream().filter(var1 -> {
            for (EnumDirection var5 : EnumDirection.values()) {
                if (var0.checkBlock(var1.relative(var5), var0 -> var0.is(TagsBlock.LOGS))) continue;
                return false;
            }
            return true;
        }).findFirst();
        if (var4.isEmpty()) {
            return;
        }
        var0.setBlock(var4.get(), (IBlockData)((IBlockData)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.STATE, CreakingHeartState.DORMANT)).setValue(CreakingHeartBlock.NATURAL, true));
    }
}

