/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressPieces;

public class NetherFortressStructure
extends Structure {
    public static final WeightedList<BiomeSettingsMobs.c> FORTRESS_ENEMIES = WeightedList.builder().add(new BiomeSettingsMobs.c(EntityTypes.BLAZE, 2, 3), 10).add(new BiomeSettingsMobs.c(EntityTypes.ZOMBIFIED_PIGLIN, 4, 4), 5).add(new BiomeSettingsMobs.c(EntityTypes.WITHER_SKELETON, 5, 5), 8).add(new BiomeSettingsMobs.c(EntityTypes.SKELETON, 5, 5), 2).add(new BiomeSettingsMobs.c(EntityTypes.MAGMA_CUBE, 4, 4), 3).build();
    public static final MapCodec<NetherFortressStructure> CODEC = NetherFortressStructure.simpleCodec(NetherFortressStructure::new);

    public NetherFortressStructure(Structure.c var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        ChunkCoordIntPair var12 = var0.chunkPos();
        BlockPosition var2 = new BlockPosition(var12.getMinBlockX(), 64, var12.getMinBlockZ());
        return Optional.of(new Structure.b(var2, var1 -> NetherFortressStructure.generatePieces(var1, var0)));
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        NetherFortressPieces.q var2 = new NetherFortressPieces.q(var1.random(), var1.chunkPos().getBlockX(2), var1.chunkPos().getBlockZ(2));
        var0.addPiece(var2);
        var2.addChildren(var2, var0, var1.random());
        List<StructurePiece> var3 = var2.pendingChildren;
        while (!var3.isEmpty()) {
            int var4 = var1.random().nextInt(var3.size());
            StructurePiece var5 = var3.remove(var4);
            var5.addChildren(var2, var0, var1.random());
        }
        var0.moveInsideHeights(var1.random(), 48, 70);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.FORTRESS;
    }
}

