/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;

public class OceanMonumentStructure
extends Structure {
    public static final MapCodec<OceanMonumentStructure> CODEC = OceanMonumentStructure.simpleCodec(OceanMonumentStructure::new);

    public OceanMonumentStructure(Structure.c var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        int var12 = var0.chunkPos().getBlockX(9);
        int var2 = var0.chunkPos().getBlockZ(9);
        Set<Holder<BiomeBase>> var3 = var0.biomeSource().getBiomesWithin(var12, var0.chunkGenerator().getSeaLevel(), var2, 29, var0.randomState().sampler());
        for (Holder<BiomeBase> var5 : var3) {
            if (var5.is(BiomeTags.REQUIRED_OCEAN_MONUMENT_SURROUNDING)) continue;
            return Optional.empty();
        }
        return OceanMonumentStructure.onTopOfChunkCenter(var0, HeightMap.Type.OCEAN_FLOOR_WG, var1 -> OceanMonumentStructure.generatePieces(var1, var0));
    }

    private static StructurePiece createTopPiece(ChunkCoordIntPair var0, SeededRandom var1) {
        int var2 = var0.getMinBlockX() - 29;
        int var3 = var0.getMinBlockZ() - 29;
        EnumDirection var4 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var1);
        return new OceanMonumentPieces.h(var1, var2, var3, var4);
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        var0.addPiece(OceanMonumentStructure.createTopPiece(var1.chunkPos(), var1.random()));
    }

    public static PiecesContainer regeneratePiecesAfterLoad(ChunkCoordIntPair var0, long var1, PiecesContainer var3) {
        if (var3.isEmpty()) {
            return var3;
        }
        SeededRandom var4 = new SeededRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        var4.setLargeFeatureSeed(var1, var0.x, var0.z);
        StructurePiece var5 = var3.pieces().get(0);
        StructureBoundingBox var6 = var5.getBoundingBox();
        int var7 = var6.minX();
        int var8 = var6.minZ();
        EnumDirection var9 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var4);
        EnumDirection var10 = Objects.requireNonNullElse(var5.getOrientation(), var9);
        OceanMonumentPieces.h var11 = new OceanMonumentPieces.h(var4, var7, var8, var10);
        StructurePiecesBuilder var12 = new StructurePiecesBuilder();
        var12.addPiece(var11);
        return var12.build();
    }

    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_MONUMENT;
    }
}

