/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PosRuleTestLinear
extends PosRuleTest {
    public static final MapCodec<PosRuleTestLinear> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.minChance)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.maxChance)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(var0 -> var0.minDist), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(var0 -> var0.maxDist)).apply((Applicative)var02, PosRuleTestLinear::new));
    private final float minChance;
    private final float maxChance;
    private final int minDist;
    private final int maxDist;

    public PosRuleTestLinear(float var0, float var1, int var2, int var3) {
        if (var2 >= var3) {
            throw new IllegalArgumentException("Invalid range: [" + var2 + "," + var3 + "]");
        }
        this.minChance = var0;
        this.maxChance = var1;
        this.minDist = var2;
        this.maxDist = var3;
    }

    @Override
    public boolean test(BlockPosition var0, BlockPosition var1, BlockPosition var2, RandomSource var3) {
        int var4 = var1.distManhattan(var2);
        float var5 = var3.nextFloat();
        return var5 <= MathHelper.clampedLerp(this.minChance, this.maxChance, MathHelper.inverseLerp(var4, this.minDist, this.maxDist));
    }

    @Override
    protected PosRuleTestType<?> getType() {
        return PosRuleTestType.LINEAR_POS_TEST;
    }
}

