/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentCommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, a> namespaces = new HashMap<String, a>();
    private final WorldPersistentData storage;

    public PersistentCommandStorage(WorldPersistentData var0) {
        this.storage = var0;
    }

    public NBTTagCompound get(MinecraftKey var0) {
        a var1 = this.getContainer(var0.getNamespace());
        if (var1 != null) {
            return var1.get(var0.getPath());
        }
        return new NBTTagCompound();
    }

    @Nullable
    private a getContainer(String var0) {
        a var1 = this.namespaces.get(var0);
        if (var1 != null) {
            return var1;
        }
        a var2 = this.storage.get(a.type(var0));
        if (var2 != null) {
            this.namespaces.put(var0, var2);
        }
        return var2;
    }

    private a getOrCreateContainer(String var0) {
        a var1 = this.namespaces.get(var0);
        if (var1 != null) {
            return var1;
        }
        a var2 = this.storage.computeIfAbsent(a.type(var0));
        this.namespaces.put(var0, var2);
        return var2;
    }

    public void set(MinecraftKey var0, NBTTagCompound var1) {
        this.getOrCreateContainer(var0.getNamespace()).put(var0.getPath(), var1);
    }

    public Stream<MinecraftKey> keys() {
        return this.namespaces.entrySet().stream().flatMap(var0 -> ((a)var0.getValue()).getKeys((String)var0.getKey()));
    }

    static String createId(String var0) {
        return ID_PREFIX + var0;
    }

    static class a
    extends PersistentBase {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.unboundedMap(ExtraCodecs.RESOURCE_PATH_CODEC, NBTTagCompound.CODEC).fieldOf("contents").forGetter(var0 -> var0.storage)).apply((Applicative)var02, a::new));
        private final Map<String, NBTTagCompound> storage;

        private a(Map<String, NBTTagCompound> var0) {
            this.storage = new HashMap<String, NBTTagCompound>(var0);
        }

        private a() {
            this(new HashMap<String, NBTTagCompound>());
        }

        public static SavedDataType<a> type(String var0) {
            return new SavedDataType<a>(PersistentCommandStorage.createId(var0), a::new, CODEC, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        }

        public NBTTagCompound get(String var0) {
            NBTTagCompound var1 = this.storage.get(var0);
            return var1 != null ? var1 : new NBTTagCompound();
        }

        public void put(String var0, NBTTagCompound var1) {
            if (var1.isEmpty()) {
                this.storage.remove(var0);
            } else {
                this.storage.put(var0, var1);
            }
            this.setDirty();
        }

        public Stream<MinecraftKey> getKeys(String var0) {
            return this.storage.keySet().stream().map(var1 -> MinecraftKey.fromNamespaceAndPath(var0, var1));
        }
    }
}

