/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record UniformGenerator(NumberProvider min, NumberProvider max) implements NumberProvider
{
    public static final MapCodec<UniformGenerator> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)NumberProviders.CODEC.fieldOf("min").forGetter(UniformGenerator::min), (App)NumberProviders.CODEC.fieldOf("max").forGetter(UniformGenerator::max)).apply((Applicative)var0, UniformGenerator::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.UNIFORM;
    }

    public static UniformGenerator between(float var0, float var1) {
        return new UniformGenerator(ConstantValue.exactly(var0), ConstantValue.exactly(var1));
    }

    @Override
    public int getInt(LootTableInfo var0) {
        return MathHelper.nextInt(var0.getRandom(), this.min.getInt(var0), this.max.getInt(var0));
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        return MathHelper.nextFloat(var0.getRandom(), this.min.getFloat(var0), this.max.getFloat(var0));
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Sets.union(this.min.getReferencedContextParams(), this.max.getReferencedContextParams());
    }
}

