/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2F;
import org.joml.Vector3f;

public class Vec3D
implements IPosition {
    public static final Codec<Vec3D> CODEC = Codec.DOUBLE.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new Vec3D((Double)var0.get(0), (Double)var0.get(1), (Double)var0.get(2))), var0 -> List.of(Double.valueOf(var0.x()), Double.valueOf(var0.y()), Double.valueOf(var0.z())));
    public static final StreamCodec<ByteBuf, Vec3D> STREAM_CODEC = new StreamCodec<ByteBuf, Vec3D>(){

        @Override
        public Vec3D decode(ByteBuf var0) {
            return PacketDataSerializer.readVec3(var0);
        }

        @Override
        public void encode(ByteBuf var0, Vec3D var1) {
            PacketDataSerializer.writeVec3(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vec3D)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final Vec3D ZERO = new Vec3D(0.0, 0.0, 0.0);
    public static final Vec3D X_AXIS = new Vec3D(1.0, 0.0, 0.0);
    public static final Vec3D Y_AXIS = new Vec3D(0.0, 1.0, 0.0);
    public static final Vec3D Z_AXIS = new Vec3D(0.0, 0.0, 1.0);
    public final double x;
    public final double y;
    public final double z;

    public static Vec3D fromRGB24(int var0) {
        double var1 = (double)(var0 >> 16 & 0xFF) / 255.0;
        double var3 = (double)(var0 >> 8 & 0xFF) / 255.0;
        double var5 = (double)(var0 & 0xFF) / 255.0;
        return new Vec3D(var1, var3, var5);
    }

    public static Vec3D atLowerCornerOf(BaseBlockPosition var0) {
        return new Vec3D(var0.getX(), var0.getY(), var0.getZ());
    }

    public static Vec3D atLowerCornerWithOffset(BaseBlockPosition var0, double var1, double var3, double var5) {
        return new Vec3D((double)var0.getX() + var1, (double)var0.getY() + var3, (double)var0.getZ() + var5);
    }

    public static Vec3D atCenterOf(BaseBlockPosition var0) {
        return Vec3D.atLowerCornerWithOffset(var0, 0.5, 0.5, 0.5);
    }

    public static Vec3D atBottomCenterOf(BaseBlockPosition var0) {
        return Vec3D.atLowerCornerWithOffset(var0, 0.5, 0.0, 0.5);
    }

    public static Vec3D upFromBottomCenterOf(BaseBlockPosition var0, double var1) {
        return Vec3D.atLowerCornerWithOffset(var0, 0.5, var1, 0.5);
    }

    public Vec3D(double var0, double var2, double var4) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
    }

    public Vec3D(Vector3f var0) {
        this(var0.x(), var0.y(), var0.z());
    }

    public Vec3D(BaseBlockPosition var0) {
        this(var0.getX(), var0.getY(), var0.getZ());
    }

    public Vec3D vectorTo(Vec3D var0) {
        return new Vec3D(var0.x - this.x, var0.y - this.y, var0.z - this.z);
    }

    public Vec3D normalize() {
        double var0 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (var0 < (double)1.0E-5f) {
            return ZERO;
        }
        return new Vec3D(this.x / var0, this.y / var0, this.z / var0);
    }

    public double dot(Vec3D var0) {
        return this.x * var0.x + this.y * var0.y + this.z * var0.z;
    }

    public Vec3D cross(Vec3D var0) {
        return new Vec3D(this.y * var0.z - this.z * var0.y, this.z * var0.x - this.x * var0.z, this.x * var0.y - this.y * var0.x);
    }

    public Vec3D subtract(Vec3D var0) {
        return this.subtract(var0.x, var0.y, var0.z);
    }

    public Vec3D subtract(double var0) {
        return this.subtract(var0, var0, var0);
    }

    public Vec3D subtract(double var0, double var2, double var4) {
        return this.add(-var0, -var2, -var4);
    }

    public Vec3D add(double var0) {
        return this.add(var0, var0, var0);
    }

    public Vec3D add(Vec3D var0) {
        return this.add(var0.x, var0.y, var0.z);
    }

    public Vec3D add(double var0, double var2, double var4) {
        return new Vec3D(this.x + var0, this.y + var2, this.z + var4);
    }

    public boolean closerThan(IPosition var0, double var1) {
        return this.distanceToSqr(var0.x(), var0.y(), var0.z()) < var1 * var1;
    }

    public double distanceTo(Vec3D var0) {
        double var1 = var0.x - this.x;
        double var3 = var0.y - this.y;
        double var5 = var0.z - this.z;
        return Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5);
    }

    public double distanceToSqr(Vec3D var0) {
        double var1 = var0.x - this.x;
        double var3 = var0.y - this.y;
        double var5 = var0.z - this.z;
        return var1 * var1 + var3 * var3 + var5 * var5;
    }

    public double distanceToSqr(double var0, double var2, double var4) {
        double var6 = var0 - this.x;
        double var8 = var2 - this.y;
        double var10 = var4 - this.z;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public boolean closerThan(Vec3D var0, double var1, double var3) {
        double var5 = var0.x() - this.x;
        double var7 = var0.y() - this.y;
        double var9 = var0.z() - this.z;
        return MathHelper.lengthSquared(var5, var9) < MathHelper.square(var1) && Math.abs(var7) < var3;
    }

    public Vec3D scale(double var0) {
        return this.multiply(var0, var0, var0);
    }

    public Vec3D reverse() {
        return this.scale(-1.0);
    }

    public Vec3D multiply(Vec3D var0) {
        return this.multiply(var0.x, var0.y, var0.z);
    }

    public Vec3D multiply(double var0, double var2, double var4) {
        return new Vec3D(this.x * var0, this.y * var2, this.z * var4);
    }

    public Vec3D horizontal() {
        return new Vec3D(this.x, 0.0, this.z);
    }

    public Vec3D offsetRandom(RandomSource var0, float var1) {
        return this.add((var0.nextFloat() - 0.5f) * var1, (var0.nextFloat() - 0.5f) * var1, (var0.nextFloat() - 0.5f) * var1);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double horizontalDistance() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double horizontalDistanceSqr() {
        return this.x * this.x + this.z * this.z;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Vec3D)) {
            return false;
        }
        Vec3D var1 = (Vec3D)var0;
        if (Double.compare(var1.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(var1.y, this.y) != 0) {
            return false;
        }
        return Double.compare(var1.z, this.z) == 0;
    }

    public int hashCode() {
        long var1 = Double.doubleToLongBits(this.x);
        int var0 = (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.y);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.z);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        return var0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vec3D lerp(Vec3D var0, double var1) {
        return new Vec3D(MathHelper.lerp(var1, this.x, var0.x), MathHelper.lerp(var1, this.y, var0.y), MathHelper.lerp(var1, this.z, var0.z));
    }

    public Vec3D xRot(float var0) {
        float var1 = MathHelper.cos(var0);
        float var2 = MathHelper.sin(var0);
        double var3 = this.x;
        double var5 = this.y * (double)var1 + this.z * (double)var2;
        double var7 = this.z * (double)var1 - this.y * (double)var2;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D yRot(float var0) {
        float var1 = MathHelper.cos(var0);
        float var2 = MathHelper.sin(var0);
        double var3 = this.x * (double)var1 + this.z * (double)var2;
        double var5 = this.y;
        double var7 = this.z * (double)var1 - this.x * (double)var2;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D zRot(float var0) {
        float var1 = MathHelper.cos(var0);
        float var2 = MathHelper.sin(var0);
        double var3 = this.x * (double)var1 + this.y * (double)var2;
        double var5 = this.y * (double)var1 - this.x * (double)var2;
        double var7 = this.z;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D rotateClockwise90() {
        return new Vec3D(-this.z, this.y, this.x);
    }

    public static Vec3D directionFromRotation(Vec2F var0) {
        return Vec3D.directionFromRotation(var0.x, var0.y);
    }

    public static Vec3D directionFromRotation(float var0, float var1) {
        float var2 = MathHelper.cos(-var1 * ((float)Math.PI / 180) - (float)Math.PI);
        float var3 = MathHelper.sin(-var1 * ((float)Math.PI / 180) - (float)Math.PI);
        float var4 = -MathHelper.cos(-var0 * ((float)Math.PI / 180));
        float var5 = MathHelper.sin(-var0 * ((float)Math.PI / 180));
        return new Vec3D(var3 * var4, var5, var2 * var4);
    }

    public Vec3D align(EnumSet<EnumDirection.EnumAxis> var0) {
        double var1 = var0.contains(EnumDirection.EnumAxis.X) ? (double)MathHelper.floor(this.x) : this.x;
        double var3 = var0.contains(EnumDirection.EnumAxis.Y) ? (double)MathHelper.floor(this.y) : this.y;
        double var5 = var0.contains(EnumDirection.EnumAxis.Z) ? (double)MathHelper.floor(this.z) : this.z;
        return new Vec3D(var1, var3, var5);
    }

    public double get(EnumDirection.EnumAxis var0) {
        return var0.choose(this.x, this.y, this.z);
    }

    public Vec3D with(EnumDirection.EnumAxis var0, double var1) {
        double var3 = var0 == EnumDirection.EnumAxis.X ? var1 : this.x;
        double var5 = var0 == EnumDirection.EnumAxis.Y ? var1 : this.y;
        double var7 = var0 == EnumDirection.EnumAxis.Z ? var1 : this.z;
        return new Vec3D(var3, var5, var7);
    }

    public Vec3D relative(EnumDirection var0, double var1) {
        BaseBlockPosition var3 = var0.getUnitVec3i();
        return new Vec3D(this.x + var1 * (double)var3.getX(), this.y + var1 * (double)var3.getY(), this.z + var1 * (double)var3.getZ());
    }

    @Override
    public final double x() {
        return this.x;
    }

    @Override
    public final double y() {
        return this.y;
    }

    @Override
    public final double z() {
        return this.z;
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vec3D projectedOn(Vec3D var0) {
        if (var0.lengthSqr() == 0.0) {
            return var0;
        }
        return var0.scale(this.dot(var0)).scale(1.0 / var0.lengthSqr());
    }
}

