/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String HIDDEN_SCORE_PREFIX = "#";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<String, ScoreboardObjective> objectivesByName = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<IScoreboardCriteria, List<ScoreboardObjective>> objectivesByCriteria = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> playerScores = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, ScoreboardObjective> displayObjectives = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Object2ObjectMap<String, ScoreboardTeam> teamsByName = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ScoreboardTeam> teamsByPlayer = new Object2ObjectOpenHashMap();

    @Nullable
    public ScoreboardObjective getObjective(@Nullable String var0) {
        return (ScoreboardObjective)this.objectivesByName.get((Object)var0);
    }

    public ScoreboardObjective addObjective(String var02, IScoreboardCriteria var1, IChatBaseComponent var2, IScoreboardCriteria.EnumScoreboardHealthDisplay var3, boolean var4, @Nullable NumberFormat var5) {
        if (this.objectivesByName.containsKey((Object)var02)) {
            throw new IllegalArgumentException("An objective with the name '" + var02 + "' already exists!");
        }
        ScoreboardObjective var6 = new ScoreboardObjective(this, var02, var1, var2, var3, var4, var5);
        ((List)this.objectivesByCriteria.computeIfAbsent((Object)var1, var0 -> Lists.newArrayList())).add(var6);
        this.objectivesByName.put((Object)var02, (Object)var6);
        this.onObjectiveAdded(var6);
        return var6;
    }

    public final void forAllObjectives(IScoreboardCriteria var0, ScoreHolder var1, Consumer<ScoreAccess> var22) {
        ((List)this.objectivesByCriteria.getOrDefault((Object)var0, Collections.emptyList())).forEach(var2 -> var22.accept(this.getOrCreatePlayerScore(var1, (ScoreboardObjective)var2, true)));
    }

    private PlayerScores getOrCreatePlayerInfo(String var02) {
        return this.playerScores.computeIfAbsent(var02, var0 -> new PlayerScores());
    }

    public ScoreAccess getOrCreatePlayerScore(ScoreHolder var0, ScoreboardObjective var1) {
        return this.getOrCreatePlayerScore(var0, var1, false);
    }

    public ScoreAccess getOrCreatePlayerScore(final ScoreHolder var0, final ScoreboardObjective var12, boolean var2) {
        final boolean var3 = var2 || !var12.getCriteria().isReadOnly();
        PlayerScores var4 = this.getOrCreatePlayerInfo(var0.getScoreboardName());
        final MutableBoolean var5 = new MutableBoolean();
        final ScoreboardScore var6 = var4.getOrCreate(var12, var1 -> var5.setTrue());
        return new ScoreAccess(){

            @Override
            public int get() {
                return var6.value();
            }

            @Override
            public void set(int var02) {
                IChatBaseComponent var2;
                if (!var3) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean var1 = var5.isTrue();
                if (var12.displayAutoUpdate() && (var2 = var0.getDisplayName()) != null && !var2.equals(var6.display())) {
                    var6.display(var2);
                    var1 = true;
                }
                if (var02 != var6.value()) {
                    var6.value(var02);
                    var1 = true;
                }
                if (var1) {
                    this.sendScoreToPlayers();
                }
            }

            @Override
            @Nullable
            public IChatBaseComponent display() {
                return var6.display();
            }

            @Override
            public void display(@Nullable IChatBaseComponent var02) {
                if (var5.isTrue() || !Objects.equals(var02, var6.display())) {
                    var6.display(var02);
                    this.sendScoreToPlayers();
                }
            }

            @Override
            public void numberFormatOverride(@Nullable NumberFormat var02) {
                var6.numberFormat(var02);
                this.sendScoreToPlayers();
            }

            @Override
            public boolean locked() {
                return var6.isLocked();
            }

            @Override
            public void unlock() {
                this.setLocked(false);
            }

            @Override
            public void lock() {
                this.setLocked(true);
            }

            private void setLocked(boolean var02) {
                var6.setLocked(var02);
                if (var5.isTrue()) {
                    this.sendScoreToPlayers();
                }
                Scoreboard.this.onScoreLockChanged(var0, var12);
            }

            private void sendScoreToPlayers() {
                Scoreboard.this.onScoreChanged(var0, var12, var6);
                var5.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo getPlayerScoreInfo(ScoreHolder var0, ScoreboardObjective var1) {
        PlayerScores var2 = this.playerScores.get(var0.getScoreboardName());
        if (var2 != null) {
            return var2.get(var1);
        }
        return null;
    }

    public Collection<PlayerScoreEntry> listPlayerScores(ScoreboardObjective var0) {
        ArrayList<PlayerScoreEntry> var1 = new ArrayList<PlayerScoreEntry>();
        this.playerScores.forEach((var2, var3) -> {
            ScoreboardScore var4 = var3.get(var0);
            if (var4 != null) {
                var1.add(new PlayerScoreEntry((String)var2, var4.value(), var4.display(), var4.numberFormat()));
            }
        });
        return var1;
    }

    public Collection<ScoreboardObjective> getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.objectivesByName.keySet();
    }

    public Collection<ScoreHolder> getTrackedPlayers() {
        return this.playerScores.keySet().stream().map(ScoreHolder::forNameOnly).toList();
    }

    public void resetAllPlayerScores(ScoreHolder var0) {
        PlayerScores var1 = this.playerScores.remove(var0.getScoreboardName());
        if (var1 != null) {
            this.onPlayerRemoved(var0);
        }
    }

    public void resetSinglePlayerScore(ScoreHolder var0, ScoreboardObjective var1) {
        PlayerScores var2 = this.playerScores.get(var0.getScoreboardName());
        if (var2 != null) {
            boolean var3 = var2.remove(var1);
            if (!var2.hasScores()) {
                PlayerScores var4 = this.playerScores.remove(var0.getScoreboardName());
                if (var4 != null) {
                    this.onPlayerRemoved(var0);
                }
            } else if (var3) {
                this.onPlayerScoreRemoved(var0, var1);
            }
        }
    }

    public Object2IntMap<ScoreboardObjective> listPlayerScores(ScoreHolder var0) {
        PlayerScores var1 = this.playerScores.get(var0.getScoreboardName());
        return var1 != null ? var1.listScores() : Object2IntMaps.emptyMap();
    }

    public void removeObjective(ScoreboardObjective var0) {
        this.objectivesByName.remove((Object)var0.getName());
        for (DisplaySlot var4 : DisplaySlot.values()) {
            if (this.getDisplayObjective(var4) != var0) continue;
            this.setDisplayObjective(var4, null);
        }
        List var1 = (List)this.objectivesByCriteria.get((Object)var0.getCriteria());
        if (var1 != null) {
            var1.remove(var0);
        }
        for (PlayerScores var3 : this.playerScores.values()) {
            var3.remove(var0);
        }
        this.onObjectiveRemoved(var0);
    }

    public void setDisplayObjective(DisplaySlot var0, @Nullable ScoreboardObjective var1) {
        this.displayObjectives.put(var0, var1);
    }

    @Nullable
    public ScoreboardObjective getDisplayObjective(DisplaySlot var0) {
        return this.displayObjectives.get(var0);
    }

    @Nullable
    public ScoreboardTeam getPlayerTeam(String var0) {
        return (ScoreboardTeam)this.teamsByName.get((Object)var0);
    }

    public ScoreboardTeam addPlayerTeam(String var0) {
        ScoreboardTeam var1 = this.getPlayerTeam(var0);
        if (var1 != null) {
            LOGGER.warn("Requested creation of existing team '{}'", (Object)var0);
            return var1;
        }
        var1 = new ScoreboardTeam(this, var0);
        this.teamsByName.put((Object)var0, (Object)var1);
        this.onTeamAdded(var1);
        return var1;
    }

    public void removePlayerTeam(ScoreboardTeam var0) {
        this.teamsByName.remove((Object)var0.getName());
        for (String var2 : var0.getPlayers()) {
            this.teamsByPlayer.remove((Object)var2);
        }
        this.onTeamRemoved(var0);
    }

    public boolean addPlayerToTeam(String var0, ScoreboardTeam var1) {
        if (this.getPlayersTeam(var0) != null) {
            this.removePlayerFromTeam(var0);
        }
        this.teamsByPlayer.put((Object)var0, (Object)var1);
        return var1.getPlayers().add(var0);
    }

    public boolean removePlayerFromTeam(String var0) {
        ScoreboardTeam var1 = this.getPlayersTeam(var0);
        if (var1 != null) {
            this.removePlayerFromTeam(var0, var1);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String var0, ScoreboardTeam var1) {
        if (this.getPlayersTeam(var0) != var1) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + var1.getName() + "'.");
        }
        this.teamsByPlayer.remove((Object)var0);
        var1.getPlayers().remove(var0);
    }

    public Collection<String> getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection<ScoreboardTeam> getPlayerTeams() {
        return this.teamsByName.values();
    }

    @Nullable
    public ScoreboardTeam getPlayersTeam(String var0) {
        return (ScoreboardTeam)this.teamsByPlayer.get((Object)var0);
    }

    public void onObjectiveAdded(ScoreboardObjective var0) {
    }

    public void onObjectiveChanged(ScoreboardObjective var0) {
    }

    public void onObjectiveRemoved(ScoreboardObjective var0) {
    }

    protected void onScoreChanged(ScoreHolder var0, ScoreboardObjective var1, ScoreboardScore var2) {
    }

    protected void onScoreLockChanged(ScoreHolder var0, ScoreboardObjective var1) {
    }

    public void onPlayerRemoved(ScoreHolder var0) {
    }

    public void onPlayerScoreRemoved(ScoreHolder var0, ScoreboardObjective var1) {
    }

    public void onTeamAdded(ScoreboardTeam var0) {
    }

    public void onTeamChanged(ScoreboardTeam var0) {
    }

    public void onTeamRemoved(ScoreboardTeam var0) {
    }

    public void entityRemoved(Entity var0) {
        if (var0 instanceof EntityHuman || var0.isAlive()) {
            return;
        }
        this.resetAllPlayerScores(var0);
        this.removePlayerFromTeam(var0.getScoreboardName());
    }

    protected List<a> packPlayerScores() {
        return this.playerScores.entrySet().stream().flatMap(var0 -> {
            String var12 = (String)var0.getKey();
            return ((PlayerScores)var0.getValue()).listRawScores().entrySet().stream().map(var1 -> new a(var12, ((ScoreboardObjective)var1.getKey()).getName(), (ScoreboardScore)var1.getValue()));
        }).toList();
    }

    protected void loadPlayerScore(a var0) {
        ScoreboardObjective var1 = this.getObjective(var0.objective);
        if (var1 == null) {
            LOGGER.error("Unknown objective {} for name {}, ignoring", (Object)var0.objective, (Object)var0.owner);
            return;
        }
        this.getOrCreatePlayerInfo(var0.owner).setScore(var1, var0.score);
    }

    protected void loadPlayerTeam(ScoreboardTeam.a var0) {
        ScoreboardTeam var1 = this.addPlayerTeam(var0.name());
        var0.displayName().ifPresent(var1::setDisplayName);
        var0.color().ifPresent(var1::setColor);
        var1.setAllowFriendlyFire(var0.allowFriendlyFire());
        var1.setSeeFriendlyInvisibles(var0.seeFriendlyInvisibles());
        var1.setPlayerPrefix(var0.memberNamePrefix());
        var1.setPlayerSuffix(var0.memberNameSuffix());
        var1.setNameTagVisibility(var0.nameTagVisibility());
        var1.setDeathMessageVisibility(var0.deathMessageVisibility());
        var1.setCollisionRule(var0.collisionRule());
        for (String var3 : var0.players()) {
            this.addPlayerToTeam(var3, var1);
        }
    }

    protected void loadObjective(ScoreboardObjective.a var0) {
        this.addObjective(var0.name(), var0.criteria(), var0.displayName(), var0.renderType(), var0.displayAutoUpdate(), var0.numberFormat().orElse(null));
    }

    public static final class a
    extends Record {
        final String owner;
        final String objective;
        final ScoreboardScore score;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("Name").forGetter(a::owner), (App)Codec.STRING.fieldOf("Objective").forGetter(a::objective), (App)ScoreboardScore.MAP_CODEC.forGetter(a::score)).apply((Applicative)var0, a::new));

        public a(String var0, String var1, ScoreboardScore var2) {
            this.owner = var0;
            this.objective = var1;
            this.score = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;objective;score", "owner", "objective", "score"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;objective;score", "owner", "objective", "score"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;objective;score", "owner", "objective", "score"}, this, var0);
        }

        public String owner() {
            return this.owner;
        }

        public String objective() {
            return this.objective;
        }

        public ScoreboardScore score() {
            return this.score;
        }
    }
}

