/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeamBase;

public class ScoreboardTeam
extends ScoreboardTeamBase {
    private static final int BIT_FRIENDLY_FIRE = 0;
    private static final int BIT_SEE_INVISIBLES = 1;
    private final Scoreboard scoreboard;
    private final String name;
    private final Set<String> players = Sets.newHashSet();
    private IChatBaseComponent displayName;
    private IChatBaseComponent playerPrefix = CommonComponents.EMPTY;
    private IChatBaseComponent playerSuffix = CommonComponents.EMPTY;
    private boolean allowFriendlyFire = true;
    private boolean seeFriendlyInvisibles = true;
    private ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS;
    private ScoreboardTeamBase.EnumNameTagVisibility deathMessageVisibility = ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS;
    private EnumChatFormat color = EnumChatFormat.RESET;
    private ScoreboardTeamBase.EnumTeamPush collisionRule = ScoreboardTeamBase.EnumTeamPush.ALWAYS;
    private final ChatModifier displayNameStyle;

    public ScoreboardTeam(Scoreboard var0, String var1) {
        this.scoreboard = var0;
        this.name = var1;
        this.displayName = IChatBaseComponent.literal(var1);
        this.displayNameStyle = ChatModifier.EMPTY.withInsertion(var1).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.literal(var1)));
    }

    public a pack() {
        return new a(this.name, Optional.of(this.displayName), this.color != EnumChatFormat.RESET ? Optional.of(this.color) : Optional.empty(), this.allowFriendlyFire, this.seeFriendlyInvisibles, this.playerPrefix, this.playerSuffix, this.nameTagVisibility, this.deathMessageVisibility, this.collisionRule, List.copyOf(this.players));
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public IChatMutableComponent getFormattedDisplayName() {
        IChatMutableComponent var0 = ChatComponentUtils.wrapInSquareBrackets(this.displayName.copy().withStyle(this.displayNameStyle));
        EnumChatFormat var1 = this.getColor();
        if (var1 != EnumChatFormat.RESET) {
            var0.withStyle(var1);
        }
        return var0;
    }

    public void setDisplayName(IChatBaseComponent var0) {
        if (var0 == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.displayName = var0;
        this.scoreboard.onTeamChanged(this);
    }

    public void setPlayerPrefix(@Nullable IChatBaseComponent var0) {
        this.playerPrefix = var0 == null ? CommonComponents.EMPTY : var0;
        this.scoreboard.onTeamChanged(this);
    }

    public IChatBaseComponent getPlayerPrefix() {
        return this.playerPrefix;
    }

    public void setPlayerSuffix(@Nullable IChatBaseComponent var0) {
        this.playerSuffix = var0 == null ? CommonComponents.EMPTY : var0;
        this.scoreboard.onTeamChanged(this);
    }

    public IChatBaseComponent getPlayerSuffix() {
        return this.playerSuffix;
    }

    @Override
    public Collection<String> getPlayers() {
        return this.players;
    }

    @Override
    public IChatMutableComponent getFormattedName(IChatBaseComponent var0) {
        IChatMutableComponent var1 = IChatBaseComponent.empty().append(this.playerPrefix).append(var0).append(this.playerSuffix);
        EnumChatFormat var2 = this.getColor();
        if (var2 != EnumChatFormat.RESET) {
            var1.withStyle(var2);
        }
        return var1;
    }

    public static IChatMutableComponent formatNameForTeam(@Nullable ScoreboardTeamBase var0, IChatBaseComponent var1) {
        if (var0 == null) {
            return var1.copy();
        }
        return var0.getFormattedName(var1);
    }

    @Override
    public boolean isAllowFriendlyFire() {
        return this.allowFriendlyFire;
    }

    public void setAllowFriendlyFire(boolean var0) {
        this.allowFriendlyFire = var0;
        this.scoreboard.onTeamChanged(this);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.seeFriendlyInvisibles;
    }

    public void setSeeFriendlyInvisibles(boolean var0) {
        this.seeFriendlyInvisibles = var0;
        this.scoreboard.onTeamChanged(this);
    }

    @Override
    public ScoreboardTeamBase.EnumNameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public ScoreboardTeamBase.EnumNameTagVisibility getDeathMessageVisibility() {
        return this.deathMessageVisibility;
    }

    public void setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility var0) {
        this.nameTagVisibility = var0;
        this.scoreboard.onTeamChanged(this);
    }

    public void setDeathMessageVisibility(ScoreboardTeamBase.EnumNameTagVisibility var0) {
        this.deathMessageVisibility = var0;
        this.scoreboard.onTeamChanged(this);
    }

    @Override
    public ScoreboardTeamBase.EnumTeamPush getCollisionRule() {
        return this.collisionRule;
    }

    public void setCollisionRule(ScoreboardTeamBase.EnumTeamPush var0) {
        this.collisionRule = var0;
        this.scoreboard.onTeamChanged(this);
    }

    public int packOptions() {
        int var0 = 0;
        if (this.isAllowFriendlyFire()) {
            var0 |= 1;
        }
        if (this.canSeeFriendlyInvisibles()) {
            var0 |= 2;
        }
        return var0;
    }

    public void unpackOptions(int var0) {
        this.setAllowFriendlyFire((var0 & 1) > 0);
        this.setSeeFriendlyInvisibles((var0 & 2) > 0);
    }

    public void setColor(EnumChatFormat var0) {
        this.color = var0;
        this.scoreboard.onTeamChanged(this);
    }

    @Override
    public EnumChatFormat getColor() {
        return this.color;
    }

    public record a(String name, Optional<IChatBaseComponent> displayName, Optional<EnumChatFormat> color, boolean allowFriendlyFire, boolean seeFriendlyInvisibles, IChatBaseComponent memberNamePrefix, IChatBaseComponent memberNameSuffix, ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility, ScoreboardTeamBase.EnumNameTagVisibility deathMessageVisibility, ScoreboardTeamBase.EnumTeamPush collisionRule, List<String> players) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("Name").forGetter(a::name), (App)ComponentSerialization.CODEC.optionalFieldOf("DisplayName").forGetter(a::displayName), (App)EnumChatFormat.COLOR_CODEC.optionalFieldOf("TeamColor").forGetter(a::color), (App)Codec.BOOL.optionalFieldOf("AllowFriendlyFire", (Object)true).forGetter(a::allowFriendlyFire), (App)Codec.BOOL.optionalFieldOf("SeeFriendlyInvisibles", (Object)true).forGetter(a::seeFriendlyInvisibles), (App)ComponentSerialization.CODEC.optionalFieldOf("MemberNamePrefix", (Object)CommonComponents.EMPTY).forGetter(a::memberNamePrefix), (App)ComponentSerialization.CODEC.optionalFieldOf("MemberNameSuffix", (Object)CommonComponents.EMPTY).forGetter(a::memberNameSuffix), (App)ScoreboardTeamBase.EnumNameTagVisibility.CODEC.optionalFieldOf("NameTagVisibility", (Object)ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS).forGetter(a::nameTagVisibility), (App)ScoreboardTeamBase.EnumNameTagVisibility.CODEC.optionalFieldOf("DeathMessageVisibility", (Object)ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS).forGetter(a::deathMessageVisibility), (App)ScoreboardTeamBase.EnumTeamPush.CODEC.optionalFieldOf("CollisionRule", (Object)ScoreboardTeamBase.EnumTeamPush.ALWAYS).forGetter(a::collisionRule), (App)Codec.STRING.listOf().optionalFieldOf("Players", List.of()).forGetter(a::players)).apply((Applicative)var0, a::new));
    }
}

