/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Frog
extends Animals {
    @Nullable
    public Entity getTongueTarget();

    public void setTongueTarget(@Nullable Entity var1);

    @NotNull
    public Variant getVariant();

    public void setVariant(@NotNull Variant var1);

    public static interface Variant
    extends OldEnum<Variant>,
    Keyed {
        public static final Variant TEMPERATE = Variant.getVariant("temperate");
        public static final Variant WARM = Variant.getVariant("warm");
        public static final Variant COLD = Variant.getVariant("cold");

        @NotNull
        private static Variant getVariant(@NotNull String key) {
            return Registry.FROG_VARIANT.getOrThrow(NamespacedKey.minecraft(key));
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Variant valueOf(@NotNull String name) {
            Variant variant = Registry.FROG_VARIANT.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument(variant != null, "No frog variant found with the name %s", (Object)name);
            return variant;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Variant[] values() {
            return Lists.newArrayList(Registry.FROG_VARIANT).toArray(new Variant[0]);
        }
    }
}

