/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_20_R1.advancement.CraftAdvancement;

public class Advancement {
    @Nullable
    private final Advancement a;
    @Nullable
    private final AdvancementDisplay b;
    private final AdvancementRewards c;
    private final MinecraftKey d;
    private final Map<String, Criterion> e;
    private final String[][] f;
    private final Set<Advancement> g = Sets.newLinkedHashSet();
    private final IChatBaseComponent h;
    private final boolean i;
    public final org.bukkit.advancement.Advancement bukkit = new CraftAdvancement(this);

    public Advancement(MinecraftKey minecraftkey, @Nullable Advancement advancement, @Nullable AdvancementDisplay advancementdisplay, AdvancementRewards advancementrewards, Map<String, Criterion> map, String[][] astring, boolean flag) {
        this.d = minecraftkey;
        this.b = advancementdisplay;
        this.e = ImmutableMap.copyOf(map);
        this.a = advancement;
        this.c = advancementrewards;
        this.f = astring;
        this.i = flag;
        if (advancement != null) {
            advancement.b(this);
        }
        if (advancementdisplay == null) {
            this.h = IChatBaseComponent.b(minecraftkey.toString());
        } else {
            IChatBaseComponent ichatbasecomponent = advancementdisplay.a();
            EnumChatFormat enumchatformat = advancementdisplay.e().c();
            IChatMutableComponent ichatmutablecomponent = ChatComponentUtils.a(ichatbasecomponent.e(), ChatModifier.a.a(enumchatformat)).f("\n").b(advancementdisplay.b());
            IChatMutableComponent ichatmutablecomponent1 = ichatbasecomponent.e().a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
            this.h = ChatComponentUtils.a(ichatmutablecomponent1).a(enumchatformat);
        }
    }

    public SerializedAdvancement a() {
        return new SerializedAdvancement(this.a == null ? null : this.a.j(), this.b, this.c, this.e, this.f, this.i);
    }

    @Nullable
    public Advancement b() {
        return this.a;
    }

    public Advancement c() {
        return Advancement.a(this);
    }

    public static Advancement a(Advancement advancement) {
        Advancement advancement1 = advancement;
        Advancement advancement2;
        while ((advancement2 = advancement1.b()) != null) {
            advancement1 = advancement2;
        }
        return advancement1;
    }

    @Nullable
    public AdvancementDisplay d() {
        return this.b;
    }

    public boolean e() {
        return this.i;
    }

    public AdvancementRewards f() {
        return this.c;
    }

    public String toString() {
        MinecraftKey minecraftkey = this.j();
        return "SimpleAdvancement{id=" + minecraftkey + ", parent=" + (this.a == null ? "null" : this.a.j()) + ", display=" + this.b + ", rewards=" + this.c + ", criteria=" + this.e + ", requirements=" + Arrays.deepToString((Object[])this.f) + ", sendsTelemetryEvent=" + this.i + "}";
    }

    public Iterable<Advancement> g() {
        return this.g;
    }

    public Map<String, Criterion> h() {
        return this.e;
    }

    public int i() {
        return this.f.length;
    }

    public void b(Advancement advancement) {
        this.g.add(advancement);
    }

    public MinecraftKey j() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)object;
        return this.d.equals(advancement.d);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public String[][] k() {
        return this.f;
    }

    public IChatBaseComponent l() {
        return this.h;
    }

    public static class SerializedAdvancement {
        @Nullable
        private MinecraftKey a;
        @Nullable
        private Advancement b;
        @Nullable
        private AdvancementDisplay c;
        private AdvancementRewards d = AdvancementRewards.a;
        private Map<String, Criterion> e = Maps.newLinkedHashMap();
        @Nullable
        private String[][] f;
        private AdvancementRequirements g = AdvancementRequirements.a;
        private final boolean h;

        SerializedAdvancement(@Nullable MinecraftKey minecraftkey, @Nullable AdvancementDisplay advancementdisplay, AdvancementRewards advancementrewards, Map<String, Criterion> map, String[][] astring, boolean flag) {
            this.a = minecraftkey;
            this.c = advancementdisplay;
            this.d = advancementrewards;
            this.e = map;
            this.f = astring;
            this.h = flag;
        }

        private SerializedAdvancement(boolean flag) {
            this.h = flag;
        }

        public static SerializedAdvancement a() {
            return new SerializedAdvancement(true);
        }

        public static SerializedAdvancement b() {
            return new SerializedAdvancement(false);
        }

        public SerializedAdvancement a(Advancement advancement) {
            this.b = advancement;
            return this;
        }

        public SerializedAdvancement a(MinecraftKey minecraftkey) {
            this.a = minecraftkey;
            return this;
        }

        public SerializedAdvancement a(ItemStack itemstack, IChatBaseComponent ichatbasecomponent, IChatBaseComponent ichatbasecomponent1, @Nullable MinecraftKey minecraftkey, AdvancementFrameType advancementframetype, boolean flag, boolean flag1, boolean flag2) {
            return this.a(new AdvancementDisplay(itemstack, ichatbasecomponent, ichatbasecomponent1, minecraftkey, advancementframetype, flag, flag1, flag2));
        }

        public SerializedAdvancement a(IMaterial imaterial, IChatBaseComponent ichatbasecomponent, IChatBaseComponent ichatbasecomponent1, @Nullable MinecraftKey minecraftkey, AdvancementFrameType advancementframetype, boolean flag, boolean flag1, boolean flag2) {
            return this.a(new AdvancementDisplay(new ItemStack(imaterial.k()), ichatbasecomponent, ichatbasecomponent1, minecraftkey, advancementframetype, flag, flag1, flag2));
        }

        public SerializedAdvancement a(AdvancementDisplay advancementdisplay) {
            this.c = advancementdisplay;
            return this;
        }

        public SerializedAdvancement a(AdvancementRewards.a advancementrewards_a) {
            return this.a(advancementrewards_a.a());
        }

        public SerializedAdvancement a(AdvancementRewards advancementrewards) {
            this.d = advancementrewards;
            return this;
        }

        public SerializedAdvancement a(String s2, CriterionInstance criterioninstance) {
            return this.a(s2, new Criterion(criterioninstance));
        }

        public SerializedAdvancement a(String s2, Criterion criterion) {
            if (this.e.containsKey(s2)) {
                throw new IllegalArgumentException("Duplicate criterion " + s2);
            }
            this.e.put(s2, criterion);
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements advancementrequirements) {
            this.g = advancementrequirements;
            return this;
        }

        public SerializedAdvancement a(String[][] astring) {
            this.f = astring;
            return this;
        }

        public boolean a(Function<MinecraftKey, Advancement> function) {
            if (this.a == null) {
                return true;
            }
            if (this.b == null) {
                this.b = function.apply(this.a);
            }
            return this.b != null;
        }

        public Advancement b(MinecraftKey minecraftkey) {
            if (!this.a((MinecraftKey minecraftkey1) -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            return new Advancement(minecraftkey, this.b, this.c, this.d, this.e, this.f, this.h);
        }

        public Advancement a(Consumer<Advancement> consumer, String s2) {
            Advancement advancement = this.b(new MinecraftKey(s2));
            consumer.accept(advancement);
            return advancement;
        }

        public JsonObject c() {
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            JsonObject jsonobject = new JsonObject();
            if (this.b != null) {
                jsonobject.addProperty("parent", this.b.j().toString());
            } else if (this.a != null) {
                jsonobject.addProperty("parent", this.a.toString());
            }
            if (this.c != null) {
                jsonobject.add("display", this.c.k());
            }
            jsonobject.add("rewards", this.d.b());
            JsonObject jsonobject1 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.e.entrySet()) {
                jsonobject1.add(entry.getKey(), entry.getValue().b());
            }
            jsonobject.add("criteria", (JsonElement)jsonobject1);
            JsonArray jsonarray = new JsonArray();
            String[][] astring = this.f;
            int i2 = astring.length;
            int j2 = 0;
            while (j2 < i2) {
                String[] astring1 = astring[j2];
                JsonArray jsonarray1 = new JsonArray();
                String[] astring2 = astring1;
                int k2 = astring1.length;
                int l2 = 0;
                while (l2 < k2) {
                    String s2 = astring2[l2];
                    jsonarray1.add(s2);
                    ++l2;
                }
                jsonarray.add((JsonElement)jsonarray1);
                ++j2;
            }
            jsonobject.add("requirements", (JsonElement)jsonarray);
            jsonobject.addProperty("sends_telemetry_event", Boolean.valueOf(this.h));
            return jsonobject;
        }

        public void a(PacketDataSerializer packetdataserializer) {
            if (this.f == null) {
                this.f = this.g.createRequirements(this.e.keySet());
            }
            packetdataserializer.a(this.a, PacketDataSerializer::a);
            packetdataserializer.a(this.c, (packetdataserializer1, advancementdisplay) -> advancementdisplay.a((PacketDataSerializer)((Object)packetdataserializer1)));
            Criterion.a(this.e, packetdataserializer);
            packetdataserializer.d(this.f.length);
            String[][] astring = this.f;
            int i2 = astring.length;
            int j2 = 0;
            while (j2 < i2) {
                String[] astring1 = astring[j2];
                packetdataserializer.d(astring1.length);
                String[] astring2 = astring1;
                int k2 = astring1.length;
                int l2 = 0;
                while (l2 < k2) {
                    String s2 = astring2[l2];
                    packetdataserializer.a(s2);
                    ++l2;
                }
                ++j2;
            }
            packetdataserializer.writeBoolean(this.h);
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.a + ", display=" + this.c + ", rewards=" + this.d + ", criteria=" + this.e + ", requirements=" + Arrays.deepToString((Object[])this.f) + ", sends_telemetry_event=" + this.h + "}";
        }

        public static SerializedAdvancement a(JsonObject jsonobject, LootDeserializationContext lootdeserializationcontext) {
            int l2;
            int j2;
            MinecraftKey minecraftkey = jsonobject.has("parent") ? new MinecraftKey(ChatDeserializer.i(jsonobject, "parent")) : null;
            AdvancementDisplay advancementdisplay = jsonobject.has("display") ? AdvancementDisplay.a(ChatDeserializer.u(jsonobject, "display")) : null;
            AdvancementRewards advancementrewards = jsonobject.has("rewards") ? AdvancementRewards.a(ChatDeserializer.u(jsonobject, "rewards")) : AdvancementRewards.a;
            Map<String, Criterion> map = Criterion.b(ChatDeserializer.u(jsonobject, "criteria"), lootdeserializationcontext);
            if (map.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray jsonarray = ChatDeserializer.a(jsonobject, "requirements", new JsonArray());
            String[][] astring = new String[jsonarray.size()][];
            int i2 = 0;
            while (i2 < jsonarray.size()) {
                JsonArray jsonarray1 = ChatDeserializer.n(jsonarray.get(i2), "requirements[" + i2 + "]");
                astring[i2] = new String[jsonarray1.size()];
                j2 = 0;
                while (j2 < jsonarray1.size()) {
                    astring[i2][j2] = ChatDeserializer.a(jsonarray1.get(j2), "requirements[" + i2 + "][" + j2 + "]");
                    ++j2;
                }
                ++i2;
            }
            if (astring.length == 0) {
                astring = new String[map.size()][];
                i2 = 0;
                for (String s2 : map.keySet()) {
                    astring[i2++] = new String[]{s2};
                }
            }
            String[][] astring1 = astring;
            int k2 = astring.length;
            j2 = 0;
            while (j2 < k2) {
                String[] astring2 = astring1[j2];
                if (astring2.length == 0 && map.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] astring3 = astring2;
                l2 = astring2.length;
                int i1 = 0;
                while (i1 < l2) {
                    String s1 = astring3[i1];
                    if (!map.containsKey(s1)) {
                        throw new JsonSyntaxException("Unknown required criterion '" + s1 + "'");
                    }
                    ++i1;
                }
                ++j2;
            }
            for (String s2 : map.keySet()) {
                boolean flag = false;
                String[][] astring4 = astring;
                int j1 = astring.length;
                for (l2 = 0; l2 < j1; ++l2) {
                    Object[] astring5 = astring4[l2];
                    if (!ArrayUtils.contains((Object[])astring5, (Object)s2)) {
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s2 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            boolean flag1 = ChatDeserializer.a(jsonobject, "sends_telemetry_event", false);
            return new SerializedAdvancement(minecraftkey, advancementdisplay, advancementrewards, map, astring, flag1);
        }

        public static SerializedAdvancement b(PacketDataSerializer packetdataserializer) {
            MinecraftKey minecraftkey = (MinecraftKey)packetdataserializer.c(PacketDataSerializer::t);
            AdvancementDisplay advancementdisplay = (AdvancementDisplay)packetdataserializer.c(AdvancementDisplay::b);
            Map<String, Criterion> map = Criterion.c(packetdataserializer);
            String[][] astring = new String[packetdataserializer.m()][];
            int i2 = 0;
            while (i2 < astring.length) {
                astring[i2] = new String[packetdataserializer.m()];
                int j2 = 0;
                while (j2 < astring[i2].length) {
                    astring[i2][j2] = packetdataserializer.s();
                    ++j2;
                }
                ++i2;
            }
            boolean flag = packetdataserializer.readBoolean();
            return new SerializedAdvancement(minecraftkey, advancementdisplay, AdvancementRewards.a, map, astring, flag);
        }

        public Map<String, Criterion> d() {
            return this.e;
        }
    }
}

