/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger a = LogUtils.getLogger();
    private static final byte b = 1;
    private static final byte c = 2;

    public static int a(boolean var0, boolean var1) {
        int var2 = 0;
        if (var0) {
            var2 |= 1;
        }
        if (var1) {
            var2 |= 2;
        }
        return var2;
    }

    public static boolean a(byte var0) {
        return (var0 & 1) != 0;
    }

    public static boolean b(byte var0) {
        return (var0 & 2) != 0;
    }

    private static <A extends ArgumentType<?>> void a(JsonObject var0, ArgumentTypeInfo.a<A> var1) {
        ArgumentUtils.a(var0, var1.a(), var1);
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void a(JsonObject var0, ArgumentTypeInfo<A, T> var1, ArgumentTypeInfo.a<A> var2) {
        var1.a(var2, var0);
    }

    private static <T extends ArgumentType<?>> void a(JsonObject var0, T var1) {
        ArgumentTypeInfo.a<T> var2 = ArgumentTypeInfos.b(var1);
        var0.addProperty("type", "argument");
        var0.addProperty("parser", BuiltInRegistries.x.b(var2.a()).toString());
        JsonObject var3 = new JsonObject();
        ArgumentUtils.a(var3, var2);
        if (var3.size() > 0) {
            var0.add("properties", (JsonElement)var3);
        }
    }

    public static <S> JsonObject a(CommandDispatcher<S> var0, CommandNode<S> var1) {
        Collection<String> var4;
        JsonObject var3;
        JsonObject var2 = new JsonObject();
        if (var1 instanceof RootCommandNode) {
            var2.addProperty("type", "root");
        } else if (var1 instanceof LiteralCommandNode) {
            var2.addProperty("type", "literal");
        } else if (var1 instanceof ArgumentCommandNode) {
            var3 = (ArgumentCommandNode)var1;
            ArgumentUtils.a(var2, var3.getType());
        } else {
            a.error("Could not serialize node {} ({})!", var1, var1.getClass());
            var2.addProperty("type", "unknown");
        }
        var3 = new JsonObject();
        for (CommandNode<S> commandNode : var1.getChildren()) {
            var3.add(commandNode.getName(), (JsonElement)ArgumentUtils.a(var0, commandNode));
        }
        if (var3.size() > 0) {
            var2.add("children", (JsonElement)var3);
        }
        if (var1.getCommand() != null) {
            var2.addProperty("executable", Boolean.valueOf(true));
        }
        if (var1.getRedirect() != null && !(var4 = var0.getPath(var1.getRedirect())).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String var7 : var4) {
                jsonArray.add(var7);
            }
            var2.add("redirect", (JsonElement)jsonArray);
        }
        return var2;
    }

    public static <T> Set<ArgumentType<?>> a(CommandNode<T> var0) {
        Set var1 = Sets.newIdentityHashSet();
        HashSet var2 = Sets.newHashSet();
        ArgumentUtils.a(var0, var2, var1);
        return var2;
    }

    private static <T> void a(CommandNode<T> var0, Set<ArgumentType<?>> var1, Set<CommandNode<T>> var22) {
        Object var3;
        if (!var22.add(var0)) {
            return;
        }
        if (var0 instanceof ArgumentCommandNode) {
            var3 = (ArgumentCommandNode)var0;
            var1.add(var3.getType());
        }
        var0.getChildren().forEach(var2 -> ArgumentUtils.a(var2, var1, var22));
        var3 = var0.getRedirect();
        if (var3 != null) {
            ArgumentUtils.a(var3, var1, var22);
        }
    }
}

