/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private static final Logger b = LogUtils.getLogger();
    final ResourceKey<? extends IRegistry<T>> c;
    private final ObjectList<Holder.c<T>> d = new ObjectArrayList(256);
    private final Object2IntMap<T> e = (Object2IntMap)SystemUtils.a(new Object2IntOpenCustomHashMap(SystemUtils.k()), (T var0) -> var0.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> f = new HashMap<MinecraftKey, Holder.c<T>>();
    private final Map<ResourceKey<T>, Holder.c<T>> g = new HashMap<ResourceKey<T>, Holder.c<T>>();
    private final Map<T, Holder.c<T>> h = new IdentityHashMap<T, Holder.c<T>>();
    private final Map<T, Lifecycle> i = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle j;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> k = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;
    @Nullable
    private List<Holder.c<T>> n;
    private int o;
    private final HolderLookup.c<T> p = new HolderLookup.c<T>(){

        @Override
        public ResourceKey<? extends IRegistry<? extends T>> f() {
            return RegistryMaterials.this.c;
        }

        @Override
        public Lifecycle g() {
            return RegistryMaterials.this.d();
        }

        @Override
        public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
            return RegistryMaterials.this.b(var0);
        }

        @Override
        public Stream<Holder.c<T>> b() {
            return RegistryMaterials.this.h();
        }

        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
            return RegistryMaterials.this.b(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> d() {
            return RegistryMaterials.this.i().map(Pair::getSecond);
        }
    };

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1) {
        this(var0, var1, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, boolean var2) {
        DispenserRegistry.a(() -> "registry " + var02);
        this.c = var02;
        this.j = var1;
        if (var2) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> c() {
        return this.c;
    }

    public String toString() {
        return "Registry[" + this.c + " (" + this.j + ")]";
    }

    private List<Holder.c<T>> a() {
        if (this.n == null) {
            this.n = this.d.stream().filter(Objects::nonNull).toList();
        }
        return this.n;
    }

    private void v() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void g(ResourceKey<T> var0) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + var0 + ")");
        }
    }

    public Holder.c<T> a(int var02, ResourceKey<T> var1, T var2, Lifecycle var3) {
        Holder.c var4;
        this.g(var1);
        Validate.notNull(var1);
        Validate.notNull(var2);
        if (this.f.containsKey(var1.a())) {
            SystemUtils.b(new IllegalStateException("Adding duplicate key '" + var1 + "' to registry"));
        }
        if (this.h.containsKey(var2)) {
            SystemUtils.b(new IllegalStateException("Adding duplicate value '" + var2 + "' to registry"));
        }
        if (this.m != null) {
            var4 = this.m.remove(var2);
            if (var4 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + var1 + ":" + var2));
            }
            var4.b(var1);
        } else {
            var4 = this.g.computeIfAbsent(var1, var0 -> Holder.c.a(this.o(), var0));
        }
        this.g.put(var1, var4);
        this.f.put(var1.a(), var4);
        this.h.put(var2, var4);
        this.d.size(Math.max(this.d.size(), var02 + 1));
        this.d.set(var02, (Object)var4);
        this.e.put(var2, var02);
        if (this.o <= var02) {
            this.o = var02 + 1;
        }
        this.i.put(var2, var3);
        this.j = this.j.add(var3);
        this.n = null;
        return var4;
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> var0, T var1, Lifecycle var2) {
        return this.a(this.o, var0, var1, var2);
    }

    @Override
    @Nullable
    public MinecraftKey b(T var0) {
        Holder.c<T> var1 = this.h.get(var0);
        return var1 != null ? var1.g().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> c(T var0) {
        return Optional.ofNullable(this.h.get(var0)).map(Holder.c::g);
    }

    @Override
    public int a(@Nullable T var0) {
        return this.e.getInt(var0);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> var0) {
        return RegistryMaterials.a(this.g.get(var0));
    }

    @Override
    @Nullable
    public T a(int var0) {
        if (var0 < 0 || var0 >= this.d.size()) {
            return null;
        }
        return RegistryMaterials.a((Holder.c)this.d.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> c(int var0) {
        if (var0 < 0 || var0 >= this.d.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.c)this.d.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> b(ResourceKey<T> var0) {
        return Optional.ofNullable(this.g.get(var0));
    }

    @Override
    public Holder<T> d(T var0) {
        Holder.c<T> var1 = this.h.get(var0);
        return var1 != null ? var1 : Holder.a(var0);
    }

    Holder.c<T> h(ResourceKey<T> var02) {
        return this.g.computeIfAbsent(var02, var0 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.g((ResourceKey<T>)var0);
            return Holder.c.a(this.o(), var0);
        });
    }

    @Override
    public int b() {
        return this.g.size();
    }

    @Override
    public Lifecycle e(T var0) {
        return this.i.get(var0);
    }

    @Override
    public Lifecycle d() {
        return this.j;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.a().iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey var0) {
        Holder.c<T> var1 = this.f.get(var0);
        return RegistryMaterials.a(var1);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> var0) {
        return var0 != null ? (T)var0.a() : null;
    }

    @Override
    public Set<MinecraftKey> e() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<ResourceKey<T>> f() {
        return Collections.unmodifiableSet(this.g.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> g() {
        return Collections.unmodifiableSet(Maps.transformValues(this.g, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> h() {
        return this.a().stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> i() {
        return this.k.entrySet().stream().map(var0 -> Pair.of((Object)((TagKey)var0.getKey()), (Object)((HolderSet.Named)var0.getValue())));
    }

    @Override
    public HolderSet.Named<T> a(TagKey<T> var0) {
        HolderSet.Named<T> var1 = this.k.get(var0);
        if (var1 == null) {
            var1 = this.d(var0);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            var2.put(var0, var1);
            this.k = var2;
        }
        return var1;
    }

    @Override
    private HolderSet.Named<T> d(TagKey<T> var0) {
        return new HolderSet.Named<T>(this.o(), var0);
    }

    @Override
    public Stream<TagKey<T>> j() {
        return this.k.keySet().stream();
    }

    @Override
    public boolean k() {
        return this.g.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource var0) {
        return SystemUtils.b(this.a(), var0);
    }

    @Override
    public boolean c(MinecraftKey var0) {
        return this.f.containsKey(var0);
    }

    @Override
    public boolean c(ResourceKey<T> var0) {
        return this.g.containsKey(var0);
    }

    @Override
    public IRegistry<T> l() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.h.forEach((? super K var0, ? super V var1) -> var1.b(var0));
        List<MinecraftKey> var02 = this.g.entrySet().stream().filter(var0 -> !((Holder.c)var0.getValue()).b()).map(var0 -> ((ResourceKey)var0.getKey()).a()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.c() + ": " + var02);
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + this.m.values());
            }
            this.m = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> f(T var02) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.v();
        return this.m.computeIfAbsent(var02, var0 -> Holder.c.a(this.p(), var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> b(TagKey<T> var0) {
        return Optional.ofNullable(this.k.get(var0));
    }

    @Override
    public void a(Map<TagKey<T>, List<Holder<T>>> var02) {
        IdentityHashMap<Holder.c, List> var12 = new IdentityHashMap<Holder.c, List>();
        this.g.values().forEach(var1 -> var12.put((Holder.c)var1, new ArrayList()));
        var02.forEach((? super K var1, ? super V var2) -> {
            for (Holder var4 : var2) {
                if (!var4.a(this.p())) {
                    throw new IllegalStateException("Can't create named set " + var1 + " containing value " + var4 + " from outside registry " + this);
                }
                if (var4 instanceof Holder.c) {
                    Holder.c var5 = (Holder.c)var4;
                    ((List)var12.get(var5)).add(var1);
                    continue;
                }
                throw new IllegalStateException("Found direct holder " + var4 + " value in tag " + var1);
            }
        });
        Sets.SetView var22 = Sets.difference(this.k.keySet(), var02.keySet());
        if (!var22.isEmpty()) {
            b.warn("Not all defined tags for registry {} are present in data pack: {}", this.c(), (Object)var22.stream().map(var0 -> var0.b().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var3 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
        var02.forEach((? super K var1, ? super V var2) -> var3.computeIfAbsent((TagKey<T>)var1, this::d).b(var2));
        var12.forEach(Holder.c::a);
        this.k = var3;
    }

    @Override
    public void m() {
        this.k.values().forEach(var0 -> var0.b(List.of()));
        this.g.values().forEach(var0 -> var0.a(Set.of()));
    }

    @Override
    public HolderGetter<T> n() {
        this.v();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> var0) {
                return RegistryMaterials.this.h(var0);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> var0) {
                return RegistryMaterials.this.a(var0);
            }
        };
    }

    @Override
    public HolderOwner<T> o() {
        return this.p;
    }

    @Override
    public HolderLookup.c<T> p() {
        return this.p;
    }

    @Override
    public /* synthetic */ Holder b(int n2, ResourceKey resourceKey, Object object, Lifecycle lifecycle) {
        return this.a(n2, resourceKey, object, lifecycle);
    }
}

