/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    @Nullable
    private static final Path d = null;
    private static final Logger e = LogUtils.getLogger();
    private final PackOutput f;
    private final Iterable<Path> g;
    private final List<a> h = Lists.newArrayList();

    public SnbtToNbt(PackOutput var0, Iterable<Path> var1) {
        this.f = var0;
        this.g = var1;
    }

    public SnbtToNbt a(a var0) {
        this.h.add(var0);
        return this;
    }

    private NBTTagCompound a(String var0, NBTTagCompound var1) {
        NBTTagCompound var2 = var1;
        for (a var4 : this.h) {
            var2 = var4.apply(var0, var2);
        }
        return var2;
    }

    @Override
    public CompletableFuture<?> a(CachedOutput var02) {
        Path var1 = this.f.a();
        ArrayList var2 = Lists.newArrayList();
        for (Path var4 : this.g) {
            var2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> var32 = Files.walk(var4, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])var32.filter(var0 -> var0.toString().endsWith(".snbt")).map(var3 -> CompletableFuture.runAsync(() -> {
                            c var4 = this.a((Path)var3, this.a(var4, (Path)var3));
                            this.a(var02, var4, var1);
                        }, SystemUtils.f())).toArray(CompletableFuture[]::new));
                        if (var32 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (var32 != null) {
                                try {
                                    var32.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception var33) {
                            throw new RuntimeException("Failed to read structure input directory, aborting", var33);
                        }
                    }
                    var32.close();
                }
                return completableFuture;
            }, SystemUtils.f()).thenCompose(var0 -> var0));
        }
        return SystemUtils.c(var2);
    }

    @Override
    public final String a() {
        return "SNBT -> NBT";
    }

    private String a(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".snbt".length());
    }

    private c a(Path var0, String var1) {
        c c2;
        block8: {
            BufferedReader var2 = Files.newBufferedReader(var0);
            try {
                String var3 = IOUtils.toString((Reader)var2);
                NBTTagCompound var4 = this.a(var1, GameProfileSerializer.a(var3));
                ByteArrayOutputStream var5 = new ByteArrayOutputStream();
                HashingOutputStream var6 = new HashingOutputStream(Hashing.sha1(), (OutputStream)var5);
                NBTCompressedStreamTools.a(var4, (OutputStream)var6);
                byte[] var7 = var5.toByteArray();
                HashCode var8 = var6.hash();
                String var9 = d != null ? GameProfileSerializer.c(var4) : null;
                c2 = new c(var1, var7, var9, var8);
                if (var2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable var22) {
                    throw new b(var0, var22);
                }
            }
            var2.close();
        }
        return c2;
    }

    private void a(CachedOutput var0, c var1, Path var2) {
        Path var3;
        if (var1.c != null) {
            var3 = d.resolve(var1.a + ".snbt");
            try {
                DebugReportNBT.a(CachedOutput.a, var3, var1.c);
            }
            catch (IOException var4) {
                e.error("Couldn't write structure SNBT {} at {}", new Object[]{var1.a, var3, var4});
            }
        }
        var3 = var2.resolve(var1.a + ".nbt");
        try {
            var0.writeIfNeeded(var3, var1.b, var1.d);
        }
        catch (IOException var4) {
            e.error("Couldn't write structure {} at {}", new Object[]{var1.a, var3, var4});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    static final class c
    extends Record {
        final String a;
        final byte[] b;
        @Nullable
        final String c;
        final HashCode d;

        c(String var0, byte[] var1, @Nullable String var2, HashCode var3) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
            this.d = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this, var0);
        }

        public String a() {
            return this.a;
        }

        public byte[] b() {
            return this.b;
        }

        @Nullable
        public String c() {
            return this.c;
        }

        public HashCode d() {
            return this.d;
        }
    }

    static class b
    extends RuntimeException {
        public b(Path var0, Throwable var1) {
            super(var0.toAbsolutePath().toString(), var1);
        }
    }
}

