/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    public static NBTTagCompound a(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            nbttagcompound = NBTCompressedStreamTools.a(fileinputstream);
        }
        return nbttagcompound;
    }

    private static DataInputStream b(InputStream inputstream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(inputstream)));
    }

    public static NBTTagCompound a(InputStream inputstream) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.a((DataInput)datainputstream, NBTReadLimiter.a);
        }
        return nbttagcompound;
    }

    public static void a(File file, StreamTagVisitor streamtagvisitor) throws IOException {
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            NBTCompressedStreamTools.a(fileinputstream, streamtagvisitor);
        }
    }

    public static void a(InputStream inputstream, StreamTagVisitor streamtagvisitor) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(inputstream);){
            NBTCompressedStreamTools.a((DataInput)datainputstream, streamtagvisitor);
        }
    }

    public static void a(NBTTagCompound nbttagcompound, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
            NBTCompressedStreamTools.a(nbttagcompound, fileoutputstream);
        }
    }

    public static void a(NBTTagCompound nbttagcompound, OutputStream outputstream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputstream)));){
            NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)dataoutputstream);
        }
    }

    public static void b(NBTTagCompound nbttagcompound, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound b(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(file);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            nbttagcompound = NBTCompressedStreamTools.a((DataInput)datainputstream, NBTReadLimiter.a);
        }
        return nbttagcompound;
    }

    public static NBTTagCompound a(DataInput datainput) throws IOException {
        return NBTCompressedStreamTools.a(datainput, NBTReadLimiter.a);
    }

    public static NBTTagCompound a(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTBase nbtbase;
        if (datainput instanceof ByteBufInputStream) {
            datainput = new DataInputStream(new LimitStream((InputStream)((Object)datainput), nbtreadlimiter));
        }
        if ((nbtbase = NBTCompressedStreamTools.a(datainput, 0, nbtreadlimiter)) instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException {
        NBTCompressedStreamTools.a((NBTBase)nbttagcompound, dataoutput);
    }

    public static void a(DataInput datainput, StreamTagVisitor streamtagvisitor) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.a(datainput.readByte());
        if (nbttagtype == NBTTagEnd.a) {
            if (streamtagvisitor.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                streamtagvisitor.a();
            }
        } else {
            switch (streamtagvisitor.b(nbttagtype)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(datainput);
                    nbttagtype.a(datainput);
                    break;
                }
                case a: {
                    NBTTagString.a(datainput);
                    nbttagtype.a(datainput, streamtagvisitor);
                }
            }
        }
    }

    public static void a(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.b());
        if (nbtbase.b() != 0) {
            dataoutput.writeUTF("");
            nbtbase.a(dataoutput);
        }
    }

    private static NBTBase a(DataInput datainput, int i2, NBTReadLimiter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        if (b0 == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(datainput);
        try {
            return NBTTagTypes.a(b0).b(datainput, i2, nbtreadlimiter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.a(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("NBT Tag");
            crashreportsystemdetails.a("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

