/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagIntArray
extends NBTList<NBTTagInt> {
    private static final int b = 24;
    public static final NBTTagType<NBTTagIntArray> a = new NBTTagType.b<NBTTagIntArray>(){

        public NBTTagIntArray a(DataInput datainput, int i2, NBTReadLimiter nbtreadlimiter) throws IOException {
            nbtreadlimiter.a(24L);
            int j2 = datainput.readInt();
            Preconditions.checkArgument((j2 < 0x1000000 ? 1 : 0) != 0);
            nbtreadlimiter.a(4L * (long)j2);
            int[] aint = new int[j2];
            int k2 = 0;
            while (k2 < j2) {
                aint[k2] = datainput.readInt();
                ++k2;
            }
            return new NBTTagIntArray(aint);
        }

        @Override
        public StreamTagVisitor.b a(DataInput datainput, StreamTagVisitor streamtagvisitor) throws IOException {
            int i2 = datainput.readInt();
            int[] aint = new int[i2];
            int j2 = 0;
            while (j2 < i2) {
                aint[j2] = datainput.readInt();
                ++j2;
            }
            return streamtagvisitor.a(aint);
        }

        @Override
        public void a(DataInput datainput) throws IOException {
            datainput.skipBytes(datainput.readInt() * 4);
        }

        @Override
        public String a() {
            return "INT[]";
        }

        @Override
        public String b() {
            return "TAG_Int_Array";
        }
    };
    private int[] c;

    public NBTTagIntArray(int[] aint) {
        this.c = aint;
    }

    public NBTTagIntArray(List<Integer> list) {
        this(NBTTagIntArray.a(list));
    }

    private static int[] a(List<Integer> list) {
        int[] aint = new int[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            Integer integer = list.get(i2);
            aint[i2] = integer == null ? 0 : integer;
            ++i2;
        }
        return aint;
    }

    @Override
    public void a(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.c.length);
        int[] aint = this.c;
        int i2 = aint.length;
        int j2 = 0;
        while (j2 < i2) {
            int k2 = aint[j2];
            dataoutput.writeInt(k2);
            ++j2;
        }
    }

    @Override
    public int a() {
        return 24 + 4 * this.c.length;
    }

    @Override
    public byte b() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> c() {
        return a;
    }

    @Override
    public String toString() {
        return this.m_();
    }

    public NBTTagIntArray e() {
        int[] aint = new int[this.c.length];
        System.arraycopy(this.c, 0, aint, 0, this.c.length);
        return new NBTTagIntArray(aint);
    }

    @Override
    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagIntArray && Arrays.equals(this.c, ((NBTTagIntArray)object).c);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    public int[] g() {
        return this.c;
    }

    @Override
    public void a(TagVisitor tagvisitor) {
        tagvisitor.a(this);
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagInt a(int i2) {
        return NBTTagInt.a(this.c[i2]);
    }

    public NBTTagInt a(int i2, NBTTagInt nbttagint) {
        int j2 = this.c[i2];
        this.c[i2] = nbttagint.g();
        return NBTTagInt.a(j2);
    }

    public void b(int i2, NBTTagInt nbttagint) {
        this.c = ArrayUtils.add((int[])this.c, (int)i2, (int)nbttagint.g());
    }

    @Override
    public boolean a(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.c[i2] = ((NBTNumber)nbtbase).g();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.c = ArrayUtils.add((int[])this.c, (int)i2, (int)((NBTNumber)nbtbase).g());
            return true;
        }
        return false;
    }

    public NBTTagInt b(int i2) {
        int j2 = this.c[i2];
        this.c = ArrayUtils.remove((int[])this.c, (int)i2);
        return NBTTagInt.a(j2);
    }

    @Override
    public byte f() {
        return 3;
    }

    @Override
    public void clear() {
        this.c = new int[0];
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.a(this.c);
    }
}

