/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagString
implements NBTBase {
    private static final int b = 36;
    public static final NBTTagType<NBTTagString> a = new NBTTagType.b<NBTTagString>(){

        public NBTTagString a(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.a(36L);
            String var3 = var0.readUTF();
            var2.a(2 * var3.length());
            return NBTTagString.a(var3);
        }

        @Override
        public StreamTagVisitor.b a(DataInput var0, StreamTagVisitor var1) throws IOException {
            return var1.a(var0.readUTF());
        }

        @Override
        public void a(DataInput var0) throws IOException {
            NBTTagString.a(var0);
        }

        @Override
        public String a() {
            return "STRING";
        }

        @Override
        public String b() {
            return "TAG_String";
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase b(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.a(dataInput, n2, nBTReadLimiter);
        }
    };
    private static final NBTTagString c = new NBTTagString("");
    private static final char w = '\"';
    private static final char x = '\'';
    private static final char y = '\\';
    private static final char z = '\u0000';
    private final String A;

    public static void a(DataInput var0) throws IOException {
        var0.skipBytes(var0.readUnsignedShort());
    }

    private NBTTagString(String var0) {
        Objects.requireNonNull(var0, "Null string not allowed");
        this.A = var0;
    }

    public static NBTTagString a(String var0) {
        if (var0.isEmpty()) {
            return c;
        }
        return new NBTTagString(var0);
    }

    @Override
    public void a(DataOutput var0) throws IOException {
        try {
            var0.writeUTF(this.A);
        }
        catch (UTFDataFormatException var1) {
            SystemUtils.a("Failed to write NBT String", (Throwable)var1);
            var0.writeUTF("");
        }
    }

    @Override
    public int a() {
        return 36 + 2 * this.A.length();
    }

    @Override
    public byte b() {
        return 8;
    }

    public NBTTagType<NBTTagString> c() {
        return a;
    }

    @Override
    public String toString() {
        return NBTBase.super.m_();
    }

    public NBTTagString e() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagString && Objects.equals(this.A, ((NBTTagString)var0).A);
    }

    public int hashCode() {
        return this.A.hashCode();
    }

    @Override
    public String m_() {
        return this.A;
    }

    @Override
    public void a(TagVisitor var0) {
        var0.a(this);
    }

    public static String b(String var0) {
        StringBuilder var1 = new StringBuilder(" ");
        int var2 = 0;
        for (int var3 = 0; var3 < var0.length(); ++var3) {
            int var4 = var0.charAt(var3);
            if (var4 == 92) {
                var1.append('\\');
            } else if (var4 == 34 || var4 == 39) {
                if (var2 == 0) {
                    int n2 = var2 = var4 == 34 ? 39 : 34;
                }
                if (var2 == var4) {
                    var1.append('\\');
                }
            }
            var1.append((char)var4);
        }
        if (var2 == 0) {
            var2 = 34;
        }
        var1.setCharAt(0, (char)var2);
        var1.append((char)var2);
        return var1.toString();
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor var0) {
        return var0.a(this.A);
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.e();
    }
}

