/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDataSerializer
extends ByteBuf {
    private static final int d = 5;
    private static final int e = 10;
    public static final int a = 0x200000;
    private final ByteBuf f;
    public static final short b = Short.MAX_VALUE;
    public static final int c = 262144;
    private static final int g = 256;
    private static final int h = 256;
    private static final int i = 512;
    private static final Gson j = new Gson();

    public PacketDataSerializer(ByteBuf bytebuf) {
        this.f = bytebuf;
    }

    public static int a(int i2) {
        int j2 = 1;
        while (j2 < 5) {
            if ((i2 & -1 << j2 * 7) == 0) {
                return j2;
            }
            ++j2;
        }
        return 5;
    }

    public static int a(long i2) {
        int j2 = 1;
        while (j2 < 10) {
            if ((i2 & -1L << j2 * 7) == 0L) {
                return j2;
            }
            ++j2;
        }
        return 10;
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> dynamicops, Codec<T> codec) {
        NBTTagCompound nbttagcompound = this.q();
        return SystemUtils.a(codec.parse(dynamicops, (Object)nbttagcompound), s2 -> new DecoderException("Failed to decode: " + s2 + " " + nbttagcompound));
    }

    @Deprecated
    public <T> void a(DynamicOps<NBTBase> dynamicops, Codec<T> codec, T t0) {
        NBTBase nbtbase = (NBTBase)SystemUtils.a(codec.encodeStart(dynamicops, t0), s2 -> new EncoderException("Failed to encode: " + s2 + " " + t0));
        this.a((NBTTagCompound)nbtbase);
    }

    public <T> T a(Codec<T> codec) {
        JsonElement jsonelement = ChatDeserializer.a(j, this.s(), JsonElement.class);
        DataResult dataresult = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return SystemUtils.a(dataresult, s2 -> new DecoderException("Failed to decode json: " + s2));
    }

    public <T> void a(Codec<T> codec, T t0) {
        DataResult dataresult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t0);
        this.a(j.toJson((JsonElement)SystemUtils.a(dataresult, s2 -> new EncoderException("Failed to encode: " + s2 + " " + t0))));
    }

    public <T> void a(Registry<T> registry, T t0) {
        int i2 = registry.a(t0);
        if (i2 == -1) {
            throw new IllegalArgumentException("Can't find id for '" + t0 + "' in map " + registry);
        }
        this.d(i2);
    }

    public <T> void a(Registry<Holder<T>> registry, Holder<T> holder, b<T> packetdataserializer_b) {
        switch (holder.f()) {
            case a: {
                int i2 = registry.a(holder);
                if (i2 == -1) {
                    T object = holder.a();
                    throw new IllegalArgumentException("Can't find id for '" + object + "' in map " + registry);
                }
                this.d(i2 + 1);
                break;
            }
            case b: {
                this.d(0);
                packetdataserializer_b.accept(this, holder.a());
            }
        }
    }

    @Nullable
    public <T> T a(Registry<T> registry) {
        int i2 = this.m();
        return registry.a(i2);
    }

    public <T> Holder<T> a(Registry<Holder<T>> registry, a<T> packetdataserializer_a) {
        int i2 = this.m();
        if (i2 == 0) {
            return Holder.a(packetdataserializer_a.apply(this));
        }
        Holder<T> holder = registry.a(i2 - 1);
        if (holder == null) {
            throw new IllegalArgumentException("Can't find element with id " + i2);
        }
        return holder;
    }

    public static <T> IntFunction<T> a(IntFunction<T> intfunction, int i2) {
        return j2 -> {
            if (j2 > i2) {
                throw new DecoderException("Value " + j2 + " is larger than limit " + i2);
            }
            return intfunction.apply(j2);
        };
    }

    public <T, C extends Collection<T>> C a(IntFunction<C> intfunction, a<T> packetdataserializer_a) {
        int i2 = this.m();
        Collection c0 = (Collection)intfunction.apply(i2);
        int j2 = 0;
        while (j2 < i2) {
            c0.add(packetdataserializer_a.apply(this));
            ++j2;
        }
        return (C)c0;
    }

    public <T> void a(Collection<T> collection, b<T> packetdataserializer_b) {
        this.d(collection.size());
        for (T t0 : collection) {
            packetdataserializer_b.accept(this, t0);
        }
    }

    public <T> List<T> a(a<T> packetdataserializer_a) {
        return this.a(Lists::newArrayListWithCapacity, packetdataserializer_a);
    }

    public IntList a() {
        int i2 = this.m();
        IntArrayList intarraylist = new IntArrayList();
        int j2 = 0;
        while (j2 < i2) {
            intarraylist.add(this.m());
            ++j2;
        }
        return intarraylist;
    }

    public void a(IntList intlist) {
        this.d(intlist.size());
        intlist.forEach(this::d);
    }

    public <K, V, M extends Map<K, V>> M a(IntFunction<M> intfunction, a<K> packetdataserializer_a, a<V> packetdataserializer_a1) {
        int i2 = this.m();
        Map m0 = (Map)intfunction.apply(i2);
        int j2 = 0;
        while (j2 < i2) {
            Object k0 = packetdataserializer_a.apply((K)((Object)this));
            Object v0 = packetdataserializer_a1.apply((V)((Object)this));
            m0.put(k0, v0);
            ++j2;
        }
        return (M)m0;
    }

    public <K, V> Map<K, V> a(a<K> packetdataserializer_a, a<V> packetdataserializer_a1) {
        return this.a(Maps::newHashMapWithExpectedSize, packetdataserializer_a, packetdataserializer_a1);
    }

    public <K, V> void a(Map<K, V> map, b<K> packetdataserializer_b, b<V> packetdataserializer_b1) {
        this.d(map.size());
        map.forEach((object, object1) -> {
            packetdataserializer_b.accept((Object)((Object)this), object);
            packetdataserializer_b1.accept((Object)((Object)this), object1);
        });
    }

    public void a(Consumer<PacketDataSerializer> consumer) {
        int i2 = this.m();
        int j2 = 0;
        while (j2 < i2) {
            consumer.accept(this);
            ++j2;
        }
    }

    public <E extends Enum<E>> void a(EnumSet<E> enumset, Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = new BitSet(ae.length);
        int i2 = 0;
        while (i2 < ae.length) {
            bitset.set(i2, enumset.contains(ae[i2]));
            ++i2;
        }
        this.a(bitset, ae.length);
    }

    public <E extends Enum<E>> EnumSet<E> a(Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = this.f(ae.length);
        EnumSet<Enum> enumset = EnumSet.noneOf(oclass);
        int i2 = 0;
        while (i2 < ae.length) {
            if (bitset.get(i2)) {
                enumset.add(ae[i2]);
            }
            ++i2;
        }
        return enumset;
    }

    public <T> void a(Optional<T> optional, b<T> packetdataserializer_b) {
        if (optional.isPresent()) {
            this.writeBoolean(true);
            packetdataserializer_b.accept(this, optional.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> b(a<T> packetdataserializer_a) {
        return this.readBoolean() ? Optional.of(packetdataserializer_a.apply(this)) : Optional.empty();
    }

    @Nullable
    public <T> T c(a<T> packetdataserializer_a) {
        return this.readBoolean() ? (T)packetdataserializer_a.apply(this) : null;
    }

    public <T> void a(@Nullable T t0, b<T> packetdataserializer_b) {
        if (t0 != null) {
            this.writeBoolean(true);
            packetdataserializer_b.accept(this, t0);
        } else {
            this.writeBoolean(false);
        }
    }

    public <L, R> void a(Either<L, R> either, b<L> packetdataserializer_b, b<R> packetdataserializer_b1) {
        either.ifLeft(object -> {
            this.writeBoolean(true);
            packetdataserializer_b.accept((Object)((Object)this), object);
        }).ifRight(object -> {
            this.writeBoolean(false);
            packetdataserializer_b1.accept((Object)((Object)this), object);
        });
    }

    public <L, R> Either<L, R> b(a<L> packetdataserializer_a, a<R> packetdataserializer_a1) {
        return this.readBoolean() ? Either.left(packetdataserializer_a.apply((L)((Object)this))) : Either.right(packetdataserializer_a1.apply((R)((Object)this)));
    }

    public byte[] b() {
        return this.b(this.readableBytes());
    }

    public PacketDataSerializer a(byte[] abyte) {
        this.d(abyte.length);
        this.writeBytes(abyte);
        return this;
    }

    public byte[] b(int i2) {
        int j2 = this.m();
        if (j2 > i2) {
            throw new DecoderException("ByteArray with size " + j2 + " is bigger than allowed " + i2);
        }
        byte[] abyte = new byte[j2];
        this.readBytes(abyte);
        return abyte;
    }

    public PacketDataSerializer a(int[] aint) {
        this.d(aint.length);
        int[] aint1 = aint;
        int i2 = aint.length;
        int j2 = 0;
        while (j2 < i2) {
            int k2 = aint1[j2];
            this.d(k2);
            ++j2;
        }
        return this;
    }

    public int[] c() {
        return this.c(this.readableBytes());
    }

    public int[] c(int i2) {
        int j2 = this.m();
        if (j2 > i2) {
            throw new DecoderException("VarIntArray with size " + j2 + " is bigger than allowed " + i2);
        }
        int[] aint = new int[j2];
        int k2 = 0;
        while (k2 < aint.length) {
            aint[k2] = this.m();
            ++k2;
        }
        return aint;
    }

    public PacketDataSerializer a(long[] along) {
        this.d(along.length);
        long[] along1 = along;
        int i2 = along.length;
        int j2 = 0;
        while (j2 < i2) {
            long k2 = along1[j2];
            this.writeLong(k2);
            ++j2;
        }
        return this;
    }

    public long[] d() {
        return this.b((long[])null);
    }

    public long[] b(@Nullable long[] along) {
        return this.a(along, this.readableBytes() / 8);
    }

    public long[] a(@Nullable long[] along, int i2) {
        int j2 = this.m();
        if (along == null || along.length != j2) {
            if (j2 > i2) {
                throw new DecoderException("LongArray with size " + j2 + " is bigger than allowed " + i2);
            }
            along = new long[j2];
        }
        int k2 = 0;
        while (k2 < along.length) {
            along[k2] = this.readLong();
            ++k2;
        }
        return along;
    }

    @VisibleForTesting
    public byte[] e() {
        int i2 = this.writerIndex();
        byte[] abyte = new byte[i2];
        this.getBytes(0, abyte);
        return abyte;
    }

    public BlockPosition f() {
        return BlockPosition.d(this.readLong());
    }

    public PacketDataSerializer a(BlockPosition blockposition) {
        this.writeLong(blockposition.a());
        return this;
    }

    public ChunkCoordIntPair g() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer a(ChunkCoordIntPair chunkcoordintpair) {
        this.writeLong(chunkcoordintpair.a());
        return this;
    }

    public SectionPosition h() {
        return SectionPosition.a(this.readLong());
    }

    public PacketDataSerializer a(SectionPosition sectionposition) {
        this.writeLong(sectionposition.s());
        return this;
    }

    public GlobalPos i() {
        ResourceKey<World> resourcekey = this.a(Registries.aH);
        BlockPosition blockposition = this.f();
        return GlobalPos.a(resourcekey, blockposition);
    }

    public void a(GlobalPos globalpos) {
        this.b(globalpos.a());
        this.a(globalpos.b());
    }

    public Vector3f j() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void a(Vector3f vector3f) {
        this.writeFloat(vector3f.x());
        this.writeFloat(vector3f.y());
        this.writeFloat(vector3f.z());
    }

    public Quaternionf k() {
        return new Quaternionf(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void a(Quaternionf quaternionf) {
        this.writeFloat(quaternionf.x);
        this.writeFloat(quaternionf.y);
        this.writeFloat(quaternionf.z);
        this.writeFloat(quaternionf.w);
    }

    public IChatBaseComponent l() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(this.e(262144));
        if (ichatmutablecomponent == null) {
            throw new DecoderException("Received unexpected null component");
        }
        return ichatmutablecomponent;
    }

    public PacketDataSerializer a(IChatBaseComponent ichatbasecomponent) {
        return this.a(IChatBaseComponent.ChatSerializer.a(ichatbasecomponent), 262144);
    }

    public <T extends Enum<T>> T b(Class<T> oclass) {
        return (T)((Enum[])oclass.getEnumConstants())[this.m()];
    }

    public PacketDataSerializer a(Enum<?> oenum) {
        return this.d(oenum.ordinal());
    }

    public int m() {
        byte b0;
        int i2 = 0;
        int j2 = 0;
        do {
            b0 = this.readByte();
            i2 |= (b0 & 0x7F) << j2++ * 7;
            if (j2 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i2;
    }

    public long n() {
        byte b0;
        long i2 = 0L;
        int j2 = 0;
        do {
            b0 = this.readByte();
            i2 |= (long)(b0 & 0x7F) << j2++ * 7;
            if (j2 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i2;
    }

    public PacketDataSerializer a(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    public UUID o() {
        return new UUID(this.readLong(), this.readLong());
    }

    public PacketDataSerializer d(int i2) {
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte(i2 & 0x7F | 0x80);
            i2 >>>= 7;
        }
        this.writeByte(i2);
        return this;
    }

    public PacketDataSerializer b(long i2) {
        while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(i2 & 0x7FL) | 0x80);
            i2 >>>= 7;
        }
        this.writeByte((int)i2);
        return this;
    }

    public PacketDataSerializer a(@Nullable NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.writeByte(0);
        } else {
            try {
                NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            }
            catch (Exception ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
        return this;
    }

    @Nullable
    public NBTTagCompound p() {
        return this.a(new NBTReadLimiter(0x200000L));
    }

    @Nullable
    public NBTTagCompound q() {
        return this.a(NBTReadLimiter.a);
    }

    @Nullable
    public NBTTagCompound a(NBTReadLimiter nbtreadlimiter) {
        int i2 = this.readerIndex();
        byte b0 = this.readByte();
        if (b0 == 0) {
            return null;
        }
        this.readerIndex(i2);
        try {
            return NBTCompressedStreamTools.a((DataInput)new ByteBufInputStream((ByteBuf)this), nbtreadlimiter);
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public PacketDataSerializer a(ItemStack itemstack) {
        if (itemstack.b() || itemstack.d() == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            Item item = itemstack.d();
            this.a(BuiltInRegistries.i, item);
            this.writeByte(itemstack.L());
            NBTTagCompound nbttagcompound = null;
            if (item.o() || item.r()) {
                itemstack = itemstack.p();
                CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                nbttagcompound = itemstack.v();
            }
            this.a(nbttagcompound);
        }
        return this;
    }

    public ItemStack r() {
        if (!this.readBoolean()) {
            return ItemStack.b;
        }
        Item item = this.a(BuiltInRegistries.i);
        byte b0 = this.readByte();
        ItemStack itemstack = new ItemStack(item, (int)b0);
        itemstack.c(this.p());
        if (itemstack.v() != null) {
            CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
        }
        return itemstack;
    }

    public String s() {
        return this.e(Short.MAX_VALUE);
    }

    public String e(int i2) {
        int j2 = PacketDataSerializer.g(i2);
        int k2 = this.m();
        if (k2 > j2) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + k2 + " > " + j2 + ")");
        }
        if (k2 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s2 = this.toString(this.readerIndex(), k2, StandardCharsets.UTF_8);
        this.readerIndex(this.readerIndex() + k2);
        if (s2.length() > i2) {
            int l2 = s2.length();
            throw new DecoderException("The received string length is longer than maximum allowed (" + l2 + " > " + i2 + ")");
        }
        return s2;
    }

    public PacketDataSerializer a(String s2) {
        return this.a(s2, Short.MAX_VALUE);
    }

    public PacketDataSerializer a(String s2, int i2) {
        int k2;
        if (s2.length() > i2) {
            int j2 = s2.length();
            throw new EncoderException("String too big (was " + j2 + " characters, max " + i2 + ")");
        }
        byte[] abyte = s2.getBytes(StandardCharsets.UTF_8);
        if (abyte.length > (k2 = PacketDataSerializer.g(i2))) {
            throw new EncoderException("String too big (was " + abyte.length + " bytes encoded, max " + k2 + ")");
        }
        this.d(abyte.length);
        this.writeBytes(abyte);
        return this;
    }

    private static int g(int i2) {
        return i2 * 3;
    }

    public MinecraftKey t() {
        return new MinecraftKey(this.e(Short.MAX_VALUE));
    }

    public PacketDataSerializer a(MinecraftKey minecraftkey) {
        this.a(minecraftkey.toString());
        return this;
    }

    public <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> resourcekey) {
        MinecraftKey minecraftkey = this.t();
        return ResourceKey.a(resourcekey, minecraftkey);
    }

    public void b(ResourceKey<?> resourcekey) {
        this.a(resourcekey.a());
    }

    public Date u() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer a(Date date) {
        this.writeLong(date.getTime());
        return this;
    }

    public Instant v() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void a(Instant instant) {
        this.writeLong(instant.toEpochMilli());
    }

    public PublicKey w() {
        try {
            return MinecraftEncryption.a(this.b(512));
        }
        catch (CryptographyException cryptographyexception) {
            throw new DecoderException("Malformed public key bytes", (Throwable)cryptographyexception);
        }
    }

    public PacketDataSerializer a(PublicKey publickey) {
        this.a(publickey.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock x() {
        BlockPosition blockposition = this.f();
        EnumDirection enumdirection = this.b(EnumDirection.class);
        float f2 = this.readFloat();
        float f1 = this.readFloat();
        float f22 = this.readFloat();
        boolean flag = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockposition.u() + (double)f2, (double)blockposition.v() + (double)f1, (double)blockposition.w() + (double)f22), enumdirection, blockposition, flag);
    }

    public void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.a();
        this.a(blockposition);
        this.a(movingobjectpositionblock.b());
        Vec3D vec3d = movingobjectpositionblock.e();
        this.writeFloat((float)(vec3d.c - (double)blockposition.u()));
        this.writeFloat((float)(vec3d.d - (double)blockposition.v()));
        this.writeFloat((float)(vec3d.e - (double)blockposition.w()));
        this.writeBoolean(movingobjectpositionblock.d());
    }

    public BitSet y() {
        return BitSet.valueOf(this.d());
    }

    public void a(BitSet bitset) {
        this.a(bitset.toLongArray());
    }

    public BitSet f(int i2) {
        byte[] abyte = new byte[MathHelper.e(i2, 8)];
        this.readBytes(abyte);
        return BitSet.valueOf(abyte);
    }

    public void a(BitSet bitset, int i2) {
        if (bitset.length() > i2) {
            int j2 = bitset.length();
            throw new EncoderException("BitSet is larger than expected size (" + j2 + ">" + i2 + ")");
        }
        byte[] abyte = bitset.toByteArray();
        this.writeBytes(Arrays.copyOf(abyte, MathHelper.e(i2, 8)));
    }

    public GameProfile z() {
        UUID uuid = this.o();
        String s2 = this.e(16);
        GameProfile gameprofile = new GameProfile(uuid, s2);
        gameprofile.getProperties().putAll((Multimap)this.A());
        return gameprofile;
    }

    public void a(GameProfile gameprofile) {
        this.a(gameprofile.getId());
        this.a(gameprofile.getName());
        this.a(gameprofile.getProperties());
    }

    public PropertyMap A() {
        PropertyMap propertymap = new PropertyMap();
        this.a((PacketDataSerializer packetdataserializer) -> {
            Property property = this.B();
            propertymap.put((Object)property.getName(), (Object)property);
        });
        return propertymap;
    }

    public void a(PropertyMap propertymap) {
        this.a((Object)propertymap.values(), PacketDataSerializer::a);
    }

    public Property B() {
        String s2 = this.s();
        String s1 = this.s();
        if (this.readBoolean()) {
            String s22 = this.s();
            return new Property(s2, s1, s22);
        }
        return new Property(s2, s1);
    }

    public void a(Property property) {
        this.a(property.getName());
        this.a(property.getValue());
        if (property.hasSignature()) {
            this.writeBoolean(true);
            this.a(property.getSignature());
        } else {
            this.writeBoolean(false);
        }
    }

    public int capacity() {
        return this.f.capacity();
    }

    public ByteBuf capacity(int i2) {
        return this.f.capacity(i2);
    }

    public int maxCapacity() {
        return this.f.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.f.alloc();
    }

    public ByteOrder order() {
        return this.f.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.f.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.f.unwrap();
    }

    public boolean isDirect() {
        return this.f.isDirect();
    }

    public boolean isReadOnly() {
        return this.f.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.f.asReadOnly();
    }

    public int readerIndex() {
        return this.f.readerIndex();
    }

    public ByteBuf readerIndex(int i2) {
        return this.f.readerIndex(i2);
    }

    public int writerIndex() {
        return this.f.writerIndex();
    }

    public ByteBuf writerIndex(int i2) {
        return this.f.writerIndex(i2);
    }

    public ByteBuf setIndex(int i2, int j2) {
        return this.f.setIndex(i2, j2);
    }

    public int readableBytes() {
        return this.f.readableBytes();
    }

    public int writableBytes() {
        return this.f.writableBytes();
    }

    public int maxWritableBytes() {
        return this.f.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.f.isReadable();
    }

    public boolean isReadable(int i2) {
        return this.f.isReadable(i2);
    }

    public boolean isWritable() {
        return this.f.isWritable();
    }

    public boolean isWritable(int i2) {
        return this.f.isWritable(i2);
    }

    public ByteBuf clear() {
        return this.f.clear();
    }

    public ByteBuf markReaderIndex() {
        return this.f.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        return this.f.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        return this.f.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        return this.f.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        return this.f.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        return this.f.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int i2) {
        return this.f.ensureWritable(i2);
    }

    public int ensureWritable(int i2, boolean flag) {
        return this.f.ensureWritable(i2, flag);
    }

    public boolean getBoolean(int i2) {
        return this.f.getBoolean(i2);
    }

    public byte getByte(int i2) {
        return this.f.getByte(i2);
    }

    public short getUnsignedByte(int i2) {
        return this.f.getUnsignedByte(i2);
    }

    public short getShort(int i2) {
        return this.f.getShort(i2);
    }

    public short getShortLE(int i2) {
        return this.f.getShortLE(i2);
    }

    public int getUnsignedShort(int i2) {
        return this.f.getUnsignedShort(i2);
    }

    public int getUnsignedShortLE(int i2) {
        return this.f.getUnsignedShortLE(i2);
    }

    public int getMedium(int i2) {
        return this.f.getMedium(i2);
    }

    public int getMediumLE(int i2) {
        return this.f.getMediumLE(i2);
    }

    public int getUnsignedMedium(int i2) {
        return this.f.getUnsignedMedium(i2);
    }

    public int getUnsignedMediumLE(int i2) {
        return this.f.getUnsignedMediumLE(i2);
    }

    public int getInt(int i2) {
        return this.f.getInt(i2);
    }

    public int getIntLE(int i2) {
        return this.f.getIntLE(i2);
    }

    public long getUnsignedInt(int i2) {
        return this.f.getUnsignedInt(i2);
    }

    public long getUnsignedIntLE(int i2) {
        return this.f.getUnsignedIntLE(i2);
    }

    public long getLong(int i2) {
        return this.f.getLong(i2);
    }

    public long getLongLE(int i2) {
        return this.f.getLongLE(i2);
    }

    public char getChar(int i2) {
        return this.f.getChar(i2);
    }

    public float getFloat(int i2) {
        return this.f.getFloat(i2);
    }

    public double getDouble(int i2) {
        return this.f.getDouble(i2);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf) {
        return this.f.getBytes(i2, bytebuf);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf, int j2) {
        return this.f.getBytes(i2, bytebuf, j2);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        return this.f.getBytes(i2, bytebuf, j2, k2);
    }

    public ByteBuf getBytes(int i2, byte[] abyte) {
        return this.f.getBytes(i2, abyte);
    }

    public ByteBuf getBytes(int i2, byte[] abyte, int j2, int k2) {
        return this.f.getBytes(i2, abyte, j2, k2);
    }

    public ByteBuf getBytes(int i2, ByteBuffer bytebuffer) {
        return this.f.getBytes(i2, bytebuffer);
    }

    public ByteBuf getBytes(int i2, OutputStream outputstream, int j2) throws IOException {
        return this.f.getBytes(i2, outputstream, j2);
    }

    public int getBytes(int i2, GatheringByteChannel gatheringbytechannel, int j2) throws IOException {
        return this.f.getBytes(i2, gatheringbytechannel, j2);
    }

    public int getBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.f.getBytes(i2, filechannel, j2, k2);
    }

    public CharSequence getCharSequence(int i2, int j2, Charset charset) {
        return this.f.getCharSequence(i2, j2, charset);
    }

    public ByteBuf setBoolean(int i2, boolean flag) {
        return this.f.setBoolean(i2, flag);
    }

    public ByteBuf setByte(int i2, int j2) {
        return this.f.setByte(i2, j2);
    }

    public ByteBuf setShort(int i2, int j2) {
        return this.f.setShort(i2, j2);
    }

    public ByteBuf setShortLE(int i2, int j2) {
        return this.f.setShortLE(i2, j2);
    }

    public ByteBuf setMedium(int i2, int j2) {
        return this.f.setMedium(i2, j2);
    }

    public ByteBuf setMediumLE(int i2, int j2) {
        return this.f.setMediumLE(i2, j2);
    }

    public ByteBuf setInt(int i2, int j2) {
        return this.f.setInt(i2, j2);
    }

    public ByteBuf setIntLE(int i2, int j2) {
        return this.f.setIntLE(i2, j2);
    }

    public ByteBuf setLong(int i2, long j2) {
        return this.f.setLong(i2, j2);
    }

    public ByteBuf setLongLE(int i2, long j2) {
        return this.f.setLongLE(i2, j2);
    }

    public ByteBuf setChar(int i2, int j2) {
        return this.f.setChar(i2, j2);
    }

    public ByteBuf setFloat(int i2, float f2) {
        return this.f.setFloat(i2, f2);
    }

    public ByteBuf setDouble(int i2, double d0) {
        return this.f.setDouble(i2, d0);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf) {
        return this.f.setBytes(i2, bytebuf);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf, int j2) {
        return this.f.setBytes(i2, bytebuf, j2);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        return this.f.setBytes(i2, bytebuf, j2, k2);
    }

    public ByteBuf setBytes(int i2, byte[] abyte) {
        return this.f.setBytes(i2, abyte);
    }

    public ByteBuf setBytes(int i2, byte[] abyte, int j2, int k2) {
        return this.f.setBytes(i2, abyte, j2, k2);
    }

    public ByteBuf setBytes(int i2, ByteBuffer bytebuffer) {
        return this.f.setBytes(i2, bytebuffer);
    }

    public int setBytes(int i2, InputStream inputstream, int j2) throws IOException {
        return this.f.setBytes(i2, inputstream, j2);
    }

    public int setBytes(int i2, ScatteringByteChannel scatteringbytechannel, int j2) throws IOException {
        return this.f.setBytes(i2, scatteringbytechannel, j2);
    }

    public int setBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.f.setBytes(i2, filechannel, j2, k2);
    }

    public ByteBuf setZero(int i2, int j2) {
        return this.f.setZero(i2, j2);
    }

    public int setCharSequence(int i2, CharSequence charsequence, Charset charset) {
        return this.f.setCharSequence(i2, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.f.readBoolean();
    }

    public byte readByte() {
        return this.f.readByte();
    }

    public short readUnsignedByte() {
        return this.f.readUnsignedByte();
    }

    public short readShort() {
        return this.f.readShort();
    }

    public short readShortLE() {
        return this.f.readShortLE();
    }

    public int readUnsignedShort() {
        return this.f.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.f.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.f.readMedium();
    }

    public int readMediumLE() {
        return this.f.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.f.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.f.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.f.readInt();
    }

    public int readIntLE() {
        return this.f.readIntLE();
    }

    public long readUnsignedInt() {
        return this.f.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.f.readUnsignedIntLE();
    }

    public long readLong() {
        return this.f.readLong();
    }

    public long readLongLE() {
        return this.f.readLongLE();
    }

    public char readChar() {
        return this.f.readChar();
    }

    public float readFloat() {
        return this.f.readFloat();
    }

    public double readDouble() {
        return this.f.readDouble();
    }

    public ByteBuf readBytes(int i2) {
        return this.f.readBytes(i2);
    }

    public ByteBuf readSlice(int i2) {
        return this.f.readSlice(i2);
    }

    public ByteBuf readRetainedSlice(int i2) {
        return this.f.readRetainedSlice(i2);
    }

    public ByteBuf readBytes(ByteBuf bytebuf) {
        return this.f.readBytes(bytebuf);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i2) {
        return this.f.readBytes(bytebuf, i2);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i2, int j2) {
        return this.f.readBytes(bytebuf, i2, j2);
    }

    public ByteBuf readBytes(byte[] abyte) {
        return this.f.readBytes(abyte);
    }

    public ByteBuf readBytes(byte[] abyte, int i2, int j2) {
        return this.f.readBytes(abyte, i2, j2);
    }

    public ByteBuf readBytes(ByteBuffer bytebuffer) {
        return this.f.readBytes(bytebuffer);
    }

    public ByteBuf readBytes(OutputStream outputstream, int i2) throws IOException {
        return this.f.readBytes(outputstream, i2);
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i2) throws IOException {
        return this.f.readBytes(gatheringbytechannel, i2);
    }

    public CharSequence readCharSequence(int i2, Charset charset) {
        return this.f.readCharSequence(i2, charset);
    }

    public int readBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.f.readBytes(filechannel, i2, j2);
    }

    public ByteBuf skipBytes(int i2) {
        return this.f.skipBytes(i2);
    }

    public ByteBuf writeBoolean(boolean flag) {
        return this.f.writeBoolean(flag);
    }

    public ByteBuf writeByte(int i2) {
        return this.f.writeByte(i2);
    }

    public ByteBuf writeShort(int i2) {
        return this.f.writeShort(i2);
    }

    public ByteBuf writeShortLE(int i2) {
        return this.f.writeShortLE(i2);
    }

    public ByteBuf writeMedium(int i2) {
        return this.f.writeMedium(i2);
    }

    public ByteBuf writeMediumLE(int i2) {
        return this.f.writeMediumLE(i2);
    }

    public ByteBuf writeInt(int i2) {
        return this.f.writeInt(i2);
    }

    public ByteBuf writeIntLE(int i2) {
        return this.f.writeIntLE(i2);
    }

    public ByteBuf writeLong(long i2) {
        return this.f.writeLong(i2);
    }

    public ByteBuf writeLongLE(long i2) {
        return this.f.writeLongLE(i2);
    }

    public ByteBuf writeChar(int i2) {
        return this.f.writeChar(i2);
    }

    public ByteBuf writeFloat(float f2) {
        return this.f.writeFloat(f2);
    }

    public ByteBuf writeDouble(double d0) {
        return this.f.writeDouble(d0);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf) {
        return this.f.writeBytes(bytebuf);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i2) {
        return this.f.writeBytes(bytebuf, i2);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i2, int j2) {
        return this.f.writeBytes(bytebuf, i2, j2);
    }

    public ByteBuf writeBytes(byte[] abyte) {
        return this.f.writeBytes(abyte);
    }

    public ByteBuf writeBytes(byte[] abyte, int i2, int j2) {
        return this.f.writeBytes(abyte, i2, j2);
    }

    public ByteBuf writeBytes(ByteBuffer bytebuffer) {
        return this.f.writeBytes(bytebuffer);
    }

    public int writeBytes(InputStream inputstream, int i2) throws IOException {
        return this.f.writeBytes(inputstream, i2);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i2) throws IOException {
        return this.f.writeBytes(scatteringbytechannel, i2);
    }

    public int writeBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.f.writeBytes(filechannel, i2, j2);
    }

    public ByteBuf writeZero(int i2) {
        return this.f.writeZero(i2);
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.f.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i2, int j2, byte b0) {
        return this.f.indexOf(i2, j2, b0);
    }

    public int bytesBefore(byte b0) {
        return this.f.bytesBefore(b0);
    }

    public int bytesBefore(int i2, byte b0) {
        return this.f.bytesBefore(i2, b0);
    }

    public int bytesBefore(int i2, int j2, byte b0) {
        return this.f.bytesBefore(i2, j2, b0);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.f.forEachByte(byteprocessor);
    }

    public int forEachByte(int i2, int j2, ByteProcessor byteprocessor) {
        return this.f.forEachByte(i2, j2, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.f.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i2, int j2, ByteProcessor byteprocessor) {
        return this.f.forEachByteDesc(i2, j2, byteprocessor);
    }

    public ByteBuf copy() {
        return this.f.copy();
    }

    public ByteBuf copy(int i2, int j2) {
        return this.f.copy(i2, j2);
    }

    public ByteBuf slice() {
        return this.f.slice();
    }

    public ByteBuf retainedSlice() {
        return this.f.retainedSlice();
    }

    public ByteBuf slice(int i2, int j2) {
        return this.f.slice(i2, j2);
    }

    public ByteBuf retainedSlice(int i2, int j2) {
        return this.f.retainedSlice(i2, j2);
    }

    public ByteBuf duplicate() {
        return this.f.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.f.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.f.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.f.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i2, int j2) {
        return this.f.nioBuffer(i2, j2);
    }

    public ByteBuffer internalNioBuffer(int i2, int j2) {
        return this.f.internalNioBuffer(i2, j2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.f.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i2, int j2) {
        return this.f.nioBuffers(i2, j2);
    }

    public boolean hasArray() {
        return this.f.hasArray();
    }

    public byte[] array() {
        return this.f.array();
    }

    public int arrayOffset() {
        return this.f.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.f.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.f.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.f.toString(charset);
    }

    public String toString(int i2, int j2, Charset charset) {
        return this.f.toString(i2, j2, charset);
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object object) {
        return this.f.equals(object);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.f.compareTo(bytebuf);
    }

    public String toString() {
        return this.f.toString();
    }

    public ByteBuf retain(int i2) {
        return this.f.retain(i2);
    }

    public ByteBuf retain() {
        return this.f.retain();
    }

    public ByteBuf touch() {
        return this.f.touch();
    }

    public ByteBuf touch(Object object) {
        return this.f.touch(object);
    }

    public int refCnt() {
        return this.f.refCnt();
    }

    public boolean release() {
        return this.f.release();
    }

    public boolean release(int i2) {
        return this.f.release(i2);
    }

    @FunctionalInterface
    public static interface a<T>
    extends Function<PacketDataSerializer, T> {
        default public a<Optional<T>> asOptional() {
            return packetdataserializer -> packetdataserializer.b(this);
        }
    }

    @FunctionalInterface
    public static interface b<T>
    extends BiConsumer<PacketDataSerializer, T> {
        default public b<Optional<T>> asOptional() {
            return (packetdataserializer, optional) -> packetdataserializer.a(optional, this);
        }
    }
}

