/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;

public final class ChatMessageType
extends Record {
    private final ChatDecoration j;
    private final ChatDecoration k;
    public static final Codec<ChatMessageType> a = RecordCodecBuilder.create(instance -> instance.group((App)ChatDecoration.a.fieldOf("chat").forGetter(ChatMessageType::a), (App)ChatDecoration.a.fieldOf("narration").forGetter(ChatMessageType::b)).apply((Applicative)instance, ChatMessageType::new));
    public static final ChatDecoration b = ChatDecoration.a("chat.type.text");
    public static final ResourceKey<ChatMessageType> c = ChatMessageType.a("chat");
    public static final ResourceKey<ChatMessageType> d = ChatMessageType.a("say_command");
    public static final ResourceKey<ChatMessageType> e = ChatMessageType.a("msg_command_incoming");
    public static final ResourceKey<ChatMessageType> f = ChatMessageType.a("msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> g = ChatMessageType.a("team_msg_command_incoming");
    public static final ResourceKey<ChatMessageType> h = ChatMessageType.a("team_msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> i = ChatMessageType.a("emote_command");
    public static final ResourceKey<ChatMessageType> RAW = ChatMessageType.a("raw");

    public ChatMessageType(ChatDecoration chat, ChatDecoration narration) {
        this.j = chat;
        this.k = narration;
    }

    private static ResourceKey<ChatMessageType> a(String s2) {
        return ResourceKey.a(Registries.aq, new MinecraftKey(s2));
    }

    public static void a(BootstapContext<ChatMessageType> bootstapcontext) {
        bootstapcontext.a(c, new ChatMessageType(b, ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(d, new ChatMessageType(ChatDecoration.a("chat.type.announcement"), ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(e, new ChatMessageType(ChatDecoration.b("commands.message.display.incoming"), ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(f, new ChatMessageType(ChatDecoration.c("commands.message.display.outgoing"), ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(g, new ChatMessageType(ChatDecoration.d("chat.type.team.text"), ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(h, new ChatMessageType(ChatDecoration.d("chat.type.team.sent"), ChatDecoration.a("chat.type.text.narrate")));
        bootstapcontext.a(i, new ChatMessageType(ChatDecoration.a("chat.type.emote"), ChatDecoration.a("chat.type.emote")));
        bootstapcontext.a(RAW, new ChatMessageType(new ChatDecoration("%s", List.of(ChatDecoration.a.c), ChatModifier.a), new ChatDecoration("%s", List.of(ChatDecoration.a.c), ChatModifier.a)));
    }

    public static a a(ResourceKey<ChatMessageType> resourcekey, Entity entity) {
        return ChatMessageType.a(resourcekey, entity.dI().B_(), entity.H_());
    }

    public static a a(ResourceKey<ChatMessageType> resourcekey, CommandListenerWrapper commandlistenerwrapper) {
        return ChatMessageType.a(resourcekey, commandlistenerwrapper.v(), commandlistenerwrapper.b());
    }

    public static a a(ResourceKey<ChatMessageType> resourcekey, IRegistryCustom iregistrycustom, IChatBaseComponent ichatbasecomponent) {
        IRegistry<ChatMessageType> iregistry = iregistrycustom.d(Registries.aq);
        return iregistry.e(resourcekey).a(ichatbasecomponent);
    }

    public a a(IChatBaseComponent ichatbasecomponent) {
        return new a(this, ichatbasecomponent);
    }

    public ChatDecoration a() {
        return this.j;
    }

    public ChatDecoration b() {
        return this.k;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this, object);
    }

    public record a(ChatMessageType a, IChatBaseComponent b, @Nullable IChatBaseComponent c) {
        a(ChatMessageType chatmessagetype, IChatBaseComponent ichatbasecomponent) {
            this(chatmessagetype, ichatbasecomponent, null);
        }

        public IChatBaseComponent a(IChatBaseComponent ichatbasecomponent) {
            return this.a.a().a(ichatbasecomponent, this);
        }

        public IChatBaseComponent b(IChatBaseComponent ichatbasecomponent) {
            return this.a.b().a(ichatbasecomponent, this);
        }

        public a c(IChatBaseComponent ichatbasecomponent) {
            return new a(this.a, this.b, ichatbasecomponent);
        }

        public b a(IRegistryCustom iregistrycustom) {
            IRegistry<ChatMessageType> iregistry = iregistrycustom.d(Registries.aq);
            return new b(iregistry.a(this.a), this.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this, object);
        }
    }

    public record b(int a, IChatBaseComponent b, @Nullable IChatBaseComponent c) {
        public b(PacketDataSerializer packetdataserializer) {
            this(packetdataserializer.m(), packetdataserializer.l(), (IChatBaseComponent)packetdataserializer.c(PacketDataSerializer::l));
        }

        public void a(PacketDataSerializer packetdataserializer) {
            packetdataserializer.d(this.a);
            packetdataserializer.a(this.b);
            packetdataserializer.a(this.c, PacketDataSerializer::a);
        }

        public Optional<a> a(IRegistryCustom iregistrycustom) {
            IRegistry<ChatMessageType> iregistry = iregistrycustom.d(Registries.aq);
            ChatMessageType chatmessagetype = (ChatMessageType)iregistry.a(this.a);
            return Optional.ofNullable(chatmessagetype).map(chatmessagetype1 -> new a((ChatMessageType)chatmessagetype1, this.b, this.c));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this, object);
        }
    }
}

