/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ChatTypeAdapterFactory;
import net.minecraft.util.FormattedString;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.c().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier a();

    public ComponentContents b();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String a(int i2) {
        StringBuilder stringbuilder = new StringBuilder();
        this.a((String s2) -> {
            int j2 = i2 - stringbuilder.length();
            if (j2 <= 0) {
                return a;
            }
            stringbuilder.append(s2.length() <= j2 ? s2 : s2.substring(0, j2));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<IChatBaseComponent> c();

    default public IChatMutableComponent d() {
        return IChatMutableComponent.a(this.b());
    }

    default public IChatMutableComponent e() {
        return new IChatMutableComponent(this.b(), new ArrayList<IChatBaseComponent>(this.c()), this.a());
    }

    public FormattedString f();

    @Override
    default public <T> Optional<T> a(IChatFormatted.b<T> ichatformatted_b, ChatModifier chatmodifier) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        ChatModifier chatmodifier1 = this.a().a(chatmodifier);
        Optional<T> optional = this.b().a(ichatformatted_b, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.c().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(ichatformatted_b, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> a(IChatFormatted.a<T> ichatformatted_a) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.b().a(ichatformatted_a);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.c().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(ichatformatted_a)).isPresent());
        return optional1;
    }

    default public List<IChatBaseComponent> g() {
        return this.a(ChatModifier.a);
    }

    default public List<IChatBaseComponent> a(ChatModifier chatmodifier) {
        ArrayList list = Lists.newArrayList();
        this.a((chatmodifier1, s2) -> {
            if (!s2.isEmpty()) {
                list.add(IChatBaseComponent.b(s2).c(chatmodifier1));
            }
            return Optional.empty();
        }, chatmodifier);
        return list;
    }

    default public boolean a(IChatBaseComponent ichatbasecomponent) {
        List<IChatBaseComponent> list1;
        if (this.equals(ichatbasecomponent)) {
            return true;
        }
        List<IChatBaseComponent> list = this.g();
        return Collections.indexOfSubList(list, list1 = ichatbasecomponent.a(this.a())) != -1;
    }

    public static IChatBaseComponent a(@Nullable String s2) {
        return s2 != null ? IChatBaseComponent.b(s2) : CommonComponents.a;
    }

    public static IChatMutableComponent b(String s2) {
        return IChatMutableComponent.a(new LiteralContents(s2));
    }

    public static IChatMutableComponent c(String s2) {
        return IChatMutableComponent.a(new TranslatableContents(s2, null, TranslatableContents.b));
    }

    public static IChatMutableComponent a(String s2, Object ... aobject) {
        return IChatMutableComponent.a(new TranslatableContents(s2, null, aobject));
    }

    public static IChatMutableComponent a(String s2, @Nullable String s1) {
        return IChatMutableComponent.a(new TranslatableContents(s2, s1, TranslatableContents.b));
    }

    public static IChatMutableComponent a(String s2, @Nullable String s1, Object ... aobject) {
        return IChatMutableComponent.a(new TranslatableContents(s2, s1, aobject));
    }

    public static IChatMutableComponent h() {
        return IChatMutableComponent.a(ComponentContents.a);
    }

    public static IChatMutableComponent d(String s2) {
        return IChatMutableComponent.a(new KeybindContents(s2));
    }

    public static IChatMutableComponent a(String s2, boolean flag, Optional<IChatBaseComponent> optional, DataSource datasource) {
        return IChatMutableComponent.a(new NbtContents(s2, flag, optional, datasource));
    }

    public static IChatMutableComponent b(String s2, String s1) {
        return IChatMutableComponent.a(new ScoreContents(s2, s1));
    }

    public static IChatMutableComponent a(String s2, Optional<IChatBaseComponent> optional) {
        return IChatMutableComponent.a(new SelectorContents(s2, optional));
    }

    public static class ChatSerializer
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private static final Gson a = SystemUtils.a(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeHierarchyAdapter(IChatBaseComponent.class, (Object)new ChatSerializer());
            gsonbuilder.registerTypeHierarchyAdapter(ChatModifier.class, (Object)new ChatModifier.ChatModifierSerializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ChatTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field b = SystemUtils.a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field c = SystemUtils.a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        public IChatMutableComponent a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            IChatMutableComponent ichatmutablecomponent;
            if (jsonelement.isJsonPrimitive()) {
                return IChatBaseComponent.b(jsonelement.getAsString());
            }
            if (!jsonelement.isJsonObject()) {
                if (jsonelement.isJsonArray()) {
                    JsonArray jsonarray = jsonelement.getAsJsonArray();
                    IChatMutableComponent ichatmutablecomponent2 = null;
                    for (JsonElement jsonelement1 : jsonarray) {
                        IChatMutableComponent ichatmutablecomponent1 = this.a(jsonelement1, jsonelement1.getClass(), jsondeserializationcontext);
                        if (ichatmutablecomponent2 == null) {
                            ichatmutablecomponent2 = ichatmutablecomponent1;
                            continue;
                        }
                        ichatmutablecomponent2.b(ichatmutablecomponent1);
                    }
                    return ichatmutablecomponent2;
                }
                throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
            }
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            if (jsonobject.has("text")) {
                s = ChatDeserializer.i(jsonobject, "text");
                ichatmutablecomponent = s.isEmpty() ? IChatBaseComponent.h() : IChatBaseComponent.b(s);
            } else if (jsonobject.has("translate")) {
                s = ChatDeserializer.i(jsonobject, "translate");
                String s1 = ChatDeserializer.a(jsonobject, "fallback", null);
                if (jsonobject.has("with")) {
                    JsonArray jsonarray1 = ChatDeserializer.v(jsonobject, "with");
                    Object[] aobject = new Object[jsonarray1.size()];
                    int i2 = 0;
                    while (i2 < aobject.length) {
                        aobject[i2] = ChatSerializer.a((Object)this.a(jsonarray1.get(i2), type, jsondeserializationcontext));
                        ++i2;
                    }
                    ichatmutablecomponent = IChatBaseComponent.a(s, s1, aobject);
                } else {
                    ichatmutablecomponent = IChatBaseComponent.a(s, s1);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = ChatDeserializer.u(jsonobject, "score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                ichatmutablecomponent = IChatBaseComponent.b(ChatDeserializer.i(jsonobject1, "name"), ChatDeserializer.i(jsonobject1, "objective"));
            } else if (jsonobject.has("selector")) {
                Optional<IChatBaseComponent> optional = this.a(type, jsondeserializationcontext, jsonobject);
                ichatmutablecomponent = IChatBaseComponent.a(ChatDeserializer.i(jsonobject, "selector"), optional);
            } else if (jsonobject.has("keybind")) {
                ichatmutablecomponent = IChatBaseComponent.d(ChatDeserializer.i(jsonobject, "keybind"));
            } else {
                Record object;
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                }
                s = ChatDeserializer.i(jsonobject, "nbt");
                Optional<IChatBaseComponent> optional1 = this.a(type, jsondeserializationcontext, jsonobject);
                boolean flag = ChatDeserializer.a(jsonobject, "interpret", false);
                if (jsonobject.has("block")) {
                    object = new BlockDataSource(ChatDeserializer.i(jsonobject, "block"));
                } else if (jsonobject.has("entity")) {
                    object = new EntityDataSource(ChatDeserializer.i(jsonobject, "entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                    }
                    object = new StorageDataSource(new MinecraftKey(ChatDeserializer.i(jsonobject, "storage")));
                }
                ichatmutablecomponent = IChatBaseComponent.a(s, flag, optional1, object);
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = ChatDeserializer.v(jsonobject, "extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                int j2 = 0;
                while (j2 < jsonarray2.size()) {
                    ichatmutablecomponent.b(this.a(jsonarray2.get(j2), type, jsondeserializationcontext));
                    ++j2;
                }
            }
            ichatmutablecomponent.b((ChatModifier)jsondeserializationcontext.deserialize(jsonelement, ChatModifier.class));
            return ichatmutablecomponent;
        }

        private static Object a(Object object) {
            ComponentContents componentcontents;
            IChatBaseComponent ichatbasecomponent;
            if (object instanceof IChatBaseComponent && (ichatbasecomponent = (IChatBaseComponent)object).a().g() && ichatbasecomponent.c().isEmpty() && (componentcontents = ichatbasecomponent.b()) instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                return literalcontents.a();
            }
            return object;
        }

        private Optional<IChatBaseComponent> a(Type type, JsonDeserializationContext jsondeserializationcontext, JsonObject jsonobject) {
            return jsonobject.has("separator") ? Optional.of(this.a(jsonobject.get("separator"), type, jsondeserializationcontext)) : Optional.empty();
        }

        private void a(ChatModifier chatmodifier, JsonObject jsonobject, JsonSerializationContext jsonserializationcontext) {
            JsonElement jsonelement = jsonserializationcontext.serialize((Object)chatmodifier);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject1 = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject1.entrySet()) {
                    jsonobject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement a(IChatBaseComponent ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            ComponentContents componentcontents;
            JsonObject jsonobject = new JsonObject();
            if (!ichatbasecomponent.a().g()) {
                this.a(ichatbasecomponent.a(), jsonobject, jsonserializationcontext);
            }
            if (!ichatbasecomponent.c().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.c()) {
                    jsonarray.add(this.a(ichatbasecomponent1, (Type)((Object)IChatBaseComponent.class), jsonserializationcontext));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if ((componentcontents = ichatbasecomponent.b()) == ComponentContents.a) {
                jsonobject.addProperty("text", "");
            } else if (componentcontents instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                jsonobject.addProperty("text", literalcontents.a());
            } else if (componentcontents instanceof TranslatableContents) {
                TranslatableContents translatablecontents = (TranslatableContents)componentcontents;
                jsonobject.addProperty("translate", translatablecontents.a());
                String s2 = translatablecontents.b();
                if (s2 != null) {
                    jsonobject.addProperty("fallback", s2);
                }
                if (translatablecontents.c().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    Object[] aobject = translatablecontents.c();
                    int i2 = aobject.length;
                    int j2 = 0;
                    while (j2 < i2) {
                        Object object = aobject[j2];
                        if (object instanceof IChatBaseComponent) {
                            jsonarray1.add(this.a((IChatBaseComponent)object, object.getClass(), jsonserializationcontext));
                        } else {
                            jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                        }
                        ++j2;
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (componentcontents instanceof ScoreContents) {
                ScoreContents scorecontents = (ScoreContents)componentcontents;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecontents.a());
                jsonobject1.addProperty("objective", scorecontents.c());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (componentcontents instanceof SelectorContents) {
                SelectorContents selectorcontents = (SelectorContents)componentcontents;
                jsonobject.addProperty("selector", selectorcontents.a());
                this.a(jsonserializationcontext, jsonobject, selectorcontents.c());
            } else if (componentcontents instanceof KeybindContents) {
                KeybindContents keybindcontents = (KeybindContents)componentcontents;
                jsonobject.addProperty("keybind", keybindcontents.a());
            } else {
                if (!(componentcontents instanceof NbtContents)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                }
                NbtContents nbtcontents = (NbtContents)componentcontents;
                jsonobject.addProperty("nbt", nbtcontents.a());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcontents.b()));
                this.a(jsonserializationcontext, jsonobject, nbtcontents.c());
                DataSource datasource = nbtcontents.d();
                if (datasource instanceof BlockDataSource) {
                    BlockDataSource blockdatasource = (BlockDataSource)datasource;
                    jsonobject.addProperty("block", blockdatasource.a());
                } else if (datasource instanceof EntityDataSource) {
                    EntityDataSource entitydatasource = (EntityDataSource)datasource;
                    jsonobject.addProperty("entity", entitydatasource.a());
                } else {
                    if (!(datasource instanceof StorageDataSource)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                    }
                    StorageDataSource storagedatasource = (StorageDataSource)datasource;
                    jsonobject.addProperty("storage", storagedatasource.a().toString());
                }
            }
            return jsonobject;
        }

        private void a(JsonSerializationContext jsonserializationcontext, JsonObject jsonobject, Optional<IChatBaseComponent> optional) {
            optional.ifPresent(ichatbasecomponent -> jsonobject.add("separator", this.a((IChatBaseComponent)ichatbasecomponent, (Type)ichatbasecomponent.getClass(), jsonserializationcontext)));
        }

        public static String a(IChatBaseComponent ichatbasecomponent) {
            return a.toJson((Object)ichatbasecomponent);
        }

        public static String b(IChatBaseComponent ichatbasecomponent) {
            return ChatDeserializer.e(ChatSerializer.c(ichatbasecomponent));
        }

        public static JsonElement c(IChatBaseComponent ichatbasecomponent) {
            return a.toJsonTree((Object)ichatbasecomponent);
        }

        @Nullable
        public static IChatMutableComponent a(String s2) {
            return ChatDeserializer.b(a, s2, IChatMutableComponent.class, false);
        }

        @Nullable
        public static IChatMutableComponent a(JsonElement jsonelement) {
            return (IChatMutableComponent)a.fromJson(jsonelement, IChatMutableComponent.class);
        }

        @Nullable
        public static IChatMutableComponent b(String s2) {
            return ChatDeserializer.b(a, s2, IChatMutableComponent.class, true);
        }

        public static IChatMutableComponent a(com.mojang.brigadier.StringReader com_mojang_brigadier_stringreader) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(com_mojang_brigadier_stringreader.getRemaining()));
                jsonreader.setLenient(false);
                IChatMutableComponent ichatmutablecomponent = (IChatMutableComponent)a.getAdapter(IChatMutableComponent.class).read(jsonreader);
                com_mojang_brigadier_stringreader.setCursor(com_mojang_brigadier_stringreader.getCursor() + ChatSerializer.a(jsonreader));
                return ichatmutablecomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int a(JsonReader jsonreader) {
            try {
                return b.getInt(jsonreader) - c.getInt(jsonreader) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }
    }
}

