/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger c = LogUtils.getLogger();
    private final boolean d;
    private final Optional<IChatBaseComponent> e;
    private final String f;
    private final DataSource g;
    @Nullable
    protected final ArgumentNBTKey.g b;

    public NbtContents(String var0, boolean var1, Optional<IChatBaseComponent> var2, DataSource var3) {
        this(var0, NbtContents.a(var0), var1, var2, var3);
    }

    private NbtContents(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, Optional<IChatBaseComponent> var3, DataSource var4) {
        this.f = var0;
        this.b = var1;
        this.d = var2;
        this.e = var3;
        this.g = var4;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String var0) {
        try {
            return new ArgumentNBTKey().a(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    public String a() {
        return this.f;
    }

    public boolean b() {
        return this.d;
    }

    public Optional<IChatBaseComponent> c() {
        return this.e;
    }

    public DataSource d() {
        return this.g;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof NbtContents)) return false;
        NbtContents var1 = (NbtContents)var0;
        if (!this.g.equals(var1.g)) return false;
        if (!this.e.equals(var1.e)) return false;
        if (this.d != var1.d) return false;
        if (!this.f.equals(var1.f)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.d ? 1 : 0;
        var0 = 31 * var0 + this.e.hashCode();
        var0 = 31 * var0 + this.f.hashCode();
        var0 = 31 * var0 + this.g.hashCode();
        return var0;
    }

    public String toString() {
        return "nbt{" + this.g + ", interpreting=" + this.d + ", separator=" + this.e + "}";
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper var02, @Nullable Entity var13, int var22) throws CommandSyntaxException {
        if (var02 == null || this.b == null) {
            return IChatBaseComponent.h();
        }
        Stream<String> var32 = this.g.getData(var02).flatMap(var0 -> {
            try {
                return this.b.a((NBTBase)var0).stream();
            }
            catch (CommandSyntaxException var1) {
                return Stream.empty();
            }
        }).map(NBTBase::m_);
        if (this.d) {
            IChatBaseComponent var4 = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.a(var02, this.e, var13, var22), (Object)ChatComponentUtils.c);
            return var32.flatMap(var3 -> {
                try {
                    IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.a(var3);
                    return Stream.of(ChatComponentUtils.a(var02, var4, var13, var22));
                }
                catch (Exception var4) {
                    c.warn("Failed to parse component: {}", var3, (Object)var4);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((var1, var2) -> var1.b(var4).b((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::h);
        }
        return ChatComponentUtils.a(var02, this.e, var13, var22).map(var12 -> var32.map(IChatBaseComponent::b).reduce((var1, var2) -> var1.b((IChatBaseComponent)var12).b((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::h)).orElseGet(() -> IChatBaseComponent.b(var32.collect(Collectors.joining(", "))));
    }
}

