/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger a = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> b = new Object2IntOpenHashMap();
    private static final int c = 254;
    private final Entity d;
    private final Int2ObjectMap<Item<?>> e = new Int2ObjectOpenHashMap();
    private boolean g;
    public boolean registrationLocked;

    public DataWatcher(Entity entity) {
        this.d = entity;
    }

    public static <T> DataWatcherObject<T> a(Class<? extends Entity> oclass, DataWatcherSerializer<T> datawatcherserializer) {
        int i2;
        if (a.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(oclass)) {
                    a.debug("defineId called for: {} from {}", new Object[]{oclass, oclass1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if (b.containsKey(oclass)) {
            i2 = b.getInt(oclass) + 1;
        } else {
            int j2 = 0;
            Class<? extends Entity> oclass2 = oclass;
            while (oclass2 != Entity.class) {
                if (!b.containsKey(oclass2 = oclass2.getSuperclass())) continue;
                j2 = b.getInt(oclass2) + 1;
                break;
            }
            i2 = j2;
        }
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        b.put(oclass, i2);
        return datawatcherserializer.a(i2);
    }

    public <T> void a(DataWatcherObject<T> datawatcherobject, T t0) {
        if (this.registrationLocked) {
            throw new IllegalStateException("Registering datawatcher object after entity initialization");
        }
        int i2 = datawatcherobject.a();
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        if (this.e.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        if (DataWatcherRegistry.b(datawatcherobject.b()) < 0) {
            DataWatcherSerializer<T> datawatcherserializer = datawatcherobject.b();
            throw new IllegalArgumentException("Unregistered serializer " + datawatcherserializer + " for " + i2 + "!");
        }
        this.c(datawatcherobject, t0);
    }

    private <T> void c(DataWatcherObject<T> datawatcherobject, T t0) {
        Item<T> datawatcher_item = new Item<T>(datawatcherobject, t0);
        this.e.put(datawatcherobject.a(), datawatcher_item);
    }

    public <T> boolean a(DataWatcherObject<T> datawatcherobject) {
        return this.e.containsKey(datawatcherobject.a());
    }

    private <T> Item<T> c(DataWatcherObject<T> datawatcherobject) {
        return (Item)this.e.get(datawatcherobject.a());
    }

    public <T> T b(DataWatcherObject<T> datawatcherobject) {
        return this.c(datawatcherobject).b();
    }

    public <T> void b(DataWatcherObject<T> datawatcherobject, T t0) {
        this.a(datawatcherobject, t0, false);
    }

    public <T> void a(DataWatcherObject<T> datawatcherobject, T t0, boolean flag) {
        Item<T> datawatcher_item = this.c(datawatcherobject);
        if (flag || ObjectUtils.notEqual(t0, datawatcher_item.b())) {
            datawatcher_item.a(t0);
            this.d.a(datawatcherobject);
            datawatcher_item.a(true);
            this.g = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> datawatcherobject) {
        this.c(datawatcherobject).a(true);
        this.g = true;
    }

    public boolean a() {
        return this.g;
    }

    @Nullable
    public List<b<?>> b() {
        ArrayList list = null;
        if (this.g) {
            for (Item datawatcher_item : this.e.values()) {
                if (!datawatcher_item.c()) continue;
                datawatcher_item.a(false);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(datawatcher_item.e());
            }
        }
        this.g = false;
        return list;
    }

    @Nullable
    public List<b<?>> c() {
        ArrayList list = null;
        for (Item datawatcher_item : this.e.values()) {
            if (datawatcher_item.d()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(datawatcher_item.e());
        }
        return list;
    }

    public void a(List<b<?>> list) {
        for (b<?> datawatcher_b : list) {
            Item datawatcher_item = (Item)this.e.get(datawatcher_b.a);
            if (datawatcher_item == null) continue;
            this.a(datawatcher_item, datawatcher_b);
            this.d.a(datawatcher_item.a());
        }
        this.d.a(list);
    }

    private <T> void a(Item<T> datawatcher_item, b<?> datawatcher_b) {
        if (!Objects.equals(datawatcher_b.b(), datawatcher_item.a.b())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", datawatcher_item.a.a(), this.d, datawatcher_item.b, datawatcher_item.b.getClass(), datawatcher_b.c, datawatcher_b.c.getClass()));
        }
        datawatcher_item.a(datawatcher_b.c);
    }

    public boolean d() {
        return this.e.isEmpty();
    }

    public void refresh(EntityPlayer to) {
        List<b<?>> list;
        if (!this.d() && (list = this.c()) != null) {
            to.c.a(new PacketPlayOutEntityMetadata(this.d.af(), list));
        }
    }

    public static class Item<T> {
        final DataWatcherObject<T> a;
        T b;
        private final T c;
        private boolean d;

        public Item(DataWatcherObject<T> datawatcherobject, T t0) {
            this.a = datawatcherobject;
            this.c = t0;
            this.b = t0;
        }

        public DataWatcherObject<T> a() {
            return this.a;
        }

        public void a(T t0) {
            this.b = t0;
        }

        public T b() {
            return this.b;
        }

        public boolean c() {
            return this.d;
        }

        public void a(boolean flag) {
            this.d = flag;
        }

        public boolean d() {
            return this.c.equals(this.b);
        }

        public b<T> e() {
            return net.minecraft.network.syncher.DataWatcher$b.a(this.a, this.b);
        }
    }

    public record b<T>(int a, DataWatcherSerializer<T> b, T c) {
        public static <T> b<T> a(DataWatcherObject<T> datawatcherobject, T t0) {
            DataWatcherSerializer<T> datawatcherserializer = datawatcherobject.b();
            return new b<T>(datawatcherobject.a(), datawatcherserializer, datawatcherserializer.a(t0));
        }

        public void a(PacketDataSerializer packetdataserializer) {
            int i2 = DataWatcherRegistry.b(this.b);
            if (i2 < 0) {
                throw new EncoderException("Unknown serializer type " + this.b);
            }
            packetdataserializer.writeByte(this.a);
            packetdataserializer.d(i2);
            this.b.a(packetdataserializer, this.c);
        }

        public static b<?> a(PacketDataSerializer packetdataserializer, int i2) {
            int j2 = packetdataserializer.m();
            DataWatcherSerializer<?> datawatcherserializer = DataWatcherRegistry.a(j2);
            if (datawatcherserializer == null) {
                throw new DecoderException("Unknown serializer type " + j2);
            }
            return net.minecraft.network.syncher.DataWatcher$b.a(packetdataserializer, i2, datawatcherserializer);
        }

        private static <T> b<T> a(PacketDataSerializer packetdataserializer, int i2, DataWatcherSerializer<T> datawatcherserializer) {
            return new b<PacketDataSerializer>(i2, datawatcherserializer, datawatcherserializer.a(packetdataserializer));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this, object);
        }
    }
}

