/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger c = LogUtils.getLogger();
    public static final List<b<?>> a = List.of(new b<DimensionManager>(Registries.au, DimensionManager.h), new b<BiomeBase>(Registries.ap, BiomeBase.a), new b<ChatMessageType>(Registries.aq, ChatMessageType.a), new b(Registries.ar, WorldGenCarverWrapper.a), new b(Registries.as, WorldGenFeatureConfigured.a), new b<PlacedFeature>(Registries.ay, PlacedFeature.a), new b<Structure>(Registries.az, Structure.a), new b<StructureSet>(Registries.aB, StructureSet.a), new b<ProcessorList>(Registries.aA, DefinedStructureStructureProcessorType.c), new b<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aC, WorldGenFeatureDefinedStructurePoolTemplate.a), new b<GeneratorSettingBase>(Registries.aw, GeneratorSettingBase.a), new b<NoiseGeneratorNormal.a>(Registries.ax, NoiseGeneratorNormal.a.a), new b<DensityFunction>(Registries.at, DensityFunction.b), new b<WorldPreset>(Registries.aF, WorldPreset.a), new b<FlatLevelGeneratorPreset>(Registries.av, FlatLevelGeneratorPreset.a), new b<TrimPattern>(Registries.aE, TrimPattern.a), new b<TrimMaterial>(Registries.aD, TrimMaterial.a), new b<DamageType>(Registries.p, DamageType.a), new b<MultiNoiseBiomeSourceParameterList>(Registries.aG, MultiNoiseBiomeSourceParameterList.a));
    public static final List<b<?>> b = List.of(new b<WorldDimension>(Registries.aI, WorldDimension.a));

    public static IRegistryCustom.Dimension a(IResourceManager var0, IRegistryCustom var12, List<b<?>> var22) {
        HashMap var3 = new HashMap();
        List<Pair<IRegistryWritable<?>, a>> var4 = var22.stream().map(var1 -> var1.a(Lifecycle.stable(), var3)).toList();
        RegistryOps.b var5 = RegistryDataLoader.a(var12, var4);
        var4.forEach(var2 -> ((a)var2.getSecond()).load(var0, var5));
        var4.forEach(var1 -> {
            IRegistry var2 = (IRegistry)var1.getFirst();
            try {
                var2.l();
            }
            catch (Exception var3) {
                var3.put(var2.c(), var3);
            }
        });
        if (!var3.isEmpty()) {
            RegistryDataLoader.a(var3);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new IRegistryCustom.c(var4.stream().map(Pair::getFirst).toList()).c();
    }

    private static RegistryOps.b a(IRegistryCustom var0, List<Pair<IRegistryWritable<?>, a>> var12) {
        final HashMap var2 = new HashMap();
        var0.b().forEach(var1 -> var2.put(var1.a(), RegistryDataLoader.a(var1.b())));
        var12.forEach(var1 -> var2.put(((IRegistryWritable)var1.getFirst()).c(), RegistryDataLoader.a((IRegistryWritable)var1.getFirst())));
        return new RegistryOps.b(){

            @Override
            public <T> Optional<RegistryOps.a<T>> a(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.a)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.a<T> a(IRegistryWritable<T> var0) {
        return new RegistryOps.a(var0.p(), var0.n(), var0.d());
    }

    private static <T> RegistryOps.a<T> a(IRegistry<T> var0) {
        return new RegistryOps.a<T>(var0.p(), var0.u(), var0.d());
    }

    private static void a(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).b(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).a(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf("> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        c.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static String a(MinecraftKey var0) {
        return var0.a();
    }

    static <E> void a(RegistryOps.b var02, IResourceManager var1, ResourceKey<? extends IRegistry<E>> var2, IRegistryWritable<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        String var6 = RegistryDataLoader.a(var2.a());
        FileToIdConverter var7 = FileToIdConverter.a(var6);
        RegistryOps var8 = RegistryOps.a(JsonOps.INSTANCE, var02);
        for (Map.Entry<MinecraftKey, IResource> var10 : var7.a(var1).entrySet()) {
            MinecraftKey var11 = var10.getKey();
            ResourceKey var12 = ResourceKey.a(var2, var7.b(var11));
            IResource var13 = var10.getValue();
            try {
                BufferedReader var14 = var13.e();
                try {
                    JsonElement var15 = JsonParser.parseReader((Reader)var14);
                    DataResult var16 = var4.parse(var8, (Object)var15);
                    Object var17 = var16.getOrThrow(false, var0 -> {});
                    var3.a(var12, var17, var13.c() ? Lifecycle.stable() : var16.lifecycle());
                }
                finally {
                    if (var14 == null) continue;
                    ((Reader)var14).close();
                }
            }
            catch (Exception var14) {
                var5.put(var12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var11, var13.b()), var14));
            }
        }
    }

    static interface a {
        public void load(IResourceManager var1, RegistryOps.b var2);
    }

    public record b<T>(ResourceKey<? extends IRegistry<T>> a, Codec<T> b) {
        Pair<IRegistryWritable<?>, a> a(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            RegistryMaterials var22 = new RegistryMaterials(this.a, var0);
            a var32 = (var2, var3) -> RegistryDataLoader.a(var3, var2, this.a, var22, this.b, var1);
            return Pair.of(var22, (Object)var32);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this, var0);
        }
    }
}

