/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;

public class CommandExecute {
    private static final int a = 32768;
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.a("commands.execute.blocks.toobig", var0, var1));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.a("commands.execute.conditional.fail_count", var0));
    private static final BinaryOperator<ResultConsumer<CommandListenerWrapper>> e = (var0, var1) -> (var2, var3, var4) -> {
        var0.onCommandComplete(var2, var3, var4);
        var1.onCommandComplete(var2, var3, var4);
    };
    private static final SuggestionProvider<CommandListenerWrapper> f = (var0, var1) -> {
        LootDataManager var2 = ((CommandListenerWrapper)var0.getSource()).l().aH();
        return ICompletionProvider.a(var2.a(LootDataType.a), var1);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        LiteralCommandNode<CommandListenerWrapper> var2 = var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(var0 -> var0.c(2))));
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("execute").requires(var0 -> var0.c(2))).then(net.minecraft.commands.CommandDispatcher.a("run").redirect(var02.getRoot()))).then(CommandExecute.a(var2, net.minecraft.commands.CommandDispatcher.a("if"), true, var1))).then(CommandExecute.a(var2, net.minecraft.commands.CommandDispatcher.a("unless"), false, var1))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).a(entity));
            }
            return var1;
        })))).then(net.minecraft.commands.CommandDispatcher.a("at").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).a((WorldServer)entity.dI()).a(entity.dg()).a(entity.bE()));
            }
            return var1;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("store").then(CommandExecute.a(var2, net.minecraft.commands.CommandDispatcher.a("result"), true))).then(CommandExecute.a(var2, net.minecraft.commands.CommandDispatcher.a("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("positioned").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).a(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)var0, "pos")).a(ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).a(entity.dg()));
            }
            return var1;
        })))).then(net.minecraft.commands.CommandDispatcher.a("over").then(net.minecraft.commands.CommandDispatcher.a("heightmap", HeightmapTypeArgument.a()).redirect(var2, var0 -> {
            Vec3D var1 = ((CommandListenerWrapper)var0.getSource()).d();
            WorldServer var2 = ((CommandListenerWrapper)var0.getSource()).e();
            double var3 = var1.a();
            double var5 = var1.c();
            if (!var2.b(SectionPosition.b(var3), SectionPosition.b(var5))) {
                throw ArgumentPosition.a.create();
            }
            int var7 = var2.a(HeightmapTypeArgument.a((CommandContext<CommandListenerWrapper>)var0, "heightmap"), MathHelper.a(var3), MathHelper.a(var5));
            return ((CommandListenerWrapper)var0.getSource()).a(new Vec3D(var3, var7, var5));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotated").then(net.minecraft.commands.CommandDispatcher.a("rot", ArgumentRotation.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).a(ArgumentRotation.a((CommandContext<CommandListenerWrapper>)var0, "rot").b((CommandListenerWrapper)var0.getSource()))))).then(net.minecraft.commands.CommandDispatcher.a("as").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).a(entity.bE()));
            }
            return var1;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            ArgumentAnchor.Anchor var2 = ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)var0, "anchor");
            for (Entity entity : ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).a(entity, var2));
            }
            return var1;
        }))))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)var0, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("align").then(net.minecraft.commands.CommandDispatcher.a("axes", ArgumentRotationAxis.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).a(((CommandListenerWrapper)var0.getSource()).d().a(ArgumentRotationAxis.a((CommandContext<CommandListenerWrapper>)var0, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.a("anchored").then(net.minecraft.commands.CommandDispatcher.a("anchor", ArgumentAnchor.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).a(ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)var0, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.a("in").then(net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()).redirect(var2, var0 -> ((CommandListenerWrapper)var0.getSource()).a(ArgumentDimension.a((CommandContext<CommandListenerWrapper>)var0, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.a("summon").then(net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(var1, Registries.s)).suggests(CompletionProviders.d).redirect(var2, var0 -> CommandExecute.a((CommandListenerWrapper)var0.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)var0, "entity")))))).then(CommandExecute.a(var2, net.minecraft.commands.CommandDispatcher.a("on")))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(LiteralCommandNode<CommandListenerWrapper> var0, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2) {
        var12.then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).redirect(var0, var1 -> CommandExecute.a((CommandListenerWrapper)var1.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)var1, "objective"), var2)))));
        var12.then(net.minecraft.commands.CommandDispatcher.a("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).suggests(CommandBossBar.a).then(net.minecraft.commands.CommandDispatcher.a("value").redirect(var0, var1 -> CommandExecute.a((CommandListenerWrapper)var1.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)var1), true, var2)))).then(net.minecraft.commands.CommandDispatcher.a("max").redirect(var0, var1 -> CommandExecute.a((CommandListenerWrapper)var1.getSource(), CommandBossBar.a((CommandContext<CommandListenerWrapper>)var1), false, var2)))));
        for (CommandData.c var4 : CommandData.b) {
            var4.a((ArgumentBuilder<CommandListenerWrapper, ?>)var12, var3 -> var3.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).then(net.minecraft.commands.CommandDispatcher.a("int").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagInt.a((int)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.a("float").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagFloat.a((float)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.a("short").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagShort.a((short)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.a("long").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagLong.a((long)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.a("double").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagDouble.a((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale")), var2))))).then(net.minecraft.commands.CommandDispatcher.a("byte").then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.a((CommandListenerWrapper)var2.getSource(), var4.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path"), (int var1) -> NBTTagByte.a((byte)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))));
        }
        return var12;
    }

    private static CommandListenerWrapper a(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, boolean var3) {
        ScoreboardServer var42 = var0.l().aF();
        return var0.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var4, var5, var6) -> {
            for (String var8 : var1) {
                ScoreboardScore var9 = var42.c(var8, var2);
                int var10 = var3 ? var6 : (var5 ? 1 : 0);
                var9.b(var10);
            }
        }), e);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper var0, BossBattleCustom var1, boolean var2, boolean var32) {
        return var0.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var3, var4, var5) -> {
            int var6;
            int n2 = var32 ? var5 : (var6 = var4 ? 1 : 0);
            if (var2) {
                var1.a(var6);
            } else {
                var1.b(var6);
            }
        }), e);
    }

    private static CommandListenerWrapper a(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2, IntFunction<NBTBase> var3, boolean var42) {
        return var0.a((ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var4, var5, var6) -> {
            try {
                NBTTagCompound var7 = var1.a();
                int var8 = var42 ? var6 : (var5 ? 1 : 0);
                var2.a((NBTBase)var7, (NBTBase)var3.apply(var8));
                var1.a(var7);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), e);
    }

    private static boolean a(WorldServer var0, BlockPosition var1) {
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1);
        Chunk var3 = var0.k().a(var2.e, var2.f);
        if (var3 != null) {
            return var3.D() == FullChunkStatus.d && var0.c(var2.a());
        }
        return false;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> var03, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2, CommandBuildContext var32) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var12.then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("block", ArgumentBlockPredicate.a(var32)), var2, (CommandContext<CommandListenerWrapper> var0) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)var0, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)var0.getSource()).e(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(var32, Registries.ap)), var2, (CommandContext<CommandListenerWrapper> var0) -> ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)var0, "biome", Registries.ap).test(((CommandListenerWrapper)var0.getSource()).e().s(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.a("loaded").then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()), var2, (CommandContext<CommandListenerWrapper> var0) -> CommandExecute.a(((CommandListenerWrapper)var0.getSource()).e(), ArgumentPosition.b((CommandContext<CommandListenerWrapper>)var0, "pos")))))).then(net.minecraft.commands.CommandDispatcher.a("dimension").then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("dimension", ArgumentDimension.a()), var2, (CommandContext<CommandListenerWrapper> var0) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)var0, "dimension") == ((CommandListenerWrapper)var0.getSource()).e())))).then(net.minecraft.commands.CommandDispatcher.a("score").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), var2, (CommandContext<CommandListenerWrapper> var0) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var0, Integer::equals)))))).then(net.minecraft.commands.CommandDispatcher.a("<").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), var2, (CommandContext<CommandListenerWrapper> var02) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 < var1)))))).then(net.minecraft.commands.CommandDispatcher.a("<=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), var2, (CommandContext<CommandListenerWrapper> var02) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 <= var1)))))).then(net.minecraft.commands.CommandDispatcher.a(">").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), var2, (CommandContext<CommandListenerWrapper> var02) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 > var1)))))).then(net.minecraft.commands.CommandDispatcher.a(">=").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()), var2, (CommandContext<CommandListenerWrapper> var02) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var02, (Integer var0, Integer var1) -> var0 >= var1)))))).then(net.minecraft.commands.CommandDispatcher.a("matches").then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()), var2, (CommandContext<CommandListenerWrapper> var0) -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var0, ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)var0, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.a("blocks").then(net.minecraft.commands.CommandDispatcher.a("start", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("all"), var2, false))).then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("masked"), var2, true))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).fork(var03, var1 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var1, var2, !ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var1, "entities").isEmpty()))).executes(CommandExecute.a(var2, (CommandContext<CommandListenerWrapper> var0) -> ArgumentEntity.c((CommandContext<CommandListenerWrapper>)var0, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.a("predicate").then(CommandExecute.a(var03, net.minecraft.commands.CommandDispatcher.a("predicate", ArgumentMinecraftKeyRegistered.a()).suggests(f), var2, (CommandContext<CommandListenerWrapper> var0) -> CommandExecute.a((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.c((CommandContext<CommandListenerWrapper>)var0, "predicate")))));
        for (CommandData.c var5 : CommandData.c) {
            var12.then(var5.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("data"), var3 -> var3.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).fork(var03, var2 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var2, var2, CommandExecute.a(var5.a((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var2, "path")) > 0))).executes(CommandExecute.a(var2, (CommandContext<CommandListenerWrapper> var1) -> CommandExecute.a(var5.a((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)var1, "path")))))));
        }
        return var12;
    }

    private static Command<CommandListenerWrapper> a(boolean var0, a var12) {
        if (var0) {
            return var1 -> {
                int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
                if (var2 > 0) {
                    ((CommandListenerWrapper)var1.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", var2), false);
                    return var2;
                }
                throw c.create();
            };
        }
        return var1 -> {
            int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
            if (var2 == 0) {
                ((CommandListenerWrapper)var1.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw d.create((Object)var2);
        };
    }

    private static int a(CommandDataAccessor var0, ArgumentNBTKey.g var1) throws CommandSyntaxException {
        return var1.b(var0.a());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> var0, BiPredicate<Integer, Integer> var1) throws CommandSyntaxException {
        String var2 = ArgumentScoreholder.a(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.a(var0, "targetObjective");
        String var4 = ArgumentScoreholder.a(var0, "source");
        ScoreboardObjective var5 = ArgumentScoreboardObjective.a(var0, "sourceObjective");
        ScoreboardServer var6 = ((CommandListenerWrapper)var0.getSource()).l().aF();
        if (!var6.b(var2, var3) || !var6.b(var4, var5)) {
            return false;
        }
        ScoreboardScore var7 = var6.c(var2, var3);
        ScoreboardScore var8 = var6.c(var4, var5);
        return var1.test(var7.b(), var8.b());
    }

    private static boolean a(CommandContext<CommandListenerWrapper> var0, CriterionConditionValue.IntegerRange var1) throws CommandSyntaxException {
        String var2 = ArgumentScoreholder.a(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.a(var0, "targetObjective");
        ScoreboardServer var4 = ((CommandListenerWrapper)var0.getSource()).l().aF();
        if (!var4.b(var2, var3)) {
            return false;
        }
        return var1.d(var4.c(var2, var3).b());
    }

    private static boolean a(CommandListenerWrapper var0, LootItemCondition var1) {
        WorldServer var2 = var0.e();
        LootParams var3 = new LootParams.a(var2).a(LootContextParameters.f, var0.d()).b(LootContextParameters.a, var0.f()).a(LootContextParameterSets.c);
        LootTableInfo var4 = new LootTableInfo.Builder(var3).a(null);
        var4.b(LootTableInfo.a(var1));
        return var1.test(var4);
    }

    private static Collection<CommandListenerWrapper> a(CommandContext<CommandListenerWrapper> var0, boolean var1, boolean var2) {
        if (var2 == var1) {
            return Collections.singleton((CommandListenerWrapper)var0.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var1, boolean var22, b var3) {
        return var1.fork(var0, var2 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var2, var22, var3.test((CommandContext<CommandListenerWrapper>)var2))).executes(var2 -> {
            if (var22 == var3.test((CommandContext<CommandListenerWrapper>)var2)) {
                ((CommandListenerWrapper)var2.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw c.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var12, boolean var22, boolean var3) {
        return var12.fork(var0, var2 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var2, var22, CommandExecute.c((CommandContext<CommandListenerWrapper>)var2, var3).isPresent())).executes(var22 ? var1 -> CommandExecute.a((CommandContext<CommandListenerWrapper>)var1, var3) : var1 -> CommandExecute.b((CommandContext<CommandListenerWrapper>)var1, var3));
    }

    private static int a(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.c(var0, var1);
        if (var2.isPresent()) {
            ((CommandListenerWrapper)var0.getSource()).a(() -> IChatBaseComponent.a("commands.execute.conditional.pass_count", var2.getAsInt()), false);
            return var2.getAsInt();
        }
        throw c.create();
    }

    private static int b(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.c(var0, var1);
        if (var2.isPresent()) {
            throw d.create((Object)var2.getAsInt());
        }
        ((CommandListenerWrapper)var0.getSource()).a(() -> IChatBaseComponent.c("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt c(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        return CommandExecute.a(((CommandListenerWrapper)var0.getSource()).e(), ArgumentPosition.a(var0, "start"), ArgumentPosition.a(var0, "end"), ArgumentPosition.a(var0, "destination"), var1);
    }

    private static OptionalInt a(WorldServer var0, BlockPosition var1, BlockPosition var2, BlockPosition var3, boolean var4) throws CommandSyntaxException {
        StructureBoundingBox var5 = StructureBoundingBox.a(var1, var2);
        StructureBoundingBox var6 = StructureBoundingBox.a(var3, var3.a(var5.b()));
        BlockPosition var7 = new BlockPosition(var6.g() - var5.g(), var6.h() - var5.h(), var6.i() - var5.i());
        int var8 = var5.c() * var5.d() * var5.e();
        if (var8 > 32768) {
            throw b.create((Object)32768, (Object)var8);
        }
        int var9 = 0;
        for (int var10 = var5.i(); var10 <= var5.l(); ++var10) {
            for (int var11 = var5.h(); var11 <= var5.k(); ++var11) {
                for (int var12 = var5.g(); var12 <= var5.j(); ++var12) {
                    BlockPosition var13 = new BlockPosition(var12, var11, var10);
                    BlockPosition var14 = var13.a(var7);
                    IBlockData var15 = var0.a_(var13);
                    if (var4 && var15.a(Blocks.a)) continue;
                    if (var15 != var0.a_(var14)) {
                        return OptionalInt.empty();
                    }
                    TileEntity var16 = var0.c_(var13);
                    TileEntity var17 = var0.c_(var14);
                    if (var16 != null) {
                        NBTTagCompound var19;
                        if (var17 == null) {
                            return OptionalInt.empty();
                        }
                        if (var17.u() != var16.u()) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound var18 = var16.o();
                        if (!var18.equals(var19 = var17.o())) {
                            return OptionalInt.empty();
                        }
                    }
                    ++var9;
                }
            }
        }
        return OptionalInt.of(var9);
    }

    private static RedirectModifier<CommandListenerWrapper> a(Function<Entity, Optional<Entity>> var0) {
        return var12 -> {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var12.getSource();
            Entity var3 = var2.f();
            if (var3 == null) {
                return List.of();
            }
            return ((Optional)var0.apply(var3)).filter(var0 -> !var0.dD()).map(var1 -> List.of(var2.a((Entity)var1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> b(Function<Entity, Stream<Entity>> var0) {
        return var1 -> {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var1.getSource();
            Entity var3 = var2.f();
            if (var3 == null) {
                return List.of();
            }
            return ((Stream)var0.apply(var3)).filter(var0 -> !var0.dD()).map(var2::a).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(CommandNode<CommandListenerWrapper> var02, LiteralArgumentBuilder<CommandListenerWrapper> var1) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var1.then(net.minecraft.commands.CommandDispatcher.a("owner").fork(var02, CommandExecute.a((Entity var0) -> {
            Optional<Object> optional;
            if (var0 instanceof OwnableEntity) {
                OwnableEntity var1 = (OwnableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.I_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("leasher").fork(var02, CommandExecute.a((Entity var0) -> {
            Optional<Object> optional;
            if (var0 instanceof EntityInsentient) {
                EntityInsentient var1 = (EntityInsentient)var0;
                optional = Optional.ofNullable(var1.fP());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("target").fork(var02, CommandExecute.a((Entity var0) -> {
            Optional<Object> optional;
            if (var0 instanceof Targeting) {
                Targeting var1 = (Targeting)((Object)var0);
                optional = Optional.ofNullable(var1.j());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("attacker").fork(var02, CommandExecute.a((Entity var0) -> {
            Optional<Object> optional;
            if (var0 instanceof Attackable) {
                Attackable var1 = (Attackable)((Object)var0);
                optional = Optional.ofNullable(var1.M_());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("vehicle").fork(var02, CommandExecute.a((Entity var0) -> Optional.ofNullable(var0.cW()))))).then(net.minecraft.commands.CommandDispatcher.a("controller").fork(var02, CommandExecute.a((Entity var0) -> Optional.ofNullable(var0.cL()))))).then(net.minecraft.commands.CommandDispatcher.a("origin").fork(var02, CommandExecute.a((Entity var0) -> {
            Optional<Object> optional;
            if (var0 instanceof TraceableEntity) {
                TraceableEntity var1 = (TraceableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.v());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.a("passengers").fork(var02, CommandExecute.b((Entity var0) -> var0.cN().stream())));
    }

    private static CommandListenerWrapper a(CommandListenerWrapper var0, Holder.c<EntityTypes<?>> var1) throws CommandSyntaxException {
        Entity var2 = CommandSummon.a(var0, var1, var0.d(), new NBTTagCompound(), true);
        return var0.a(var2);
    }

    @FunctionalInterface
    static interface b {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }
}

