/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_20_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_20_R1.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_20_R1.util.TerminalConsoleWriterThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger n = LogUtils.getLogger();
    private static final int o = 5000;
    private static final int p = 2;
    private final List<ServerCommand> q = Collections.synchronizedList(Lists.newArrayList());
    @Nullable
    private RemoteStatusListener r;
    public final RemoteControlCommandListener s;
    @Nullable
    private RemoteControlListener t;
    public DedicatedServerSettings u;
    @Nullable
    private ServerGUI v;
    @Nullable
    private final TextFilter w;

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super(options, worldLoader, thread, convertable_conversionsession, resourcepackrepository, worldstem, Proxy.NO_PROXY, datafixer, services, worldloadlistenerfactory);
        this.u = dedicatedserversettings;
        this.s = new RemoteControlCommandListener(this);
        this.w = TextFilter.a(dedicatedserversettings.a().R);
    }

    @Override
    public boolean e() throws IOException {
        Thread thread = new Thread("Server console handler"){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                bufferedreader = DedicatedServer.this.reader;
                try {
                    System.in.available();
                    if (true) ** GOTO lbl20
                }
                catch (IOException ex) {
                    return;
                }
                {
                    do {
                        if ((s = Main.useJline != false ? bufferedreader.readLine(">", null) : bufferedreader.readLine()) == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        if (s.trim().length() <= 0) continue;
                        DedicatedServer.this.a(s, DedicatedServer.this.aD());
lbl20:
                        // 5 sources

                    } while (!DedicatedServer.this.ab() && DedicatedServer.this.v());
                }
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        Handler[] handlerArray = global.getHandlers();
        int n2 = handlerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Handler handler = handlerArray[n3];
            global.removeHandler(handler);
            ++n3;
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        for (Appender appender : logger.getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            logger.removeAppender(appender);
        }
        new TerminalConsoleWriterThread(System.out, this.reader).start();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(n));
        thread.start();
        n.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            n.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        n.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.u.a();
        if (this.O()) {
            this.a_("127.0.0.1");
        } else {
            this.d(dedicatedserverproperties.a);
            this.e(dedicatedserverproperties.b);
            this.a_(dedicatedserverproperties.c);
        }
        this.a(new DedicatedPlayerList(this, this.aW(), this.i));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        this.f(dedicatedserverproperties.f);
        this.g(dedicatedserverproperties.g);
        this.d(dedicatedserverproperties.h);
        super.c(dedicatedserverproperties.U.get());
        this.h(dedicatedserverproperties.j);
        n.info("Default game type: {}", (Object)dedicatedserverproperties.l);
        InetAddress inetaddress = null;
        if (!this.u().isEmpty()) {
            inetaddress = InetAddress.getByName(this.u());
        }
        if (this.M() < 0) {
            this.a(dedicatedserverproperties.n);
        }
        this.P();
        n.info("Starting Minecraft server on {}:{}", (Object)(this.u().isEmpty() ? "*" : this.u()), (Object)this.M());
        try {
            this.ad().a(inetaddress, this.M());
        }
        catch (IOException ioexception) {
            n.warn("**** FAILED TO BIND TO PORT!");
            n.warn("The exception was: {}", (Object)ioexception.toString());
            n.warn("Perhaps a server is already running on that port?");
            return false;
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        if (!this.U()) {
            n.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            n.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (SpigotConfig.bungee) {
                n.warn("Whilst this makes it possible to use BungeeCord, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.");
                n.warn("Please see http://www.spigotmc.org/wiki/firewall-guide/ for further information.");
            } else {
                n.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            n.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.bi()) {
            this.ap().c();
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        long i2 = SystemUtils.c();
        TileEntitySkull.a(this.l, this);
        UserCache.a(this.U());
        n.info("Preparing level \"{}\"", (Object)this.q());
        this.loadLevel(this.h.a());
        long j2 = SystemUtils.c() - i2;
        String s2 = String.format(Locale.ROOT, "%.3fs", (double)j2 / 1.0E9);
        n.info("Done ({})! For help, type \"help\"", (Object)s2);
        if (dedicatedserverproperties.o != null) {
            this.aI().a(GameRules.y).a(dedicatedserverproperties.o, (MinecraftServer)this);
        }
        if (dedicatedserverproperties.p) {
            n.info("Starting GS4 status listener");
            this.r = RemoteStatusListener.a(this);
        }
        if (dedicatedserverproperties.r) {
            n.info("Starting remote control listener");
            this.t = RemoteControlListener.a(this);
            this.remoteConsole = new CraftRemoteConsoleCommandSender(this.s);
        }
        if (dedicatedserverproperties.N) {
            MinecraftServerBeans.a(this);
            n.info("JMX monitoring enabled");
        }
        return true;
    }

    @Override
    public boolean W() {
        return this.a().d && super.W();
    }

    @Override
    public boolean Q() {
        return this.u.a().w && super.Q();
    }

    @Override
    public boolean X() {
        return this.u.a().e && super.X();
    }

    @Override
    public DedicatedServerProperties a() {
        return this.u.a();
    }

    @Override
    public void r() {
        this.a(this.a().k, true);
    }

    @Override
    public boolean h() {
        return this.a().u;
    }

    @Override
    public SystemReport a(SystemReport systemreport) {
        systemreport.a("Is Modded", () -> this.K().b());
        systemreport.a("Type", () -> "Dedicated Server (map_server.txt)");
        return systemreport;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", dedicatedserverproperties.M));
            bufferedwriter.write(String.format(Locale.ROOT, "gamemode=%s%n", dedicatedserverproperties.l));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", dedicatedserverproperties.w));
            bufferedwriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.Q));
            bufferedwriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", dedicatedserverproperties.L));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-npcs=%s%n", dedicatedserverproperties.e));
            bufferedwriter.write(String.format(Locale.ROOT, "view-distance=%d%n", dedicatedserverproperties.F));
            bufferedwriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", dedicatedserverproperties.G));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-animals=%s%n", dedicatedserverproperties.d));
            bufferedwriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", dedicatedserverproperties.X.c()));
            bufferedwriter.write(String.format(Locale.ROOT, "use-native=%s%n", dedicatedserverproperties.x));
            bufferedwriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", dedicatedserverproperties.E));
        }
    }

    @Override
    public void g() {
        if (this.w != null) {
            this.w.close();
        }
        if (this.v != null) {
            this.v.b();
        }
        if (this.t != null) {
            this.t.b();
        }
        if (this.r != null) {
            this.r.b();
        }
        System.exit(0);
    }

    @Override
    public void b(BooleanSupplier booleansupplier) {
        super.b(booleansupplier);
        this.bf();
    }

    @Override
    public boolean B() {
        return this.a().v;
    }

    public void a(String s2, CommandListenerWrapper commandlistenerwrapper) {
        this.q.add(new ServerCommand(s2, commandlistenerwrapper));
    }

    public void bf() {
        SpigotTimings.serverCommandTimer.startTiming();
        while (!this.q.isEmpty()) {
            ServerCommand servercommand = this.q.remove(0);
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
        SpigotTimings.serverCommandTimer.stopTiming();
    }

    @Override
    public boolean l() {
        return true;
    }

    @Override
    public int m() {
        return this.a().E;
    }

    @Override
    public boolean n() {
        return this.a().x;
    }

    public DedicatedPlayerList bg() {
        return (DedicatedPlayerList)super.ac();
    }

    @Override
    public boolean p() {
        return true;
    }

    @Override
    public String b() {
        return this.u();
    }

    @Override
    public int d() {
        return this.M();
    }

    @Override
    public String f() {
        return this.aa();
    }

    public void bh() {
        if (this.v == null) {
            this.v = ServerGUI.a(this);
        }
    }

    @Override
    public boolean af() {
        return this.v != null;
    }

    @Override
    public boolean o() {
        return this.a().y;
    }

    @Override
    public int ah() {
        return this.a().z;
    }

    @Override
    public boolean a(WorldServer worldserver, BlockPosition blockposition, EntityHuman entityhuman) {
        int j2;
        if (worldserver.ac() != World.h) {
            return false;
        }
        if (this.bg().k().c()) {
            return false;
        }
        if (this.bg().f(entityhuman.fM())) {
            return false;
        }
        if (this.ah() <= 0) {
            return false;
        }
        BlockPosition blockposition1 = worldserver.R();
        int i2 = MathHelper.a(blockposition.u() - blockposition1.u());
        int k2 = Math.max(i2, j2 = MathHelper.a(blockposition.w() - blockposition1.w()));
        return k2 <= this.ah();
    }

    @Override
    public boolean ai() {
        return this.a().O;
    }

    @Override
    public boolean aj() {
        return this.a().P;
    }

    @Override
    public int i() {
        return this.a().A;
    }

    @Override
    public int j() {
        return this.a().B;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.u.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.U.a(this.aV(), i2));
    }

    @Override
    public boolean k() {
        return this.a().J;
    }

    @Override
    public boolean N_() {
        return this.a().K;
    }

    @Override
    public int as() {
        return this.a().L;
    }

    @Override
    public int av() {
        return this.a().I;
    }

    @Override
    public boolean aw() {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        return dedicatedserverproperties.W && dedicatedserverproperties.a && this.l.a() != null;
    }

    protected boolean bi() {
        boolean flag = false;
        int i2 = 0;
        while (!flag && i2 <= 2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bs();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
            ++i2;
        }
        boolean flag1 = false;
        i2 = 0;
        while (!flag1 && i2 <= 2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bs();
            }
            flag1 = NameReferencingFileConverter.b(this);
            ++i2;
        }
        boolean flag2 = false;
        i2 = 0;
        while (!flag2 && i2 <= 2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bs();
            }
            flag2 = NameReferencingFileConverter.c(this);
            ++i2;
        }
        boolean flag3 = false;
        i2 = 0;
        while (!flag3 && i2 <= 2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bs();
            }
            flag3 = NameReferencingFileConverter.d(this);
            ++i2;
        }
        boolean flag4 = false;
        i2 = 0;
        while (!flag4 && i2 <= 2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bs();
            }
            flag4 = NameReferencingFileConverter.a(this);
            ++i2;
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bs() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bj() {
        return this.a().C;
    }

    @Override
    public int bd() {
        return this.a().D;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            int i2 = 0;
            while (i2 < plugins.length) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
                ++i2;
            }
        }
        return result.toString();
    }

    @Override
    public String a(String s2) {
        this.s.e();
        this.h(() -> {
            RemoteServerCommandEvent event = new RemoteServerCommandEvent((CommandSender)this.remoteConsole, s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ServerCommand serverCommand = new ServerCommand(event.getCommand(), this.s.g());
            this.server.dispatchServerCommand((CommandSender)this.remoteConsole, serverCommand);
        });
        return this.s.f();
    }

    @Override
    public void i(boolean flag) {
        this.u.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.V.a(this.aV(), flag));
    }

    @Override
    public void t() {
        super.t();
        SystemUtils.h();
        TileEntitySkull.c();
    }

    @Override
    public boolean a(GameProfile gameprofile) {
        return false;
    }

    @Override
    public int b(int i2) {
        return this.a().Q * i2 / 100;
    }

    @Override
    public String q() {
        return this.h.a();
    }

    @Override
    public boolean aS() {
        return this.u.a().M;
    }

    @Override
    public ITextFilter a(EntityPlayer entityplayer) {
        return this.w != null ? this.w.a(entityplayer.fM()) : ITextFilter.a;
    }

    @Override
    @Nullable
    public EnumGamemode aX() {
        return this.u.a().i ? this.m.m() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> S() {
        return this.u.a().S;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

