/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.SpawnCategory;

public class ChunkProviderServer
extends IChunkProvider {
    private static final List<ChunkStatus> b = ChunkStatus.a();
    private final ChunkMapDistance c;
    final WorldServer d;
    final Thread e;
    final LightEngineThreaded f;
    private final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d p;

    public ChunkProviderServer(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, ChunkGenerator chunkgenerator, int i2, int j2, boolean flag, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier) {
        this.d = worldserver;
        this.g = new b(worldserver);
        this.e = Thread.currentThread();
        File file = convertable_conversionsession.a(worldserver.ac()).resolve("data").toFile();
        file.mkdirs();
        this.h = new WorldPersistentData(file, datafixer);
        this.a = new PlayerChunkMap(worldserver, convertable_conversionsession, datafixer, structuretemplatemanager, executor, this.g, this, chunkgenerator, worldloadlistener, chunkstatusupdatelistener, supplier, i2, flag);
        this.f = this.a.e();
        this.c = this.a.j();
        this.c.b(j2);
        this.r();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long i2) {
        return this.a.b(i2);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long i2, IChunkAccess ichunkaccess, ChunkStatus chunkstatus) {
        int j2 = 3;
        while (j2 > 0) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
            --j2;
        }
        this.m[0] = i2;
        this.n[0] = chunkstatus;
        this.o[0] = ichunkaccess;
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess;
        if (Thread.currentThread() != this.e) {
            return CompletableFuture.supplyAsync(() -> this.a(i2, j2, chunkstatus, flag), this.g).join();
        }
        GameProfilerFiller gameprofilerfiller = this.d.ad();
        gameprofilerfiller.d("getChunk");
        long k2 = ChunkCoordIntPair.c(i2, j2);
        int l2 = 0;
        while (l2 < 4) {
            if (k2 == this.m[l2] && chunkstatus == this.n[l2] && (ichunkaccess = this.o[l2]) != null) {
                return ichunkaccess;
            }
            ++l2;
        }
        gameprofilerfiller.d("getChunkCacheMiss");
        this.d.timings.syncChunkLoadTimer.startTiming();
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = this.c(i2, j2, chunkstatus, flag);
        b chunkproviderserver_b = this.g;
        Objects.requireNonNull(completablefuture);
        chunkproviderserver_b.c(completablefuture::isDone);
        this.d.timings.syncChunkLoadTimer.stopTiming();
        ichunkaccess = (IChunkAccess)completablefuture.join().map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> {
            if (flag) {
                throw SystemUtils.b(new IllegalStateException("Chunk not there when requested: " + playerchunk_failure));
            }
            return null;
        });
        this.a(k2, ichunkaccess, chunkstatus);
        return ichunkaccess;
    }

    @Override
    @Nullable
    public Chunk a(int i2, int j2) {
        if (Thread.currentThread() != this.e) {
            return null;
        }
        this.d.ad().d("getChunkNow");
        long k2 = ChunkCoordIntPair.c(i2, j2);
        int l2 = 0;
        while (l2 < 4) {
            if (k2 == this.m[l2] && this.n[l2] == ChunkStatus.n) {
                IChunkAccess ichunkaccess = this.o[l2];
                return ichunkaccess instanceof Chunk ? (Chunk)ichunkaccess : null;
            }
            ++l2;
        }
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        Either either = playerchunk.b(ChunkStatus.n).getNow(null);
        if (either == null) {
            return null;
        }
        IChunkAccess ichunkaccess1 = either.left().orElse(null);
        if (ichunkaccess1 != null) {
            this.a(k2, ichunkaccess1, ChunkStatus.n);
            if (ichunkaccess1 instanceof Chunk) {
                return (Chunk)ichunkaccess1;
            }
        }
        return null;
    }

    private void r() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        CompletionStage<Object> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.e;
        if (flag1) {
            completablefuture = this.c(i2, j2, chunkstatus, flag);
            b chunkproviderserver_b = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.c(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(i2, j2, chunkstatus, flag), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.a();
        int l2 = ChunkLevel.a(chunkstatus);
        PlayerChunk playerchunk = this.b(k2);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            FullChunkStatus oldChunkState = ChunkLevel.b(playerchunk.n);
            FullChunkStatus currentChunkState = ChunkLevel.b(playerchunk.k());
            boolean bl = currentlyUnloading = oldChunkState.a(FullChunkStatus.b) && !currentChunkState.a(FullChunkStatus.b);
        }
        if (flag && !currentlyUnloading) {
            this.c.a(TicketType.h, chunkcoordintpair, l2, chunkcoordintpair);
            if (this.a(playerchunk, l2)) {
                GameProfilerFiller gameprofilerfiller = this.d.ad();
                gameprofilerfiller.a("chunkLoad");
                this.s();
                playerchunk = this.b(k2);
                gameprofilerfiller.c();
                if (this.a(playerchunk, l2)) {
                    throw SystemUtils.b(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        return this.a(playerchunk, l2) ? PlayerChunk.b : playerchunk.a(chunkstatus, this.a);
    }

    private boolean a(@Nullable PlayerChunk playerchunk, int i2) {
        return playerchunk == null || playerchunk.n > i2;
    }

    @Override
    public boolean b(int i2, int j2) {
        int k2;
        PlayerChunk playerchunk = this.b(new ChunkCoordIntPair(i2, j2).a());
        return !this.a(playerchunk, k2 = ChunkLevel.a(ChunkStatus.n));
    }

    @Override
    @Nullable
    public LightChunk c(int i2, int j2) {
        long k2 = ChunkCoordIntPair.c(i2, j2);
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        int l2 = b.size() - 1;
        ChunkStatus chunkstatus;
        Optional optional;
        while (!(optional = playerchunk.a(chunkstatus = b.get(l2)).getNow(PlayerChunk.a).left()).isPresent()) {
            if (chunkstatus == ChunkStatus.k.d()) {
                return null;
            }
            --l2;
        }
        return (LightChunk)optional.get();
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.x();
    }

    boolean s() {
        boolean flag = this.c.a(this.a);
        boolean flag1 = this.a.g();
        if (!flag && !flag1) {
            return false;
        }
        this.r();
        return true;
    }

    public boolean a(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        if (playerchunk == null) {
            return false;
        }
        if (!this.d.a(i2)) {
            return false;
        }
        Either either = playerchunk.a().getNow(null);
        return either != null && either.left().isPresent();
    }

    public void a(boolean flag) {
        this.s();
        this.a.a(flag);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.a(true);
        }
        this.f.close();
        this.a.close();
    }

    public void purgeUnload() {
        this.d.ad().a("purge");
        this.c.a();
        this.s();
        this.d.ad().b("unload");
        this.a.a(() -> true);
        this.d.ad().c();
        this.r();
    }

    @Override
    public void a(BooleanSupplier booleansupplier, boolean flag) {
        this.d.ad().a("purge");
        this.d.timings.doChunkMap.startTiming();
        this.c.a();
        this.s();
        this.d.timings.doChunkMap.stopTiming();
        this.d.ad().b("chunks");
        if (flag) {
            this.t();
        }
        this.d.timings.doChunkUnload.startTiming();
        this.d.ad().b("unload");
        this.a.a(booleansupplier);
        this.d.timings.doChunkUnload.stopTiming();
        this.d.ad().c();
        this.r();
    }

    private void t() {
        long i2 = this.d.V();
        long j2 = i2 - this.i;
        this.i = i2;
        boolean flag = this.d.af();
        if (flag) {
            this.a.l();
        } else {
            SpawnerCreature.d spawnercreature_d;
            WorldData worlddata = this.d.u_();
            GameProfilerFiller gameprofilerfiller = this.d.ad();
            gameprofilerfiller.a("pollingChunks");
            int k2 = this.d.X().c(GameRules.n);
            boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && worlddata.e() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            gameprofilerfiller.a("naturalSpawnCount");
            int l2 = this.c.b();
            this.p = spawnercreature_d = SpawnerCreature.a(l2, this.d.y(), this::a, new LocalMobCapCalculator(this.a));
            gameprofilerfiller.b("filteringLoadedChunks");
            ArrayList list = Lists.newArrayListWithCapacity((int)l2);
            for (PlayerChunk playerchunk : this.a.k()) {
                Chunk chunk = playerchunk.d();
                if (chunk == null) continue;
                list.add(new a(chunk, playerchunk));
            }
            gameprofilerfiller.b("spawnAndTick");
            boolean flag2 = this.d.X().b(GameRules.e) && !this.d.v().isEmpty();
            Collections.shuffle(list);
            for (a chunkproviderserver_a : list) {
                Chunk chunk1 = chunkproviderserver_a.a;
                ChunkCoordIntPair chunkcoordintpair = chunk1.f();
                if (!this.d.a(chunkcoordintpair) || !this.a.c(chunkcoordintpair)) continue;
                chunk1.a(j2);
                if (flag2 && (this.j || this.k) && this.d.w_().a(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
                    SpawnerCreature.a(this.d, chunk1, spawnercreature_d, this.k, this.j, flag1);
                }
                if (!this.d.a(chunkcoordintpair.a())) continue;
                this.d.timings.doTickTiles.startTiming();
                this.d.a(chunk1, k2);
                this.d.timings.doTickTiles.stopTiming();
            }
            gameprofilerfiller.b("customSpawners");
            if (flag2) {
                this.d.a(this.j, this.k);
            }
            gameprofilerfiller.b("broadcast");
            list.forEach(chunkproviderserver_a1 -> chunkproviderserver_a1.b.a(chunkproviderserver_a1.a));
            gameprofilerfiller.c();
            gameprofilerfiller.c();
            this.d.timings.tracker.startTiming();
            this.a.l();
            this.d.timings.tracker.stopTiming();
        }
    }

    private void a(long i2, Consumer<Chunk> consumer) {
        PlayerChunk playerchunk = this.b(i2);
        if (playerchunk != null) {
            playerchunk.c().getNow(PlayerChunk.c).left().ifPresent(consumer);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.bm();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition blockposition) {
        int j2;
        int i2 = SectionPosition.a(blockposition.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.c(i2, j2 = SectionPosition.a(blockposition.w())));
        if (playerchunk != null) {
            playerchunk.a(blockposition);
        }
    }

    @Override
    public void a(EnumSkyBlock enumskyblock, SectionPosition sectionposition) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(sectionposition.r().a());
            if (playerchunk != null) {
                playerchunk.a(enumskyblock, sectionposition.b());
            }
        });
    }

    public <T> void a(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.c.c(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> void b(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.c.d(tickettype, chunkcoordintpair, i2, t0);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        this.c.a(chunkcoordintpair, flag);
    }

    public void a(EntityPlayer entityplayer) {
        if (!entityplayer.dD()) {
            this.a.a(entityplayer);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int i2) {
        this.a.a(i2);
    }

    public void b(int i2) {
        this.c.b(i2);
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        this.j = flag;
        this.k = flag1;
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public WorldPersistentData k() {
        return this.h;
    }

    public VillagePlace l() {
        return this.a.m();
    }

    public ChunkScanAccess m() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d n() {
        return this.p;
    }

    public void o() {
        this.c.e();
    }

    private record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, object);
        }
    }

    private final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + world.ac().a());
        }

        @Override
        protected Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean at() {
            return true;
        }

        @Override
        protected Thread au() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable runnable) {
            ChunkProviderServer.this.d.ad().d("runTask");
            super.d(runnable);
        }

        @Override
        public boolean x() {
            try {
                if (ChunkProviderServer.this.s()) {
                    return true;
                }
                ChunkProviderServer.this.f.b();
                boolean bl = super.x();
                return bl;
            }
            finally {
                ChunkProviderServer.this.a.callbackExecutor.run();
            }
        }
    }
}

