/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

public class EntityPlayer
extends EntityHuman {
    private static final Logger b = LogUtils.getLogger();
    private static final int cl = 32;
    private static final int cm = 10;
    public PlayerConnection c;
    public final MinecraftServer d;
    public final PlayerInteractManager e;
    private final AdvancementDataPlayer cn;
    private final ServerStatisticManager co;
    private float cp = Float.MIN_VALUE;
    private int cq = Integer.MIN_VALUE;
    private int cr = Integer.MIN_VALUE;
    private int cs = Integer.MIN_VALUE;
    private int ct = Integer.MIN_VALUE;
    private int cu = Integer.MIN_VALUE;
    private float cv = -1.0E8f;
    private int cw = -99999999;
    private boolean cx = true;
    public int cy = -99999999;
    public int cz = 60;
    private EnumChatVisibility cA = EnumChatVisibility.a;
    private boolean cB = true;
    private long cC = SystemUtils.b();
    @Nullable
    private net.minecraft.world.entity.Entity cD;
    public boolean cE;
    private boolean cF;
    private final RecipeBookServer cG = new RecipeBookServer();
    @Nullable
    private Vec3D cH;
    private int cI;
    private boolean cJ;
    @Nullable
    private Vec3D cK;
    @Nullable
    private Vec3D cL;
    @Nullable
    private Vec3D cM;
    private SectionPosition cN = SectionPosition.a(0, 0, 0);
    private ResourceKey<net.minecraft.world.level.World> cO = net.minecraft.world.level.World.h;
    @Nullable
    private BlockPosition cP;
    private boolean cQ;
    private float cR;
    private final ITextFilter cS;
    private boolean cT;
    private boolean cU;
    private WardenSpawnTracker cV = new WardenSpawnTracker(0, 0, 0);
    private final ContainerSynchronizer cW = new ContainerSynchronizer(){

        @Override
        public void a(Container container, NonNullList<ItemStack> nonnulllist, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.c.a(new PacketPlayOutWindowItems(container.j, container.k(), nonnulllist, itemstack));
            int i2 = 0;
            while (i2 < aint.length) {
                this.b(container, i2, aint[i2]);
                ++i2;
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.c.a(new PacketPlayOutSetSlot(container.j, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.c.a(new PacketPlayOutSetSlot(-1, container.k(), -1, itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.c.a(new PacketPlayOutWindowData(container.j, i2, j2));
        }
    };
    private final ICrafting cX = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fN()) {
                CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fN(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    @Nullable
    private RemoteChatSession cY;
    private int cZ;
    public int f;
    public boolean g;
    public String displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public Integer clientViewDistance;
    public String kickLeaveMessage = null;
    public String locale = "en_us";
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile) {
        super(worldserver, worldserver.R(), worldserver.S(), gameprofile);
        this.cS = minecraftserver.a(this);
        this.e = minecraftserver.b(this);
        this.d = minecraftserver;
        this.co = minecraftserver.ac().getPlayerStats(this);
        this.cn = minecraftserver.ac().f(this);
        this.r(1.0f);
        this.d(worldserver);
        this.displayName = this.cv();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eI();
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.R();
        if (worldserver.x_().g() && worldserver.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.w_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            int l1 = 0;
            while (l1 < i1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 != null) {
                    return blockposition1;
                }
                ++l1;
            }
        }
        return blockposition;
    }

    private void d(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.R();
        if (worldserver.x_().g() && worldserver.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.w_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            int l1 = 0;
            while (l1 < i1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 != null) {
                    this.a(blockposition1, 0.0f, 0.0f);
                    if (worldserver.g(this)) break;
                }
                ++l1;
            }
        } else {
            this.a(blockposition, 0.0f, 0.0f);
            while (!worldserver.g(this) && this.dp() < (double)(worldserver.aj() - 1)) {
                this.e(this.dn(), this.dp() + 1.0, this.dt());
            }
        }
    }

    private int u(int i2) {
        return i2 <= 16 ? i2 - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbttagcompound);
        if (nbttagcompound.b("warden_spawn_tracker", 10)) {
            DataResult dataresult = WardenSpawnTracker.a.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("warden_spawn_tracker")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.cV = wardenspawntracker;
            });
        }
        if (nbttagcompound.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("enteredNetherPosition");
            this.cL = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cF = nbttagcompound.q("seenCredits");
        if (nbttagcompound.b("recipeBook", 10)) {
            this.cG.a(nbttagcompound.p("recipeBook"), this.d.aE());
        }
        this.getBukkitEntity().readExtraData(nbttagcompound);
        if (this.fy()) {
            this.fz();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbttagcompound.l("SpawnWorld")))) != null) {
            this.cO = oldWorld.getHandle().ac();
        }
        if (nbttagcompound.b("SpawnX", 99) && nbttagcompound.b("SpawnY", 99) && nbttagcompound.b("SpawnZ", 99)) {
            this.cP = new BlockPosition(nbttagcompound.h("SpawnX"), nbttagcompound.h("SpawnY"), nbttagcompound.h("SpawnZ"));
            this.cQ = nbttagcompound.q("SpawnForced");
            this.cR = nbttagcompound.j("SpawnAngle");
            if (nbttagcompound.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("SpawnDimension"));
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                this.cO = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cV);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbttagcompound);
        nbttagcompound.a("seenCredits", this.cF);
        if (this.cL != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cL.c);
            nbttagcompound1.a("y", this.cL.d);
            nbttagcompound1.a("z", this.cL.e);
            nbttagcompound.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cT();
        net.minecraft.world.entity.Entity entity1 = this.cW();
        boolean persistVehicle = true;
        if (entity1 != null) {
            net.minecraft.world.entity.Entity vehicle = entity1;
            while (vehicle != null) {
                if (!vehicle.persist) {
                    persistVehicle = false;
                    break;
                }
                vehicle = vehicle.cW();
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cS()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.ct());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbttagcompound.a("RootVehicle", nbttagcompound2);
        }
        nbttagcompound.a("recipeBook", this.cG.b());
        nbttagcompound.a("Dimension", this.dI().ac().a().toString());
        if (this.cP != null) {
            nbttagcompound.a("SpawnX", this.cP.u());
            nbttagcompound.a("SpawnY", this.cP.v());
            nbttagcompound.a("SpawnZ", this.cP.w());
            nbttagcompound.a("SpawnForced", this.cQ);
            nbttagcompound.a("SpawnAngle", this.cR);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cO.a());
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbttagcompound);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dF();
            Vec3D position = null;
            if (this.cO != null && (world = this.d.a(this.cO)) != null && this.N() != null) {
                position = EntityHuman.a((WorldServer)world, this.N(), this.O(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.R());
            }
            this.a(world);
            this.a(position);
        }
        this.e.a((WorldServer)world);
    }

    public void a(int i2) {
        float f2 = this.fW();
        float f1 = (f2 - 1.0f) / f2;
        this.cg = MathHelper.a((float)i2 / f2, 0.0f, f1);
        this.cy = -1;
    }

    public void b(int i2) {
        this.ce = i2;
        this.cy = -1;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.cy = -1;
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.cy = -1;
    }

    public void a(Container container) {
        container.a(this.cX);
        container.a(this.cW);
    }

    public void h() {
        this.a(this.bQ);
    }

    @Override
    public void Q_() {
        super.Q_();
        this.c.a(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void F_() {
        super.F_();
        this.c.a(new ClientboundPlayerCombatEndPacket(this.eG()));
    }

    @Override
    protected void a(IBlockData iblockdata) {
        CriterionTriggers.d.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.e.a();
        this.cV.a();
        --this.cz;
        if (this.ak > 0) {
            --this.ak;
        }
        this.bR.d();
        if (!this.dI().B && !this.bR.a(this)) {
            this.q();
            this.bR = this.bQ;
        }
        if ((entity = this.G()) != this) {
            if (entity.bs()) {
                this.a(entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA());
                this.x().k().a(this);
                if (this.fE()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.w.a(this);
        if (this.cH != null) {
            CriterionTriggers.u.a(this, this.cH, this.ag - this.cI);
        }
        this.o();
        this.p();
        this.cn.b(this);
    }

    public void m() {
        try {
            if (!this.G_() || !this.db()) {
                super.l();
            }
            int i2 = 0;
            while (i2 < this.fN().b()) {
                Packet<?> packet;
                ItemStack itemstack = this.fN().a(i2);
                if (itemstack.d().ad_() && (packet = ((ItemWorldMapBase)itemstack.d()).a(itemstack, this.dI(), this)) != null) {
                    this.c.a(packet);
                }
                ++i2;
            }
            if (this.er() != this.cv || this.cw != this.bS.a() || this.bS.e() == 0.0f != this.cx) {
                this.c.a(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bS.a(), this.bS.e()));
                this.cv = this.er();
                this.cw = this.bS.a();
                boolean bl = this.cx = this.bS.e() == 0.0f;
            }
            if (this.er() + this.ff() != this.cp) {
                this.cp = this.er() + this.ff();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.cp));
            }
            if (this.bS.a() != this.cq) {
                this.cq = this.bS.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cq));
            }
            if (this.cf() != this.cr) {
                this.cr = this.cf();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cr));
            }
            if (this.eF() != this.cs) {
                this.cs = this.eF();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cs));
            }
            if (this.cf != this.cu) {
                this.cu = this.cf;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cu));
            }
            if (this.maxHealthCache != (double)this.eI()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.ce != this.ct) {
                this.ct = this.ce;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.ct));
            }
            if (this.cf != this.cy) {
                this.cy = this.cf;
                this.c.a(new PacketPlayOutExperience(this.cg, this.cf, this.ce));
            }
            if (this.ag % 20 == 0) {
                CriterionTriggers.p.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.ce;
            }
            if (this.oldLevel != this.ce) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.ce);
                this.oldLevel = this.ce;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.er() > 0.0f && this.cK != null) {
            CriterionTriggers.U.a(this, this.cK);
        }
        this.cK = null;
        super.n();
    }

    public void o() {
        if (this.aa > 0.0f && this.cK == null) {
            this.cK = this.dg();
        }
    }

    public void p() {
        if (this.cW() != null && this.cW().bi()) {
            if (this.cM == null) {
                this.cM = this.dg();
            } else {
                CriterionTriggers.V.a(this, this.cM);
            }
        }
        if (!(this.cM == null || this.cW() != null && this.cW().bi())) {
            this.cM = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(iscoreboardcriteria, this.cv(), scoreboardscore -> scoreboardscore.b(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        this.a(GameEvent.p);
        boolean flag = this.dI().X().b(GameRules.m);
        if (this.dD()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.fN().b());
        boolean bl = keepInventory = this.dI().X().b(GameRules.d) || this.G_();
        if (!keepInventory) {
            for (ItemStack item : this.fN().getContents()) {
                if (item.b() || EnchantmentManager.e(item)) continue;
                loot.add(CraftItemStack.asCraftMirror(item));
            }
        }
        this.a(damagesource, this.ba > 0);
        for (ItemStack item : this.drops) {
            loot.add((org.bukkit.inventory.ItemStack)item);
        }
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.eG().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, deathmessage, keepInventory);
        if (this.bR != this.bQ) {
            this.q();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.eG().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.af(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.H_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.af(), ichatmutablecomponent1);
            }));
            ScoreboardTeamBase scoreboardteambase = this.cd();
            if (scoreboardteambase != null && scoreboardteambase.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardteambase.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ac().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardteambase.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ac().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ac().a(ichatbasecomponent, false);
            }
        } else {
            this.c.a(new ClientboundPlayerCombatKillPacket(this.af(), CommonComponents.a));
        }
        this.gb();
        if (this.dI().X().b(GameRules.J)) {
            this.gn();
        }
        this.ev();
        if (!event.getKeepInventory()) {
            this.fN().a();
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.c, this.cv(), ScoreboardScore::a);
        EntityLiving entityliving = this.eH();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ae()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bi, damagesource);
            this.f(entityliving);
        }
        this.dI().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aw();
        this.k(0);
        this.a_(false);
        this.eG().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dI().ac(), this.di())));
    }

    private void gn() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.di()).c(32.0, 10.0, 32.0);
        this.dI().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int i2, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, i2, damagesource);
            this.s(i2);
            String s2 = this.cv();
            String s1 = entity.cv();
            this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.e, s2, ScoreboardScore::a);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.d, s2, ScoreboardScore::a);
            } else {
                this.a(StatisticList.O);
            }
            this.a(s2, s1, IScoreboardCriteria.l);
            this.a(s1, s2, IScoreboardCriteria.m);
            CriterionTriggers.b.a(this, entity, damagesource);
        }
    }

    private void a(String s2, String s1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gc().i(s1);
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(aiscoreboardcriteria[i2], s2, ScoreboardScore::a);
        }
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(damagesource)) {
            return false;
        }
        boolean bl = flag = this.d.l() && this.go() && damagesource.a(DamageTypeTags.m);
        if (!flag && this.cz > 0 && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).v()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.go() ? false : super.a(entityhuman);
    }

    private boolean go() {
        return this.dI().pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer worldserver) {
        ShapeDetectorShape shapedetectorshape = super.a(worldserver);
        WorldServer worldServer = worldserver = shapedetectorshape == null ? worldserver : shapedetectorshape.world;
        if (shapedetectorshape != null && this.dI().getTypeKey() == WorldDimension.b && worldserver != null && worldserver.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.b, 90.0f, 0.0f, worldserver, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer worldserver) {
        return this.changeDimension(worldserver, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fy()) {
            return this;
        }
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cE = true;
            this.ac();
            this.x().a(this, Entity.RemovalReason.e);
            if (!this.g) {
                this.g = true;
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cF ? 0.0f : 1.0f));
                this.cF = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.ad().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cL = this.dg();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, BlockPosition.a(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(shapedetectorshape.a, (World)worldserver.getWorld(), shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ad().c();
        worldserver1.ad().a("placing");
        this.cE = true;
        this.c.a(new PacketPlayOutRespawn(worldserver.aa(), worldserver.ac(), BiomeManager.a(worldserver.A()), this.e.b(), this.e.c(), worldserver.af(), worldserver.z(), 3, this.gm(), this.ar()));
        this.c.a(new PacketPlayOutServerDifficulty(this.dI().ai(), this.dI().u_().t()));
        PlayerList playerlist = this.d.ac();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dF();
        this.c(worldserver);
        this.c.teleport(exit);
        this.c.d();
        worldserver.b(this);
        worldserver1.ad().c();
        this.e(worldserver1);
        this.c.a(new PacketPlayOutAbilities(this.fO()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.eo()) {
            this.c.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        }
        this.c.a(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cy = -1;
        this.cv = -1.0f;
        this.cw = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dI().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld(), this.dy(), this.dA());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.j();
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldserver);
        int i2 = -2;
        while (i2 <= 2) {
            int j2 = -2;
            while (j2 <= 2) {
                int k2 = -1;
                while (k2 < 3) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.co.n() : Blocks.a.n();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(blockposition).e(j2, k2, i2), iblockdata, 3);
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)worldserver.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.dI().a_(this.aw).d(BlockPortal.a).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.o().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        optional1.isPresent();
        return optional1;
    }

    public void e(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.ac();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dI().ac();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dI());
        CriterionTriggers.v.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.v.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.cL != null) {
            CriterionTriggers.C.a(this, this.cL);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.cL = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.G_() ? this.G() == this : (this.G_() ? false : super.a(entityplayer));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int i2) {
        super.a(entity, i2);
        this.bR.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fy() && this.bs()) {
            if (!this.dI().x_().j() || !this.dI().x_().l()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.a));
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.c));
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.d));
            }
            this.setRespawnPosition(this.dI().ac(), blockposition, this.dy(), false, true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.dI().N()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.b));
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dI().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.f(this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)EntityHuman.EnumBedResult.f));
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)((Object)EntityHuman.EnumBedResult.e));
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dI().a_(blockposition).c(BlockFacingHorizontal.aC);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.q.a(this);
        });
        if (!this.x().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dI()).e();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dn() - vec3d.a()) <= 3.0 && Math.abs(this.dp() - vec3d.b()) <= 2.0 && Math.abs(this.dt() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.c();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.fy()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fw().orElse(null);
        Block bed = bedPosition != null ? this.dI().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dI().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fy()) {
            this.x().k().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.c != null) {
            this.c.a(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
        }
    }

    @Override
    public void a(double d0, double d1, double d2) {
        this.bA();
        this.e(d0, d1, d2);
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return super.b(damagesource) || this.K();
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    protected void c(BlockPosition blockposition) {
        if (!this.G_()) {
            super.c(blockposition);
        }
    }

    public void a(double d0, double d1, double d2, boolean flag) {
        if (!this.db()) {
            this.b(flag, new Vec3D(d0, d1, d2));
            BlockPosition blockposition = this.aD();
            super.a(d1, flag, this.dI().a_(blockposition), blockposition);
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.c.a(new PacketPlayOutBlockChange(this.dI(), tileentitysign.p()));
        this.c.a(new PacketPlayOutOpenSignEditor(tileentitysign.p(), flag));
    }

    public int nextContainerCounter() {
        this.cZ = this.cZ % 100 + 1;
        return this.cZ;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.cZ, this.fN(), this);
        if (container != null) {
            container.setTitle(itileinventory.H_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).c(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.G_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bR = container;
        this.c.a(new PacketPlayOutOpenWindow(container.j, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.cZ);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.c.a(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.cZ, this.fN(), iinventory, entityhorseabstract);
        container.setTitle(entityhorseabstract.H_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.c(this);
            return;
        }
        if (this.bR != this.bQ) {
            this.q();
        }
        this.c.a(new PacketPlayOutOpenWindowHorse(this.cZ, iinventory.b(), entityhorseabstract.af()));
        this.bR = container;
        this.a(this.bR);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.a(Items.th)) {
            if (ItemWrittenBook.a(itemstack, this.da(), this)) {
                this.bR.d();
            }
            this.c.a(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.c.a(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::o));
    }

    @Override
    public void q() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.c.a(new PacketPlayOutCloseWindow(this.bR.j));
        this.r();
    }

    @Override
    public void r() {
        this.bR.b(this);
        this.bQ.a(this.bR);
        this.bR = this.bQ;
    }

    public void a(float f2, float f1, boolean flag, boolean flag1) {
        if (this.bM()) {
            if (f2 >= -1.0f && f2 <= 1.0f) {
                this.bl = f2;
            }
            if (f1 >= -1.0f && f1 <= 1.0f) {
                this.bn = f1;
            }
            this.bk = flag;
            if (flag1 != this.bP()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), flag1);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.f(flag1);
        }
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.co.b(this, statistic, i2);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(statistic, this.cv(), scoreboardscore -> scoreboardscore.a(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.co.a(this, statistic, 0);
        this.dI().getCraftServer().getScoreboardManager().getScoreboardScores(statistic, this.cv(), ScoreboardScore::c);
    }

    @Override
    public int a(Collection<IRecipe<?>> collection) {
        return this.cG.a(collection, this);
    }

    @Override
    public void a(IRecipe<?> irecipe, List<ItemStack> list) {
        CriterionTriggers.Z.a(this, irecipe.e(), list);
    }

    @Override
    public void a(MinecraftKey[] aminecraftkey) {
        ArrayList list = Lists.newArrayList();
        MinecraftKey[] aminecraftkey1 = aminecraftkey;
        int i2 = aminecraftkey.length;
        int j2 = 0;
        while (j2 < i2) {
            MinecraftKey minecraftkey = aminecraftkey1[j2];
            Optional<IRecipe<?>> optional = this.d.aE().a(minecraftkey);
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            ++j2;
        }
        this.a(list);
    }

    @Override
    public int b(Collection<IRecipe<?>> collection) {
        return this.cG.b(collection, this);
    }

    @Override
    public void d(int i2) {
        super.d(i2);
        this.cy = -1;
    }

    public void s() {
        this.cJ = true;
        this.bz();
        if (this.fy()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cJ;
    }

    public void u() {
        this.cv = -1.0E8f;
        this.cy = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void Z_() {
        if (!this.bw.b() && this.fi()) {
            this.c.a(new PacketPlayOutEntityStatus(this, 9));
            super.Z_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.c.a(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.c, vec3d.d, vec3d.e));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.c.a(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.cV = entityplayer.cV;
        this.cT = entityplayer.cT;
        this.cY = entityplayer.cY;
        this.e.a(entityplayer.e.b(), entityplayer.e.c());
        this.w();
        if (flag) {
            this.fN().a(entityplayer.fN());
            this.t(entityplayer.er());
            this.bS = entityplayer.bS;
            this.ce = entityplayer.ce;
            this.cf = entityplayer.cf;
            this.cg = entityplayer.cg;
            this.r(entityplayer.fI());
            this.aw = entityplayer.aw;
        } else if (this.dI().X().b(GameRules.d) || entityplayer.G_()) {
            this.fN().a(entityplayer.fN());
            this.ce = entityplayer.ce;
            this.cf = entityplayer.cf;
            this.cg = entityplayer.cg;
            this.r(entityplayer.fI());
        }
        this.ch = entityplayer.ch;
        this.bP = entityplayer.bP;
        this.aj().b(bL, (Byte)entityplayer.aj().b(bL));
        this.cy = -1;
        this.cv = -1.0f;
        this.cw = -1;
        this.cF = entityplayer.cF;
        this.cL = entityplayer.cL;
        this.i(entityplayer.ge());
        this.j(entityplayer.gf());
        ((EntityHuman)this).a(entityplayer.gm());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(mobeffect, entity);
        this.c.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        if (mobeffect.c() == MobEffects.y) {
            this.cI = this.ag;
            this.cH = this.dg();
        }
        CriterionTriggers.A.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(mobeffect, flag, entity);
        this.c.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        CriterionTriggers.A.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect) {
        super.a(mobeffect);
        this.c.a(new PacketPlayOutRemoveEntityEffect(this.af(), mobeffect.c()));
        if (mobeffect.c() == MobEffects.y) {
            this.cH = null;
        }
        CriterionTriggers.A.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double d0, double d1, double d2) {
        this.c.a(d0, d1, d2, this.dy(), this.dA(), RelativeMovement.g);
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.c.a(this.dn() + d0, this.dp() + d1, this.dt() + d2, this.dy(), this.dA(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.k().a(TicketType.g, chunkcoordintpair, 1, this.af());
        this.Y();
        if (this.fy()) {
            this.a(true, true);
        }
        if (worldserver == this.dI()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.n(f2);
        return true;
    }

    @Override
    public void d(double d0, double d1, double d2) {
        super.d(d0, d1, d2);
        this.c.d();
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity) {
        this.x().k().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity entity) {
        this.x().k().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void w() {
        if (this.c != null) {
            this.c.a(new PacketPlayOutAbilities(this.fO()));
            this.F();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.dI();
    }

    public boolean a(EnumGamemode enumgamemode) {
        if (!this.e.a(enumgamemode)) {
            return false;
        }
        this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.gb();
            this.Y();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.w();
        this.fg();
        return true;
    }

    @Override
    public boolean G_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.v(flag)) {
            this.c.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.v(false)) {
                    boolean flag1 = true;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.gq()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String y() {
        SocketAddress socketaddress = this.c.e();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(PacketPlayInSettings packetplayinsettings) {
        PlayerChangedMainHandEvent event;
        if (this.fh() != packetplayinsettings.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fh() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.locale.equals(packetplayinsettings.b)) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packetplayinsettings.b);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        this.locale = packetplayinsettings.b;
        this.clientViewDistance = packetplayinsettings.c;
        this.cA = packetplayinsettings.d();
        this.cB = packetplayinsettings.e();
        this.cT = packetplayinsettings.h();
        this.cU = packetplayinsettings.i();
        this.aj().b(bL, (byte)packetplayinsettings.f());
        this.aj().b(bM, (byte)(packetplayinsettings.g() != EnumMainHand.a ? 1 : 0));
    }

    public boolean z() {
        return this.cB;
    }

    public EnumChatVisibility A() {
        return this.cA;
    }

    private boolean v(boolean flag) {
        return this.cA == EnumChatVisibility.c ? flag : true;
    }

    private boolean gq() {
        return this.cA == EnumChatVisibility.a;
    }

    public void a(String s2, String s1, boolean flag, @Nullable IChatBaseComponent ichatbasecomponent) {
        this.c.a(new PacketPlayOutResourcePackSend(s2, s1, flag, ichatbasecomponent));
    }

    public void a(ServerPing serverping) {
        this.c.a(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a), serverping.e()));
    }

    @Override
    protected int B() {
        return this.d.c(this.fM());
    }

    public void C() {
        this.cC = SystemUtils.b();
    }

    public ServerStatisticManager D() {
        return this.co;
    }

    public RecipeBookServer E() {
        return this.cG;
    }

    @Override
    protected void F() {
        if (this.G_()) {
            this.em();
            this.j(true);
        } else {
            super.F();
        }
    }

    public net.minecraft.world.entity.Entity G() {
        return this.cD == null ? this : this.cD;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.G();
        net.minecraft.world.entity.Entity entity2 = this.cD = entity == null ? this : entity;
        if (entity1 != this.cD) {
            net.minecraft.world.level.World world = this.cD.dI();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cD.dn(), this.cD.dp(), this.cD.dt(), Set.of(), this.dy(), this.dA(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.x().k().a(this);
            }
            this.c.a(new PacketPlayOutCamera(this.cD));
            this.c.d();
        }
    }

    @Override
    protected void H() {
        if (!this.cE) {
            super.H();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity entity) {
        if (this.e.b() == EnumGamemode.d) {
            this.c(entity);
        } else {
            super.d(entity);
        }
    }

    public long I() {
        return this.cC;
    }

    @Nullable
    public IChatBaseComponent J() {
        return this.listName;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.gh();
    }

    public boolean K() {
        return this.cE;
    }

    public void L() {
        this.cE = false;
    }

    public AdvancementDataPlayer M() {
        return this.cn;
    }

    public void a(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1) {
        this.teleportTo(worldserver, d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.Y();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition N() {
        return this.cP;
    }

    public float O() {
        return this.cR;
    }

    public ResourceKey<net.minecraft.world.level.World> P() {
        return this.cO;
    }

    public boolean Q() {
        return this.cQ;
    }

    public void a(ResourceKey<net.minecraft.world.level.World> resourcekey, @Nullable BlockPosition blockposition, float f2, boolean flag, boolean flag1) {
        this.setRespawnPosition(resourcekey, blockposition, f2, flag, flag1, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(ResourceKey<net.minecraft.world.level.World> resourcekey, @Nullable BlockPosition blockposition, float f2, boolean flag, boolean flag1, PlayerSpawnChangeEvent.Cause cause) {
        WorldServer newWorld = this.d.a(resourcekey);
        Location newSpawn = blockposition != null ? CraftLocation.toBukkit(blockposition, (World)newWorld.getWorld(), f2, 0.0f) : null;
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, flag, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        flag = event.isForced();
        if (newSpawn != null) {
            resourcekey = ((CraftWorld)newSpawn.getWorld()).getHandle().ac();
            blockposition = BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ());
            f2 = newSpawn.getYaw();
        } else {
            resourcekey = net.minecraft.world.level.World.h;
            blockposition = null;
            f2 = 0.0f;
        }
        if (blockposition != null) {
            boolean flag2;
            boolean bl = flag2 = blockposition.equals(this.cP) && resourcekey.equals(this.cO);
            if (flag1 && !flag2) {
                this.a(IChatBaseComponent.c("block.minecraft.set_spawn"));
            }
            this.cP = blockposition;
            this.cO = resourcekey;
            this.cR = f2;
            this.cQ = flag;
        } else {
            this.cP = null;
            this.cO = net.minecraft.world.level.World.h;
            this.cR = 0.0f;
            this.cQ = false;
        }
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, Packet<?> packet) {
        this.c.a(packet);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair) {
        if (this.bs()) {
            this.c.a(new PacketPlayOutUnloadChunk(chunkcoordintpair.e, chunkcoordintpair.f));
        }
    }

    public SectionPosition R() {
        return this.cN;
    }

    public void a(SectionPosition sectionposition) {
        this.cN = sectionposition;
    }

    @Override
    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.c.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(soundeffect), soundcategory, this.dn(), this.dp(), this.dt(), f2, f1, this.af.g()));
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutNamedEntitySpawn(this);
    }

    @Override
    public EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        EntityItem entityitem = super.a(itemstack, flag, flag1);
        if (entityitem == null) {
            return null;
        }
        this.dI().b(entityitem);
        ItemStack itemstack1 = entityitem.j();
        if (flag1) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.d()), itemstack.L());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter T() {
        return this.cS;
    }

    public void c(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.e.a(worldserver);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbttagcompound, String s2) {
        return nbttagcompound != null && nbttagcompound.b(s2, 99) ? EnumGamemode.a(nbttagcompound.h(s2)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.d.aX();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.d.o_());
    }

    public void c(@Nullable NBTTagCompound nbttagcompound) {
        this.e.a(this.b(EntityPlayer.a(nbttagcompound, "playerGameType")), EntityPlayer.a(nbttagcompound, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbttagcompound.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean U() {
        return this.cT;
    }

    public boolean b(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.cT || entityplayer.cT;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        return super.a(world, blockposition) && world.a(this, blockposition);
    }

    @Override
    protected void a(ItemStack itemstack) {
        CriterionTriggers.T.a(this, itemstack);
        super.a(itemstack);
    }

    public boolean a(boolean flag) {
        PlayerInventory playerinventory = this.fN();
        ItemStack itemstack = playerinventory.a(flag);
        this.bR.b(playerinventory, playerinventory.l).ifPresent(i2 -> this.bR.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean V() {
        return this.cU;
    }

    @Override
    public Optional<WardenSpawnTracker> W() {
        return Optional.of(this.cV);
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        net.minecraft.world.entity.Entity entity = entityitem.v();
        if (entity != null) {
            CriterionTriggers.P.a(this, entityitem.j(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.cY = remotechatsession;
    }

    @Nullable
    public RemoteChatSession X() {
        return this.cY != null && this.cY.c() ? null : this.cY;
    }

    @Override
    public void a(double d0, double d1) {
        this.ck = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dy());
        this.c.a(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean flag) {
        if (!super.a(entity, flag)) {
            return false;
        }
        entity.i(this);
        this.c.a(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eo()) {
                this.c.a(new PacketPlayOutEntityEffect(entity.af(), mobeffect));
            }
        }
        return true;
    }

    @Override
    public void Y() {
        net.minecraft.world.entity.Entity entity = this.cW();
        super.Y();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eo()) {
                this.c.a(new PacketPlayOutRemoveEntityEffect(entity.af(), mobeffect.c()));
            }
        }
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dI().W() + this.timeOffset;
        }
        return this.dI().W() - this.dI().W() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dI().u_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.cv() + " at " + this.dn() + "," + this.dp() + "," + this.dt() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.d();
    }

    @Override
    public boolean eT() {
        return super.eT() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard gc() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dI().X().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.cg;
            this.newTotalExp = this.cf;
            this.newLevel = this.ce;
        }
        this.t(this.eI());
        this.fo();
        this.h(0);
        this.aa = 0.0f;
        this.bS = new FoodMetaData(this);
        this.ce = this.newLevel;
        this.cf = this.newTotalExp;
        this.cg = 0.0f;
        this.aN = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bV = true;
        this.bR = this.bQ;
        this.aZ = null;
        this.bW = null;
        this.bQ = new CombatTracker(this);
        this.cy = -1;
        if (this.keepLevel) {
            this.cg = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.o(0.0, 0.0, 0.0);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }
}

