/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> a = Either.right((Object)Failure.b);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> b = CompletableFuture.completedFuture(a);
    public static final Either<Chunk, Failure> c = Either.right((Object)Failure.b);
    private static final Either<IChunkAccess, Failure> d = Either.right((Object)Failure.b);
    private static final CompletableFuture<Either<Chunk, Failure>> e = CompletableFuture.completedFuture(c);
    private static final List<ChunkStatus> f = ChunkStatus.a();
    private final AtomicReferenceArray<CompletableFuture<Either<IChunkAccess, Failure>>> g = new AtomicReferenceArray(f.size());
    private final LevelHeightAccessor h;
    private volatile CompletableFuture<Either<Chunk, Failure>> i = e;
    private volatile CompletableFuture<Either<Chunk, Failure>> j = e;
    private volatile CompletableFuture<Either<Chunk, Failure>> k = e;
    private CompletableFuture<IChunkAccess> l = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<b> m = null;
    public int n;
    private int o;
    private int p;
    final ChunkCoordIntPair q;
    private boolean r;
    private final ShortSet[] s;
    private final BitSet t = new BitSet();
    private final BitSet u = new BitSet();
    private final LevelLightEngine v;
    private final c w;
    public final d x;
    private boolean y;
    private CompletableFuture<Void> z = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair chunkcoordintpair, int i2, LevelHeightAccessor levelheightaccessor, LevelLightEngine levellightengine, c playerchunk_c, d playerchunk_d) {
        this.q = chunkcoordintpair;
        this.h = levelheightaccessor;
        this.v = levellightengine;
        this.w = playerchunk_c;
        this.x = playerchunk_d;
        this.o = this.n = ChunkLevel.a + 1;
        this.p = this.n;
        this.a(i2);
        this.s = new ShortSet[levelheightaccessor.ak()];
    }

    public Chunk getFullChunkNow() {
        if (!ChunkLevel.b(this.n).a(FullChunkStatus.b)) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public Chunk getFullChunkNowUnchecked() {
        CompletableFuture<Either<IChunkAccess, Failure>> statusFuture = this.a(ChunkStatus.n);
        Either either = statusFuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus chunkstatus) {
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.g.get(chunkstatus.c());
        return completablefuture == null ? b : completablefuture;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> b(ChunkStatus chunkstatus) {
        return ChunkLevel.a(this.o).b(chunkstatus) ? this.a(chunkstatus) : b;
    }

    public CompletableFuture<Either<Chunk, Failure>> a() {
        return this.j;
    }

    public CompletableFuture<Either<Chunk, Failure>> b() {
        return this.k;
    }

    public CompletableFuture<Either<Chunk, Failure>> c() {
        return this.i;
    }

    @Nullable
    public Chunk d() {
        CompletableFuture<Either<Chunk, Failure>> completablefuture = this.a();
        Either either = completablefuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Nullable
    public Chunk e() {
        CompletableFuture<Either<Chunk, Failure>> completablefuture = this.c();
        Either either = completablefuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Nullable
    public ChunkStatus f() {
        int i2 = f.size() - 1;
        while (i2 >= 0) {
            ChunkStatus chunkstatus = f.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (completablefuture.getNow(a).left().isPresent()) {
                return chunkstatus;
            }
            --i2;
        }
        return null;
    }

    @Nullable
    public IChunkAccess g() {
        int i2 = f.size() - 1;
        while (i2 >= 0) {
            Optional optional;
            ChunkStatus chunkstatus = f.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (!completablefuture.isCompletedExceptionally() && (optional = completablefuture.getNow(a).left()).isPresent()) {
                return (IChunkAccess)optional.get();
            }
            --i2;
        }
        return null;
    }

    public CompletableFuture<IChunkAccess> h() {
        return this.l;
    }

    public void a(BlockPosition blockposition) {
        Chunk chunk = this.d();
        if (chunk != null) {
            int i2 = this.h.e(blockposition.v());
            if (i2 < 0 || i2 >= this.s.length) {
                return;
            }
            if (this.s[i2] == null) {
                this.r = true;
                this.s[i2] = new ShortOpenHashSet();
            }
            this.s[i2].add(SectionPosition.b(blockposition));
        }
    }

    public void a(EnumSkyBlock enumskyblock, int i2) {
        IChunkAccess ichunkaccess;
        Either either = this.b(ChunkStatus.k).getNow(null);
        if (either != null && (ichunkaccess = (IChunkAccess)either.left().orElse(null)) != null) {
            ichunkaccess.a(true);
            Chunk chunk = this.d();
            if (chunk != null) {
                int j2 = this.v.d();
                int k2 = this.v.e();
                if (i2 >= j2 && i2 <= k2) {
                    int l2 = i2 - j2;
                    if (enumskyblock == EnumSkyBlock.a) {
                        this.u.set(l2);
                    } else {
                        this.t.set(l2);
                    }
                }
            }
        }
    }

    public void a(Chunk chunk) {
        if (this.r || !this.u.isEmpty() || !this.t.isEmpty()) {
            List<EntityPlayer> list;
            World world = chunk.F();
            if (!this.u.isEmpty() || !this.t.isEmpty()) {
                list = this.x.a(this.q, true);
                if (!list.isEmpty()) {
                    PacketPlayOutLightUpdate packetplayoutlightupdate = new PacketPlayOutLightUpdate(chunk.f(), this.v, this.u, this.t);
                    this.a(list, packetplayoutlightupdate);
                }
                this.u.clear();
                this.t.clear();
            }
            if (this.r) {
                list = this.x.a(this.q, false);
                int i2 = 0;
                while (i2 < this.s.length) {
                    ShortSet shortset = this.s[i2];
                    if (shortset != null) {
                        this.s[i2] = null;
                        if (!list.isEmpty()) {
                            int j2 = this.h.g(i2);
                            SectionPosition sectionposition = SectionPosition.a(chunk.f(), j2);
                            if (shortset.size() == 1) {
                                BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                                IBlockData iblockdata = world.a_(blockposition);
                                this.a(list, new PacketPlayOutBlockChange(blockposition, iblockdata));
                                this.a(list, world, blockposition, iblockdata);
                            } else {
                                ChunkSection chunksection = chunk.b(i2);
                                PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection);
                                this.a(list, packetplayoutmultiblockchange);
                                List<EntityPlayer> finalList = list;
                                packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(finalList, world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                            }
                        }
                    }
                    ++i2;
                }
                this.r = false;
            }
        }
    }

    private void a(List<EntityPlayer> list, World world, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.t()) {
            this.a(list, world, blockposition);
        }
    }

    private void a(List<EntityPlayer> list, World world, BlockPosition blockposition) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity != null && (packet = tileentity.h()) != null) {
            this.a(list, packet);
        }
    }

    private void a(List<EntityPlayer> list, Packet<?> packet) {
        list.forEach(entityplayer -> entityplayer.c.a(packet));
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus chunkstatus, PlayerChunkMap playerchunkmap) {
        int i2 = chunkstatus.c();
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.g.get(i2);
        if (completablefuture != null) {
            Either<IChunkAccess, Failure> either = completablefuture.getNow(d);
            if (either == null) {
                String s2 = "value in future for status: " + chunkstatus + " was incorrectly set to null at chunk: " + this.q;
                throw playerchunkmap.a(new IllegalStateException("null value previously set for chunk status"), s2);
            }
            if (either == d || either.right().isEmpty()) {
                return completablefuture;
            }
        }
        if (ChunkLevel.a(this.o).b(chunkstatus)) {
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture1 = playerchunkmap.a(this, chunkstatus);
            this.a(completablefuture1, "schedule " + chunkstatus);
            this.g.set(i2, completablefuture1);
            return completablefuture1;
        }
        return completablefuture == null ? b : completablefuture;
    }

    protected void a(String s2, CompletableFuture<?> completablefuture) {
        if (this.m != null) {
            this.m.a(new b(Thread.currentThread(), completablefuture, s2));
        }
        this.l = this.l.thenCombine(completablefuture, (ichunkaccess, object) -> ichunkaccess);
    }

    private void a(CompletableFuture<? extends Either<? extends IChunkAccess, Failure>> completablefuture, String s2) {
        if (this.m != null) {
            this.m.a(new b(Thread.currentThread(), completablefuture, s2));
        }
        this.l = this.l.thenCombine(completablefuture, (ichunkaccess, either) -> (IChunkAccess)either.map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> ichunkaccess));
    }

    public FullChunkStatus i() {
        return ChunkLevel.b(this.o);
    }

    public ChunkCoordIntPair j() {
        return this.q;
    }

    public int k() {
        return this.o;
    }

    public int l() {
        return this.p;
    }

    private void b(int i2) {
        this.p = i2;
    }

    public void a(int i2) {
        this.o = i2;
    }

    private void a(PlayerChunkMap playerchunkmap, CompletableFuture<Either<Chunk, Failure>> completablefuture, Executor executor, FullChunkStatus fullchunkstatus) {
        this.z.cancel(false);
        CompletableFuture completablefuture1 = new CompletableFuture();
        completablefuture1.thenRunAsync(() -> playerchunkmap.a(this.q, fullchunkstatus), executor);
        this.z = completablefuture1;
        completablefuture.thenAccept(either -> either.ifLeft(chunk -> completablefuture1.complete(null)));
    }

    private void a(PlayerChunkMap playerchunkmap, FullChunkStatus fullchunkstatus) {
        this.z.cancel(false);
        playerchunkmap.a(this.q, fullchunkstatus);
    }

    protected void a(PlayerChunkMap playerchunkmap, Executor executor) {
        ChunkStatus chunkstatus = ChunkLevel.a(this.n);
        ChunkStatus chunkstatus1 = ChunkLevel.a(this.o);
        boolean flag = ChunkLevel.e(this.n);
        boolean flag1 = ChunkLevel.e(this.o);
        FullChunkStatus fullchunkstatus = ChunkLevel.b(this.n);
        FullChunkStatus fullchunkstatus1 = ChunkLevel.b(this.o);
        if (fullchunkstatus.a(FullChunkStatus.b) && !fullchunkstatus1.a(FullChunkStatus.b)) {
            ((CompletableFuture)this.a(ChunkStatus.n).thenAccept(either -> {
                Chunk chunk = either.left().orElse(null);
                if (chunk != null) {
                    playerChunkMap.callbackExecutor.execute(() -> {
                        chunk.a(true);
                        chunk.unloadCallback();
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.n.error("Failed to schedule unload callback for chunk " + this.q, throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
        if (flag) {
            Either either2 = Either.right((Object)new Failure(){

                public String toString() {
                    return "Unloaded ticket level " + PlayerChunk.this.q;
                }
            });
            int i2 = flag1 ? chunkstatus1.c() + 1 : 0;
            while (i2 <= chunkstatus.c()) {
                CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.g.get(i2);
                if (completablefuture == null) {
                    this.g.set(i2, CompletableFuture.completedFuture(either2));
                }
                ++i2;
            }
        }
        boolean flag2 = fullchunkstatus.a(FullChunkStatus.b);
        boolean flag3 = fullchunkstatus1.a(FullChunkStatus.b);
        this.y |= flag3;
        if (!flag2 && flag3) {
            this.i = playerchunkmap.c(this);
            this.a(playerchunkmap, this.i, executor, FullChunkStatus.b);
            this.a(this.i, "full");
        }
        if (flag2 && !flag3) {
            this.i.complete(c);
            this.i = e;
        }
        boolean flag4 = fullchunkstatus.a(FullChunkStatus.c);
        boolean flag5 = fullchunkstatus1.a(FullChunkStatus.c);
        if (!flag4 && flag5) {
            this.j = playerchunkmap.b(this);
            this.a(playerchunkmap, this.j, executor, FullChunkStatus.c);
            this.a(this.j, "ticking");
        }
        if (flag4 && !flag5) {
            this.j.complete(c);
            this.j = e;
        }
        boolean flag6 = fullchunkstatus.a(FullChunkStatus.d);
        boolean flag7 = fullchunkstatus1.a(FullChunkStatus.d);
        if (!flag6 && flag7) {
            if (this.k != e) {
                throw SystemUtils.b(new IllegalStateException());
            }
            this.k = playerchunkmap.a(this);
            this.a(playerchunkmap, this.k, executor, FullChunkStatus.d);
            this.a(this.k, "entity ticking");
        }
        if (flag6 && !flag7) {
            this.k.complete(c);
            this.k = e;
        }
        if (!fullchunkstatus1.a(fullchunkstatus)) {
            this.a(playerchunkmap, fullchunkstatus1);
        }
        this.w.onLevelChange(this.q, this::l, this.o, this::b);
        this.n = this.o;
        if (!fullchunkstatus.a(FullChunkStatus.b) && fullchunkstatus1.a(FullChunkStatus.b)) {
            ((CompletableFuture)this.a(ChunkStatus.n).thenAccept(either -> {
                Chunk chunk = either.left().orElse(null);
                if (chunk != null) {
                    playerChunkMap.callbackExecutor.execute(() -> chunk.loadCallback());
                }
            })).exceptionally(throwable -> {
                MinecraftServer.n.error("Failed to schedule load callback for chunk " + this.q, throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
    }

    public boolean m() {
        return this.y;
    }

    public void n() {
        this.y = ChunkLevel.b(this.o).a(FullChunkStatus.b);
    }

    public void a(ProtoChunkExtension protochunkextension) {
        int i2 = 0;
        while (i2 < this.g.length()) {
            Optional optional;
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.g.get(i2);
            if (completablefuture != null && !(optional = completablefuture.getNow(a).left()).isEmpty() && optional.get() instanceof ProtoChunk) {
                this.g.set(i2, CompletableFuture.completedFuture(Either.left((Object)protochunkextension)));
            }
            ++i2;
        }
        this.a(CompletableFuture.completedFuture(Either.left((Object)protochunkextension.C())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> o() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> list = new ArrayList<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>>();
        int i2 = 0;
        while (i2 < f.size()) {
            list.add((Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>)Pair.of((Object)f.get(i2), this.g.get(i2)));
            ++i2;
        }
        return list;
    }

    public static interface Failure {
        public static final Failure b = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }

    private static final class b {
        private final Thread a;
        private final CompletableFuture<?> b;
        private final String c;

        b(Thread thread, CompletableFuture<?> completablefuture, String s2) {
            this.a = thread;
            this.b = completablefuture;
            this.c = s2;
        }
    }

    @FunctionalInterface
    public static interface c {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface d {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }
}

