/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomChunkGenerator;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.d {
    private static final byte e = -1;
    private static final byte f = 0;
    private static final byte g = 1;
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 200;
    private static final int j = 20;
    private static final int k = 10000;
    private static final int l = 2;
    public static final int a = 32;
    public static final int b = ChunkLevel.a(FullChunkStatus.d);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> m = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> n;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> o;
    private final LongSet p;
    public final WorldServer q;
    private final LightEngineThreaded r;
    private final IAsyncTaskHandler<Runnable> s;
    public ChunkGenerator t;
    private final RandomState u;
    private final ChunkGeneratorStructureState v;
    private final Supplier<WorldPersistentData> w;
    private final VillagePlace x;
    public final LongSet y;
    private boolean z;
    private final ChunkTaskQueueSorter A;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> B;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> C;
    public final WorldLoadListener D;
    private final ChunkStatusUpdateListener E;
    public final a F;
    private final AtomicInteger G;
    private final StructureTemplateManager H;
    private final String I;
    private final PlayerMap J;
    public final Int2ObjectMap<EntityTracker> K;
    private final Long2ByteMap L;
    private final Long2LongMap M;
    private final Queue<Runnable> N;
    int O;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public PlayerChunkMap(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, IAsyncTaskHandler<Runnable> iasynctaskhandler, ILightAccess ilightaccess, ChunkGenerator chunkgenerator, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier, int i2, boolean flag) {
        super(convertable_conversionsession.a(worldserver.ac()).resolve("region"), datafixer, flag);
        this.n = this.m.clone();
        this.o = new Long2ObjectLinkedOpenHashMap();
        this.p = new LongOpenHashSet();
        this.y = new LongOpenHashSet();
        this.G = new AtomicInteger();
        this.J = new PlayerMap();
        this.K = new Int2ObjectOpenHashMap();
        this.L = new Long2ByteOpenHashMap();
        this.M = new Long2LongOpenHashMap();
        this.N = Queues.newConcurrentLinkedQueue();
        this.H = structuretemplatemanager;
        Path path = convertable_conversionsession.a(worldserver.ac());
        this.I = path.getFileName().toString();
        this.q = worldserver;
        this.t = chunkgenerator;
        if (chunkgenerator instanceof CustomChunkGenerator) {
            chunkgenerator = ((CustomChunkGenerator)chunkgenerator).getDelegate();
        }
        IRegistryCustom iregistrycustom = worldserver.B_();
        long j2 = worldserver.A();
        if (chunkgenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)chunkgenerator;
            this.u = RandomState.a(chunkgeneratorabstract.g().a(), iregistrycustom.b(Registries.ax), j2);
        } else {
            this.u = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.b(Registries.ax), j2);
        }
        this.v = chunkgenerator.createState(iregistrycustom.b(Registries.aB), this.u, j2, worldserver.spigotConfig);
        this.s = iasynctaskhandler;
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.a(executor, "worldgen");
        Objects.requireNonNull(iasynctaskhandler);
        Mailbox<Runnable> mailbox = Mailbox.a("main", iasynctaskhandler::i);
        this.D = worldloadlistener;
        this.E = chunkstatusupdatelistener;
        ThreadedMailbox<Runnable> threadedmailbox1 = ThreadedMailbox.a(executor, "light");
        this.A = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(threadedmailbox, mailbox, threadedmailbox1), executor, Integer.MAX_VALUE);
        this.B = this.A.a(threadedmailbox, false);
        this.C = this.A.a(mailbox, false);
        this.r = new LightEngineThreaded(ilightaccess, this, this.q.x_().g(), threadedmailbox1, this.A.a(threadedmailbox1, false));
        this.F = new a(executor, iasynctaskhandler);
        this.w = supplier;
        this.x = new VillagePlace(path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver);
        this.a(i2);
    }

    protected ChunkGenerator a() {
        return this.t;
    }

    protected ChunkGeneratorStructureState b() {
        return this.v;
    }

    protected RandomState c() {
        return this.u;
    }

    public void d() {
        DataResult dataresult = ChunkGenerator.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.t);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.result().ifPresent(chunkgenerator -> {
            this.t = chunkgenerator;
        });
    }

    private static double a(ChunkCoordIntPair chunkcoordintpair, Entity entity) {
        double d0 = SectionPosition.a(chunkcoordintpair.e, 8);
        double d1 = SectionPosition.a(chunkcoordintpair.f, 8);
        double d2 = d0 - entity.dn();
        double d3 = d1 - entity.dt();
        return d2 * d2 + d3 * d3;
    }

    public static boolean a(int i2, int j2, int k2, int l2, int i1) {
        int k22;
        int j1 = Math.max(0, Math.abs(i2 - k2) - 1);
        int k1 = Math.max(0, Math.abs(j2 - l2) - 1);
        long l1 = Math.max(0, Math.max(j1, k1) - 1);
        long i22 = Math.min(j1, k1);
        long j22 = i22 * i22 + l1 * l1;
        return j22 < (long)(k22 = i1 * i1);
    }

    private static boolean b(int i2, int j2, int k2, int l2, int i1) {
        return !PlayerChunkMap.a(i2, j2, k2, l2, i1) ? false : !PlayerChunkMap.a(i2 + 1, j2 + 1, k2, l2, i1) || !PlayerChunkMap.a(i2 - 1, j2 + 1, k2, l2, i1) || !PlayerChunkMap.a(i2 + 1, j2 - 1, k2, l2, i1) || !PlayerChunkMap.a(i2 - 1, j2 - 1, k2, l2, i1);
    }

    protected LightEngineThreaded e() {
        return this.r;
    }

    @Nullable
    protected PlayerChunk a(long i2) {
        return (PlayerChunk)this.m.get(i2);
    }

    @Nullable
    protected PlayerChunk b(long i2) {
        return (PlayerChunk)this.n.get(i2);
    }

    protected IntSupplier c(long i2) {
        return () -> {
            PlayerChunk playerchunk = this.b(i2);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.l(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        PlayerChunk playerchunk = this.b(chunkcoordintpair.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = String.valueOf(playerchunk.k()) + "\n";
        ChunkStatus chunkstatus = playerchunk.f();
        IChunkAccess ichunkaccess = playerchunk.g();
        if (chunkstatus != null) {
            s2 = String.valueOf(s2) + "St: \u00a7" + chunkstatus.c() + chunkstatus + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = String.valueOf(s2) + "Ch: \u00a7" + ichunkaccess.j().c() + ichunkaccess.j() + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.i();
        s2 = String.valueOf(s2) + "\u00a7" + fullchunkstatus.ordinal() + (Object)((Object)fullchunkstatus);
        return String.valueOf(s2) + "\u00a7r";
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> a(PlayerChunk playerchunk, final int i2, IntFunction<ChunkStatus> intfunction) {
        if (i2 == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.a(chunkstatus, this).thenApply(either -> either.mapLeft(List::of));
        }
        ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> list = new ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>>();
        ArrayList<PlayerChunk> list1 = new ArrayList<PlayerChunk>();
        ChunkCoordIntPair chunkcoordintpair = playerchunk.j();
        final int j2 = chunkcoordintpair.e;
        final int k2 = chunkcoordintpair.f;
        int l2 = -i2;
        while (l2 <= i2) {
            int i1 = -i2;
            while (i1 <= i2) {
                int j1 = Math.max(Math.abs(i1), Math.abs(l2));
                final ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(j2 + i1, k2 + l2);
                long k1 = chunkcoordintpair1.a();
                PlayerChunk playerchunk1 = this.a(k1);
                if (playerchunk1 == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new PlayerChunk.Failure(){

                        public String toString() {
                            return "Unloaded " + chunkcoordintpair1;
                        }
                    }));
                }
                ChunkStatus chunkstatus1 = intfunction.apply(j1);
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = playerchunk1.a(chunkstatus1, this);
                list1.add(playerchunk1);
                list.add(completablefuture);
                ++i1;
            }
            ++l2;
        }
        ArrayList completablefuture1 = SystemUtils.b(list);
        CompletionStage completablefuture2 = ((CompletableFuture)((Object)completablefuture1)).thenApply(list2 -> {
            ArrayList list3 = Lists.newArrayList();
            int cnt = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                final int l1 = cnt++;
                final Either either = (Either)iterator.next();
                if (either == null) {
                    throw this.a(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    return Either.right((Object)new PlayerChunk.Failure(){

                        public String toString() {
                            ChunkCoordIntPair chunkcoordintpair2 = new ChunkCoordIntPair(j2 + l1 % (i2 * 2 + 1), k2 + l1 / (i2 * 2 + 1));
                            return "Unloaded " + chunkcoordintpair2 + " " + either.right().get();
                        }
                    });
                }
                list3.add((IChunkAccess)optional.get());
            }
            return Either.left((Object)list3);
        });
        for (PlayerChunk playerchunk2 : list1) {
            playerchunk2.a("getChunkRangeFuture " + chunkcoordintpair + " " + i2, (CompletableFuture<?>)completablefuture2);
        }
        return completablefuture2;
    }

    public ReportedException a(IllegalStateException illegalstateexception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.o().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.j()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.m.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.n.values().forEach(consumer);
        CrashReport crashreport = CrashReport.a(illegalstateexception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", s2);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> a(PlayerChunk playerchunk) {
        return this.a(playerchunk, 2, (int i2) -> ChunkStatus.n).thenApplyAsync(either -> either.mapLeft(list -> (Chunk)list.get(list.size() / 2)), (Executor)this.s);
    }

    @Nullable
    PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
        if (!ChunkLevel.e(k2) && !ChunkLevel.e(j2)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.a(j2);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.e(j2)) {
                this.y.add(i2);
            } else {
                this.y.remove(i2);
            }
        }
        if (ChunkLevel.e(j2) && playerchunk == null) {
            playerchunk = (PlayerChunk)this.o.remove(i2);
            if (playerchunk != null) {
                playerchunk.a(j2);
            } else {
                playerchunk = new PlayerChunk(new ChunkCoordIntPair(i2), j2, this.q, this.r, this.A, this);
            }
            this.m.put(i2, (Object)playerchunk);
            this.z = true;
        }
        return playerchunk;
    }

    @Override
    public void close() throws IOException {
        try {
            this.A.close();
            this.x.close();
        }
        finally {
            super.close();
        }
    }

    protected void a(boolean flag) {
        if (flag) {
            List list = this.n.values().stream().filter(PlayerChunk::m).peek(PlayerChunk::n).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    CompletableFuture<IChunkAccess> completablefuture;
                    do {
                        completablefuture = playerchunk.h();
                        IAsyncTaskHandler<Runnable> iasynctaskhandler = this.s;
                        Objects.requireNonNull(completablefuture);
                        iasynctaskhandler.c(completablefuture::isDone);
                    } while (completablefuture != playerchunk.h());
                    return completablefuture.join();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.b(() -> true);
            this.o();
        } else {
            this.n.values().forEach(this::e);
        }
    }

    protected void a(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = this.q.ad();
        gameprofilerfiller.a("poi");
        this.x.a(booleansupplier);
        gameprofilerfiller.b("chunk_unload");
        if (!this.q.r()) {
            this.b(booleansupplier);
        }
        gameprofilerfiller.c();
    }

    public boolean f() {
        return this.r.E_() || !this.o.isEmpty() || !this.m.isEmpty() || this.x.a() || !this.y.isEmpty() || !this.N.isEmpty() || this.A.a() || this.F.f();
    }

    private void b(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.y.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (booleansupplier.getAsBoolean() || i2 < 200 || this.y.size() > 2000)) {
            long j2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.m.remove(j2);
            if (playerchunk != null) {
                this.o.put(j2, (Object)playerchunk);
                this.z = true;
                ++i2;
                this.a(j2, playerchunk);
            }
            longiterator.remove();
        }
        int k2 = Math.max(0, this.N.size() - 2000);
        while ((booleansupplier.getAsBoolean() || k2 > 0) && (runnable = this.N.poll()) != null) {
            --k2;
            runnable.run();
        }
        int l2 = 0;
        ObjectIterator objectiterator = this.n.values().iterator();
        while (l2 < 20 && booleansupplier.getAsBoolean() && objectiterator.hasNext()) {
            if (!this.e((PlayerChunk)objectiterator.next())) continue;
            ++l2;
        }
    }

    private void a(long i2, PlayerChunk playerchunk) {
        CompletableFuture<IChunkAccess> completablefuture = playerchunk.h();
        Consumer<IChunkAccess> consumer = ichunkaccess -> {
            CompletableFuture<IChunkAccess> completablefuture1 = playerchunk.h();
            if (completablefuture1 != completablefuture) {
                this.a(i2, playerchunk);
            } else if (this.o.remove(i2, (Object)playerchunk) && ichunkaccess != null) {
                if (ichunkaccess instanceof Chunk) {
                    ((Chunk)ichunkaccess).c(false);
                }
                this.a((IChunkAccess)ichunkaccess);
                if (this.p.remove(i2) && ichunkaccess instanceof Chunk) {
                    Chunk chunk = (Chunk)ichunkaccess;
                    this.q.a(chunk);
                }
                this.r.a(ichunkaccess.f());
                this.r.b();
                this.D.a(ichunkaccess.f(), null);
                this.M.remove(ichunkaccess.f().a());
            }
        };
        Queue<Runnable> queue = this.N;
        Objects.requireNonNull(this.N);
        ((CompletableFuture)completablefuture.thenAcceptAsync((Consumer)consumer, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                h.error("Failed to save chunk {}", (Object)playerchunk.j(), throwable);
            }
        });
    }

    protected boolean g() {
        if (!this.z) {
            return false;
        }
        this.n = this.m.clone();
        this.z = false;
        return true;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(PlayerChunk playerchunk, ChunkStatus chunkstatus) {
        Optional optional;
        ChunkCoordIntPair chunkcoordintpair = playerchunk.j();
        if (chunkstatus == ChunkStatus.c) {
            return this.f(chunkcoordintpair);
        }
        if (chunkstatus == ChunkStatus.l) {
            this.F.a(TicketType.e, chunkcoordintpair, ChunkLevel.a(ChunkStatus.l), chunkcoordintpair);
        }
        if (!chunkstatus.f() && (optional = playerchunk.a(chunkstatus.d(), this).getNow(PlayerChunk.a).left()).isPresent() && ((IChunkAccess)optional.get()).j().b(chunkstatus)) {
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = chunkstatus.a(this.q, this.H, this.r, ichunkaccess -> this.d(playerchunk), (IChunkAccess)optional.get());
            this.D.a(chunkcoordintpair, chunkstatus);
            return completablefuture;
        }
        return this.b(playerchunk, chunkstatus);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> f(ChunkCoordIntPair chunkcoordintpair) {
        return ((CompletableFuture)((CompletableFuture)this.j(chunkcoordintpair).thenApply(optional -> optional.filter(nbttagcompound -> {
            boolean flag = PlayerChunkMap.b(nbttagcompound);
            if (!flag) {
                h.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return flag;
        }))).thenApplyAsync(optional -> {
            this.q.ad().d("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk protochunk = ChunkRegionLoader.a(this.q, this.x, chunkcoordintpair, (NBTTagCompound)optional.get());
                this.a(chunkcoordintpair, protochunk.j().g());
                return Either.left((Object)protochunk);
            }
            return Either.left((Object)this.g(chunkcoordintpair));
        }, (Executor)this.s)).exceptionallyAsync(throwable -> this.a((Throwable)throwable, chunkcoordintpair), (Executor)this.s);
    }

    private static boolean b(NBTTagCompound nbttagcompound) {
        return nbttagcompound.b("Status", 8);
    }

    private Either<IChunkAccess, PlayerChunk.Failure> a(Throwable throwable, ChunkCoordIntPair chunkcoordintpair) {
        if (throwable instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable;
            Throwable throwable1 = reportedexception.getCause();
            if (!(throwable1 instanceof IOException)) {
                this.h(chunkcoordintpair);
                throw reportedexception;
            }
            h.error("Couldn't load chunk {}", (Object)chunkcoordintpair, (Object)throwable1);
        } else if (throwable instanceof IOException) {
            h.error("Couldn't load chunk {}", (Object)chunkcoordintpair, (Object)throwable);
        }
        return Either.left((Object)this.g(chunkcoordintpair));
    }

    private IChunkAccess g(ChunkCoordIntPair chunkcoordintpair) {
        this.h(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, ChunkConverter.a, this.q, this.q.B_().d(Registries.ap), null);
    }

    private void h(ChunkCoordIntPair chunkcoordintpair) {
        this.L.put(chunkcoordintpair.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkcoordintpair, ChunkStatus.Type chunkstatus_type) {
        return this.L.put(chunkcoordintpair.a(), (byte)(chunkstatus_type == ChunkStatus.Type.a ? -1 : 1));
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(PlayerChunk playerchunk, ChunkStatus chunkstatus) {
        ChunkCoordIntPair chunkcoordintpair = playerchunk.j();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(playerchunk, chunkstatus.e(), (int i2) -> this.a(chunkstatus, i2));
        this.q.ad().c(() -> "chunkGenerate " + chunkstatus);
        Executor executor = runnable -> this.B.a(ChunkTaskQueueSorter.a(playerchunk, runnable));
        return completablefuture.thenComposeAsync(either -> (CompletionStage)either.map(list -> {
            try {
                IChunkAccess ichunkaccess = (IChunkAccess)list.get(list.size() / 2);
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture1 = ichunkaccess.j().b(chunkstatus) ? chunkstatus.a(this.q, this.H, this.r, ichunkaccess1 -> this.d(playerchunk), ichunkaccess) : chunkstatus.a(executor, this.q, this.t, this.H, this.r, ichunkaccess1 -> this.d(playerchunk), (List<IChunkAccess>)list);
                this.D.a(chunkcoordintpair, chunkstatus);
                return completablefuture1;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
                crashreportsystemdetails.a("Location", String.format(Locale.ROOT, "%d,%d", chunkCoordIntPair.e, chunkCoordIntPair.f));
                crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.c(chunkCoordIntPair.e, chunkCoordIntPair.f));
                crashreportsystemdetails.a("Generator", this.t);
                this.s.execute(() -> {
                    throw new ReportedException(crashreport);
                });
                throw new ReportedException(crashreport);
            }
        }, playerchunk_failure -> {
            this.b(chunkcoordintpair);
            return CompletableFuture.completedFuture(Either.right((Object)playerchunk_failure));
        }), executor);
    }

    protected void b(ChunkCoordIntPair chunkcoordintpair) {
        this.s.i(SystemUtils.a(() -> this.F.b(TicketType.e, chunkcoordintpair, ChunkLevel.a(ChunkStatus.l), chunkcoordintpair), () -> "release light ticket " + chunkcoordintpair));
    }

    private ChunkStatus a(ChunkStatus chunkstatus, int i2) {
        ChunkStatus chunkstatus1 = i2 == 0 ? chunkstatus.d() : ChunkStatus.a(ChunkStatus.a(chunkstatus) + i2);
        return chunkstatus1;
    }

    private static void a(WorldServer worldserver, List<NBTTagCompound> list) {
        if (!list.isEmpty()) {
            worldserver.b(EntityTypes.a(list, (World)worldserver).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = worldserver.getCraftServer().getServer();
                if (!server.X() && entity instanceof NPC) {
                    entity.ai();
                    needsRemoval = true;
                }
                if (!server.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.ai();
                    needsRemoval = true;
                }
                return !needsRemoval;
            }));
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> d(PlayerChunk playerchunk) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = playerchunk.a(ChunkStatus.n.d());
        return completablefuture.thenApplyAsync(either -> {
            ChunkStatus chunkstatus = ChunkLevel.a(playerchunk.k());
            return !chunkstatus.b(ChunkStatus.n) ? PlayerChunk.a : either.mapLeft(ichunkaccess -> {
                Chunk chunk;
                ChunkCoordIntPair chunkcoordintpair = playerchunk.j();
                ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
                if (protochunk instanceof ProtoChunkExtension) {
                    chunk = ((ProtoChunkExtension)protochunk).C();
                } else {
                    chunk = new Chunk(this.q, protochunk, chunk1 -> PlayerChunkMap.a(this.q, protochunk.E()));
                    playerchunk.a(new ProtoChunkExtension(chunk, false));
                }
                chunk.b(() -> ChunkLevel.b(playerchunk.k()));
                chunk.E();
                if (this.p.add(chunkcoordintpair.a())) {
                    chunk.c(true);
                    chunk.J();
                    chunk.a(this.q);
                }
                return chunk;
            });
        }, runnable -> {
            Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailbox = this.C;
            long i2 = playerchunk.j().a();
            Objects.requireNonNull(playerchunk);
            mailbox.a(ChunkTaskQueueSorter.a(runnable, i2, playerchunk::k));
        });
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(PlayerChunk playerchunk) {
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(playerchunk, 1, (int i2) -> ChunkStatus.n);
        CompletionStage completablefuture1 = ((CompletableFuture)completablefuture.thenApplyAsync(either -> either.mapLeft(list -> (Chunk)list.get(list.size() / 2)), runnable -> this.C.a(ChunkTaskQueueSorter.a(playerchunk, runnable)))).thenApplyAsync(either -> either.ifLeft(chunk -> {
            chunk.H();
            this.q.b((Chunk)chunk);
        }), (Executor)this.s);
        ((CompletableFuture)completablefuture1).handle((either, throwable) -> {
            this.G.getAndIncrement();
            return null;
        });
        ((CompletableFuture)completablefuture1).thenAcceptAsync(either -> either.ifLeft(chunk -> {
            MutableObject mutableobject = new MutableObject();
            this.a(playerchunk.j(), false).forEach(entityplayer -> this.a((EntityPlayer)entityplayer, (MutableObject<ClientboundLevelChunkWithLightPacket>)mutableobject, (Chunk)chunk));
        }), runnable -> this.C.a(ChunkTaskQueueSorter.a(playerchunk, runnable)));
        return completablefuture1;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> c(PlayerChunk playerchunk) {
        return this.a(playerchunk, 1, ChunkStatus::a).thenApplyAsync(either -> either.mapLeft(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            return chunk;
        }), runnable -> this.C.a(ChunkTaskQueueSorter.a(playerchunk, runnable)));
    }

    public int h() {
        return this.G.get();
    }

    private boolean e(PlayerChunk playerchunk) {
        if (!playerchunk.m()) {
            return false;
        }
        IChunkAccess ichunkaccess = playerchunk.h().getNow(null);
        if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
            return false;
        }
        long i2 = ichunkaccess.f().a();
        long j2 = this.M.getOrDefault(i2, -1L);
        long k2 = System.currentTimeMillis();
        if (k2 < j2) {
            return false;
        }
        boolean flag = this.a(ichunkaccess);
        playerchunk.n();
        if (flag) {
            this.M.put(i2, k2 + 10000L);
        }
        return flag;
    }

    public boolean a(IChunkAccess ichunkaccess) {
        ChunkStatus chunkstatus;
        ChunkCoordIntPair chunkcoordintpair;
        block5: {
            block6: {
                this.x.a(ichunkaccess.f());
                if (!ichunkaccess.i()) {
                    return false;
                }
                ichunkaccess.a(false);
                chunkcoordintpair = ichunkaccess.f();
                try {
                    chunkstatus = ichunkaccess.j();
                    if (chunkstatus.g() == ChunkStatus.Type.b) break block5;
                    if (!this.i(chunkcoordintpair)) break block6;
                    return false;
                }
                catch (Exception exception) {
                    h.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.e, chunkcoordintpair.f, exception});
                    return false;
                }
            }
            if (chunkstatus != ChunkStatus.c || !ichunkaccess.g().values().stream().noneMatch(StructureStart::b)) break block5;
            return false;
        }
        this.q.ad().d("chunkSave");
        NBTTagCompound nbttagcompound = ChunkRegionLoader.a(this.q, ichunkaccess);
        this.a(chunkcoordintpair, nbttagcompound);
        this.a(chunkcoordintpair, chunkstatus.g());
        return true;
    }

    private boolean i(ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.L.get(chunkcoordintpair.a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.j(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.h(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            h.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.h(chunkcoordintpair);
            return false;
        }
        ChunkStatus.Type chunkstatus_type = ChunkRegionLoader.a(nbttagcompound);
        return this.a(chunkcoordintpair, chunkstatus_type) == 1;
    }

    protected void a(int i2) {
        int j2 = MathHelper.a(i2, 2, 32);
        if (j2 != this.O) {
            int k2 = this.O;
            this.O = j2;
            this.F.a(this.O);
            for (PlayerChunk playerchunk : this.m.values()) {
                ChunkCoordIntPair chunkcoordintpair = playerchunk.j();
                MutableObject mutableobject = new MutableObject();
                this.a(chunkcoordintpair, false).forEach(entityplayer -> {
                    SectionPosition sectionposition = entityplayer.R();
                    boolean flag = PlayerChunkMap.a(chunkCoordIntPair.e, chunkCoordIntPair.f, sectionposition.a(), sectionposition.c(), k2);
                    boolean flag1 = PlayerChunkMap.a(chunkCoordIntPair.e, chunkCoordIntPair.f, sectionposition.a(), sectionposition.c(), this.O);
                    this.a((EntityPlayer)entityplayer, chunkcoordintpair, (MutableObject<ClientboundLevelChunkWithLightPacket>)mutableobject, flag, flag1);
                });
            }
        }
    }

    protected void a(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, MutableObject<ClientboundLevelChunkWithLightPacket> mutableobject, boolean flag, boolean flag1) {
        if (entityplayer.dI() == this.q) {
            PlayerChunk playerchunk;
            if (flag1 && !flag && (playerchunk = this.b(chunkcoordintpair.a())) != null) {
                Chunk chunk = playerchunk.d();
                if (chunk != null) {
                    this.a(entityplayer, mutableobject, chunk);
                }
                PacketDebug.a(this.q, chunkcoordintpair);
            }
            if (!flag1 && flag) {
                entityplayer.a(chunkcoordintpair);
            }
        }
    }

    public int i() {
        return this.n.size();
    }

    public ChunkMapDistance j() {
        return this.F;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable((Iterable)this.n.values());
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        TickingTracker tickingtracker = this.F.d();
        for (Long2ObjectMap.Entry entry : this.n.long2ObjectEntrySet()) {
            long i2 = entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.g());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.e, chunkcoordintpair.f, playerchunk.k(), optional.isPresent(), optional.map(IChunkAccess::j).orElse(null), optional1.map(Chunk::D).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.F.e(i2), this.c(chunkcoordintpair), optional1.map(chunk -> chunk.G().size()).orElse(0), tickingtracker.d(i2), tickingtracker.c(i2), optional1.map(chunk -> chunk.o().a()).orElse(0), optional1.map(chunk -> chunk.p().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> completablefuture) {
        try {
            Either either = completablefuture.getNow(null);
            return either != null ? (String)either.map(chunk -> "done", playerchunk_failure -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> j(ChunkCoordIntPair chunkcoordintpair) {
        return this.e(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkcoordintpair)), (Executor)SystemUtils.f());
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.q.getTypeKey(), this.w, nbttagcompound, this.t.b(), chunkcoordintpair, this.q);
    }

    boolean c(ChunkCoordIntPair chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        EntityPlayer entityplayer;
        int chunkRange = this.q.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.q.spigotConfig.viewDistance ? (int)this.q.spigotConfig.viewDistance : chunkRange;
        chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = reducedRange ? Math.pow(chunkRange << 4, 2.0) : 16384.0;
        long i2 = chunkcoordintpair.a();
        if (!this.F.f(i2)) {
            return false;
        }
        Iterator<EntityPlayer> iterator = this.J.a(i2).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer = iterator.next(), chunkcoordintpair, blockRange));
        return true;
    }

    public List<EntityPlayer> d(ChunkCoordIntPair chunkcoordintpair) {
        long i2 = chunkcoordintpair.a();
        if (!this.F.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.J.a(i2)) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.G_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean b(EntityPlayer entityplayer) {
        return entityplayer.G_() && !this.q.X().b(GameRules.q);
    }

    void a(EntityPlayer entityplayer, boolean flag) {
        boolean flag1 = this.b(entityplayer);
        boolean flag2 = this.J.c(entityplayer);
        int i2 = SectionPosition.a(entityplayer.dm());
        int j2 = SectionPosition.a(entityplayer.ds());
        if (flag) {
            this.J.a(ChunkCoordIntPair.c(i2, j2), entityplayer, flag1);
            this.c(entityplayer);
            if (!flag1) {
                this.F.a(SectionPosition.a(entityplayer), entityplayer);
            }
        } else {
            SectionPosition sectionposition = entityplayer.R();
            this.J.a(sectionposition.r().a(), entityplayer);
            if (!flag2) {
                this.F.b(sectionposition, entityplayer);
            }
        }
        int k2 = i2 - this.O - 1;
        while (k2 <= i2 + this.O + 1) {
            int l2 = j2 - this.O - 1;
            while (l2 <= j2 + this.O + 1) {
                if (PlayerChunkMap.a(k2, l2, i2, j2, this.O)) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(k2, l2);
                    this.a(entityplayer, chunkcoordintpair, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), !flag, flag);
                }
                ++l2;
            }
            ++k2;
        }
    }

    private SectionPosition c(EntityPlayer entityplayer) {
        SectionPosition sectionposition = SectionPosition.a(entityplayer);
        entityplayer.a(sectionposition);
        entityplayer.c.a(new PacketPlayOutViewCentre(sectionposition.a(), sectionposition.c()));
        return sectionposition;
    }

    public void a(EntityPlayer entityplayer) {
        boolean flag2;
        for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
            if (playerchunkmap_entitytracker.c == entityplayer) {
                playerchunkmap_entitytracker.a(this.q.v());
                continue;
            }
            playerchunkmap_entitytracker.b(entityplayer);
        }
        int i2 = SectionPosition.a(entityplayer.dm());
        int j2 = SectionPosition.a(entityplayer.ds());
        SectionPosition sectionposition = entityplayer.R();
        SectionPosition sectionposition1 = SectionPosition.a(entityplayer);
        long k2 = sectionposition.r().a();
        long l2 = sectionposition1.r().a();
        boolean flag = this.J.d(entityplayer);
        boolean flag1 = this.b(entityplayer);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.c(entityplayer);
            if (!flag) {
                this.F.b(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.F.a(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.J.a(entityplayer);
            }
            if (flag && !flag1) {
                this.J.b(entityplayer);
            }
            if (k2 != l2) {
                this.J.a(k2, l2, entityplayer);
            }
        }
        int i1 = sectionposition.a();
        int j1 = sectionposition.c();
        int k1 = this.O + 1;
        if (Math.abs(i1 - i2) <= k1 * 2 && Math.abs(j1 - j2) <= k1 * 2) {
            int l1 = Math.min(i2, i1) - k1;
            int i22 = Math.min(j2, j1) - k1;
            int j22 = Math.max(i2, i1) + k1;
            int k22 = Math.max(j2, j1) + k1;
            int l22 = l1;
            while (l22 <= j22) {
                int i3 = i22;
                while (i3 <= k22) {
                    boolean flag3 = PlayerChunkMap.a(l22, i3, i1, j1, this.O);
                    boolean flag4 = PlayerChunkMap.a(l22, i3, i2, j2, this.O);
                    this.a(entityplayer, new ChunkCoordIntPair(l22, i3), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), flag3, flag4);
                    ++i3;
                }
                ++l22;
            }
        } else {
            boolean flag6;
            boolean flag5;
            int i23;
            int l1 = i1 - k1;
            while (l1 <= i1 + k1) {
                i23 = j1 - k1;
                while (i23 <= j1 + k1) {
                    if (PlayerChunkMap.a(l1, i23, i1, j1, this.O)) {
                        flag5 = true;
                        flag6 = false;
                        this.a(entityplayer, new ChunkCoordIntPair(l1, i23), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false);
                    }
                    ++i23;
                }
                ++l1;
            }
            l1 = i2 - k1;
            while (l1 <= i2 + k1) {
                i23 = j2 - k1;
                while (i23 <= j2 + k1) {
                    if (PlayerChunkMap.a(l1, i23, i2, j2, this.O)) {
                        flag5 = false;
                        flag6 = true;
                        this.a(entityplayer, new ChunkCoordIntPair(l1, i23), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                    }
                    ++i23;
                }
                ++l1;
            }
        }
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Set<EntityPlayer> set = this.J.a(chunkcoordintpair.a());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            SectionPosition sectionposition = entityplayer.R();
            if ((!flag || !PlayerChunkMap.b(chunkcoordintpair.e, chunkcoordintpair.f, sectionposition.a(), sectionposition.c(), this.O)) && (flag || !PlayerChunkMap.a(chunkcoordintpair.e, chunkcoordintpair.f, sectionposition.a(), sectionposition.c(), this.O))) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    protected void a(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ae();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int j2 = entitytypes.p();
                if (this.K.containsKey(entity.af())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.K.put(entity.af(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.a(this.q.v());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.K.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.K.remove(entity.af())) != null) {
            playerchunkmap_entitytracker1.a();
        }
    }

    protected void l() {
        ArrayList list = Lists.newArrayList();
        List<EntityPlayer> list1 = this.q.v();
        for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
            boolean flag;
            SectionPosition sectionposition = playerchunkmap_entitytracker.e;
            SectionPosition sectionposition1 = SectionPosition.a(playerchunkmap_entitytracker.c);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.a(list1);
                Entity entity = playerchunkmap_entitytracker.c;
                if (entity instanceof EntityPlayer) {
                    list.add((EntityPlayer)entity);
                }
                playerchunkmap_entitytracker.e = sectionposition1;
            }
            if (!flag && !this.F.c(sectionposition1.r().a())) continue;
            playerchunkmap_entitytracker.b.a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(list);
            }
        }
    }

    public void a(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.af());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.af());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public void a(List<IChunkAccess> list) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : list) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.q.d(chunkcoordintpair.e, chunkcoordintpair.f);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.c.a(ClientboundChunksBiomesPacket.a(list1)));
    }

    private void a(EntityPlayer entityplayer, MutableObject<ClientboundLevelChunkWithLightPacket> mutableobject, Chunk chunk) {
        if (mutableobject.getValue() == null) {
            mutableobject.setValue((Object)new ClientboundLevelChunkWithLightPacket(chunk, this.r, null, null));
        }
        entityplayer.a(chunk.f(), (Packet)mutableobject.getValue());
        PacketDebug.a(this.q, chunk.f());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
            Entity entity = playerchunkmap_entitytracker.c;
            if (entity == entityplayer || !entity.dk().equals(chunk.f())) continue;
            playerchunkmap_entitytracker.b(entityplayer);
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).fP() != null) {
                list.add(entity);
            }
            if (entity.cN().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                entityplayer.c.a(new PacketPlayOutAttachEntity(entity1, ((EntityInsentient)entity1).fP()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity1 : list1) {
                entityplayer.c.a(new PacketPlayOutMount(entity1));
            }
        }
    }

    protected VillagePlace m() {
        return this.x;
    }

    public String n() {
        return this.I;
    }

    void a(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.E.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class EntityTracker {
        final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = Sets.newIdentityHashSet();

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.q, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.af() == this.c.af() : false;
        }

        public int hashCode() {
            return this.c.af();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.a(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).c.a(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.f());
            }
        }

        public void a(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(entityplayer.c)) {
                this.b.a(entityplayer);
            }
        }

        public void b(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker update");
            if (entityplayer != this.c) {
                boolean flag;
                Vec3D vec3d = entityplayer.dg().d(this.c.dg());
                double d1 = vec3d.c * vec3d.c + vec3d.e * vec3d.e;
                double d0 = Math.min(this.b(), PlayerChunkMap.this.O * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(entityplayer);
                if (!entityplayer.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(entityplayer.c)) {
                        this.b.b(entityplayer);
                    }
                } else if (this.f.remove(entityplayer.c)) {
                    this.b.a(entityplayer);
                }
            }
        }

        private int a(int i2) {
            return PlayerChunkMap.this.q.n().b(i2);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.cR()) {
                int j2 = entity.ae().o() * 16;
                if (j2 <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> list) {
            for (EntityPlayer entityplayer : list) {
                this.b(entityplayer);
            }
        }
    }

    private class a
    extends ChunkMapDistance {
        protected a(Executor executor, Executor executor1) {
            super(executor, executor1);
        }

        @Override
        protected boolean a(long i2) {
            return PlayerChunkMap.this.y.contains(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk b(long i2) {
            return PlayerChunkMap.this.a(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
            return PlayerChunkMap.this.a(i2, j2, playerchunk, k2);
        }
    }
}

