/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger a = LogUtils.getLogger();
    protected WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode b = EnumGamemode.e;
    @Nullable
    private EnumGamemode e;
    private boolean f;
    private int g;
    private BlockPosition h = BlockPosition.b;
    private int i;
    private boolean j;
    private BlockPosition k = BlockPosition.b;
    private int l;
    private int m = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer entityplayer) {
        this.d = entityplayer;
        this.c = entityplayer.x();
    }

    public boolean a(EnumGamemode enumgamemode) {
        if (enumgamemode == this.b) {
            return false;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)enumgamemode.a()));
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.a(enumgamemode, this.e);
        this.d.w();
        this.d.d.ac().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.e();
        return true;
    }

    protected void a(EnumGamemode enumgamemode, @Nullable EnumGamemode enumgamemode1) {
        this.e = enumgamemode1;
        this.b = enumgamemode;
        enumgamemode.a(this.d.fO());
    }

    public EnumGamemode b() {
        return this.b;
    }

    @Nullable
    public EnumGamemode c() {
        return this.e;
    }

    public boolean d() {
        return this.b.h();
    }

    public boolean e() {
        return this.b.g();
    }

    public void a() {
        this.i = MinecraftServer.currentTick;
        if (this.j) {
            IBlockData iblockdata = this.c.a_(this.k);
            if (iblockdata.i()) {
                this.j = false;
            } else {
                float f2 = this.a(iblockdata, this.k, this.l);
                if (f2 >= 1.0f) {
                    this.j = false;
                    this.a(this.k);
                }
            }
        } else if (this.f) {
            IBlockData iblockdata = this.c.a_(this.h);
            if (iblockdata.i()) {
                this.c.a(this.d.af(), this.h, -1);
                this.m = -1;
                this.f = false;
            } else {
                this.a(iblockdata, this.h, this.g);
            }
        }
    }

    private float a(IBlockData iblockdata, BlockPosition blockposition, int i2) {
        int j2 = this.i - i2;
        float f2 = iblockdata.a(this.d, this.d.dI(), blockposition) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.m) {
            this.c.a(this.d.af(), blockposition, k2);
            this.m = k2;
        }
        return f2;
    }

    private void a(BlockPosition blockposition, boolean flag, int i2, String s2) {
    }

    public void a(BlockPosition blockposition, PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype, EnumDirection enumdirection, int i2, int j2) {
        if (this.d.bm().g(Vec3D.b(blockposition)) > PlayerConnection.a) {
            this.a(blockposition, false, j2, "too far");
        } else if (blockposition.v() >= i2) {
            this.d.c.a(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, j2, "too high");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((EntityHuman)this.d, blockposition)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.fN().f(), EnumHand.a);
                this.d.c.a(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "may not interact");
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.c.a(tileentity.h());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.fN().f(), EnumHand.a);
            if (event.isCancelled()) {
                this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.c.a(tileentity.h());
                }
                return;
            }
            if (this.e()) {
                this.a(blockposition, j2, "creative destroy");
                return;
            }
            if (this.d.eO().a(Items.uD) && ((ItemDebugStick)Items.uD).a(this.d, this.c.a_(blockposition), this.c, blockposition, false, this.d.eO())) {
                this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (this.d.a(this.c, blockposition, this.b)) {
                this.d.c.a(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "block action restricted");
                return;
            }
            this.g = this.i;
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(blockposition);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                IBlockData data = this.c.a_(blockposition);
                if (data.b() instanceof BlockDoor) {
                    boolean bottom = data.c(BlockDoor.e) == BlockPropertyDoubleBlockHalf.b;
                    this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                    this.d.c.a(new PacketPlayOutBlockChange(this.c, bottom ? blockposition.c() : blockposition.d()));
                } else if (data.b() instanceof BlockTrapdoor) {
                    this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                }
            } else if (!iblockdata.i()) {
                iblockdata.a((World)this.c, blockposition, this.d);
                f2 = iblockdata.a(this.d, this.d.dI(), blockposition);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, blockposition, this.d.fN().f(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.i() && f2 >= 1.0f) {
                this.a(blockposition, j2, "insta mine");
            } else {
                if (this.f) {
                    this.d.c.a(new PacketPlayOutBlockChange(this.h, this.c.a_(this.h)));
                    this.a(blockposition, false, j2, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.f = true;
                this.h = blockposition.i();
                int k2 = (int)(f2 * 10.0f);
                this.c.a(this.d.af(), blockposition, k2);
                this.a(blockposition, true, j2, "actual start of destroying");
                this.m = k2;
            }
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (blockposition.equals(this.h)) {
                int l2 = this.i - this.g;
                IBlockData iblockdata = this.c.a_(blockposition);
                if (!iblockdata.i()) {
                    float f1 = iblockdata.a(this.d, this.d.dI(), blockposition) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.f = false;
                        this.c.a(this.d.af(), blockposition, -1);
                        this.a(blockposition, j2, "destroyed");
                        return;
                    }
                    if (!this.j) {
                        this.f = false;
                        this.j = true;
                        this.k = blockposition;
                        this.l = this.g;
                    }
                }
            }
            this.a(blockposition, true, j2, "stopped destroying");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.f = false;
            if (!Objects.equals(this.h, blockposition)) {
                a.debug("Mismatch in destroy block pos: {} {}", (Object)this.h, (Object)blockposition);
                this.c.a(this.d.af(), this.h, -1);
                this.a(blockposition, true, j2, "aborted mismatched destroying");
            }
            this.c.a(this.d.af(), blockposition, -1);
            this.a(blockposition, true, j2, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, blockposition, this.d.fN().f());
        }
    }

    public void a(BlockPosition blockposition, int i2, String s2) {
        if (this.a(blockposition)) {
            this.a(blockposition, true, i2, s2);
        } else {
            this.d.c.a(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, i2, s2);
        }
    }

    public boolean a(BlockPosition blockposition) {
        IBlockData iblockdata = this.c.a_(blockposition);
        CraftBlock bblock = CraftBlock.at(this.c, blockposition);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.d.eO().d().a(iblockdata, (World)this.c, blockposition, (EntityHuman)this.d);
            if (this.c.c_(blockposition) == null && !isSwordNoBreak) {
                PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(blockposition, Blocks.a.n());
                this.d.c.a(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(blockposition);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.c(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.e(nmsBlock.n())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, blockposition, itemstack, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition));
                EnumDirection[] enumDirectionArray = EnumDirection.values();
                int n2 = enumDirectionArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    EnumDirection dir = enumDirectionArray[n3];
                    this.d.c.a(new PacketPlayOutBlockChange(this.c, blockposition.a(dir)));
                    ++n3;
                }
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.c.a(tileentity.h());
                }
                return false;
            }
        }
        if ((iblockdata = this.c.a_(blockposition)).i()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof GameMasterBlock && !this.d.gk()) {
            this.c.a(blockposition, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a(this.c, blockposition, this.b)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList();
        block.a((World)this.c, blockposition, iblockdata, (EntityHuman)this.d);
        boolean flag = this.c.a(blockposition, false);
        if (flag) {
            block.a((GeneratorAccess)this.c, blockposition, iblockdata);
        }
        if (!this.e()) {
            ItemStack itemstack = this.d.eO();
            ItemStack itemstack1 = itemstack.p();
            boolean flag1 = this.d.e(iblockdata);
            itemstack.a((World)this.c, iblockdata, blockposition, this.d);
            if (flag && flag1 && event.isDropItems()) {
                block.a(this.c, this.d, blockposition, iblockdata, tileentity, itemstack1);
            }
        }
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, this.c.captureDrops);
        }
        this.c.captureDrops = null;
        if (flag && event != null) {
            iblockdata.b().a(this.c, blockposition, event.getExpToDrop());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand) {
        if (this.b == EnumGamemode.d) {
            return EnumInteractionResult.d;
        }
        if (entityplayer.gi().a(itemstack.d())) {
            return EnumInteractionResult.d;
        }
        int i2 = itemstack.L();
        int j2 = itemstack.k();
        InteractionResultWrapper<ItemStack> interactionresultwrapper = itemstack.a(world, (EntityHuman)entityplayer, enumhand);
        ItemStack itemstack1 = interactionresultwrapper.b();
        if (itemstack1 == itemstack && itemstack1.L() == i2 && itemstack1.r() <= 0 && itemstack1.k() == j2) {
            return interactionresultwrapper.a();
        }
        if (interactionresultwrapper.a() == EnumInteractionResult.e && itemstack1.r() > 0 && !entityplayer.fi()) {
            return interactionresultwrapper.a();
        }
        if (itemstack != itemstack1) {
            entityplayer.a(enumhand, itemstack1);
        }
        if (this.e() && itemstack1 != ItemStack.b) {
            itemstack1.f(i2);
            if (itemstack1.i() && itemstack1.k() != j2) {
                itemstack1.b(j2);
            }
        }
        if (itemstack1.b()) {
            entityplayer.a(enumhand, ItemStack.b);
        }
        if (!entityplayer.fi()) {
            entityplayer.bQ.b();
        }
        return interactionresultwrapper.a();
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.a();
        IBlockData iblockdata = world.a_(blockposition);
        EnumInteractionResult enuminteractionresult = EnumInteractionResult.d;
        boolean cancelledBlock = false;
        if (!iblockdata.b().a(world.G())) {
            return EnumInteractionResult.e;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (entityplayer.gi().a(itemstack.d())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(entityplayer, Action.RIGHT_CLICK_BLOCK, blockposition, movingobjectpositionblock.b(), itemstack, cancelledBlock, enumhand);
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.i();
        this.interactHand = enumhand;
        this.interactItemStack = itemstack.p();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.b() instanceof BlockDoor) {
                boolean bottom = iblockdata.c(BlockDoor.e) == BlockPropertyDoubleBlockHalf.b;
                entityplayer.c.a(new PacketPlayOutBlockChange(world, bottom ? blockposition.c() : blockposition.d()));
            } else if (iblockdata.b() instanceof BlockCake) {
                entityplayer.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.d() instanceof ItemBisected) {
                entityplayer.c.a(new PacketPlayOutBlockChange(world, blockposition.a(movingobjectpositionblock.b()).c()));
                entityplayer.c.a(new PacketPlayOutBlockChange(world, blockposition.c()));
            }
            entityplayer.getBukkitEntity().updateInventory();
            enuminteractionresult = event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.d;
        } else {
            if (this.b == EnumGamemode.d) {
                ITileInventory itileinventory = iblockdata.b(world, blockposition);
                if (itileinventory != null) {
                    entityplayer.a(itileinventory);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.d;
            }
            boolean flag = !entityplayer.eO().b() || !entityplayer.eP().b();
            boolean flag1 = entityplayer.fD() && flag;
            ItemStack itemstack1 = itemstack.p();
            if (!flag1 && (enuminteractionresult = iblockdata.a(world, entityplayer, enumhand, movingobjectpositionblock)).a()) {
                CriterionTriggers.M.a(entityplayer, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (!itemstack.b() && enuminteractionresult != EnumInteractionResult.a && !this.interactResult) {
                EnumInteractionResult enuminteractionresult1;
                ItemActionContext itemactioncontext = new ItemActionContext(entityplayer, enumhand, movingobjectpositionblock);
                if (this.e()) {
                    int i2 = itemstack.L();
                    enuminteractionresult1 = itemstack.useOn(itemactioncontext, enumhand);
                    itemstack.f(i2);
                } else {
                    enuminteractionresult1 = itemstack.useOn(itemactioncontext, enumhand);
                }
                if (enuminteractionresult1.a()) {
                    CriterionTriggers.M.a(entityplayer, blockposition, itemstack1);
                }
                return enuminteractionresult1;
            }
        }
        return enuminteractionresult;
    }

    public void a(WorldServer worldserver) {
        this.c = worldserver;
    }
}

