/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final List<IChunkAccess> b;
    private final IChunkAccess c;
    private final int d;
    private final WorldServer e;
    private final long f;
    private final WorldData g;
    private final RandomSource h;
    private final DimensionManager i;
    private final TickListWorldGen<Block> j = new TickListWorldGen(blockposition -> this.x((BlockPosition)blockposition).o());
    private final TickListWorldGen<FluidType> k = new TickListWorldGen(blockposition -> this.x((BlockPosition)blockposition).p());
    private final BiomeManager l;
    private final ChunkCoordIntPair m;
    private final ChunkCoordIntPair n;
    private final StructureManager o;
    private final ChunkStatus p;
    private final int q;
    @Nullable
    private Supplier<String> r;
    private final AtomicLong s = new AtomicLong();
    private static final MinecraftKey t = new MinecraftKey("worldgen_region_random");

    public RegionLimitedWorldAccess(WorldServer worldserver, List<IChunkAccess> list, ChunkStatus chunkstatus, int i2) {
        this.p = chunkstatus;
        this.q = i2;
        int j2 = MathHelper.a(Math.sqrt(list.size()));
        if (j2 * j2 != list.size()) {
            throw SystemUtils.b(new IllegalStateException("Cache size is not a square."));
        }
        this.b = list;
        this.c = list.get(list.size() / 2);
        this.d = j2;
        this.e = worldserver;
        this.f = worldserver.A();
        this.g = worldserver.u_();
        this.h = worldserver.k().i().a(t).a(this.c.f().l());
        this.i = worldserver.x_();
        this.l = new BiomeManager(this, BiomeManager.a(this.f));
        this.m = list.get(0).f();
        this.n = list.get(list.size() - 1).f();
        this.o = worldserver.a().a(this);
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.e.k().a.a(chunkcoordintpair, i2);
    }

    public ChunkCoordIntPair a() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> supplier) {
        this.r = supplier;
    }

    @Override
    public IChunkAccess a(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess;
        if (this.b(i2, j2)) {
            int k2 = i2 - this.m.e;
            int l2 = j2 - this.m.f;
            ichunkaccess = this.b.get(k2 + l2 * this.d);
            if (ichunkaccess.j().b(chunkstatus)) {
                return ichunkaccess;
            }
        } else {
            ichunkaccess = null;
        }
        if (!flag) {
            return null;
        }
        a.error("Requested chunk : {} {}", (Object)i2, (Object)j2);
        a.error("Region bounds : {} {} | {} {}", new Object[]{this.m.e, this.m.f, this.n.e, this.n.f});
        if (ichunkaccess != null) {
            throw SystemUtils.b(new RuntimeException(String.format(Locale.ROOT, "Chunk is not of correct status. Expecting %s, got %s | %s %s", chunkstatus, ichunkaccess.j(), i2, j2)));
        }
        throw SystemUtils.b(new RuntimeException(String.format(Locale.ROOT, "We are asking a region for a chunk out of bound | %s %s", i2, j2)));
    }

    @Override
    public boolean b(int i2, int j2) {
        return i2 >= this.m.e && i2 <= this.n.e && j2 >= this.m.f && j2 <= this.n.f;
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        return this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w())).a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        return this.x(blockposition).b_(blockposition);
    }

    @Override
    @Nullable
    public EntityHuman a(double d0, double d1, double d2, double d3, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int v_() {
        return 0;
    }

    @Override
    public BiomeManager z_() {
        return this.l;
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.e.a(i2, j2, k2);
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine s_() {
        return this.e.s_();
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.i()) {
            return false;
        }
        return this.a(blockposition, Blocks.a.n(), 3, i2);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        IChunkAccess ichunkaccess = this.x(blockposition);
        TileEntity tileentity = ichunkaccess.c_(blockposition);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunkaccess.f(blockposition);
        IBlockData iblockdata = ichunkaccess.a_(blockposition);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.l("id"))) {
                if (!iblockdata.t()) {
                    return null;
                }
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
            } else {
                tileentity = TileEntity.a(blockposition, iblockdata, nbttagcompound);
            }
            if (tileentity != null) {
                ichunkaccess.a(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.t()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)blockposition);
        }
        return null;
    }

    @Override
    public boolean f_(BlockPosition blockposition) {
        int i2 = SectionPosition.a(blockposition.u());
        int j2 = SectionPosition.a(blockposition.w());
        ChunkCoordIntPair chunkcoordintpair = this.a();
        int k2 = Math.abs(chunkcoordintpair.e - i2);
        int l2 = Math.abs(chunkcoordintpair.f - j2);
        if (k2 <= this.q && l2 <= this.q) {
            if (this.c.y()) {
                LevelHeightAccessor levelheightaccessor = this.c.z();
                if (blockposition.v() < levelheightaccessor.C_() || blockposition.v() >= levelheightaccessor.aj()) {
                    return false;
                }
            }
            return true;
        }
        SystemUtils.a("Detected setBlock in a far chunk [" + i2 + ", " + j2 + "], pos: " + blockposition + ", status: " + this.p + (this.r == null ? "" : ", currently generating: " + this.r.get()));
        return false;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        if (!this.f_(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.x(blockposition);
        IBlockData iblockdata1 = ichunkaccess.a(blockposition, iblockdata, false);
        if (iblockdata1 != null) {
            this.e.a(blockposition, iblockdata1, iblockdata);
        }
        if (iblockdata.t()) {
            if (ichunkaccess.j().g() == ChunkStatus.Type.b) {
                TileEntity tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
                if (tileentity != null) {
                    ichunkaccess.a(tileentity);
                } else {
                    ichunkaccess.d(blockposition);
                }
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.a("x", blockposition.u());
                nbttagcompound.a("y", blockposition.v());
                nbttagcompound.a("z", blockposition.w());
                nbttagcompound.a("id", "DUMMY");
                ichunkaccess.a(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.t()) {
            ichunkaccess.d(blockposition);
        }
        if (iblockdata.q(this, blockposition)) {
            this.f(blockposition);
        }
        return true;
    }

    private void f(BlockPosition blockposition) {
        this.x(blockposition).e(blockposition);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i2 = SectionPosition.a(entity.dm());
        int j2 = SectionPosition.a(entity.ds());
        this.a(i2, j2).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        return this.a(blockposition, Blocks.a.n(), 3);
    }

    @Override
    public WorldBorder w_() {
        return this.e.w_();
    }

    @Override
    public boolean r_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer C() {
        return this.e;
    }

    @Override
    public IRegistryCustom B_() {
        return this.e.B_();
    }

    @Override
    public FeatureFlagSet G() {
        return this.e.G();
    }

    @Override
    public WorldData u_() {
        return this.g;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        if (!this.b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.e.ai(), this.e.W(), 0L, this.e.an());
    }

    @Override
    @Nullable
    public MinecraftServer n() {
        return this.e.n();
    }

    @Override
    public IChunkProvider J() {
        return this.e.k();
    }

    @Override
    public long A() {
        return this.f;
    }

    @Override
    public LevelTickAccess<Block> L() {
        return this.j;
    }

    @Override
    public LevelTickAccess<FluidType> K() {
        return this.k;
    }

    @Override
    public int t_() {
        return this.e.t_();
    }

    @Override
    public RandomSource y_() {
        return this.h;
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        return this.a(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, int i2, BlockPosition blockposition, int j2) {
    }

    @Override
    public void a(GameEvent gameevent, Vec3D vec3d, GameEvent.a gameevent_a) {
    }

    @Override
    public DimensionManager x_() {
        return this.i;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> v() {
        return Collections.emptyList();
    }

    @Override
    public int C_() {
        return this.e.C_();
    }

    @Override
    public int D_() {
        return this.e.D_();
    }

    @Override
    public long A_() {
        return this.s.getAndIncrement();
    }
}

