/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_20_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_20_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R1.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider D = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger E = LogUtils.getLogger();
    private static final int F = 300;
    private static final int G = 65536;
    final List<EntityPlayer> H;
    private final ChunkProviderServer I;
    private final MinecraftServer J;
    public final WorldDataServer K;
    final EntityTickList L;
    public final PersistentEntitySectionManager<net.minecraft.world.entity.Entity> M;
    private final GameEventDispatcher N;
    public boolean e;
    private final SleepStatus O;
    private int P;
    private final PortalTravelAgent Q;
    private final TickListServer<Block> R;
    private final TickListServer<FluidType> S;
    final Set<EntityInsentient> T;
    volatile boolean U;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> V;
    private final List<BlockActionData> W;
    private boolean X;
    private final List<MobSpawner> Y;
    @Nullable
    private EnderDragonBattle Z;
    final Int2ObjectMap<EntityComplexPart> aa;
    private final StructureManager ab;
    private final StructureCheck ac;
    private final boolean ad;
    private final RandomSequences ae;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;

    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.I.a(x2, z2, false);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.aV(), worlddimension.a(), minecraftserver::aN, false, flag, i2, minecraftserver.bd(), gen, biomeProvider, env);
        this.pvpMode = minecraftserver.Y();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.H = Lists.newArrayList();
        this.L = new EntityTickList();
        this.R = new TickListServer(this::d, this.ae());
        this.S = new TickListServer(this::d, this.ae());
        this.T = new ObjectOpenHashSet();
        this.V = new ObjectLinkedOpenHashSet();
        this.W = new ArrayList<BlockActionData>(64);
        this.aa = new Int2ObjectOpenHashMap();
        this.ad = flag1;
        this.J = minecraftserver;
        this.Y = list;
        this.K = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.K.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.J.aV().d(Registries.ap));
            if (chunkgenerator instanceof ChunkGeneratorAbstract var22_20) {
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else {
                if (chunkgenerator instanceof ChunkProviderFlat var25_22) {
                    chunkgenerator = new ChunkProviderFlat(cpf.g(), worldChunkManager);
                }
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aS();
        DataFixer datafixer = minecraftserver.ay();
        EntityStorage entitypersistentstorage = new EntityStorage(this, convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, minecraftserver);
        this.M = new PersistentEntitySectionManager<net.minecraft.world.entity.Entity>(net.minecraft.world.entity.Entity.class, new a(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.aT();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<net.minecraft.world.entity.Entity> persistententitysectionmanager = this.M;
        Objects.requireNonNull(this.M);
        this.I = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, persistententitysectionmanager::a, () -> minecraftserver.D().s());
        this.I.h().b();
        this.Q = new PortalTravelAgent(this);
        this.Q();
        this.T();
        this.w_().a(minecraftserver.as());
        this.f = this.s().a((NBTTagCompound nbttagcompound) -> PersistentRaid.a(this, nbttagcompound), () -> new PersistentRaid(this), PersistentRaid.a(this.ab()));
        if (!minecraftserver.O()) {
            iworlddataserver.a(minecraftserver.o_());
        }
        long l2 = minecraftserver.aU().A().b();
        this.ac = new StructureCheck(this.I.m(), this.B_(), minecraftserver.aT(), resourcekey, chunkgenerator, this.I.i(), this, chunkgenerator.c(), l2, datafixer);
        this.ab = new StructureManager(this, this.K.A(), this.ac);
        this.Z = this.ac() == net.minecraft.world.level.World.j && this.ab().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.K.A().b(), this.K.E()) : null;
        this.O = new SleepStatus();
        this.N = new GameEventDispatcher(this);
        this.ae = Objects.requireNonNullElseGet(randomsequences, () -> this.s().a((NBTTagCompound nbttagcompound) -> RandomSequences.a(l2, nbttagcompound), () -> new RandomSequences(l2), "random_sequences"));
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderdragonbattle) {
        this.Z = enderdragonbattle;
    }

    public void a(int i2, int j2, boolean flag, boolean flag1) {
        this.K.a(i2);
        this.K.f(j2);
        this.K.e(j2);
        this.K.b(flag);
        this.K.a(flag1);
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.k().g().c().getNoiseBiome(i2, j2, k2, this.k().i().b());
    }

    public StructureManager a() {
        return this.ab;
    }

    public void a(BooleanSupplier booleansupplier) {
        long j2;
        GameProfilerFiller gameprofilerfiller = this.ad();
        this.X = true;
        gameprofilerfiller.a("world border");
        this.w_().s();
        gameprofilerfiller.b("weather");
        this.ar();
        int i2 = this.X().c(GameRules.L);
        if (this.O.a(i2) && this.O.a(i2, this.H)) {
            j2 = this.A.f() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.W());
            if (this.X().b(GameRules.k)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.W() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.ap();
            }
            if (this.X().b(GameRules.u) && this.Z()) {
                this.as();
            }
        }
        this.Q();
        this.b();
        gameprofilerfiller.b("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.af()) {
            j2 = this.V();
            gameprofilerfiller.a("blockTicks");
            this.R.a(j2, 65536, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.S.a(j2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.b("raid");
        this.f.a();
        gameprofilerfiller.b("chunkSource");
        this.k().a(booleansupplier, true);
        gameprofilerfiller.b("blockEvents");
        this.timings.doSounds.startTiming();
        this.au();
        this.timings.doSounds.stopTiming();
        this.X = false;
        gameprofilerfiller.c();
        boolean flag = true;
        if (flag) {
            this.g();
        }
        if (flag || this.P++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.Z != null) {
                gameprofilerfiller.a("dragonFight");
                this.Z.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.L.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dD()) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.du();
                    gameprofilerfiller.c();
                    if (this.I.a.j().c(entity.dk().a())) {
                        net.minecraft.world.entity.Entity entity1 = entity.cW();
                        if (entity1 != null) {
                            if (!entity1.dD() && entity1.u((net.minecraft.world.entity.Entity)entity)) {
                                return;
                            }
                            entity.Y();
                        }
                        gameprofilerfiller.a("tick");
                        this.a(this::a, entity);
                        gameprofilerfiller.c();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.P();
        }
        gameprofilerfiller.a("entityManagement");
        this.M.a();
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long i2) {
        return this.I.a.j().d(i2);
    }

    protected void b() {
        if (this.ad) {
            long i2 = this.A.e() + 1L;
            this.K.a(i2);
            this.K.u().a(this.J, i2);
            if (this.A.q().b(GameRules.k)) {
                this.b(this.A.f() + 1L);
            }
        }
    }

    public void b(long i2) {
        this.K.b(i2);
    }

    public void a(boolean flag, boolean flag1) {
        for (MobSpawner mobspawner : this.Y) {
            mobspawner.a(this, flag, flag1);
        }
    }

    private boolean i(net.minecraft.world.entity.Entity entity) {
        return !this.J.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.J.X() && entity instanceof NPC;
    }

    private void ap() {
        this.O.a();
        this.H.stream().filter(EntityLiving::fy).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int i2) {
        int i1;
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.Z();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.ad();
        gameprofilerfiller.a("thunder");
        if (flag && this.Y() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0 && this.q(blockposition = this.a(this.a(j2, 0, k2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.X().b(GameRules.e) && this.z.j() < (double)difficultydamagescaler.b() * 0.01 && !this.a_(blockposition.d()).a(Blocks.rr);
            if (flag1 && (entityhorseskeleton = EntityTypes.aK.a(this)) != null) {
                entityhorseskeleton.w(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.e(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.ai.a(this)) != null) {
                entitylightning.d(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (this.z.a(16) == 0) {
            blockposition = this.a(HeightMap.Type.e, this.a(j2, 0, k2, 15));
            BlockPosition blockposition1 = blockposition.d();
            BiomeBase biomebase = this.s(blockposition).a();
            if (biomebase.a(this, blockposition1)) {
                CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.dO.n(), null);
            }
            if (flag) {
                BiomeBase.Precipitation biomebase_precipitation;
                int l2 = this.X().c(GameRules.P);
                if (l2 > 0 && biomebase.b(this, blockposition)) {
                    IBlockData iblockdata = this.a_(blockposition);
                    if (iblockdata.a(Blocks.dN)) {
                        i1 = iblockdata.c(BlockSnow.b);
                        if (i1 < Math.min(l2, 8)) {
                            IBlockData iblockdata1 = (IBlockData)iblockdata.a(BlockSnow.b, i1 + 1);
                            Block.a(iblockdata, iblockdata1, this, blockposition);
                            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition, iblockdata1, null);
                        }
                    } else {
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition, Blocks.dN.n(), null);
                    }
                }
                if ((biomebase_precipitation = biomebase.a(blockposition1)) != BiomeBase.Precipitation.a) {
                    IBlockData iblockdata2 = this.a_(blockposition1);
                    iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition1, biomebase_precipitation);
                }
            }
        }
        gameprofilerfiller.b("tickBlocks");
        if (i2 > 0) {
            ChunkSection[] achunksection = chunk.d();
            int j1 = 0;
            while (j1 < achunksection.length) {
                ChunkSection chunksection = achunksection[j1];
                if (chunksection.d()) {
                    int l3 = chunk.g(j1);
                    int k1 = SectionPosition.c(l3);
                    i1 = 0;
                    while (i1 < i2) {
                        Fluid fluid;
                        BlockPosition blockposition2 = this.a(j2, k1, k2, 15);
                        gameprofilerfiller.a("randomTick");
                        IBlockData iblockdata3 = chunksection.a(blockposition2.u() - j2, blockposition2.v() - k1, blockposition2.w() - k2);
                        if (iblockdata3.v()) {
                            iblockdata3.b(this, blockposition2, this.z);
                        }
                        if ((fluid = iblockdata3.u()).f()) {
                            fluid.b(this, blockposition2, this.z);
                        }
                        gameprofilerfiller.c();
                        ++i1;
                    }
                }
                ++j1;
            }
        }
        gameprofilerfiller.c();
    }

    private Optional<BlockPosition> D(BlockPosition blockposition) {
        Optional<BlockPosition> optional = this.w().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, blockposition, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition a(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        Optional<BlockPosition> optional = this.D(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition1, new BlockPosition(blockposition1.u(), this.aj(), blockposition1.w())).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bs() && this.g(entityliving.di()));
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).di();
        }
        if (blockposition1.v() == this.C_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.X;
    }

    public boolean d() {
        return this.X().c(GameRules.L) <= 100;
    }

    private void aq() {
        if (this.d() && (!this.n().O() || this.n().p())) {
            int i2 = this.X().c(GameRules.L);
            IChatMutableComponent ichatmutablecomponent = this.O.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.O.b(), this.O.b(i2));
            for (EntityPlayer entityplayer : this.H) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void e() {
        if (!this.H.isEmpty() && this.O.a(this.H)) {
            this.aq();
        }
    }

    public ScoreboardServer f() {
        return this.J.aF();
    }

    private void ar() {
        boolean flag = this.Z();
        if (this.x_().g()) {
            if (this.X().b(GameRules.u)) {
                int i2 = this.K.h();
                int j2 = this.K.j();
                int k2 = this.K.l();
                boolean flag1 = this.A.i();
                boolean flag2 = this.A.k();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : D.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.K.e(j2);
                this.K.f(k2);
                this.K.a(i2);
                this.K.a(flag1);
                this.K.b(flag2);
            }
            this.x = this.y;
            this.y = this.A.i() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.k() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        int idx = 0;
        while (idx < this.H.size()) {
            if (this.H.get(idx).dI() == this) {
                this.H.get(idx).tickWeather();
            }
            ++idx;
        }
        if (flag != this.Z()) {
            idx = 0;
            while (idx < this.H.size()) {
                if (this.H.get(idx).dI() == this) {
                    this.H.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
                }
                ++idx;
            }
        }
        idx = 0;
        while (idx < this.H.size()) {
            if (this.H.get(idx).dI() == this) {
                this.H.get(idx).updateWeather(this.v, this.w, this.x, this.y);
            }
            ++idx;
        }
    }

    private void as() {
        this.K.b(false);
        if (!this.K.k()) {
            this.K.f(0);
        }
        this.K.a(false);
        if (!this.K.i()) {
            this.K.e(0);
        }
    }

    public void g() {
        this.P = 0;
    }

    private void a(BlockPosition blockposition, FluidType fluidtype) {
        Fluid fluid = this.b_(blockposition);
        if (fluid.b(fluidtype)) {
            fluid.a(this, blockposition);
        }
    }

    private void d(BlockPosition blockposition, Block block) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.a(block)) {
            iblockdata.a(this, blockposition, this.z);
        }
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.ag;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.bk();
        GameProfilerFiller gameprofilerfiller = this.ad();
        ++entity.ag;
        this.ad().a(() -> BuiltInRegistries.h.b(entity.ae()).toString());
        gameprofilerfiller.d("tickNonPassenger");
        entity.l();
        entity.postTick();
        this.ad().c();
        for (net.minecraft.world.entity.Entity entity1 : entity.cN()) {
            this.a(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void a(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity entity1) {
        if (!entity1.dD() && entity1.cW() == entity) {
            if (entity1 instanceof EntityHuman || this.L.c(entity1)) {
                entity1.bk();
                ++entity1.ag;
                GameProfilerFiller gameprofilerfiller = this.ad();
                gameprofilerfiller.a(() -> BuiltInRegistries.h.b(entity1.ae()).toString());
                gameprofilerfiller.d("tickPassenger");
                entity1.bv();
                entity1.postTick();
                gameprofilerfiller.c();
                for (net.minecraft.world.entity.Entity entity2 : entity1.cN()) {
                    this.a(entity1, entity2);
                }
            }
        } else {
            entity1.Y();
        }
    }

    @Override
    public boolean a(EntityHuman entityhuman, BlockPosition blockposition) {
        return !this.J.a(this, blockposition, entityhuman) && this.w_().a(blockposition);
    }

    public void a(@Nullable IProgressUpdate iprogressupdate, boolean flag, boolean flag1) {
        ChunkProviderServer chunkproviderserver = this.k();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.at();
            if (iprogressupdate != null) {
                iprogressupdate.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            chunkproviderserver.a(flag);
            if (flag) {
                this.M.c();
            } else {
                this.M.b();
            }
        }
        WorldServer worldserver1 = this;
        this.K.a(worldserver1.w_().t());
        this.K.a(this.J.aJ().c());
        this.convertable.a(this.J.aV(), this.K, this.J.ac().r());
    }

    private void at() {
        if (this.Z != null) {
            this.K.a(this.Z.b());
        }
        this.k().k().a();
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.E().a(entitytypetest, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> h() {
        return this.a(EntityTypes.C, EntityLiving::bs);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int i2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.H) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i2) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer i() {
        List<EntityPlayer> list = this.a(EntityLiving::bs);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.addEntity(entity, reason);
    }

    public void a(EntityPlayer entityplayer) {
        this.e(entityplayer);
    }

    public void b(EntityPlayer entityplayer) {
        this.e(entityplayer);
    }

    public void c(EntityPlayer entityplayer) {
        this.e(entityplayer);
    }

    public void d(EntityPlayer entityplayer) {
        this.e(entityplayer);
    }

    private void e(EntityPlayer entityplayer) {
        net.minecraft.world.entity.Entity entity = this.E().a(entityplayer.ct());
        if (entity != null) {
            E.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.ct().toString());
            entity.ac();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.M.a(entityplayer);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.dD()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.M.a(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.cP().map(net.minecraft.world.entity.Entity::ct);
        PersistentEntitySectionManager<net.minecraft.world.entity.Entity> persistententitysectionmanager = this.M;
        Objects.requireNonNull(this.M);
        if (stream.anyMatch(persistententitysectionmanager::a)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.G().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                h2.closeInventory();
            }
        }
        chunk.I();
        chunk.b(this);
    }

    public void a(EntityPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.a(entity_removalreason);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int i2, BlockPosition blockposition, int j2) {
        Iterator<EntityPlayer> iterator = this.J.ac().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(i2);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dI() != this || entityplayer.af() == i2) continue;
            double d0 = (double)blockposition.u() - entityplayer.dn();
            double d1 = (double)blockposition.v() - entityplayer.dp();
            double d2 = (double)blockposition.w() - entityplayer.dt();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.c.a(new PacketPlayOutBlockBreakAnimation(i2, blockposition, j2));
        }
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.J.ac().a(entityhuman, d0, d1, d2, holder.a().a(f2), this.ac(), new PacketPlayOutNamedSoundEffect(holder, soundcategory, d0, d1, d2, f2, f1, i2));
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.J.ac().a(entityhuman, entity.dn(), entity.dp(), entity.dt(), holder.a().a(f2), this.ac(), new PacketPlayOutEntitySound(holder, soundcategory, entity, f2, f1, i2));
    }

    @Override
    public void b(int i2, BlockPosition blockposition, int j2) {
        if (this.X().b(GameRules.S)) {
            this.J.ac().a(new PacketPlayOutWorldEvent(i2, blockposition, j2, true));
        } else {
            this.a(null, i2, blockposition, j2);
        }
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, int i2, BlockPosition blockposition, int j2) {
        this.J.ac().a(entityhuman, blockposition.u(), blockposition.v(), blockposition.w(), 64.0, this.ac(), new PacketPlayOutWorldEvent(i2, blockposition, j2, false));
    }

    public int j() {
        return this.x_().p();
    }

    @Override
    public void a(GameEvent gameevent, Vec3D vec3d, GameEvent.a gameevent_a) {
        this.N.a(gameevent, vec3d, gameevent_a);
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, int i2) {
        if (this.U) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.k().a(blockposition);
        VoxelShape voxelshape = iblockdata.k(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.k(this, blockposition);
        if (VoxelShapes.c(voxelshape, voxelshape1, OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.T.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(blockposition, iblockdata, iblockdata1, i2);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.J();
                if (!navigationabstract.b(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.U = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.U = false;
            }
        }
    }

    @Override
    public void a(BlockPosition blockposition, Block block) {
        this.s.a(blockposition, block, (EnumDirection)null);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
        this.s.a(blockposition, block, enumdirection);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
        this.s.a(blockposition, block, blockposition1);
    }

    @Override
    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        this.s.a(iblockdata, blockposition, block, blockposition1, flag);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte b0) {
        this.k().a(entity, new PacketPlayOutEntityStatus(entity, b0));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damagesource) {
        this.k().a(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    public ChunkProviderServer k() {
        return this.I;
    }

    @Override
    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a) {
        Explosion explosion = this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, false);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.b()) {
            explosion.g();
        }
        for (EntityPlayer entityplayer : this.H) {
            if (!(entityplayer.i(d0, d1, d2) < 4096.0)) continue;
            entityplayer.c.a(new PacketPlayOutExplosion(d0, d1, d2, f2, explosion.h(), explosion.d().get(entityplayer)));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.V.add((Object)new BlockActionData(blockposition, block, i2, j2));
    }

    private void au() {
        this.W.clear();
        while (!this.V.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.V.removeFirst();
            if (this.m(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.J.ac().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.ac(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.W.add(blockactiondata);
        }
        this.V.addAll(this.W);
    }

    private boolean a(BlockActionData blockactiondata) {
        IBlockData iblockdata = this.a_(blockactiondata.a());
        return iblockdata.a(blockactiondata.b()) ? iblockdata.a((net.minecraft.world.level.World)this, blockactiondata.a(), blockactiondata.c(), blockactiondata.d()) : false;
    }

    public TickListServer<Block> l() {
        return this.R;
    }

    public TickListServer<FluidType> m() {
        return this.S;
    }

    @Override
    @Nonnull
    public MinecraftServer n() {
        return this.J;
    }

    public PortalTravelAgent o() {
        return this.Q;
    }

    public StructureTemplateManager p() {
        return this.J.aT();
    }

    public <T extends ParticleParam> int a(T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticles(null, t0, d0, d1, d2, i2, d3, d4, d5, d6, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        int k2 = 0;
        while (k2 < this.H.size()) {
            EntityPlayer entityplayer = this.H.get(k2);
            if ((sender == null || entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity())) && this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) {
                ++j2;
            }
            ++k2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer entityplayer, T t0, boolean flag, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(t0, flag, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        return this.a(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean a(EntityPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.dI() != this) {
            return false;
        }
        BlockPosition blockposition = entityplayer.di();
        if (blockposition.a(new Vec3D(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.c.a(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int i2) {
        return this.E().a(i2);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int i2) {
        net.minecraft.world.entity.Entity entity = this.E().a(i2);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.aa.get(i2);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.E().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> tagkey, BlockPosition blockposition, int i2, boolean flag) {
        if (!this.K.A().c()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.B_().d(Registries.az).b(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.k().g().a(this, (HolderSet<Structure>)optional.get(), blockposition, i2, flag);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition blockposition, int i2, int j2, int k2) {
        return this.k().g().c().a(blockposition, i2, j2, k2, predicate, this.k().i().b(), this);
    }

    @Override
    public CraftingManager q() {
        return this.J.aE();
    }

    @Override
    public boolean r() {
        return this.e;
    }

    public WorldPersistentData s() {
        return this.k().k();
    }

    @Override
    @Nullable
    public WorldMap a(String s2) {
        return this.n().D().s().a((NBTTagCompound nbttagcompound) -> {
            WorldMap newMap = WorldMap.b(nbttagcompound);
            newMap.id = s2;
            MapInitializeEvent event = new MapInitializeEvent((MapView)newMap.mapView);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            return newMap;
        }, s2);
    }

    @Override
    public void a(String s2, WorldMap worldmap) {
        worldmap.id = s2;
        this.n().D().s().a(s2, worldmap);
    }

    @Override
    public int t() {
        return this.n().D().s().a(PersistentIdCounts::b, PersistentIdCounts::new, "idcounts").a();
    }

    public void a(BlockPosition blockposition, float f2) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(new BlockPosition(this.A.a(), 0, this.A.c()));
        this.A.a(blockposition, f2);
        this.k().b(TicketType.a, chunkcoordintpair, 11, Unit.a);
        this.k().a(TicketType.a, new ChunkCoordIntPair(blockposition), 11, Unit.a);
        this.n().ac().a(new PacketPlayOutSpawnPosition(blockposition, f2));
    }

    public LongSet u() {
        ForcedChunk forcedchunk = this.s().a(ForcedChunk::b, "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.a()) : LongSets.EMPTY_SET;
    }

    public boolean a(int i2, int j2, boolean flag) {
        boolean flag1;
        ForcedChunk forcedchunk = this.s().a(ForcedChunk::b, ForcedChunk::new, "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.a();
        if (flag) {
            flag1 = forcedchunk.a().add(k2);
            if (flag1) {
                this.d(i2, j2);
            }
        } else {
            flag1 = forcedchunk.a().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.k().a(chunkcoordintpair, flag);
        }
        return flag1;
    }

    public List<EntityPlayer> v() {
        return this.H;
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(iblockdata1))) {
            BlockPosition blockposition1 = blockposition.i();
            optional.ifPresent(holder -> this.n().execute(() -> {
                this.w().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.n().execute(() -> {
                this.w().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace w() {
        return this.k().l();
    }

    public boolean b(BlockPosition blockposition) {
        return this.a(blockposition, 1);
    }

    public boolean a(SectionPosition sectionposition) {
        return this.b(sectionposition.q());
    }

    public boolean a(BlockPosition blockposition, int i2) {
        return i2 > 6 ? false : this.b(SectionPosition.a(blockposition)) <= i2;
    }

    public int b(SectionPosition sectionposition) {
        return this.w().a(sectionposition);
    }

    public PersistentRaid x() {
        return this.f;
    }

    @Nullable
    public Raid c(BlockPosition blockposition) {
        return this.f.a(blockposition, 9216);
    }

    public boolean d(BlockPosition blockposition) {
        return this.c(blockposition) != null;
    }

    public void a(ReputationEvent reputationevent, net.minecraft.world.entity.Entity entity, ReputationHandler reputationhandler) {
        reputationhandler.a(reputationevent, entity);
    }

    public void a(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.k().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.k().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.M.e()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.l().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.m().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.k().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.e());
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.a(bufferedwriter2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter bufferedwriter3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.M.a(bufferedwriter3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.E().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> iterable) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : iterable) {
            IChatBaseComponent ichatbasecomponent = entity.ab();
            IChatBaseComponent ichatbasecomponent1 = entity.H_();
            csvwriter.a(entity.dn(), entity.dp(), entity.dt(), entity.ct(), BuiltInRegistries.h.b(entity.ae()), entity.bs(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox structureboundingbox) {
        this.V.removeIf(blockactiondata -> structureboundingbox.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition blockposition, Block block) {
        if (!this.af()) {
            if (this.populating) {
                return;
            }
            this.a(blockposition, block);
        }
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> y() {
        return this.E().a();
    }

    public String toString() {
        return "ServerLevel[" + this.K.g() + "]";
    }

    public boolean z() {
        return this.K.B();
    }

    @Override
    public long A() {
        return this.K.A().b();
    }

    @Nullable
    public EnderDragonBattle B() {
        return this.Z;
    }

    @Override
    public WorldServer C() {
        return this;
    }

    @VisibleForTesting
    public String D() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.H.size(), this.M.e(), WorldServer.a(this.M.d().a(), (T entity) -> BuiltInRegistries.h.b(entity.ae()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.l().a(), this.m().a(), this.F());
    }

    private static <T> String a(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s2 = function.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return String.valueOf(s1) + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void a(WorldServer worldserver) {
        WorldServer.makeObsidianPlatform(worldserver, null);
    }

    public static void makeObsidianPlatform(WorldServer worldserver, net.minecraft.world.entity.Entity entity) {
        BlockPosition blockposition = a;
        int i2 = blockposition.u();
        int j2 = blockposition.v() - 2;
        int k2 = blockposition.w();
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldserver);
        BlockPosition.b(i2 - 2, j2 + 1, k2 - 2, i2 + 2, j2 + 3, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.a.n(), 3));
        BlockPosition.b(i2 - 2, j2, k2 - 2, i2 + 2, j2, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.co.n(), 3));
        CraftWorld bworld = worldserver.getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> E() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.M.d();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> stream) {
        this.M.a(stream);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> stream) {
        this.M.b(stream);
    }

    public void b(Chunk chunk) {
        chunk.c(this.u_().e());
    }

    public void a(IChunkAccess ichunkaccess) {
        this.J.execute(() -> this.ac.a(ichunkaccess.f(), ichunkaccess.g()));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.M.close();
    }

    @Override
    public String F() {
        String s2 = this.I.e();
        return "Chunks[S] W: " + s2 + " E: " + this.M.e();
    }

    public boolean c(long i2) {
        return this.M.a(i2);
    }

    private boolean d(long i2) {
        return this.c(i2) && this.I.a(i2);
    }

    public boolean e(BlockPosition blockposition) {
        return this.M.a(blockposition) && this.I.a.j().c(ChunkCoordIntPair.a(blockposition));
    }

    public boolean f(BlockPosition blockposition) {
        return this.M.a(blockposition);
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return this.M.a(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet G() {
        return this.J.aU().M();
    }

    public RandomSource a(MinecraftKey minecraftkey) {
        return this.ae.a(minecraftkey);
    }

    public RandomSequences H() {
        return this.ae;
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.L.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.L.b(entity);
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            WorldServer.this.k().b(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.U) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.T.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                EntityComplexPart[] aentitycomplexpart = entityenderdragon.fV();
                int i2 = aentitycomplexpart.length;
                int j2 = 0;
                while (j2 < i2) {
                    EntityComplexPart entitycomplexpart = aentitycomplexpart[j2];
                    WorldServer.this.aa.put(entitycomplexpart.af(), (Object)entitycomplexpart);
                    ++j2;
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.valid = true;
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.n().F()).map(WorldServer::s).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.o.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.n.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dE() != Entity.RemovalReason.a)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory();
                }
            }
            WorldServer.this.k().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.U) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.T.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                EntityComplexPart[] aentitycomplexpart = entityenderdragon.fV();
                int i2 = aentitycomplexpart.length;
                int j2 = 0;
                while (j2 < i2) {
                    EntityComplexPart entitycomplexpart = aentitycomplexpart[j2];
                    WorldServer.this.aa.remove(entitycomplexpart.af());
                    ++j2;
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

