/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginInCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener {
    private static final AtomicInteger a = new AtomicInteger(0);
    static final Logger b = LogUtils.getLogger();
    private static final int c = 600;
    private static final RandomSource d = RandomSource.a();
    private final byte[] e;
    final MinecraftServer f;
    public final NetworkManager g;
    EnumProtocolState h = EnumProtocolState.a;
    private int i;
    @Nullable
    GameProfile j;
    private final String k;
    @Nullable
    private EntityPlayer l;

    public LoginListener(MinecraftServer minecraftserver, NetworkManager networkmanager) {
        this.k = "";
        this.f = minecraftserver;
        this.g = networkmanager;
        this.e = Ints.toByteArray((int)d.f());
    }

    @Override
    public void c() {
        EntityPlayer entityplayer;
        if (this.h == EnumProtocolState.e) {
            this.d();
        } else if (this.h == EnumProtocolState.f && (entityplayer = this.f.ac().a(this.j.getId())) == null) {
            this.h = EnumProtocolState.e;
            this.a(this.l);
            this.l = null;
        }
        if (this.i++ == 600) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.b(IChatBaseComponent.b(s2));
    }

    @Override
    public boolean a() {
        return this.g.h();
    }

    public void b(IChatBaseComponent ichatbasecomponent) {
        try {
            b.info("Disconnecting {}: {}", (Object)this.e(), (Object)ichatbasecomponent.getString());
            this.g.a(new PacketLoginOutDisconnect(ichatbasecomponent));
            this.g.a(ichatbasecomponent);
        }
        catch (Exception exception) {
            b.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void initUUID() {
        UUID uuid = this.g.spoofedUUID != null ? this.g.spoofedUUID : UUIDUtil.a(this.j.getName());
        this.j = new GameProfile(uuid, this.j.getName());
        if (this.g.spoofedProfile != null) {
            Property[] propertyArray = this.g.spoofedProfile;
            int n2 = this.g.spoofedProfile.length;
            int n3 = 0;
            while (n3 < n2) {
                Property property = propertyArray[n3];
                if (HandshakeListener.PROP_PATTERN.matcher(property.getName()).matches()) {
                    this.j.getProperties().put((Object)property.getName(), (Object)property);
                }
                ++n3;
            }
        }
    }

    public void d() {
        this.f.U();
        EntityPlayer s2 = this.f.ac().canPlayerLogin(this, this.j);
        if (s2 != null) {
            this.h = EnumProtocolState.g;
            if (this.f.av() >= 0 && !this.g.d()) {
                this.g.a(new PacketLoginOutSetCompression(this.f.av()), PacketSendListener.a(() -> this.g.a(this.f.av(), true)));
            }
            this.g.a(new PacketLoginOutSuccess(this.j));
            EntityPlayer entityplayer = this.f.ac().a(this.j.getId());
            try {
                EntityPlayer entityplayer1 = this.f.ac().getPlayerForLogin(this.j, s2);
                if (entityplayer != null) {
                    this.h = EnumProtocolState.f;
                    this.l = entityplayer1;
                } else {
                    this.a(entityplayer1);
                }
            }
            catch (Exception exception) {
                b.error("Couldn't place player in world", (Throwable)exception);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
                this.g.a(new PacketPlayOutKickDisconnect(ichatmutablecomponent));
                this.g.a(ichatmutablecomponent);
            }
        }
    }

    private void a(EntityPlayer entityplayer) {
        this.f.ac().a(this.g, entityplayer);
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
        b.info("{} lost connection: {}", (Object)this.e(), (Object)ichatbasecomponent.getString());
    }

    public String e() {
        return this.j != null ? this.j + " (" + this.g.c() + ")" : String.valueOf(this.g.c());
    }

    @Override
    public void a(PacketLoginInStart packetlogininstart) {
        Validate.validState((this.h == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)LoginListener.a(packetlogininstart.a()), (String)"Invalid characters in username", (Object[])new Object[0]);
        GameProfile gameprofile = this.f.N();
        if (gameprofile != null && packetlogininstart.a().equalsIgnoreCase(gameprofile.getName())) {
            this.j = gameprofile;
            this.h = EnumProtocolState.e;
        } else {
            this.j = new GameProfile(null, packetlogininstart.a());
            if (this.f.U() && !this.g.d()) {
                this.h = EnumProtocolState.b;
                this.g.a(new PacketLoginOutEncryptionBegin("", this.f.L().getPublic().getEncoded(), this.e));
            } else {
                new Thread("User Authenticator #" + a.incrementAndGet()){

                    @Override
                    public void run() {
                        try {
                            LoginListener.this.initUUID();
                            new LoginHandler().fireEvents();
                        }
                        catch (Exception ex) {
                            LoginListener.this.disconnect("Failed to verify username!");
                            LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.j.getName(), ex);
                        }
                    }
                }.start();
            }
        }
    }

    public static boolean a(String s2) {
        return s2.chars().filter(i2 -> i2 <= 32 || i2 >= 127).findAny().isEmpty();
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packetlogininencryptionbegin) {
        String s2;
        Validate.validState((this.h == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f.L().getPrivate();
            if (!packetlogininencryptionbegin.a(this.e, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packetlogininencryptionbegin.a(privatekey);
            Cipher cipher = MinecraftEncryption.a(2, secretkey);
            Cipher cipher1 = MinecraftEncryption.a(1, secretkey);
            s2 = new BigInteger(MinecraftEncryption.a("", this.f.L().getPublic(), secretkey)).toString(16);
            this.h = EnumProtocolState.c;
            this.g.a(cipher, cipher1);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        Thread thread = new Thread("User Authenticator #" + a.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = LoginListener.this.j;
                try {
                    LoginListener.this.j = LoginListener.this.f.am().hasJoinedServer(new GameProfile(null, gameprofile.getName()), s2, this.getAddress());
                    if (LoginListener.this.j != null) {
                        if (!LoginListener.this.g.h()) {
                            return;
                        }
                        new LoginHandler().fireEvents();
                    } else if (LoginListener.this.f.O()) {
                        b.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.j = gameprofile;
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        LoginListener.this.b(IChatBaseComponent.c("multiplayer.disconnect.unverified_username"));
                        b.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.f.O()) {
                        b.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.j = gameprofile;
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        LoginListener.this.b(IChatBaseComponent.c("multiplayer.disconnect.authservers_down"));
                        b.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + gameprofile.getName(), exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.g.c();
                return LoginListener.this.f.V() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(b));
        thread.start();
    }

    @Override
    public void a(PacketLoginInCustomPayload packetloginincustompayload) {
        this.b(IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile a(GameProfile gameprofile) {
        UUID uuid = UUIDUtil.a(gameprofile.getName());
        return new GameProfile(uuid, gameprofile.getName());
    }

    private static enum EnumProtocolState {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }

    public class LoginHandler {
        public void fireEvents() throws Exception {
            String playerName = LoginListener.this.j.getName();
            InetAddress address = ((InetSocketAddress)LoginListener.this.g.c()).getAddress();
            UUID uniqueId = LoginListener.this.j.getId();
            final CraftServer server = LoginListener.this.f.server;
            AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
            server.getPluginManager().callEvent((Event)asyncEvent);
            if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
                if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                    event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
                }
                Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                    @Override
                    protected PlayerPreLoginEvent.Result evaluate() {
                        server.getPluginManager().callEvent((Event)event);
                        return event.getResult();
                    }
                };
                LoginListener.this.f.processQueue.add(waitable);
                if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                    LoginListener.this.disconnect(event.getKickMessage());
                    return;
                }
            } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                LoginListener.this.disconnect(asyncEvent.getKickMessage());
                return;
            }
            b.info("UUID of player {} is {}", (Object)LoginListener.this.j.getName(), (Object)LoginListener.this.j.getId());
            LoginListener.this.h = EnumProtocolState.e;
        }
    }
}

