/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.status.PacketStatusInListener;
import net.minecraft.network.protocol.status.PacketStatusInPing;
import net.minecraft.network.protocol.status.PacketStatusInStart;
import net.minecraft.network.protocol.status.PacketStatusOutPong;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftIconCache;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.spigotmc.SpigotConfig;

public class PacketStatusListener
implements PacketStatusInListener {
    private static final IChatBaseComponent a = IChatBaseComponent.c("multiplayer.status.request_handled");
    private final ServerPing b;
    private final NetworkManager c;
    private boolean d;

    public PacketStatusListener(ServerPing serverping, NetworkManager networkmanager) {
        this.b = serverping;
        this.c = networkmanager;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
    }

    @Override
    public boolean a() {
        return this.c.h();
    }

    @Override
    public void a(PacketStatusInStart packetstatusinstart) {
        if (this.d) {
            this.c.a(a);
        } else {
            this.d = true;
            MinecraftServer server = MinecraftServer.getServer();
            Object[] players = server.ac().k.toArray();
            class ServerListPingEvent
            extends org.bukkit.event.server.ServerListPingEvent {
                CraftIconCache icon;
                private final /* synthetic */ Object[] val$players;

                ServerListPingEvent(MinecraftServer minecraftServer, Object[] objectArray) {
                    this.val$players = objectArray;
                    super(PacketStatusListener.this.c.hostname, ((InetSocketAddress)PacketStatusListener.this.c.c()).getAddress(), minecraftServer.aa(), minecraftServer.ac().n());
                    this.icon = minecraftServer.server.getServerIcon();
                }

                public void setServerIcon(CachedServerIcon icon) {
                    if (!(icon instanceof CraftIconCache)) {
                        throw new IllegalArgumentException(icon + " was not created by " + CraftServer.class);
                    }
                    this.icon = (CraftIconCache)icon;
                }

                public Iterator<Player> iterator() throws UnsupportedOperationException {
                    return new Iterator<Player>(){
                        int i;
                        int ret = Integer.MIN_VALUE;
                        EntityPlayer player;

                        @Override
                        public boolean hasNext() {
                            if (this.player != null) {
                                return true;
                            }
                            Object[] currentPlayers = val$players;
                            int length = currentPlayers.length;
                            int i2 = this.i;
                            while (i2 < length) {
                                EntityPlayer player = (EntityPlayer)currentPlayers[i2];
                                if (player != null) {
                                    this.i = i2 + 1;
                                    this.player = player;
                                    return true;
                                }
                                ++i2;
                            }
                            return false;
                        }

                        @Override
                        public Player next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            EntityPlayer player = this.player;
                            this.player = null;
                            this.ret = this.i - 1;
                            return player.getBukkitEntity();
                        }

                        @Override
                        public void remove() {
                            Object[] currentPlayers = val$players;
                            int i2 = this.ret;
                            if (i2 < 0 || currentPlayers[i2] == null) {
                                throw new IllegalStateException();
                            }
                            currentPlayers[i2] = null;
                        }
                    };
                }
            }
            ServerListPingEvent event = new ServerListPingEvent(server, players);
            server.server.getPluginManager().callEvent((Event)event);
            List<Object> profiles = new ArrayList(players.length);
            Object[] objectArray = players;
            int n2 = players.length;
            int n3 = 0;
            while (n3 < n2) {
                Object player = objectArray[n3];
                if (player != null) {
                    EntityPlayer entityPlayer = (EntityPlayer)player;
                    if (entityPlayer.V()) {
                        profiles.add(entityPlayer.fM());
                    } else {
                        profiles.add(MinecraftServer.g);
                    }
                }
                ++n3;
            }
            if (!server.aj() && !profiles.isEmpty()) {
                Collections.shuffle(profiles);
                profiles = profiles.subList(0, Math.min(profiles.size(), SpigotConfig.playerSample));
            }
            ServerPing.ServerPingPlayerSample playerSample = new ServerPing.ServerPingPlayerSample(event.getMaxPlayers(), profiles.size(), server.aj() ? Collections.emptyList() : profiles);
            ServerPing ping = new ServerPing(CraftChatMessage.fromString(event.getMotd(), true)[0], Optional.of(playerSample), Optional.of(new ServerPing.ServerData(String.valueOf(server.getServerModName()) + " " + server.G(), SharedConstants.b().e())), event.icon.value != null ? Optional.of(new ServerPing.a(event.icon.value)) : Optional.empty(), server.aw());
            this.c.a(new PacketStatusOutServerInfo(ping));
        }
    }

    @Override
    public void a(PacketStatusInPing packetstatusinping) {
        this.c.a(new PacketStatusOutPong(packetstatusinping.a()));
        this.c.a(a);
    }
}

