/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_20_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
implements ServerPlayerConnection,
TickablePacketListener,
PacketListenerPlayIn {
    static final Logger c = LogUtils.getLogger();
    private static final int d = 15000;
    public static final double a = MathHelper.k(6.0);
    private static final int e = -1;
    private static final int f = 4096;
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    private final NetworkManager h;
    private final MinecraftServer i;
    public EntityPlayer b;
    private int j;
    private int k = -1;
    private long l;
    private boolean m;
    private long n;
    private final AtomicInteger o = new AtomicInteger();
    private int p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    @Nullable
    private net.minecraft.world.entity.Entity w;
    private double x;
    private double y;
    private double z;
    private double A;
    private double B;
    private double C;
    @Nullable
    private Vec3D D;
    private int E;
    private int F;
    private boolean G;
    private int H;
    private boolean I;
    private int J;
    private int K;
    private int L;
    private final AtomicReference<Instant> M;
    @Nullable
    private RemoteChatSession N;
    private SignedMessageChain.b O;
    private final LastSeenMessagesValidator P;
    private final MessageSignatureCache Q;
    private final FutureChain R;
    private final CraftServer cserver;
    public boolean processedDisconnect;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final MinecraftKey CUSTOM_REGISTER = new MinecraftKey("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = new MinecraftKey("unregister");

    public PlayerConnection(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer) {
        this.M = new AtomicReference<Instant>(Instant.EPOCH);
        this.P = new LastSeenMessagesValidator(20);
        this.Q = MessageSignatureCache.a();
        this.i = minecraftserver;
        this.h = networkmanager;
        networkmanager.a(this);
        this.b = entityplayer;
        entityplayer.c = this;
        this.l = SystemUtils.b();
        entityplayer.T().a();
        this.O = minecraftserver.aw() ? SignedMessageChain.b.a : SignedMessageChain.b.unsigned(entityplayer.ct());
        this.R = new FutureChain(minecraftserver.chatExecutor);
        this.cserver = minecraftserver.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.b == null ? null : this.b.getBukkitEntity();
    }

    @Override
    public void c() {
        int spam;
        SpigotTimings.playerConnectionTimer.startTiming();
        if (this.k > -1) {
            this.a(new ClientboundBlockChangedAckPacket(this.k));
            this.k = -1;
        }
        this.d();
        this.b.J = this.b.dn();
        this.b.K = this.b.dp();
        this.b.L = this.b.dt();
        this.b.m();
        this.b.a(this.q, this.r, this.s, this.b.dy(), this.b.dA());
        ++this.j;
        this.L = this.K;
        if (this.G && !this.b.fy() && !this.b.bM() && !this.b.es()) {
            if (++this.H > 80) {
                c.warn("{} was kicked for floating too long!", (Object)this.b.Z().getString());
                this.b(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.G = false;
            this.H = 0;
        }
        this.w = this.b.cT();
        if (this.w != this.b && this.w.cL() == this.b) {
            this.x = this.w.dn();
            this.y = this.w.dp();
            this.z = this.w.dt();
            this.A = this.w.dn();
            this.B = this.w.dp();
            this.C = this.w.dt();
            if (this.I && this.b.cT().cL() == this.b) {
                if (++this.J > 80) {
                    c.warn("{} was kicked for floating a vehicle too long!", (Object)this.b.Z().getString());
                    this.b(IChatBaseComponent.c("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.I = false;
                this.J = 0;
            }
        } else {
            this.w = null;
            this.I = false;
            this.J = 0;
        }
        this.i.aN().a("keepAlive");
        long i2 = SystemUtils.b();
        if (i2 - this.l >= 25000L) {
            if (this.m) {
                this.b(IChatBaseComponent.c("disconnect.timeout"));
            } else {
                this.m = true;
                this.l = i2;
                this.n = i2;
                this.a(new PacketPlayOutKeepAlive(this.n));
            }
        }
        this.i.aN().c();
        while ((spam = this.o.get()) > 0 && !this.o.compareAndSet(spam, spam - 1)) {
        }
        if (this.p > 0) {
            --this.p;
        }
        if (this.b.I() > 0L && this.i.al() > 0 && SystemUtils.b() - this.b.I() > (long)this.i.al() * 1000L * 60L) {
            this.b.C();
            this.b(IChatBaseComponent.c("multiplayer.disconnect.idling"));
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    public void d() {
        this.q = this.b.dn();
        this.r = this.b.dp();
        this.s = this.b.dt();
        this.t = this.b.dn();
        this.u = this.b.dp();
        this.v = this.b.dt();
    }

    @Override
    public boolean a() {
        return this.h.h();
    }

    private boolean g() {
        return this.i.a(this.b.fM());
    }

    @Deprecated
    public void b(IChatBaseComponent ichatbasecomponent) {
        this.disconnect(CraftChatMessage.fromComponent(ichatbasecomponent));
    }

    public void disconnect(final String s2) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    PlayerConnection.this.disconnect(s2);
                    return null;
                }
            };
            this.i.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        String leaveMessage = EnumChatFormat.o + this.b.cv() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent((Player)this.b.getBukkitEntity(), s2, leaveMessage);
        if (this.cserver.getServer().v()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        this.b.kickLeaveMessage = event.getLeaveMessage();
        IChatBaseComponent ichatbasecomponent = CraftChatMessage.fromString(event.getReason(), true)[0];
        this.h.a(new PacketPlayOutKickDisconnect(ichatbasecomponent), PacketSendListener.a(() -> this.h.a(ichatbasecomponent)));
        this.a(ichatbasecomponent);
        this.h.l();
        MinecraftServer minecraftserver = this.i;
        NetworkManager networkmanager = this.h;
        Objects.requireNonNull(this.h);
        minecraftserver.a(networkmanager::m);
    }

    private <T, R> CompletableFuture<R> a(T t0, BiFunction<ITextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.b.T(), (ITextFilter)t0).thenApply(object -> {
            if (!this.a()) {
                c.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String s2) {
        return this.a(s2, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> list) {
        return this.a(list, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packetplayinsteervehicle) {
        PlayerConnectionUtils.a(packetplayinsteervehicle, this, this.b.x());
        this.b.a(packetplayinsteervehicle.a(), packetplayinsteervehicle.c(), packetplayinsteervehicle.d(), packetplayinsteervehicle.e());
    }

    private static boolean b(double d0, double d1, double d2, float f2, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f2);
    }

    private static double a(double d0) {
        return MathHelper.a(d0, -3.0E7, 3.0E7);
    }

    private static double b(double d0) {
        return MathHelper.a(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packetplayinvehiclemove) {
        PlayerConnectionUtils.a(packetplayinvehiclemove, this, this.b.x());
        if (PlayerConnection.b(packetplayinvehiclemove.a(), packetplayinvehiclemove.c(), packetplayinvehiclemove.d(), packetplayinvehiclemove.e(), packetplayinvehiclemove.f())) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"));
        } else {
            net.minecraft.world.entity.Entity entity = this.b.cT();
            if (entity != this.b && entity.cL() == this.b && entity == this.w) {
                EntityLiving entityliving;
                WorldServer worldserver = this.b.x();
                double d0 = entity.dn();
                double d1 = entity.dp();
                double d2 = entity.dt();
                double d3 = PlayerConnection.a(packetplayinvehiclemove.a());
                double d4 = PlayerConnection.b(packetplayinvehiclemove.c());
                double d5 = PlayerConnection.a(packetplayinvehiclemove.d());
                float f2 = MathHelper.g(packetplayinvehiclemove.e());
                float f1 = MathHelper.g(packetplayinvehiclemove.f());
                double d6 = d3 - this.x;
                double d7 = d4 - this.y;
                double d8 = d5 - this.z;
                double d9 = entity.dl().g();
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.K;
                int i2 = this.K - this.L;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    c.debug(String.valueOf(this.b.cv()) + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.b.fO().b ? (double)(this.b.fO().f * 20.0f) : (double)(this.b.fO().g * 10.0f);
                speed *= 2.0;
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.g()) {
                    c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.Z().getString(), this.b.Z().getString(), d6, d7, d8});
                    this.h.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                boolean flag = worldserver.a(entity, entity.cE().h(0.0625));
                d6 = d3 - this.A;
                d7 = d4 - this.B - 1.0E-6;
                d8 = d5 - this.C;
                boolean flag1 = entity.Q;
                if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).i_()) {
                    entityliving.n();
                }
                entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                double d11 = d7;
                d6 = d3 - entity.dn();
                d7 = d4 - entity.dp();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.dt();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    c.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.Z().getString(), this.b.Z().getString(), Math.sqrt(d10)});
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.a(d3, d4, d5, f2, f1);
                this.b.a(d3, d4, d5, this.b.dy(), this.b.dA());
                boolean flag3 = worldserver.a(entity, entity.cE().h(0.0625));
                if (flag && (flag2 || !flag3)) {
                    entity.a(d0, d1, d2, f2, f1);
                    this.b.a(d0, d1, d2, this.b.dy(), this.b.dA());
                    this.h.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packetplayinvehiclemove.a());
                to.setY(packetplayinvehiclemove.c());
                to.setZ(packetplayinvehiclemove.d());
                to.setYaw(packetplayinvehiclemove.e());
                to.setPitch(packetplayinvehiclemove.f());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.eT()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.b.x().k().a(this.b);
                this.b.r(this.b.dn() - d0, this.b.dp() - d1, this.b.dt() - d2);
                this.I = d11 >= -0.03125 && !flag1 && !this.i.Z() && !entity.aR() && this.a(entity);
                this.A = entity.dn();
                this.B = entity.dp();
                this.C = entity.dt();
            }
        }
    }

    private boolean a(net.minecraft.world.entity.Entity entity) {
        return entity.dI().a(entity.cE().g(0.0625).b(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::i);
    }

    @Override
    public void a(PacketPlayInTeleportAccept packetplayinteleportaccept) {
        PlayerConnectionUtils.a(packetplayinteleportaccept, this, this.b.x());
        if (packetplayinteleportaccept.a() == this.E) {
            if (this.D == null) {
                this.b(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.b.a(this.D.c, this.D.d, this.D.e, this.b.dy(), this.b.dA());
            this.t = this.D.c;
            this.u = this.D.d;
            this.v = this.D.e;
            if (this.b.K()) {
                this.b.L();
            }
            this.D = null;
            this.b.x().k().a(this.b);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packetplayinrecipedisplayed) {
        PlayerConnectionUtils.a(packetplayinrecipedisplayed, this, this.b.x());
        Optional<IRecipe<?>> optional = this.i.aE().a(packetplayinrecipedisplayed.a());
        RecipeBookServer recipebookserver = this.b.E();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packetplayinrecipesettings) {
        PlayerConnectionUtils.a(packetplayinrecipesettings, this, this.b.x());
        this.b.E().a(packetplayinrecipesettings.a(), packetplayinrecipesettings.c(), packetplayinrecipesettings.d());
    }

    @Override
    public void a(PacketPlayInAdvancements packetplayinadvancements) {
        PlayerConnectionUtils.a(packetplayinadvancements, this, this.b.x());
        if (packetplayinadvancements.c() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = packetplayinadvancements.d();
            Advancement advancement = this.i.az().a(minecraftkey);
            if (advancement != null) {
                this.b.M().a(advancement);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packetplayintabcomplete) {
        PlayerConnectionUtils.a(packetplayintabcomplete, this, this.b.x());
        if (this.o.addAndGet(1) > 500 && !this.i.ac().f(this.b.fM())) {
            this.b(IChatBaseComponent.c("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.c());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandListenerWrapper> parseresults = this.i.aC().a().parse(stringreader, this.b.da());
        this.i.aC().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            this.h.a(new PacketPlayOutTabComplete(packetplayintabcomplete.a(), (Suggestions)suggestions));
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packetplayinsetcommandblock) {
        PlayerConnectionUtils.a(packetplayinsetcommandblock, this, this.b.x());
        if (!this.i.o()) {
            this.b.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.b.gk()) {
            this.b.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packetplayinsetcommandblock.a();
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.c();
            }
            String s2 = packetplayinsetcommandblock.c();
            boolean flag = packetplayinsetcommandblock.d();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.v();
                IBlockData iblockdata = this.b.dI().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.a);
                IBlockData iblockdata2 = (IBlockData)((IBlockData)(switch (packetplayinsetcommandblock.g()) {
                    case TileEntityCommand.Type.a -> Blocks.kH.n();
                    case TileEntityCommand.Type.b -> Blocks.kG.n();
                    default -> Blocks.fN.n();
                }).a(BlockCommand.a, enumdirection)).a(BlockCommand.b, packetplayinsetcommandblock.e());
                if (iblockdata2 != iblockdata) {
                    this.b.dI().a(blockposition, iblockdata2, 2);
                    tileentity.b(iblockdata2);
                    this.b.dI().l(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.c(null);
                }
                tileentitycommand.b(packetplayinsetcommandblock.f());
                if (tileentitycommand_type != packetplayinsetcommandblock.g()) {
                    tileentitycommand.g();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.b.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packetplayinsetcommandminecart) {
        PlayerConnectionUtils.a(packetplayinsetcommandminecart, this, this.b.x());
        if (!this.i.o()) {
            this.b.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!this.b.gk()) {
            this.b.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packetplayinsetcommandminecart.a(this.b.dI());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.a());
                commandblocklistenerabstract.a(packetplayinsetcommandminecart.c());
                if (!packetplayinsetcommandminecart.c()) {
                    commandblocklistenerabstract.c(null);
                }
                commandblocklistenerabstract.f();
                this.b.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packetplayinsetcommandminecart.a()}));
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packetplayinpickitem) {
        PlayerConnectionUtils.a(packetplayinpickitem, this, this.b.x());
        this.b.fN().c(packetplayinpickitem.a());
        this.b.c.a(new PacketPlayOutSetSlot(-2, 0, this.b.fN().l, this.b.fN().a(this.b.fN().l)));
        this.b.c.a(new PacketPlayOutSetSlot(-2, 0, packetplayinpickitem.a(), this.b.fN().a(packetplayinpickitem.a())));
        this.b.c.a(new PacketPlayOutHeldItemSlot(this.b.fN().l));
    }

    @Override
    public void a(PacketPlayInItemName packetplayinitemname) {
        PlayerConnectionUtils.a(packetplayinitemname, this, this.b.x());
        Container container = this.b.bR;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)containeranvil);
                return;
            }
            containeranvil.a(packetplayinitemname.a());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packetplayinbeacon) {
        PlayerConnectionUtils.a(packetplayinbeacon, this, this.b.x());
        Container container = this.b.bR;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
                return;
            }
            containerbeacon.a(packetplayinbeacon.a(), packetplayinbeacon.c());
        }
    }

    @Override
    public void a(PacketPlayInStruct packetplayinstruct) {
        PlayerConnectionUtils.a(packetplayinstruct, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packetplayinstruct.a();
            IBlockData iblockdata = this.b.dI().a_(blockposition);
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packetplayinstruct.d());
                tileentitystructure.a(packetplayinstruct.e());
                tileentitystructure.a(packetplayinstruct.f());
                tileentitystructure.a(packetplayinstruct.g());
                tileentitystructure.a(packetplayinstruct.h());
                tileentitystructure.a(packetplayinstruct.i());
                tileentitystructure.b(packetplayinstruct.j());
                tileentitystructure.a(packetplayinstruct.k());
                tileentitystructure.d(packetplayinstruct.l());
                tileentitystructure.e(packetplayinstruct.m());
                tileentitystructure.a(packetplayinstruct.n());
                tileentitystructure.a(packetplayinstruct.o());
                if (tileentitystructure.g()) {
                    String s2 = tileentitystructure.d();
                    if (packetplayinstruct.c() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.b.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.c() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.b.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.b.x())) {
                            this.b.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packetplayinstruct.c() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.b.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.b.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.b.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packetplayinstruct.e()}), false);
                }
                tileentitystructure.e();
                this.b.dI().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packetplayinsetjigsaw) {
        PlayerConnectionUtils.a(packetplayinsetjigsaw, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packetplayinsetjigsaw.a();
            IBlockData iblockdata = this.b.dI().a_(blockposition);
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packetplayinsetjigsaw.c());
                tileentityjigsaw.b(packetplayinsetjigsaw.d());
                tileentityjigsaw.a(ResourceKey.a(Registries.aC, packetplayinsetjigsaw.e()));
                tileentityjigsaw.a(packetplayinsetjigsaw.f());
                tileentityjigsaw.a(packetplayinsetjigsaw.g());
                tileentityjigsaw.e();
                this.b.dI().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packetplayinjigsawgenerate) {
        PlayerConnectionUtils.a(packetplayinjigsawgenerate, this, this.b.x());
        if (this.b.gk()) {
            BlockPosition blockposition = packetplayinjigsawgenerate.a();
            TileEntity tileentity = this.b.dI().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.b.x(), packetplayinjigsawgenerate.c(), packetplayinjigsawgenerate.d());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packetplayintrsel) {
        PlayerConnectionUtils.a(packetplayintrsel, this, this.b.x());
        int i2 = packetplayintrsel.a();
        Container container = this.b.bR;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.b, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.b.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect("Book edited too quickly!");
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packetplayinbedit.d();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.c();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packetplayinbedit.a().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.i);
        }
    }

    private void a(List<FilteredText> list, int i2) {
        ItemStack itemstack = this.b.fN().a(i2);
        if (itemstack.a(Items.tg)) {
            this.updateBookPages(list, UnaryOperator.identity(), itemstack.p(), i2, itemstack);
        }
    }

    private void a(FilteredText filteredtext, List<FilteredText> list, int i2) {
        ItemStack itemstack = this.b.fN().a(i2);
        if (itemstack.a(Items.tg)) {
            ItemStack itemstack1 = new ItemStack(Items.th);
            NBTTagCompound nbttagcompound = itemstack.v();
            if (nbttagcompound != null) {
                itemstack1.c(nbttagcompound.h());
            }
            itemstack1.a("author", NBTTagString.a(this.b.Z().getString()));
            if (this.b.U()) {
                itemstack1.a("title", NBTTagString.a(filteredtext.b()));
            } else {
                itemstack1.a("filtered_title", NBTTagString.a(filteredtext.b()));
                itemstack1.a("title", NBTTagString.a(filteredtext.d()));
            }
            this.updateBookPages(list, s2 -> IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.b(s2)), itemstack1, i2, itemstack);
            this.b.fN().a(i2, itemstack);
        }
    }

    private void updateBookPages(List<FilteredText> list, UnaryOperator<String> unaryoperator, ItemStack itemstack, int slot, ItemStack handItem) {
        NBTTagList nbttaglist = new NBTTagList();
        if (this.b.U()) {
            Stream<NBTTagString> stream = list.stream().map(filteredtext -> NBTTagString.a((String)unaryoperator.apply(filteredtext.b())));
            Objects.requireNonNull(nbttaglist);
            stream.forEach(nbttaglist::add);
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            int i2 = 0;
            int j2 = list.size();
            while (i2 < j2) {
                FilteredText filteredtext2 = list.get(i2);
                String s2 = filteredtext2.d();
                nbttaglist.add(NBTTagString.a((String)unaryoperator.apply(s2)));
                if (filteredtext2.c()) {
                    nbttagcompound.a(String.valueOf(i2), (String)unaryoperator.apply(filteredtext2.b()));
                }
                ++i2;
            }
            if (!nbttagcompound.g()) {
                itemstack.a("filtered_pages", nbttagcompound);
            }
        }
        itemstack.a("pages", nbttaglist);
        CraftEventFactory.handleEditBookEvent(this.b, slot, handItem, itemstack);
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packetplayinentitynbtquery, this, this.b.x());
        if (this.b.l(2) && (entity = this.b.dI().a(packetplayinentitynbtquery.c())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.b.c.a(new PacketPlayOutNBTQuery(packetplayinentitynbtquery.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packetplayintilenbtquery) {
        PlayerConnectionUtils.a(packetplayintilenbtquery, this, this.b.x());
        if (this.b.l(2)) {
            TileEntity tileentity = this.b.dI().c_(packetplayintilenbtquery.c());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.o() : null;
            this.b.c.a(new PacketPlayOutNBTQuery(packetplayintilenbtquery.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packetplayinflying) {
        PlayerConnectionUtils.a(packetplayinflying, this, this.b.x());
        if (PlayerConnection.b(packetplayinflying.a(0.0), packetplayinflying.b(0.0), packetplayinflying.c(0.0), packetplayinflying.a(0.0f), packetplayinflying.b(0.0f))) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"));
        } else {
            WorldServer worldserver = this.b.x();
            if (!this.b.g && !this.b.eT()) {
                if (this.j == 0) {
                    this.d();
                }
                if (this.D != null) {
                    if (this.j - this.F > 20) {
                        this.F = this.j;
                        this.a(this.D.c, this.D.d, this.D.e, this.b.dy(), this.b.dA());
                    }
                    this.allowedPlayerTicks = 20;
                } else {
                    this.F = this.j;
                    double d0 = PlayerConnection.a(packetplayinflying.a(this.b.dn()));
                    double d1 = PlayerConnection.b(packetplayinflying.b(this.b.dp()));
                    double d2 = PlayerConnection.a(packetplayinflying.c(this.b.dt()));
                    float f2 = MathHelper.g(packetplayinflying.a(this.b.dy()));
                    float f1 = MathHelper.g(packetplayinflying.b(this.b.dA()));
                    if (this.b.bM()) {
                        this.b.a(this.b.dn(), this.b.dp(), this.b.dt(), f2, f1);
                        this.b.x().k().a(this.b);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.b.dn();
                        double prevY = this.b.dp();
                        double prevZ = this.b.dt();
                        float prevYaw = this.b.dy();
                        float prevPitch = this.b.dA();
                        double d3 = this.b.dn();
                        double d4 = this.b.dp();
                        double d5 = this.b.dt();
                        double d6 = d0 - this.q;
                        double d7 = d1 - this.r;
                        double d8 = d2 - this.s;
                        double d9 = this.b.dl().g();
                        double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (this.b.fy()) {
                            if (d10 > 1.0) {
                                this.a(this.b.dn(), this.b.dp(), this.b.dt(), f2, f1);
                            }
                        } else {
                            boolean flag;
                            ++this.K;
                            int i2 = this.K - this.L;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.b.Z().getString(), (Object)i2);
                                i2 = 1;
                            }
                            this.allowedPlayerTicks = packetplayinflying.h || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.b.fO().b ? (double)(this.b.fO().f * 20.0f) : (double)(this.b.fO().g * 10.0f);
                            if (!(this.b.K() || this.b.dI().X().b(GameRules.s) && this.b.fr())) {
                                float f22;
                                float f3 = f22 = this.b.fr() ? 300.0f : 100.0f;
                                if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.g()) {
                                    c.warn("{} moved too quickly! {},{},{}", new Object[]{this.b.Z().getString(), d6, d7, d8});
                                    this.a(this.b.dn(), this.b.dp(), this.b.dt(), this.b.dy(), this.b.dA());
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.b.cE();
                            d6 = d0 - this.t;
                            d7 = d1 - this.u;
                            d8 = d2 - this.v;
                            boolean bl = flag = d7 > 0.0;
                            if (this.b.ay() && !packetplayinflying.a() && flag) {
                                this.b.eW();
                            }
                            boolean flag1 = this.b.Q;
                            this.b.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                            this.b.aJ = packetplayinflying.a();
                            double d11 = d7;
                            d6 = d0 - this.b.dn();
                            d7 = d1 - this.b.dp();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.b.dt();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag2 = false;
                            if (!this.b.K() && d10 > SpigotConfig.movedWronglyThreshold && !this.b.fy() && !this.b.e.e() && this.b.e.b() != EnumGamemode.d) {
                                flag2 = true;
                                c.warn("{} moved wrongly!", (Object)this.b.Z().getString());
                            }
                            if (!this.b.ae && !this.b.fy() && (flag2 && worldserver.a((net.minecraft.world.entity.Entity)this.b, axisalignedbb) || this.a(worldserver, axisalignedbb, d0, d1, d2))) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.b.a(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5, packetplayinflying.a());
                            } else {
                                this.b.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packetplayinflying.g) {
                                    to.setX(packetplayinflying.a);
                                    to.setY(packetplayinflying.b);
                                    to.setZ(packetplayinflying.c);
                                }
                                if (packetplayinflying.h) {
                                    to.setYaw(packetplayinflying.d);
                                    to.setPitch(packetplayinflying.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.eT()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.b.a(d0, d1, d2, f2, f1);
                                this.G = d11 >= -0.03125 && !flag1 && this.b.e.b() != EnumGamemode.d && !this.i.Z() && !this.b.fO().c && !this.b.a(MobEffects.y) && !this.b.fr() && !this.b.fe() && this.a(this.b);
                                this.b.x().k().a(this.b);
                                this.b.a(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5, packetplayinflying.a());
                                this.b.a(packetplayinflying.a(), new Vec3D(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5));
                                if (flag) {
                                    this.b.n();
                                }
                                this.b.r(this.b.dn() - d3, this.b.dp() - d4, this.b.dt() - d5);
                                this.t = this.b.dn();
                                this.u = this.b.dp();
                                this.v = this.b.dt();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean a(IWorldReader iworldreader, AxisAlignedBB axisalignedbb, double d0, double d1, double d2) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.b.cE().d(d0 - this.b.dn(), d1 - this.b.dp(), d2 - this.b.dt());
        Iterable<VoxelShape> iterable = iworldreader.c(this.b, axisalignedbb1.h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.teleport(d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void a(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        this.teleport(d0, d1, d2, f2, f1, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return false;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set.clear();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.a) ? this.b.dn() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.b) ? this.b.dp() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.c) ? this.b.dt() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.d) ? this.b.dy() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.e) ? this.b.dA() : 0.0f;
        this.D = new Vec3D(d0, d1, d2);
        if (++this.E == Integer.MAX_VALUE) {
            this.E = 0;
        }
        this.lastPosX = this.D.c;
        this.lastPosY = this.D.d;
        this.lastPosZ = this.D.e;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.F = this.j;
        this.b.a(d0, d1, d2, f2, f1);
        this.b.c.a(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.E));
    }

    @Override
    public void a(PacketPlayInBlockDig packetplayinblockdig) {
        PlayerConnectionUtils.a(packetplayinblockdig, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        BlockPosition blockposition = packetplayinblockdig.a();
        this.b.C();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.d();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.b.G_()) {
                    ItemStack itemstack = this.b.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.b.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.b.a(EnumHand.b, this.b.b(EnumHand.a));
                    } else {
                        this.b.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.b.a(EnumHand.a, itemstack);
                    } else {
                        this.b.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.b.fo();
                }
                return;
            }
            case e: {
                if (!this.b.G_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            c.warn(String.valueOf(this.b.cv()) + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)");
                            return;
                        }
                    }
                    this.b.a(false);
                }
                return;
            }
            case d: {
                if (!this.b.G_()) {
                    this.b.a(true);
                }
                return;
            }
            case f: {
                this.b.fn();
                return;
            }
            case a: 
            case b: 
            case c: {
                this.b.e.a(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.c(), this.b.dI().aj(), packetplayinblockdig.e());
                this.b.c.a(packetplayinblockdig.e());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack.b()) {
            return false;
        }
        Item item = itemstack.d();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !entityplayer.gi().a(item);
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packetplayinuseitem) {
        PlayerConnectionUtils.a(packetplayinuseitem, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (!this.checkLimit(packetplayinuseitem.timestamp)) {
            return;
        }
        this.b.c.a(packetplayinuseitem.d());
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packetplayinuseitem.a();
        ItemStack itemstack = this.b.b(enumhand);
        if (itemstack.a(worldserver.G())) {
            MovingObjectPositionBlock movingobjectpositionblock = packetplayinuseitem.c();
            Vec3D vec3d = movingobjectpositionblock.e();
            BlockPosition blockposition = movingobjectpositionblock.a();
            Vec3D vec3d1 = Vec3D.b(blockposition);
            if (this.b.bm().g(vec3d1) <= a) {
                Vec3D vec3d2 = vec3d.d(vec3d1);
                double d0 = 1.0000001;
                if (Math.abs(vec3d2.a()) < 1.0000001 && Math.abs(vec3d2.b()) < 1.0000001 && Math.abs(vec3d2.c()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.b();
                    this.b.C();
                    int i2 = this.b.dI().aj();
                    if (blockposition.v() < i2) {
                        if (this.D == null && this.b.i((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) < 64.0 && worldserver.a((EntityHuman)this.b, blockposition)) {
                            this.b.fo();
                            EnumInteractionResult enuminteractionresult = this.b.e.a(this.b, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.b, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                                this.b.b(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.b()) {
                                this.b.a(enumhand, true);
                            }
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                        this.b.b(ichatmutablecomponent1, true);
                    }
                    this.b.c.a(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.b.c.a(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                } else {
                    c.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.b.fM().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packetplayinblockplace) {
        PlayerConnectionUtils.a(packetplayinblockplace, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (!this.checkLimit(packetplayinblockplace.timestamp)) {
            return;
        }
        this.a(packetplayinblockplace.c());
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packetplayinblockplace.a();
        ItemStack itemstack = this.b.b(enumhand);
        this.b.C();
        if (!itemstack.b() && itemstack.a(worldserver.G())) {
            boolean cancelled;
            float f1 = this.b.dA();
            float f2 = this.b.dy();
            double d0 = this.b.dn();
            double d1 = this.b.dp() + (double)this.b.cF();
            double d2 = this.b.dt();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.b.e.b() == EnumGamemode.b ? 5.0 : 4.5;
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.b.dI().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.b));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.b.e.firedInteract && this.b.e.interactPosition.equals(movingobjectpositionblock.a()) && this.b.e.interactHand == enumhand && ItemStack.c(this.b.e.interactItemStack, itemstack) ? this.b.e.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand)).useItemInHand() == Event.Result.DENY;
                this.b.e.firedInteract = false;
            }
            if (cancelled) {
                this.b.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.b.b(enumhand);
            if (itemstack.b()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.b.e.a(this.b, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.b.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packetplayinspectate) {
        PlayerConnectionUtils.a(packetplayinspectate, this, this.b.x());
        if (this.b.G_()) {
            for (WorldServer worldserver : this.i.F()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.a(worldserver);
                if (entity == null) continue;
                this.b.teleportTo(worldserver, entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInResourcePackStatus packetplayinresourcepackstatus) {
        PlayerConnectionUtils.a(packetplayinresourcepackstatus, this, this.b.x());
        if (packetplayinresourcepackstatus.a() == PacketPlayInResourcePackStatus.EnumResourcePackStatus.b && this.i.T()) {
            c.info("Disconnecting {} due to resource pack rejection", (Object)this.b.Z());
            this.b(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"));
        }
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), PlayerResourcePackStatusEvent.Status.values()[packetplayinresourcepackstatus.a.ordinal()]));
    }

    @Override
    public void a(PacketPlayInBoatMove packetplayinboatmove) {
        PlayerConnectionUtils.a(packetplayinboatmove, this, this.b.x());
        net.minecraft.world.entity.Entity entity = this.b.cX();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.a(packetplayinboatmove.a(), packetplayinboatmove.c());
        }
    }

    @Override
    public void a(ServerboundPongPacket serverboundpongpacket) {
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        this.R.close();
        c.info("{} lost connection: {}", (Object)this.b.Z().getString(), (Object)ichatbasecomponent.getString());
        this.b.s();
        String quitMessage = this.i.ac().remove(this.b);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.i.ac().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.b.T().b();
        if (this.g()) {
            c.info("Stopping singleplayer server as player logged out");
            this.i.a(false);
        }
    }

    public void a(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.k = Math.max(i2, this.k);
    }

    @Override
    public void a(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.b.compassTarget = CraftLocation.toBukkit(packet6.a, this.getCraftPlayer().getWorld());
        }
        try {
            this.h.a(packet, packetsendlistener);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packetplayinhelditemslot) {
        PlayerConnectionUtils.a(packetplayinhelditemslot, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        if (packetplayinhelditemslot.a() >= 0 && packetplayinhelditemslot.a() < PlayerInventory.g()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.b.fN().l, packetplayinhelditemslot.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.a(new PacketPlayOutHeldItemSlot(this.b.fN().l));
                this.b.C();
                return;
            }
            if (this.b.fN().l != packetplayinhelditemslot.a() && this.b.fj() == EnumHand.a) {
                this.b.fo();
            }
            this.b.fN().l = packetplayinhelditemslot.a();
            this.b.C();
        } else {
            c.warn("{} tried to set an invalid carried item", (Object)this.b.Z().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)");
        }
    }

    @Override
    public void a(PacketPlayInChat packetplayinchat) {
        if (this.i.ab()) {
            return;
        }
        if (PlayerConnection.c(packetplayinchat.a())) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"));
        } else {
            Optional<LastSeenMessages> optional = this.a(packetplayinchat.a(), packetplayinchat.c(), packetplayinchat.f());
            if (optional.isPresent()) {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packetplayinchat, optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletableFuture<FilteredText> completablefuture = this.a(playerchatmessage.b());
                CompletableFuture<IChatBaseComponent> completablefuture1 = this.i.be().decorate(this.b, playerchatmessage.c());
                this.R.append(executor -> CompletableFuture.allOf(completablefuture, completablefuture1).thenAcceptAsync(ovoid -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a((IChatBaseComponent)completablefuture1.join()).a(((FilteredText)completablefuture.join()).e());
                    this.b(playerchatmessage1);
                }, (Executor)this.i.chatExecutor));
            }
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        if (PlayerConnection.c(serverboundchatcommandpacket.a())) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"));
        } else {
            Optional<LastSeenMessages> optional = this.a(serverboundchatcommandpacket.a(), serverboundchatcommandpacket.c(), serverboundchatcommandpacket.f());
            if (optional.isPresent()) {
                this.i.g(() -> {
                    if (this.b.t()) {
                        return;
                    }
                    this.a(serverboundchatcommandpacket, (LastSeenMessages)optional.get());
                    this.detectRateSpam("/" + serverboundchatcommandpacket.a());
                });
            }
        }
    }

    private void a(ServerboundChatCommandPacket serverboundchatcommandpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        String command = "/" + serverboundchatcommandpacket.a();
        c.info(String.valueOf(this.b.cv()) + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.i));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.b(command);
        try {
            map = serverboundchatcommandpacket.a().equals(command) ? this.a(serverboundchatcommandpacket, SignableCommand.a(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext_a));
        this.i.aC().a(parseresults, command);
    }

    private void a(SignedMessageChain.a signedmessagechain_a) {
        if (signedmessagechain_a.a()) {
            this.b(signedmessagechain_a.b());
        } else {
            this.b.a(signedmessagechain_a.b().e().a(EnumChatFormat.m));
        }
    }

    private Map<String, PlayerChatMessage> a(ServerboundChatCommandPacket serverboundchatcommandpacket, SignableCommand<?> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (SignableCommand.a<?> signablecommand_a : signablecommand.a()) {
            MessageSignature messagesignature = serverboundchatcommandpacket.e().a(signablecommand_a.a());
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), serverboundchatcommandpacket.c(), serverboundchatcommandpacket.d(), lastseenmessages);
            map.put(signablecommand_a.a(), this.O.unpack(messagesignature, signedmessagebody));
        }
        return map;
    }

    private ParseResults<CommandListenerWrapper> b(String s2) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.i.aC().a();
        return com_mojang_brigadier_commanddispatcher.parse(s2, this.b.da());
    }

    private Optional<LastSeenMessages> a(String s2, Instant instant, LastSeenMessages.b lastseenmessages_b) {
        if (!this.a(instant)) {
            c.warn("{} sent out-of-order chat: '{}'", (Object)this.b.Z().getString(), (Object)s2);
            this.b(IChatBaseComponent.c("multiplayer.disconnect.out_of_order_chat"));
            return Optional.empty();
        }
        Optional<LastSeenMessages> optional = this.a(lastseenmessages_b);
        if (this.b.dD() || this.b.A() == EnumChatVisibility.c) {
            this.a(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m), false));
            return Optional.empty();
        }
        this.b.C();
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b lastseenmessages_b) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.P.a(lastseenmessages_b);
            if (optional.isEmpty()) {
                c.warn("Failed to validate message acknowledgements from {}", (Object)this.b.Z().getString());
                this.b(g);
            }
            return optional;
        }
    }

    private boolean a(Instant instant) {
        Instant instant1;
        do {
            if (!instant.isBefore(instant1 = this.M.get())) continue;
            return false;
        } while (!this.M.compareAndSet(instant1, instant));
        return true;
    }

    private static boolean c(String s2) {
        int i2 = 0;
        while (i2 < s2.length()) {
            if (!SharedConstants.a(s2.charAt(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void chat(String s2, final PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.b.A() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (!async && s2.startsWith("/")) {
            this.handleCommand(s2);
        } else if (this.b.A() != EnumChatVisibility.b) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s2, (Set)new LazyPlayerSet(this.i));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                PlayerConnection.this.i.ac().a(original, PlayerConnection.this.b, ChatMessageType.a(ChatMessageType.c, PlayerConnection.this.b));
                                return null;
                            }
                            if (!SpigotConfig.bungee && CraftChatMessage.fromComponent(original.c()).equals(message)) {
                                PlayerConnection.this.i.ac().a(original, PlayerConnection.this.b, ChatMessageType.a(ChatMessageType.RAW, PlayerConnection.this.b));
                                return null;
                            }
                            for (EntityPlayer recipient : PlayerConnection.this.i.ac().k) {
                                recipient.getBukkitEntity().sendMessage(PlayerConnection.this.b.ct(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(PlayerConnection.this.b.ct(), message);
                            }
                        }
                        PlayerConnection.this.i.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.i.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException("Exception processing chat event", e3.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.i.ac().a(original, this.b, ChatMessageType.a(ChatMessageType.c, this.b));
                        return;
                    }
                    if (!SpigotConfig.bungee && CraftChatMessage.fromComponent(original.c()).equals(s2)) {
                        this.i.ac().a(original, this.b, ChatMessageType.a(ChatMessageType.RAW, this.b));
                        return;
                    }
                    for (EntityPlayer recipient : this.i.ac().k) {
                        recipient.getBukkitEntity().sendMessage(this.b.ct(), s2);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.b.ct(), s2);
                    }
                }
                this.i.console.sendMessage(s2);
            }
        }
    }

    private void handleCommand(String s2) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            c.info(String.valueOf(this.b.cv()) + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.i));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.a(), packetplayinchat.c(), packetplayinchat.d(), lastseenmessages);
        return this.O.unpack(packetplayinchat.e(), signedmessagebody);
    }

    private void b(PlayerChatMessage playerchatmessage) {
        String s2 = playerchatmessage.b();
        if (s2.isEmpty()) {
            c.warn(String.valueOf(this.b.cv()) + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.i.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.b.A() == EnumChatVisibility.b) {
            this.a(new ClientboundSystemChatPacket(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m), false));
        } else {
            this.chat(s2, playerchatmessage, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (this.o.addAndGet(20) > 200 && !this.i.ac().f(this.b.fM())) {
            this.b(IChatBaseComponent.c("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
        synchronized (lastSeenMessagesValidator) {
            if (!this.P.a(serverboundchatackpacket.a())) {
                c.warn("Failed to validate message acknowledgements from {}", (Object)this.b.Z().getString());
                this.b(g);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packetplayinarmanimation) {
        PlayerConnectionUtils.a(packetplayinarmanimation, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        float f1 = this.b.dA();
        float f2 = this.b.dy();
        double d0 = this.b.dn();
        double d1 = this.b.dp() + (double)this.b.cF();
        double d2 = this.b.dt();
        Location origin = new Location((World)this.b.dI().getWorld(), d0, d1, d2, f2, f1);
        double d3 = this.b.e.b() == EnumGamemode.b ? 5.0 : 4.5;
        RayTraceResult result = this.b.dI().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> entity != this.b.getBukkitEntity() && this.b.getBukkitEntity().canSee((Entity)entity));
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.b, Action.LEFT_CLICK_AIR, this.b.fN().f(), EnumHand.a);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getCraftPlayer(), packetplayinarmanimation.a() == EnumHand.a ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.b.a(packetplayinarmanimation.a());
    }

    @Override
    public void a(PacketPlayInEntityAction packetplayinentityaction) {
        PlayerConnectionUtils.a(packetplayinentityaction, this, this.b.x());
        if (this.b.dD()) {
            return;
        }
        switch (packetplayinentityaction.c()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packetplayinentityaction.c() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packetplayinentityaction.c() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.b.C();
        switch (packetplayinentityaction.c()) {
            case a: {
                this.b.f(true);
                break;
            }
            case b: {
                this.b.f(false);
                break;
            }
            case d: {
                this.b.g(true);
                break;
            }
            case e: {
                this.b.g(false);
                break;
            }
            case c: {
                if (!this.b.fy()) break;
                this.b.a(false, true);
                this.D = this.b.dg();
                break;
            }
            case f: {
                net.minecraft.world.entity.Entity entity = this.b.cX();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packetplayinentityaction.d();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.c(i2);
                break;
            }
            case g: {
                net.minecraft.world.entity.Entity entity = this.b.cX();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.b();
                break;
            }
            case h: {
                net.minecraft.world.entity.Entity entity = this.b.cW();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.b(this.b);
                break;
            }
            case i: {
                if (this.b.fS()) break;
                this.b.fU();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage playerchatmessage) {
        MessageSignature messagesignature = playerchatmessage.k();
        if (messagesignature != null) {
            int i2;
            this.Q.a(playerchatmessage);
            LastSeenMessagesValidator lastseenmessagesvalidator = this.P;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.P;
            synchronized (lastSeenMessagesValidator) {
                this.P.a(messagesignature);
                i2 = this.P.a();
            }
            if (i2 > 4096) {
                this.b(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void a(PlayerChatMessage playerchatmessage, ChatMessageType.a chatmessagetype_a) {
        if (!this.getCraftPlayer().canSee(playerchatmessage.j().c())) {
            this.a(playerchatmessage.c(), chatmessagetype_a);
            return;
        }
        this.a(new ClientboundPlayerChatPacket(playerchatmessage.j().c(), playerchatmessage.j().b(), playerchatmessage.k(), playerchatmessage.l().a(this.Q), playerchatmessage.m(), playerchatmessage.n(), chatmessagetype_a.a(this.b.dI().B_())));
        this.a(playerchatmessage);
    }

    public void a(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a) {
        this.a(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a.a(this.b.dI().B_())));
    }

    public SocketAddress e() {
        return this.h.c();
    }

    public SocketAddress getRawAddress() {
        return this.h.m.remoteAddress();
    }

    @Override
    public void a(PacketPlayInUseEntity packetplayinuseentity) {
        PlayerConnectionUtils.a(packetplayinuseentity, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        final WorldServer worldserver = this.b.x();
        final net.minecraft.world.entity.Entity entity = packetplayinuseentity.a(worldserver);
        if (entity == this.b && !this.b.G_()) {
            this.disconnect("Cannot interact with self!");
            return;
        }
        this.b.C();
        this.b.f(packetplayinuseentity.a());
        if (entity != null) {
            if (!worldserver.w_().a(entity.di())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.cE();
            if (axisalignedbb.e(this.b.bm()) < a) {
                packetplayinuseentity.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.b.b(enumhand);
                        if (itemstack.a(worldserver.G())) {
                            ItemStack itemstack1 = itemstack.p();
                            ItemStack itemInHand = PlayerConnection.this.b.b(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.d() == Items.tQ && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.b.fN().f() == null ? null : PlayerConnection.this.b.fN().f().d();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.k() == Items.pL && (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem)) {
                                PlayerConnection.this.a(new PacketPlayOutSpawnEntity(entity));
                                PlayerConnection.this.b.bR.b();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem)) {
                                PlayerConnection.this.a(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).fP()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.b.fN().f() == null || PlayerConnection.this.b.fN().f().d() != origItem) {
                                entity.aj().refresh(PlayerConnection.this.b);
                                if (entity instanceof Allay) {
                                    PlayerConnection.this.a(new PacketPlayOutEntityEquipment(entity.af(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).c((EnumItemSlot)((Object)slot)).p())).collect(Collectors.toList())));
                                    PlayerConnection.this.b.bR.b();
                                }
                            }
                            if (event.isCancelled()) {
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.b, entity, enumhand);
                            if (!itemInHand.b() && itemInHand.L() <= -1) {
                                PlayerConnection.this.b.bR.b();
                            }
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.Q.a(PlayerConnection.this.b, itemstack1, entity);
                                if (enuminteractionresult.b()) {
                                    PlayerConnection.this.b.a(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand enumhand) {
                        this.performInteraction(enumhand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand enumhand, Vec3D vec3d) {
                        this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.c, vec3d.d, vec3d.e), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity instanceof EntityArrow || entity == PlayerConnection.this.b && !PlayerConnection.this.b.G_())) {
                            ItemStack itemstack = PlayerConnection.this.b.b(EnumHand.a);
                            if (itemstack.a(worldserver.G())) {
                                PlayerConnection.this.b.d(entity);
                                if (!itemstack.b() && itemstack.L() <= -1) {
                                    PlayerConnection.this.b.bR.b();
                                }
                            }
                        } else {
                            PlayerConnection.this.b(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"));
                            c.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.b.Z().getString());
                        }
                    }
                });
            }
        }
    }

    @Override
    public void a(PacketPlayInClientCommand packetplayinclientcommand) {
        PlayerConnectionUtils.a(packetplayinclientcommand, this, this.b.x());
        this.b.C();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.a();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.b.g) {
                    this.b.g = false;
                    this.b = this.i.ac().respawn(this.b, true, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    CriterionTriggers.v.a(this.b, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.b.er() > 0.0f) {
                    return;
                }
                this.b = this.i.ac().respawn(this.b, false, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.i.h()) break;
                this.b.a(EnumGamemode.d);
                this.b.dI().X().a(GameRules.q).a(false, this.i);
                break;
            }
            case b: {
                this.b.D().a(this.b);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packetplayinclosewindow) {
        PlayerConnectionUtils.a(packetplayinclosewindow, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.b);
        this.b.r();
    }

    @Override
    public void a(PacketPlayInWindowClick packetplayinwindowclick) {
        PlayerConnectionUtils.a(packetplayinwindowclick, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        if (this.b.bR.j == packetplayinwindowclick.a() && this.b.bR.a(this.b)) {
            boolean cancelled = this.b.G_();
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                int i2 = packetplayinwindowclick.c();
                if (!this.b.bR.a(i2)) {
                    c.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.b.Z(), i2, this.b.bR.i.size()});
                } else {
                    boolean flag = packetplayinwindowclick.h() != this.b.bR.j();
                    this.b.bR.h();
                    if (packetplayinwindowclick.c() < -1 && packetplayinwindowclick.c() != -999) {
                        return;
                    }
                    InventoryView inventory = this.b.bR.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packetplayinwindowclick.c());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.b;
                    switch (packetplayinwindowclick.g()) {
                        case a: {
                            if (packetplayinwindowclick.d() == 0) {
                                click = ClickType.LEFT;
                            } else if (packetplayinwindowclick.d() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.d() != 0 && packetplayinwindowclick.d() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.c() == -999) {
                                if (this.b.bR.g().b()) break;
                                action = packetplayinwindowclick.d() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.c() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.b.bR.b(packetplayinwindowclick.c());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.e();
                            ItemStack cursor = this.b.bR.g();
                            if (clickedItem.b()) {
                                if (cursor.b()) break;
                                action = packetplayinwindowclick.d() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.b)) break;
                            if (cursor.b()) {
                                action = packetplayinwindowclick.d() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.d() == 0 ? cursor.L() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.g() - clickedItem.L());
                                    if ((toPlace = Math.min(toPlace, slot.d.ac_() - clickedItem.L())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.L()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.L() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.L() < 0 || clickedItem.L() + cursor.L() > cursor.g()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packetplayinwindowclick.d() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.d() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.d() != 0 && packetplayinwindowclick.d() != 1) break;
                            if (packetplayinwindowclick.c() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.b.bR.b(packetplayinwindowclick.c());
                            if (slot != null && slot.a(this.b) && slot.f()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packetplayinwindowclick.d() < 0 || packetplayinwindowclick.d() >= 9) && packetplayinwindowclick.d() != 40) break;
                            click = packetplayinwindowclick.d() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.b.bR.b(packetplayinwindowclick.c());
                            if (clickedSlot.a(this.b)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.b.fN().a(packetplayinwindowclick.d());
                                boolean bl = canCleanSwap = hotbar.b() || clickedSlot.d == this.b.fN() && clickedSlot.a(hotbar);
                                if (clickedSlot.f()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.f() && !hotbar.b() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packetplayinwindowclick.d() == 2) {
                                click = ClickType.MIDDLE;
                                if (packetplayinwindowclick.c() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.b.bR.b(packetplayinwindowclick.c());
                                if (slot != null && slot.f() && this.b.fO().d && this.b.bR.g().b()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packetplayinwindowclick.c() >= 0) {
                                if (packetplayinwindowclick.d() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.b.bR.b(packetplayinwindowclick.c());
                                    if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.d() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.b.bR.b(packetplayinwindowclick.c());
                                if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packetplayinwindowclick.d() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            this.b.bR.a(packetplayinwindowclick.c(), packetplayinwindowclick.d(), packetplayinwindowclick.g(), this.b);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.c() < 0 || this.b.bR.g().b()) break;
                            ItemStack cursor = this.b.bR.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial(cursor.d())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial(cursor.d()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.g() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packetplayinwindowclick.c(), click, action, packetplayinwindowclick.d()) : new InventoryClickEvent(inventory, type, packetplayinwindowclick.c(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.c() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.c(), click, action, packetplayinwindowclick.d()) : new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.c(), click, action);
                        }
                        if (packetplayinwindowclick.c() == 2 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packetplayinwindowclick.c(), click, action, packetplayinwindowclick.d()) : new SmithItemEvent(inventory, type, packetplayinwindowclick.c(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.b.bR;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.b.bR != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case DEFAULT: 
                            case ALLOW: {
                                this.b.bR.a(i2, packetplayinwindowclick.d(), packetplayinwindowclick.g(), this.b);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.b.bR.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.b.c.a(new PacketPlayOutSetSlot(-1, -1, this.b.bQ.k(), this.b.bR.g()));
                                        this.b.c.a(new PacketPlayOutSetSlot(this.b.bR.j, this.b.bQ.k(), packetplayinwindowclick.c(), this.b.bR.b(packetplayinwindowclick.c()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.b.c.a(new PacketPlayOutSetSlot(this.b.bR.j, this.b.bQ.k(), packetplayinwindowclick.c(), this.b.bR.b(packetplayinwindowclick.c()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.b.c.a(new PacketPlayOutSetSlot(-1, -1, this.b.bQ.k(), this.b.bR.g()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.b.bR.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.f())) {
                        this.b.bR.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.b.bR.a(packetplayinwindowclick.e());
                    this.b.bR.i();
                    if (flag) {
                        this.b.bR.e();
                    } else {
                        this.b.bR.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packetplayinautorecipe) {
        PlayerConnectionUtils.a(packetplayinautorecipe, this, this.b.x());
        this.b.C();
        if (!this.b.G_() && this.b.bR.j == packetplayinautorecipe.a() && this.b.bR instanceof ContainerRecipeBook) {
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                this.i.aE().a(packetplayinautorecipe.c()).ifPresent(irecipe -> ((ContainerRecipeBook)this.b.bR).a(packetplayinautorecipe.d(), (IRecipe<?>)irecipe, this.b));
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packetplayinenchantitem) {
        PlayerConnectionUtils.a(packetplayinenchantitem, this, this.b.x());
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        if (this.b.bR.j == packetplayinenchantitem.a() && !this.b.G_()) {
            if (!this.b.bR.a(this.b)) {
                c.debug("Player {} interacted with invalid menu {}", (Object)this.b, (Object)this.b.bR);
            } else {
                boolean flag = this.b.bR.b(this.b, packetplayinenchantitem.c());
                if (flag) {
                    this.b.bR.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packetplayinsetcreativeslot) {
        PlayerConnectionUtils.a(packetplayinsetcreativeslot, this, this.b.x());
        if (this.b.e.e()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.a() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.c();
            if (!itemstack.a(this.b.dI().G())) {
                return;
            }
            NBTTagCompound nbttagcompound = ItemBlock.a(itemstack);
            if (!itemstack.b() && nbttagcompound != null && nbttagcompound.e("x") && nbttagcompound.e("y") && nbttagcompound.e("z") && this.b.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                TileEntity tileentity;
                BlockPosition blockposition = TileEntity.c(nbttagcompound);
                if (this.b.dI().o(blockposition) && (tileentity = this.b.dI().c_(blockposition)) != null) {
                    tileentity.e(itemstack);
                }
            }
            boolean flag1 = packetplayinsetcreativeslot.a() >= 1 && packetplayinsetcreativeslot.a() <= 45;
            boolean bl = flag2 = itemstack.b() || itemstack.k() >= 0 && itemstack.L() <= 64 && !itemstack.b();
            if (flag || flag1 && !ItemStack.a(this.b.bQ.b(packetplayinsetcreativeslot.a()).e(), packetplayinsetcreativeslot.c())) {
                CraftInventoryView inventory = this.b.bQ.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.c());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.a() < 36) {
                    type = packetplayinsetcreativeslot.a() >= 5 && packetplayinsetcreativeslot.a() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : packetplayinsetcreativeslot.a(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.a() >= 0) {
                            this.b.c.a(new PacketPlayOutSetSlot(this.b.bQ.j, this.b.bQ.k(), packetplayinsetcreativeslot.a(), this.b.bQ.b(packetplayinsetcreativeslot.a()).e()));
                            this.b.c.a(new PacketPlayOutSetSlot(-1, this.b.bQ.k(), -1, ItemStack.b));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.b.bQ.b(packetplayinsetcreativeslot.a()).d(itemstack);
                this.b.bQ.d();
            } else if (flag && flag2 && this.p < 200) {
                this.p += 20;
                this.b.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.d()).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.i);
    }

    private void a(PacketPlayInUpdateSign packetplayinupdatesign, List<FilteredText> list) {
        if (this.b.eT()) {
            return;
        }
        this.b.C();
        WorldServer worldserver = this.b.x();
        BlockPosition blockposition = packetplayinupdatesign.a();
        if (worldserver.A(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.b, packetplayinupdatesign.c(), list);
        }
    }

    @Override
    public void a(PacketPlayInKeepAlive packetplayinkeepalive) {
        PlayerConnectionUtils.a(packetplayinkeepalive, this, this.b.x());
        if (this.m && packetplayinkeepalive.a() == this.n) {
            int i2 = (int)(SystemUtils.b() - this.l);
            this.b.f = (this.b.f * 3 + i2) / 4;
            this.m = false;
        } else if (!this.g()) {
            this.b(IChatBaseComponent.c("disconnect.timeout"));
        }
    }

    @Override
    public void a(PacketPlayInAbilities packetplayinabilities) {
        PlayerConnectionUtils.a(packetplayinabilities, this, this.b.x());
        if (this.b.fO().c && this.b.fO().b != packetplayinabilities.a()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.b.getBukkitEntity(), packetplayinabilities.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.b.fO().b = packetplayinabilities.a();
            } else {
                this.b.w();
            }
        }
    }

    @Override
    public void a(PacketPlayInSettings packetplayinsettings) {
        PlayerConnectionUtils.a(packetplayinsettings, this, this.b.x());
        this.b.a(packetplayinsettings);
    }

    @Override
    public void a(PacketPlayInCustomPayload packetplayincustompayload) {
        PlayerConnectionUtils.a(packetplayincustompayload, this, this.b.x());
        if (packetplayincustompayload.c.equals(CUSTOM_REGISTER)) {
            try {
                String channels = packetplayincustompayload.d.toString(Charsets.UTF_8);
                String[] stringArray = channels.split("\u0000");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String channel = stringArray[n3];
                    this.getCraftPlayer().addChannel(channel);
                    ++n3;
                }
            }
            catch (Exception ex) {
                c.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!");
            }
        } else if (packetplayincustompayload.c.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = packetplayincustompayload.d.toString(Charsets.UTF_8);
                String[] stringArray = channels.split("\u0000");
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String channel = stringArray[n5];
                    this.getCraftPlayer().removeChannel(channel);
                    ++n5;
                }
            }
            catch (Exception ex) {
                c.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!");
            }
        } else {
            try {
                byte[] data = new byte[packetplayincustompayload.d.readableBytes()];
                packetplayincustompayload.d.readBytes(data);
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.b.getBukkitEntity(), packetplayincustompayload.c.toString(), data);
            }
            catch (Exception ex) {
                c.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!");
            }
        }
    }

    public final boolean isDisconnected() {
        return !this.b.joining && !this.h.h();
    }

    @Override
    public void a(PacketPlayInDifficultyChange packetplayindifficultychange) {
        PlayerConnectionUtils.a(packetplayindifficultychange, this, this.b.x());
        if (this.b.l(2) || this.g()) {
            this.i.a(packetplayindifficultychange.a(), false);
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packetplayindifficultylock) {
        PlayerConnectionUtils.a(packetplayindifficultylock, this, this.b.x());
        if (this.b.l(2) || this.g()) {
            this.i.b(packetplayindifficultylock.a());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PlayerConnectionUtils.a(serverboundchatsessionupdatepacket, this, this.b.x());
        RemoteChatSession.a remotechatsession_a = serverboundchatsessionupdatepacket.a();
        ProfilePublicKey.a profilepublickey_a = this.N != null ? this.N.e().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.b(ProfilePublicKey.a);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.i.an();
                    if (signaturevalidator == null) {
                        c.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.b.fM().getName());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.b.fM(), signaturevalidator, Duration.ZERO));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    c.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.b(profilepublickey_b.b());
                }
            }
        }
    }

    private void a(RemoteChatSession remotechatsession) {
        this.N = remotechatsession;
        this.O = remotechatsession.a(this.b.ct());
        this.R.append(executor -> {
            this.b.a(remotechatsession);
            this.i.ac().a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), List.of(this.b)));
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public EntityPlayer f() {
        return this.b;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

