/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import net.minecraft.util.LazyInitVar;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerConnection {
    private static final Logger d = LogUtils.getLogger();
    public static final LazyInitVar<NioEventLoopGroup> a = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).build()));
    public static final LazyInitVar<EpollEventLoopGroup> b = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).build()));
    final MinecraftServer e;
    public volatile boolean c;
    private final List<ChannelFuture> f = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> g = Collections.synchronizedList(Lists.newArrayList());

    public ServerConnection(MinecraftServer minecraftserver) {
        this.e = minecraftserver;
        this.c = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nullable InetAddress inetaddress, int i2) throws IOException {
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            LazyInitVar<NioEventLoopGroup> lazyinitvar;
            Class<NioServerSocketChannel> oclass;
            if (Epoll.isAvailable() && this.e.n()) {
                oclass = EpollServerSocketChannel.class;
                lazyinitvar = b;
                d.info("Using epoll channel type");
            } else {
                oclass = NioServerSocketChannel.class;
                lazyinitvar = a;
                d.info("Using default channel type");
            }
            this.f.add(((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(oclass)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this));
                    NetworkManager.a(channelpipeline, EnumProtocolDirection.a);
                    int j2 = ServerConnection.this.e.m();
                    NetworkManager object = j2 > 0 ? new NetworkManagerServer(j2) : new NetworkManager(EnumProtocolDirection.a);
                    ServerConnection.this.g.add(object);
                    channelpipeline.addLast("packet_handler", (ChannelHandler)object);
                    object.a(new HandshakeListener(ServerConnection.this.e, object));
                }
            }).group((EventLoopGroup)lazyinitvar.a()).localAddress(inetaddress, i2)).option(ChannelOption.AUTO_READ, (Object)false)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptConnections() {
        List<ChannelFuture> list = this.f;
        synchronized (list) {
            for (ChannelFuture future : this.f) {
                future.channel().config().setAutoRead(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress a() {
        ChannelFuture channelfuture;
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            channelfuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.a);
                    networkmanager.a(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.e, networkmanager));
                    ServerConnection.this.g.add(networkmanager);
                    ChannelPipeline channelpipeline = channel.pipeline();
                    channelpipeline.addLast("packet_handler", (ChannelHandler)networkmanager);
                }
            }).group((EventLoopGroup)a.a()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.f.add(channelfuture);
        }
        return channelfuture.channel().localAddress();
    }

    public void b() {
        this.c = false;
        for (ChannelFuture channelfuture : this.f) {
            try {
                channelfuture.channel().close().sync();
            }
            catch (InterruptedException interruptedexception) {
                d.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c() {
        List<NetworkManager> list = this.g;
        List<NetworkManager> list2 = this.g;
        synchronized (list2) {
            if (SpigotConfig.playerShuffle > 0 && MinecraftServer.currentTick % SpigotConfig.playerShuffle == 0) {
                Collections.shuffle(this.g);
            }
            Iterator<NetworkManager> iterator = this.g.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.i()) continue;
                if (networkmanager.h()) {
                    try {
                        networkmanager.a();
                    }
                    catch (Exception exception) {
                        if (networkmanager.d()) {
                            throw new ReportedException(CrashReport.a(exception, "Ticking memory connection"));
                        }
                        d.warn("Failed to handle packet for {}", (Object)networkmanager.c(), (Object)exception);
                        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b("Internal server error");
                        networkmanager.a(new PacketPlayOutKickDisconnect(ichatmutablecomponent), PacketSendListener.a(() -> networkmanager.a(ichatmutablecomponent)));
                        networkmanager.l();
                    }
                    continue;
                }
                if (networkmanager.preparing) continue;
                iterator.remove();
                networkmanager.m();
            }
        }
    }

    public MinecraftServer d() {
        return this.e;
    }

    public List<NetworkManager> e() {
        return this.g;
    }

    private static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer a = new HashedWheelTimer();
        private final int b;
        private final int c;
        private final List<DelayedMessage> d = Lists.newArrayList();

        public LatencySimulator(int i2, int j2) {
            this.b = i2;
            this.c = j2;
        }

        public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
            this.a(channelhandlercontext, object);
        }

        private void a(ChannelHandlerContext channelhandlercontext, Object object) {
            int i2 = this.b + (int)(Math.random() * (double)this.c);
            this.d.add(new DelayedMessage(channelhandlercontext, object));
            a.newTimeout(this::a, (long)i2, TimeUnit.MILLISECONDS);
        }

        private void a(Timeout timeout) {
            DelayedMessage serverconnection_latencysimulator_delayedmessage = this.d.remove(0);
            serverconnection_latencysimulator_delayedmessage.a.fireChannelRead(serverconnection_latencysimulator_delayedmessage.b);
        }

        private static class DelayedMessage {
            public final ChannelHandlerContext a;
            public final Object b;

            public DelayedMessage(ChannelHandlerContext channelhandlercontext, Object object) {
                this.a = channelhandlercontext;
                this.b = object;
            }
        }
    }
}

