/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.thread.ThreadedMailbox;
import org.slf4j.Logger;

public class TextFilter
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private static final AtomicInteger b = new AtomicInteger(1);
    private static final ThreadFactory c = var0 -> {
        Thread var1 = new Thread(var0);
        var1.setName("Chat-Filter-Worker-" + b.getAndIncrement());
        return var1;
    };
    private static final String d = "v1/chat";
    private final URL e;
    private final c f;
    final URL g;
    final b h;
    final URL i;
    final b j;
    private final String k;
    final a l;
    final ExecutorService m;

    private TextFilter(URL var0, c var1, URL var2, b var3, URL var4, b var5, String var6, a var7, int var8) {
        this.k = var6;
        this.l = var7;
        this.e = var0;
        this.f = var1;
        this.g = var2;
        this.h = var3;
        this.i = var4;
        this.j = var5;
        this.m = Executors.newFixedThreadPool(var8, c);
    }

    private static URL a(URI var0, @Nullable JsonObject var1, String var2, String var3) throws MalformedURLException {
        String var4 = TextFilter.a(var1, var2, var3);
        return var0.resolve("/" + var4).toURL();
    }

    private static String a(@Nullable JsonObject var0, String var1, String var2) {
        return var0 != null ? ChatDeserializer.a(var0, var1, var2) : var2;
    }

    @Nullable
    public static TextFilter a(String var0) {
        if (Strings.isNullOrEmpty((String)var0)) {
            return null;
        }
        try {
            Object var17;
            c var16;
            JsonObject var1 = ChatDeserializer.a(var0);
            URI var22 = new URI(ChatDeserializer.i(var1, "apiServer"));
            String var32 = ChatDeserializer.i(var1, "apiKey");
            if (var32.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int var42 = ChatDeserializer.a(var1, "ruleId", 1);
            String var5 = ChatDeserializer.a(var1, "serverId", "");
            String var6 = ChatDeserializer.a(var1, "roomId", "Java:Chat");
            int var7 = ChatDeserializer.a(var1, "hashesToDrop", -1);
            int var8 = ChatDeserializer.a(var1, "maxConcurrentRequests", 7);
            JsonObject var9 = ChatDeserializer.a(var1, "endpoints", null);
            String var10 = TextFilter.a(var9, "chat", d);
            boolean var11 = var10.equals(d);
            URL var12 = var22.resolve("/" + var10).toURL();
            URL var13 = TextFilter.a(var22, var9, "join", "v1/join");
            URL var14 = TextFilter.a(var22, var9, "leave", "v1/leave");
            b var15 = var2 -> {
                JsonObject var3 = new JsonObject();
                var3.addProperty("server", var5);
                var3.addProperty("room", var6);
                var3.addProperty("user_id", var2.getId().toString());
                var3.addProperty("user_display_name", var2.getName());
                return var3;
            };
            if (var11) {
                var16 = (var3, var4) -> {
                    JsonObject var5 = new JsonObject();
                    var5.addProperty("rule", (Number)var42);
                    var5.addProperty("server", var5);
                    var5.addProperty("room", var6);
                    var5.addProperty("player", var3.getId().toString());
                    var5.addProperty("player_display_name", var3.getName());
                    var5.addProperty("text", var4);
                    var5.addProperty("language", "*");
                    return var5;
                };
            } else {
                var17 = String.valueOf(var42);
                var16 = (arg_0, arg_1) -> TextFilter.a((String)var17, var5, var6, arg_0, arg_1);
            }
            var17 = net.minecraft.server.network.TextFilter$a.select(var7);
            String var18 = Base64.getEncoder().encodeToString(var32.getBytes(StandardCharsets.US_ASCII));
            return new TextFilter(var12, var16, var13, var15, var14, var15, var18, (a)var17, var8);
        }
        catch (Exception var1) {
            a.warn("Failed to parse chat filter config {}", (Object)var0, (Object)var1);
            return null;
        }
    }

    void a(GameProfile var0, URL var1, b var2, Executor var3) {
        var3.execute(() -> {
            JsonObject var3 = var2.encode(var0);
            try {
                this.b(var3, var1);
            }
            catch (Exception var4) {
                a.warn("Failed to send join/leave packet to {} for player {}", new Object[]{var1, var0, var4});
            }
        });
    }

    CompletableFuture<FilteredText> a(GameProfile var0, String var1, a var2, Executor var3) {
        if (var1.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.a);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject var3 = this.f.encode(var0, var1);
            try {
                JsonObject var4 = this.a(var3, this.e);
                boolean var5 = ChatDeserializer.a(var4, "response", false);
                if (var5) {
                    return FilteredText.a(var1);
                }
                String var6 = ChatDeserializer.a(var4, "hashed", null);
                if (var6 == null) {
                    return FilteredText.b(var1);
                }
                JsonArray var7 = ChatDeserializer.v(var4, "hashes");
                FilterMask var8 = this.a(var1, var7, var2);
                return new FilteredText(var1, var8);
            }
            catch (Exception var4) {
                a.warn("Failed to validate message '{}'", (Object)var1, (Object)var4);
                return FilteredText.b(var1);
            }
        }, var3);
    }

    private FilterMask a(String var0, JsonArray var1, a var2) {
        if (var1.isEmpty()) {
            return FilterMask.c;
        }
        if (var2.shouldIgnore(var0, var1.size())) {
            return FilterMask.b;
        }
        FilterMask var3 = new FilterMask(var0.length());
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            var3.a(var1.get(var4).getAsInt());
        }
        return var3;
    }

    @Override
    public void close() {
        this.m.shutdownNow();
    }

    private void a(InputStream var0) throws IOException {
        byte[] var1 = new byte[1024];
        while (var0.read(var1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject a(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.c(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            JsonObject jsonObject;
            if (var2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(var3, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.a(var3);
                throw throwable;
            }
            this.a(var3);
            return jsonObject;
        }
    }

    private void b(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.c(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            this.a(var3);
        }
    }

    private HttpURLConnection c(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = (HttpURLConnection)var1.openConnection();
        var2.setConnectTimeout(15000);
        var2.setReadTimeout(2000);
        var2.setUseCaches(false);
        var2.setDoOutput(true);
        var2.setDoInput(true);
        var2.setRequestMethod("POST");
        var2.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        var2.setRequestProperty("Accept", "application/json");
        var2.setRequestProperty("Authorization", "Basic " + this.k);
        var2.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.b().c());
        try (OutputStreamWriter var3 = new OutputStreamWriter(var2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter var4 = new JsonWriter((Writer)var3);){
            Streams.write((JsonElement)var0, (JsonWriter)var4);
        }
        int var5 = var2.getResponseCode();
        if (var5 < 200 || var5 >= 300) {
            throw new e(var5 + " " + var2.getResponseMessage());
        }
        return var2;
    }

    public ITextFilter a(GameProfile var0) {
        return new d(var0);
    }

    private static /* synthetic */ JsonObject a(String var0, String var1, String var2, GameProfile var3, String var4) {
        JsonObject var5 = new JsonObject();
        var5.addProperty("rule_id", var0);
        var5.addProperty("category", var1);
        var5.addProperty("subcategory", var2);
        var5.addProperty("user_id", var3.getId().toString());
        var5.addProperty("user_display_name", var3.getName());
        var5.addProperty("text", var4);
        var5.addProperty("language", "*");
        return var5;
    }

    @FunctionalInterface
    public static interface a {
        public static final a a = (var0, var1) -> false;
        public static final a b = (var0, var1) -> var0.length() == var1;

        public static a ignoreOverThreshold(int var0) {
            return (var1, var2) -> var2 >= var0;
        }

        public static a select(int var0) {
            return switch (var0) {
                case -1 -> a;
                case 0 -> b;
                default -> net.minecraft.server.network.TextFilter$a.ignoreOverThreshold(var0);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    static interface c {
        public JsonObject encode(GameProfile var1, String var2);
    }

    @FunctionalInterface
    static interface b {
        public JsonObject encode(GameProfile var1);
    }

    public static class e
    extends RuntimeException {
        e(String var0) {
            super(var0);
        }
    }

    class d
    implements ITextFilter {
        private final GameProfile c;
        private final Executor d;

        d(GameProfile var1) {
            this.c = var1;
            ThreadedMailbox<Runnable> var2 = ThreadedMailbox.a(TextFilter.this.m, "chat stream for " + var1.getName());
            this.d = var2::a;
        }

        @Override
        public void a() {
            TextFilter.this.a(this.c, TextFilter.this.g, TextFilter.this.h, this.d);
        }

        @Override
        public void b() {
            TextFilter.this.a(this.c, TextFilter.this.i, TextFilter.this.j, this.d);
        }

        @Override
        public CompletableFuture<List<FilteredText>> a(List<String> var02) {
            List var1 = (List)var02.stream().map(var0 -> TextFilter.this.a(this.c, (String)var0, TextFilter.this.l, this.d)).collect(ImmutableList.toImmutableList());
            return SystemUtils.c(var1).exceptionally(var0 -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<FilteredText> a(String var0) {
            return TextFilter.this.a(this.c, var0, TextFilter.this.l, this.d);
        }
    }
}

