/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class PathPackResources
extends ResourcePackAbstract {
    private static final Logger a = LogUtils.getLogger();
    private static final Joiner d = Joiner.on((String)"/");
    private final Path e;

    public PathPackResources(String var0, Path var1, boolean var2) {
        super(var0, var2);
        this.e = var1;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(String ... var0) {
        FileUtils.a(var0);
        Path var1 = FileUtils.a(this.e, List.of(var0));
        if (Files.exists(var1, new LinkOption[0])) {
            return IoSupplier.create(var1);
        }
        return null;
    }

    public static boolean a(Path var0) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(EnumResourcePackType var0, MinecraftKey var1) {
        Path var2 = this.e.resolve(var0.a()).resolve(var1.b());
        return PathPackResources.a(var1, var2);
    }

    public static IoSupplier<InputStream> a(MinecraftKey var0, Path var12) {
        return (IoSupplier)FileUtils.c(var0.a()).get().map(var1 -> {
            Path var2 = FileUtils.a(var12, var1);
            return PathPackResources.b(var2);
        }, var1 -> {
            a.error("Invalid path {}: {}", (Object)var0, (Object)var1.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> b(Path var0) {
        if (Files.exists(var0, new LinkOption[0]) && PathPackResources.a(var0)) {
            return IoSupplier.create(var0);
        }
        return null;
    }

    @Override
    public void a(EnumResourcePackType var0, String var12, String var2, IResourcePack.a var32) {
        FileUtils.c(var2).get().ifLeft(var3 -> {
            Path var4 = this.e.resolve(var0.a()).resolve(var12);
            PathPackResources.a(var12, var4, var3, var32);
        }).ifRight(var1 -> a.error("Invalid path {}: {}", (Object)var2, (Object)var1.message()));
    }

    public static void a(String var02, Path var12, List<String> var2, IResourcePack.a var32) {
        Path var4 = FileUtils.a(var12, var2);
        try (Stream<Path> var52 = Files.find(var4, Integer.MAX_VALUE, (var0, var1) -> var1.isRegularFile(), new FileVisitOption[0]);){
            var52.forEach(var3 -> {
                String var4 = d.join((Iterable)var12.relativize((Path)var3));
                MinecraftKey var5 = MinecraftKey.a(var02, var4);
                if (var5 == null) {
                    SystemUtils.a(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", var02, var4));
                } else {
                    var32.accept(var5, IoSupplier.create(var3));
                }
            });
        }
        catch (NoSuchFileException var52) {
        }
        catch (IOException var53) {
            a.error("Failed to list path {}", (Object)var4, (Object)var53);
        }
    }

    @Override
    public Set<String> a(EnumResourcePackType var0) {
        HashSet var1 = Sets.newHashSet();
        Path var2 = this.e.resolve(var0.a());
        try (DirectoryStream<Path> var32 = Files.newDirectoryStream(var2);){
            for (Path var5 : var32) {
                String var6 = var5.getFileName().toString();
                if (var6.equals(var6.toLowerCase(Locale.ROOT))) {
                    var1.add(var6);
                    continue;
                }
                a.warn("Ignored non-lowercase namespace: {} in {}", (Object)var6, (Object)this.e);
            }
        }
        catch (NoSuchFileException var32) {
        }
        catch (IOException var33) {
            a.error("Failed to list path {}", (Object)var2, (Object)var33);
        }
        return var1;
    }

    @Override
    public void close() {
    }
}

