/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    private static final Logger a = LogUtils.getLogger();
    private final Path b;
    private final EnumResourcePackType c;
    private final PackSource d;

    public ResourcePackSourceFolder(Path var0, EnumResourcePackType var1, PackSource var2) {
        this.b = var0;
        this.c = var1;
        this.d = var2;
    }

    private static String a(Path var0) {
        return var0.getFileName().toString();
    }

    @Override
    public void a(Consumer<ResourcePackLoader> var0) {
        try {
            FileUtils.c(this.b);
            ResourcePackSourceFolder.a(this.b, false, (Path var1, ResourcePackLoader.c var2) -> {
                String var3 = ResourcePackSourceFolder.a(var1);
                ResourcePackLoader var4 = ResourcePackLoader.a("file/" + var3, IChatBaseComponent.b(var3), false, var2, this.c, ResourcePackLoader.Position.a, this.d);
                if (var4 != null) {
                    var0.accept(var4);
                }
            });
        }
        catch (IOException var12) {
            a.warn("Failed to list packs in {}", (Object)this.b, (Object)var12);
        }
    }

    public static void a(Path var0, boolean var1, BiConsumer<Path, ResourcePackLoader.c> var2) throws IOException {
        try (DirectoryStream<Path> var3 = Files.newDirectoryStream(var0);){
            for (Path var5 : var3) {
                ResourcePackLoader.c var6 = ResourcePackSourceFolder.a(var5, var1);
                if (var6 == null) continue;
                var2.accept(var5, var6);
            }
        }
    }

    @Nullable
    public static ResourcePackLoader.c a(Path var0, boolean var1) {
        BasicFileAttributes var22;
        try {
            var22 = Files.readAttributes(var0, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException var3) {
            return null;
        }
        catch (IOException var3) {
            a.warn("Failed to read properties of '{}', ignoring", (Object)var0, (Object)var3);
            return null;
        }
        if (var22.isDirectory() && Files.isRegularFile(var0.resolve("pack.mcmeta"), new LinkOption[0])) {
            return var2 -> new PathPackResources(var2, var0, var1);
        }
        if (var22.isRegularFile() && var0.getFileName().toString().endsWith(".zip") && ((var3 = var0.getFileSystem()) == FileSystems.getDefault() || var3 instanceof LinkFileSystem)) {
            File var4 = var0.toFile();
            return var2 -> new ResourcePackFile(var2, var4, var1);
        }
        a.info("Found non-pack entry '{}', ignoring", (Object)var0);
        return null;
    }
}

