/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jline.console.completer.Completer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_20_R1.command.ConsoleCommandCompleter;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File b = new File("banned-players.json");
    public static final File c = new File("banned-ips.json");
    public static final File d = new File("ops.json");
    public static final File e = new File("whitelist.json");
    public static final IChatBaseComponent f = IChatBaseComponent.c("chat.filtered_full");
    private static final Logger a = LogUtils.getLogger();
    private static final int h = 600;
    private static final SimpleDateFormat i = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer j;
    public final List<EntityPlayer> k = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> l = Maps.newHashMap();
    private final GameProfileBanList m;
    private final IpBanList n;
    private final OpList o;
    private final WhiteList p;
    public final WorldNBTStorage s;
    private boolean t;
    private final LayeredRegistryAccess<RegistryLayer> u;
    private final IRegistryCustom.Dimension v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, WorldNBTStorage worldnbtstorage, int i2) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        minecraftserver.reader.addCompleter((Completer)new ConsoleCommandCompleter(minecraftserver.server));
        this.m = new GameProfileBanList(b);
        this.n = new IpBanList(c);
        this.o = new OpList(d);
        this.p = new WhiteList(e);
        this.j = minecraftserver;
        this.u = layeredregistryaccess;
        this.v = new IRegistryCustom.c(RegistrySynchronization.a(layeredregistryaccess)).c();
        this.g = i2;
        this.s = worldnbtstorage;
    }

    public void a(NetworkManager networkmanager, EntityPlayer entityplayer) {
        WorldServer worldserver1;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        String s2;
        GameProfile gameprofile = entityplayer.fM();
        UserCache usercache = this.j.ap();
        if (usercache != null) {
            Optional<GameProfile> optional = usercache.a(gameprofile.getId());
            s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
            usercache.a(gameprofile);
        } else {
            s2 = gameprofile.getName();
        }
        NBTTagCompound nbttagcompound = this.a(entityplayer);
        if (nbttagcompound != null && nbttagcompound.e("bukkit")) {
            NBTTagCompound bukkit = nbttagcompound.p("bukkit");
            String string = s2 = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : s2;
        }
        if (nbttagcompound != null) {
            DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("Dimension")));
            Logger logger = a;
            Objects.requireNonNull(logger);
            resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(net.minecraft.world.level.World.h);
        } else {
            resourcekey = net.minecraft.world.level.World.h;
        }
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = resourcekey;
        WorldServer worldserver = this.j.a(resourcekey1);
        if (worldserver == null) {
            a.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey1);
            worldserver1 = this.j.D();
        } else {
            worldserver1 = worldserver;
        }
        entityplayer.c(worldserver1);
        String s1 = "local";
        if (networkmanager.c() != null) {
            s1 = networkmanager.c().toString();
        }
        CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
        PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        entityplayer.spawnIn(worldserver1);
        entityplayer.e.a((WorldServer)entityplayer.dI());
        entityplayer.a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.u_();
        entityplayer.c(nbttagcompound);
        PlayerConnection playerconnection = new PlayerConnection(this.j, networkmanager, entityplayer);
        GameRules gamerules = worldserver1.X();
        boolean flag = gamerules.b(GameRules.B);
        boolean flag1 = gamerules.b(GameRules.p);
        playerconnection.a(new PacketPlayOutLogin(entityplayer.af(), worlddata.n(), entityplayer.e.b(), entityplayer.e.c(), this.j.E(), this.v, worldserver1.aa(), worldserver1.ac(), BiomeManager.a(worldserver1.A()), this.n(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, worldserver1.af(), worldserver1.z(), entityplayer.gm(), entityplayer.ar()));
        entityplayer.getBukkitEntity().sendSupportedChannels();
        playerconnection.a(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.c.b(worldserver1.G())));
        playerconnection.a(new PacketPlayOutCustomPayload(PacketPlayOutCustomPayload.a, new PacketDataSerializer(Unpooled.buffer()).a(this.c().getServerModName())));
        playerconnection.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        playerconnection.a(new PacketPlayOutAbilities(entityplayer.fO()));
        playerconnection.a(new PacketPlayOutHeldItemSlot(entityplayer.fN().l));
        playerconnection.a(new PacketPlayOutRecipeUpdate(this.j.aE().b()));
        playerconnection.a(new PacketPlayOutTags(TagNetworkSerialization.a(this.u)));
        this.d(entityplayer);
        entityplayer.D().c();
        entityplayer.E().a(entityplayer);
        this.a(worldserver1.f(), entityplayer);
        this.j.ar();
        IChatMutableComponent ichatmutablecomponent = entityplayer.fM().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", entityplayer.H_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", entityplayer.H_(), s2);
        ichatmutablecomponent.a(EnumChatFormat.o);
        String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
        playerconnection.a(entityplayer.dn(), entityplayer.dp(), entityplayer.dt(), entityplayer.dy(), entityplayer.dA());
        ServerPing serverping = this.j.aq();
        if (serverping != null) {
            entityplayer.a(serverping);
        }
        this.k.add(entityplayer);
        this.playersByName.put(entityplayer.cv().toLowerCase(Locale.ROOT), entityplayer);
        this.l.put(entityplayer.ct(), entityplayer);
        CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
        entityplayer.bR.transferTo(entityplayer.bR, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, joinMessage);
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!entityplayer.c.a()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            IChatBaseComponent[] iChatBaseComponentArray = CraftChatMessage.fromString(joinMessage);
            int n2 = iChatBaseComponentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IChatBaseComponent line = iChatBaseComponentArray[n3];
                this.j.ac().a(line, false);
                ++n3;
            }
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer));
        int i2 = 0;
        while (i2 < this.k.size()) {
            EntityPlayer entityplayer1 = this.k.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.c.a(packet);
            }
            if (bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) {
                entityplayer.c.a(ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer1)));
            }
            ++i2;
        }
        entityplayer.sentListPacket = true;
        entityplayer.aj().refresh(entityplayer);
        this.a(entityplayer, worldserver1);
        if (entityplayer.dI() == worldserver1 && !worldserver1.v().contains(entityplayer)) {
            worldserver1.c(entityplayer);
            this.j.aJ().a(entityplayer);
        }
        worldserver1 = entityplayer.x();
        this.j.S().ifPresent(minecraftserver_serverresourcepackinfo -> entityplayer.a(minecraftserver_serverresourcepackinfo.a(), minecraftserver_serverresourcepackinfo.b(), minecraftserver_serverresourcepackinfo.c(), minecraftserver_serverresourcepackinfo.d()));
        for (MobEffect mobeffect : entityplayer.eo()) {
            playerconnection.a(new PacketPlayOutEntityEffect(entityplayer.af(), mobeffect));
        }
        if (nbttagcompound != null && nbttagcompound.b("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.a(nbttagcompound1.p("Entity"), finalWorldServer, entity1 -> !finalWorldServer.c((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound1.b("Attach") ? nbttagcompound1.a("Attach") : null;
                if (entity.ct().equals(uuid)) {
                    entityplayer.a(entity, true);
                } else {
                    for (Entity entity12 : entity.cR()) {
                        if (!entity12.ct().equals(uuid)) continue;
                        entityplayer.a(entity12, true);
                        break;
                    }
                }
                if (!entityplayer.bM()) {
                    a.warn("Couldn't reattach entity to player");
                    entity.ai();
                    for (Entity entity12 : entity.cR()) {
                        entity12.ai();
                    }
                }
            }
        }
        entityplayer.h();
        a.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.Z().getString(), s1, entityplayer.af(), worldserver1.K.g(), entityplayer.dn(), entityplayer.dp(), entityplayer.dt()});
    }

    public void a(ScoreboardServer scoreboardserver, EntityPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboardserver.g()) {
            entityplayer.c.a(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        int i2 = 0;
        while (i2 < 19) {
            ScoreboardObjective scoreboardobjective = scoreboardserver.a(i2);
            if (scoreboardobjective != null && !set.contains(scoreboardobjective)) {
                List<Packet<?>> list = scoreboardserver.d(scoreboardobjective);
                for (Packet<?> packet : list) {
                    entityplayer.c.a(packet);
                }
                set.add(scoreboardobjective);
            }
            ++i2;
        }
    }

    public void a(WorldServer worldserver) {
        if (this.s != null) {
            return;
        }
        worldserver.w_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
    }

    @Nullable
    public NBTTagCompound a(EntityPlayer entityplayer) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = this.j.aU().y();
        if (this.j.a(entityplayer.fM()) && nbttagcompound != null) {
            nbttagcompound1 = nbttagcompound;
            entityplayer.g(nbttagcompound);
            a.debug("loading single player");
        } else {
            nbttagcompound1 = this.s.b(entityplayer);
        }
        return nbttagcompound1;
    }

    protected void b(EntityPlayer entityplayer) {
        AdvancementDataPlayer advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.s.a(entityplayer);
        ServerStatisticManager serverstatisticmanager = entityplayer.D();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = entityplayer.M()) != null) {
            advancementdataplayer.b();
        }
    }

    public String remove(EntityPlayer entityplayer) {
        Entity entity;
        WorldServer worldserver = entityplayer.x();
        entityplayer.a(StatisticList.j);
        if (entityplayer.bR != entityplayer.bQ) {
            entityplayer.q();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.cv() + " left the game");
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.m();
        this.b(entityplayer);
        if (entityplayer.bM() && (entity = entityplayer.cT()).cS()) {
            a.debug("Removing player mount");
            entityplayer.Y();
            entity.cQ().forEach(entity1 -> entity1.b(Entity.RemovalReason.d));
        }
        entityplayer.ac();
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.M().a();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cv().toLowerCase(Locale.ROOT));
        this.j.aJ().b(entityplayer);
        UUID uuid = entityplayer.ct();
        EntityPlayer entityplayer1 = this.l.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.l.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.ct()));
        int i2 = 0;
        while (i2 < this.k.size()) {
            EntityPlayer entityplayer2 = this.k.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.c.a(packet);
            } else {
                entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
            }
            ++i2;
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        UUID uuid = UUIDUtil.a(gameprofile);
        ArrayList list = Lists.newArrayList();
        int i2 = 0;
        while (i2 < this.k.size()) {
            EntityPlayer entityplayer = this.k.get(i2);
            if (entityplayer.ct().equals(uuid)) {
                list.add(entityplayer);
            }
            ++i2;
        }
        for (EntityPlayer entityplayer : list) {
            this.b(entityplayer);
            entityplayer.c.b(IChatBaseComponent.c("multiplayer.disconnect.duplicate_login"));
        }
        SocketAddress socketaddress = loginlistener.g.c();
        EntityPlayer entity = new EntityPlayer(this.j, this.j.a(net.minecraft.world.level.World.h), gameprofile);
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.m.remoteAddress()).getAddress());
        if (this.f().a(gameprofile) && !((GameProfileBanEntry)this.f().b(gameprofile)).f()) {
            GameProfileBanEntry gameprofilebanentry = (GameProfileBanEntry)this.m.b(gameprofile);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.d()});
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{i.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.c(gameprofile)) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.g().a(socketaddress) && !this.g().b(socketaddress).f()) {
            IpBanEntry ipbanentry = this.n.b(socketaddress);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.d()});
            if (ipbanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{i.format(ipbanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (this.k.size() >= this.g && !this.d(gameprofile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, EntityPlayer player) {
        return player;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, this.j.a(entityplayer.P()), flag, null, true, reason);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, WorldServer worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnReason reason) {
        entityplayer.Y();
        this.k.remove(entityplayer);
        this.playersByName.remove(entityplayer.cv().toLowerCase(Locale.ROOT));
        entityplayer.x().a(entityplayer, Entity.RemovalReason.b);
        BlockPosition blockposition = entityplayer.N();
        float f2 = entityplayer.O();
        boolean flag1 = entityplayer.Q();
        EntityPlayer entityplayer1 = entityplayer;
        World fromWorld = entityplayer.getBukkitEntity().getWorld();
        entityplayer.g = false;
        entityplayer1.c = entityplayer.c;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.af());
        entityplayer1.a(entityplayer.fh());
        for (String s2 : entityplayer.ag()) {
            entityplayer1.a(s2);
        }
        boolean flag2 = false;
        if (location == null) {
            boolean isBedSpawn = false;
            WorldServer worldserver1 = this.j.a(entityplayer.P());
            if (worldserver1 != null) {
                Optional<Object> optional = blockposition != null ? EntityHuman.a(worldserver1, blockposition, f2, flag1, flag) : Optional.empty();
                if (optional.isPresent()) {
                    float f1;
                    IBlockData iblockdata = worldserver1.a_(blockposition);
                    boolean flag3 = iblockdata.a(Blocks.pl);
                    Vec3D vec3d = (Vec3D)optional.get();
                    if (!iblockdata.a(TagsBlock.R) && !flag3) {
                        f1 = f2;
                    } else {
                        Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                        f1 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                    }
                    flag2 = !flag && flag3;
                    isBedSpawn = true;
                    location = CraftLocation.toBukkit(vec3d, (World)worldserver1.getWorld(), f1, 0.0f);
                } else if (blockposition != null) {
                    entityplayer1.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.a, 0.0f));
                    entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSpawnChangeEvent.Cause.RESET);
                }
            }
            if (location == null) {
                worldserver1 = this.j.a(net.minecraft.world.level.World.h);
                blockposition = entityplayer1.getSpawnPoint(worldserver1);
                location = CraftLocation.toBukkit(blockposition, (World)worldserver1.getWorld()).add(0.5, (double)0.1f, 0.5);
            }
            CraftPlayer respawnPlayer = entityplayer1.getBukkitEntity();
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn && !flag2, flag2, reason);
            this.cserver.getPluginManager().callEvent((Event)respawnEvent);
            if (entityplayer.c.isDisconnected()) {
                return entityplayer;
            }
            location = respawnEvent.getRespawnLocation();
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            location.setWorld((World)worldserver.getWorld());
        }
        WorldServer worldserver1 = ((CraftWorld)location.getWorld()).getHandle();
        entityplayer1.forceSetPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        while (avoidSuffocation && !worldserver1.g(entityplayer1) && entityplayer1.dp() < (double)worldserver1.aj()) {
            entityplayer1.e(entityplayer1.dn(), entityplayer1.dp() + 1.0, entityplayer1.dt());
        }
        boolean i2 = flag;
        WorldData worlddata = worldserver1.u_();
        entityplayer1.c.a(new PacketPlayOutRespawn(worldserver1.aa(), worldserver1.ac(), BiomeManager.a(worldserver1.A()), entityplayer1.e.b(), entityplayer1.e.c(), worldserver1.af(), worldserver1.z(), (byte)(i2 ? 1 : 0), entityplayer1.gm(), entityplayer1.ar()));
        entityplayer1.c.a(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.c.a(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.spawnIn(worldserver1);
        entityplayer1.dF();
        entityplayer1.c.teleport(CraftLocation.toBukkit(entityplayer1.dg(), (World)worldserver1.getWorld(), entityplayer1.dy(), entityplayer1.dA()));
        entityplayer1.f(false);
        entityplayer1.c.a(new PacketPlayOutSpawnPosition(worldserver1.R(), worldserver1.S()));
        entityplayer1.c.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        entityplayer1.c.a(new PacketPlayOutExperience(entityplayer1.cg, entityplayer1.cf, entityplayer1.ce));
        this.a(entityplayer1, worldserver1);
        this.d(entityplayer1);
        if (!entityplayer.c.isDisconnected()) {
            worldserver1.d(entityplayer1);
            this.k.add(entityplayer1);
            this.playersByName.put(entityplayer1.cv().toLowerCase(Locale.ROOT), entityplayer1);
            this.l.put(entityplayer1.ct(), entityplayer1);
        }
        entityplayer1.t(entityplayer1.er());
        if (flag2) {
            entityplayer1.c.a(new PacketPlayOutNamedSoundEffect(SoundEffects.tL, SoundCategory.e, blockposition.u(), blockposition.v(), blockposition.w(), 1.0f, 1.0f, worldserver1.y_().g()));
        }
        this.e(entityplayer);
        entityplayer.w();
        for (MobEffect mobEffect : entityplayer.eo()) {
            entityplayer.c.a(new PacketPlayOutEntityEffect(entityplayer.af(), mobEffect));
        }
        entityplayer.e(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), fromWorld);
            this.j.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.c.isDisconnected()) {
            this.b(entityplayer);
        }
        return entityplayer1;
    }

    public void d(EntityPlayer entityplayer) {
        GameProfile gameprofile = entityplayer.fM();
        int i2 = this.j.c(gameprofile);
        this.a(entityplayer, i2);
    }

    public void d() {
        if (++this.A > 600) {
            int i2 = 0;
            while (i2 < this.k.size()) {
                final EntityPlayer target = this.k.get(i2);
                target.c.a(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.k.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
                ++i2;
            }
            this.A = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.c.a(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        int i2 = 0;
        while (i2 < this.k.size()) {
            EntityPlayer entityplayer = this.k.get(i2);
            if (entityhuman == null || entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) {
                this.k.get((int)i2).c.a(packet);
            }
            ++i2;
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        int i2 = 0;
        while (i2 < world.v().size()) {
            ((EntityPlayer)world.v().get((int)i2)).c.a(packet);
            ++i2;
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> resourcekey) {
        for (EntityPlayer entityplayer : this.k) {
            if (entityplayer.dI().ac() != resourcekey) continue;
            entityplayer.c.a(packet);
        }
    }

    public void a(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeamBase scoreboardteambase = entityhuman.cd();
        if (scoreboardteambase != null) {
            Collection<String> collection = scoreboardteambase.g();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public void b(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeamBase scoreboardteambase = entityhuman.cd();
        if (scoreboardteambase == null) {
            this.a(ichatbasecomponent, false);
        } else {
            int i2 = 0;
            while (i2 < this.k.size()) {
                EntityPlayer entityplayer = this.k.get(i2);
                if (entityplayer.cd() != scoreboardteambase) {
                    entityplayer.a(ichatbasecomponent);
                }
                ++i2;
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.k.size()];
        int i2 = 0;
        while (i2 < this.k.size()) {
            astring[i2] = this.k.get(i2).fM().getName();
            ++i2;
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.m;
    }

    public IpBanList g() {
        return this.n;
    }

    public void a(GameProfile gameprofile) {
        this.o.a(new OpListEntry(gameprofile, this.j.i(), this.o.a(gameprofile)));
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    public void b(GameProfile gameprofile) {
        this.o.c(gameprofile);
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    private void a(EntityPlayer entityplayer, int i2) {
        if (entityplayer.c != null) {
            byte b0 = i2 <= 0 ? (byte)24 : (i2 >= 4 ? (byte)28 : (byte)((byte)(24 + i2)));
            entityplayer.c.a(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.j.aC().a(entityplayer);
    }

    public boolean c(GameProfile gameprofile) {
        return !this.t || this.o.d(gameprofile) || this.p.d(gameprofile);
    }

    public boolean f(GameProfile gameprofile) {
        return this.o.d(gameprofile) || this.j.a(gameprofile) && this.j.aU().o() || this.y;
    }

    @Nullable
    public EntityPlayer a(String s2) {
        return this.playersByName.get(s2.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, double d3, ResourceKey<net.minecraft.world.level.World> resourcekey, Packet<?> packet) {
        int i2 = 0;
        while (i2 < this.k.size()) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.k.get(i2);
            if ((entityhuman == null || entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) && entityplayer != entityhuman && entityplayer.dI().ac() == resourcekey && (d4 = d0 - entityplayer.dn()) * d4 + (d5 = d1 - entityplayer.dp()) * d5 + (d6 = d2 - entityplayer.dt()) * d6 < d3 * d3) {
                entityplayer.c.a(packet);
            }
            ++i2;
        }
    }

    public void h() {
        int i2 = 0;
        while (i2 < this.k.size()) {
            this.b(this.k.get(i2));
            ++i2;
        }
    }

    public WhiteList i() {
        return this.p;
    }

    public String[] j() {
        return this.p.a();
    }

    public OpList k() {
        return this.o;
    }

    public String[] l() {
        return this.o.a();
    }

    public void a() {
    }

    public void a(EntityPlayer entityplayer, WorldServer worldserver) {
        WorldBorder worldborder = entityplayer.dI().w_();
        entityplayer.c.a(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.c.a(new PacketPlayOutUpdateTime(worldserver.V(), worldserver.W(), worldserver.X().b(GameRules.k)));
        entityplayer.c.a(new PacketPlayOutSpawnPosition(worldserver.R(), worldserver.S()));
        if (worldserver.Z()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.w, worldserver.w, -worldserver.y, worldserver.y);
        }
    }

    public void e(EntityPlayer entityplayer) {
        entityplayer.bQ.b();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.aj().refresh(entityplayer);
        entityplayer.c.a(new PacketPlayOutHeldItemSlot(entityplayer.fN().l));
        int i2 = entityplayer.dI().X().b(GameRules.p) ? 22 : 23;
        entityplayer.c.a(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        float immediateRespawn = entityplayer.dI().X().b(GameRules.B) ? 1.0f : 0.0f;
        entityplayer.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, immediateRespawn));
    }

    public int m() {
        return this.k.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.t;
    }

    public void a(boolean flag) {
        this.t = flag;
    }

    public List<EntityPlayer> b(String s2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.k) {
            if (!entityplayer.y().equals(s2)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.j;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean flag) {
        this.y = flag;
    }

    public void s() {
        for (EntityPlayer player : this.k) {
            player.c.disconnect(this.j.server.getShutdownMessage());
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        IChatBaseComponent[] iChatBaseComponentArray = iChatBaseComponents;
        int n2 = iChatBaseComponents.length;
        int n3 = 0;
        while (n3 < n2) {
            IChatBaseComponent component = iChatBaseComponentArray[n3];
            this.a(component, false);
            ++n3;
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.a(ichatbasecomponent, (EntityPlayer entityplayer) -> ichatbasecomponent, flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent, Function<EntityPlayer, IChatBaseComponent> function, boolean flag) {
        this.j.a(ichatbasecomponent);
        for (EntityPlayer entityplayer : this.k) {
            IChatBaseComponent ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, flag);
        }
    }

    public void a(PlayerChatMessage playerchatmessage, CommandListenerWrapper commandlistenerwrapper, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.a(playerchatmessage, commandlistenerwrapper::a, commandlistenerwrapper.i(), chatmessagetype_a);
    }

    public void a(PlayerChatMessage playerchatmessage, EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.a(playerchatmessage, entityplayer::b, entityplayer, chatmessagetype_a);
    }

    private void a(PlayerChatMessage playerchatmessage, Predicate<EntityPlayer> predicate, @Nullable EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        boolean flag = this.a(playerchatmessage);
        this.j.a(playerchatmessage.c(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(playerchatmessage);
        boolean flag1 = false;
        for (EntityPlayer entityplayer1 : this.k) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.a(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.i();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.a(f);
        }
    }

    private boolean a(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.h() && !playerchatmessage.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.D();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.ct(), entityhuman.H_().getString()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.D();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.j.a(SavedFile.b).toFile();
            File file1 = new File(file, uuid + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, String.valueOf(displayName) + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.j, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer f(EntityPlayer entityplayer) {
        UUID uuid = entityplayer.ct();
        AdvancementDataPlayer advancementdataplayer = entityplayer.M();
        if (advancementdataplayer == null) {
            Path path = this.j.a(SavedFile.a).resolve(uuid + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.j.ay(), this, this.j.az(), path, entityplayer);
        }
        advancementdataplayer.a(entityplayer);
        return advancementdataplayer;
    }

    public void a(int i2) {
        this.w = i2;
        this.a(new PacketPlayOutViewDistance(i2));
        for (WorldServer worldserver : this.j.F()) {
            if (worldserver == null) continue;
            worldserver.k().a(i2);
        }
    }

    public void b(int i2) {
        this.x = i2;
        this.a(new ClientboundSetSimulationDistancePacket(i2));
        for (WorldServer worldserver : this.j.F()) {
            if (worldserver == null) continue;
            worldserver.k().b(i2);
        }
    }

    public List<EntityPlayer> t() {
        return this.k;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.l.get(uuid);
    }

    public boolean d(GameProfile gameprofile) {
        return false;
    }

    public void u() {
        for (EntityPlayer player : this.k) {
            player.M().a(this.j.az());
            player.M().b(player);
        }
        this.a(new PacketPlayOutTags(TagNetworkSerialization.a(this.u)));
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.j.aE().b());
        for (EntityPlayer entityplayer : this.k) {
            entityplayer.c.a(packetplayoutrecipeupdate);
            entityplayer.E().a(entityplayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

