/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterMinecart
extends DataFix {
    private static final List<String> a = Lists.newArrayList((Object[])new String[]{"MinecartRideable", "MinecartChest", "MinecartFurnace"});

    public DataConverterMinecart(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType var0 = this.getInputSchema().findChoiceType(DataConverterTypes.q);
        TaggedChoice.TaggedChoiceType var1 = this.getOutputSchema().findChoiceType(DataConverterTypes.q);
        return this.fixTypeEverywhere("EntityMinecartIdentifiersFix", (Type)var0, (Type)var1, var2 -> var3 -> {
            if (Objects.equals(var3.getFirst(), "Minecart")) {
                Typed var4 = (Typed)var0.point(var2, (Object)"Minecart", var3.getSecond()).orElseThrow(IllegalStateException::new);
                Dynamic var5 = (Dynamic)var4.getOrCreate(DSL.remainderFinder());
                int var7 = var5.get("Type").asInt(0);
                String var6 = var7 > 0 && var7 < a.size() ? a.get(var7) : "MinecartRideable";
                return Pair.of((Object)var6, (Object)((DataResult)var4.write().map(var2 -> ((Type)var1.types().get(var6)).read(var2)).result().orElseThrow(() -> new IllegalStateException("Could not read the new minecart."))));
            }
            return var3;
        });
    }
}

