/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String b = "bytesPerSecond";
    private static final String c = "count";
    private static final String d = "durationNanosTotal";
    private static final String e = "totalBytes";
    private static final String f = "countPerSecond";
    final Gson a = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    public String a(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("startedEpoch", (Number)var0.c().toEpochMilli());
        var1.addProperty("endedEpoch", (Number)var0.d().toEpochMilli());
        var1.addProperty("durationMs", (Number)var0.e().toMillis());
        Duration var2 = var0.f();
        if (var2 != null) {
            var1.addProperty("worldGenDurationMs", (Number)var2.toMillis());
        }
        var1.add("heap", this.a(var0.i()));
        var1.add("cpuPercent", this.c(var0.h()));
        var1.add("network", this.c(var0));
        var1.add("fileIO", this.b(var0));
        var1.add("serverTick", this.b(var0.g()));
        var1.add("threadAllocation", this.a(var0.j()));
        var1.add("chunkGen", this.a(var0.a()));
        return this.a.toJson((JsonElement)var1);
    }

    private JsonElement a(GcHeapStat.a var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("allocationRateBytesPerSecond", (Number)var0.e());
        var1.addProperty("gcCount", (Number)var0.d());
        var1.addProperty("gcOverHeadPercent", (Number)Float.valueOf(var0.a()));
        var1.addProperty("gcTotalDurationMs", (Number)var0.c().toMillis());
        return var1;
    }

    private JsonElement a(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> var02) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(d, (Number)var02.stream().mapToDouble(var0 -> ((TimedStatSummary)var0.getSecond()).f().toNanos()).sum());
        JsonArray var22 = SystemUtils.a(new JsonArray(), (T var1) -> var12.add("status", (JsonElement)var1));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> var4 : var02) {
            TimedStatSummary var5 = (TimedStatSummary)var4.getSecond();
            JsonObject var6 = SystemUtils.a(new JsonObject(), arg_0 -> ((JsonArray)var22).add(arg_0));
            var6.addProperty("state", ((ChunkStatus)var4.getFirst()).toString());
            var6.addProperty(c, (Number)var5.d());
            var6.addProperty(d, (Number)var5.f().toNanos());
            var6.addProperty("durationNanosAvg", (Number)(var5.f().toNanos() / (long)var5.d()));
            JsonObject var7 = SystemUtils.a(new JsonObject(), (T var1) -> var6.add("durationNanosPercentiles", (JsonElement)var1));
            var5.e().forEach((var1, var2) -> var7.addProperty("p" + var1, (Number)var2));
            Function<ChunkGenStat, JsonElement> var8 = var0 -> {
                JsonObject var1 = new JsonObject();
                var1.addProperty("durationNanos", (Number)var0.a().toNanos());
                var1.addProperty("level", var0.e());
                var1.addProperty("chunkPosX", (Number)var0.b().e);
                var1.addProperty("chunkPosZ", (Number)var0.b().f);
                var1.addProperty("worldPosX", (Number)var0.c().c());
                var1.addProperty("worldPosZ", (Number)var0.c().d());
                return var1;
            };
            var6.add("fastest", var8.apply((ChunkGenStat)var5.a()));
            var6.add("slowest", var8.apply((ChunkGenStat)var5.b()));
            var6.add("secondSlowest", (JsonElement)(var5.c() != null ? var8.apply((ChunkGenStat)var5.c()) : JsonNull.INSTANCE));
        }
        return var12;
    }

    private JsonElement a(ThreadAllocationStat.a var0) {
        JsonArray var12 = new JsonArray();
        var0.a().forEach((var1, var22) -> var12.add((JsonElement)SystemUtils.a(new JsonObject(), (T var2) -> {
            var2.addProperty("thread", var1);
            var2.addProperty(b, (Number)var22);
        })));
        return var12;
    }

    private JsonElement b(List<TickTimeStat> var02) {
        if (var02.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject var12 = new JsonObject();
        double[] var22 = var02.stream().mapToDouble(var0 -> (double)var0.b().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics var3 = DoubleStream.of(var22).summaryStatistics();
        var12.addProperty("minMs", (Number)var3.getMin());
        var12.addProperty("averageMs", (Number)var3.getAverage());
        var12.addProperty("maxMs", (Number)var3.getMax());
        Map<Integer, Double> var4 = Percentiles.a(var22);
        var4.forEach((var1, var2) -> var12.addProperty("p" + var1, (Number)var2));
        return var12;
    }

    private JsonElement b(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("write", this.a(var0.m()));
        var1.add("read", this.a(var0.n()));
        return var1;
    }

    private JsonElement a(FileIOStat.a var0) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(e, (Number)var0.a());
        var12.addProperty(c, (Number)var0.c());
        var12.addProperty(b, (Number)var0.b());
        var12.addProperty(f, (Number)var0.d());
        JsonArray var2 = new JsonArray();
        var12.add("topContributors", (JsonElement)var2);
        var0.f().forEach(var1 -> {
            JsonObject var2 = new JsonObject();
            var2.add((JsonElement)var2);
            var2.addProperty("path", (String)var1.getFirst());
            var2.addProperty(e, (Number)var1.getSecond());
        });
        return var12;
    }

    private JsonElement c(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("sent", this.a(var0.l()));
        var1.add("received", this.a(var0.k()));
        return var1;
    }

    private JsonElement a(NetworkPacketSummary var0) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(e, (Number)var0.d());
        var12.addProperty(c, (Number)var0.c());
        var12.addProperty(b, (Number)var0.b());
        var12.addProperty(f, (Number)var0.a());
        JsonArray var2 = new JsonArray();
        var12.add("topContributors", (JsonElement)var2);
        var0.e().forEach(var1 -> {
            JsonObject var2 = new JsonObject();
            var2.add((JsonElement)var2);
            NetworkPacketSummary.b var3 = (NetworkPacketSummary.b)var1.getFirst();
            NetworkPacketSummary.a var4 = (NetworkPacketSummary.a)var1.getSecond();
            var2.addProperty("protocolId", (Number)var3.c());
            var2.addProperty("packetId", (Number)var3.d());
            var2.addProperty("packetName", var3.a());
            var2.addProperty(e, (Number)var4.b());
            var2.addProperty(c, (Number)var4.a());
        });
        return var12;
    }

    private JsonElement c(List<CpuLoadStat> var02) {
        JsonObject var12 = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> var2 = (var0, var1) -> {
            JsonObject var2 = new JsonObject();
            DoubleSummaryStatistics var3 = var0.stream().mapToDouble(var1).summaryStatistics();
            var2.addProperty("min", (Number)var3.getMin());
            var2.addProperty("average", (Number)var3.getAverage());
            var2.addProperty("max", (Number)var3.getMax());
            return var2;
        };
        var12.add("jvm", (JsonElement)var2.apply(var02, CpuLoadStat::a));
        var12.add("userJvm", (JsonElement)var2.apply(var02, CpuLoadStat::b));
        var12.add("system", (JsonElement)var2.apply(var02, CpuLoadStat::c));
        return var12;
    }
}

