/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class UniformFloat
extends FloatProvider {
    public static final Codec<UniformFloat> a = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(var0 -> Float.valueOf(var0.b)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(var0 -> Float.valueOf(var0.d))).apply((Applicative)var02, UniformFloat::new)).comapFlatMap(var0 -> {
        if (var0.d <= var0.b) {
            return DataResult.error(() -> "Max must be larger than min, min_inclusive: " + var0.b + ", max_exclusive: " + var0.d);
        }
        return DataResult.success((Object)var0);
    }, Function.identity());
    private final float b;
    private final float d;

    private UniformFloat(float var0, float var1) {
        this.b = var0;
        this.d = var1;
    }

    public static UniformFloat b(float var0, float var1) {
        if (var1 <= var0) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(var0, var1);
    }

    @Override
    public float a(RandomSource var0) {
        return MathHelper.b(var0, this.b, this.d);
    }

    @Override
    public float a() {
        return this.b;
    }

    @Override
    public float b() {
        return this.d;
    }

    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.b;
    }

    public String toString() {
        return "[" + this.b + "-" + this.d + "]";
    }
}

