/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class MobEffectList {
    private final Map<AttributeBase, AttributeModifier> a = Maps.newHashMap();
    private final MobEffectInfo b;
    private final int c;
    @Nullable
    private String d;
    private Supplier<MobEffect.a> e = () -> null;

    @Nullable
    public static MobEffectList a(int i2) {
        return (MobEffectList)BuiltInRegistries.e.a(i2);
    }

    public static int a(MobEffectList mobeffectlist) {
        return BuiltInRegistries.e.a(mobeffectlist);
    }

    public static int b(@Nullable MobEffectList mobeffectlist) {
        return BuiltInRegistries.e.a(mobeffectlist);
    }

    protected MobEffectList(MobEffectInfo mobeffectinfo, int i2) {
        this.b = mobeffectinfo;
        this.c = i2;
    }

    public Optional<MobEffect.a> b() {
        return Optional.ofNullable(this.e.get());
    }

    public void a(EntityLiving entityliving, int i2) {
        if (this == MobEffects.j) {
            if (entityliving.er() < entityliving.eI()) {
                entityliving.heal(1.0f, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN);
            }
        } else if (this == MobEffects.s) {
            if (entityliving.er() > 1.0f) {
                entityliving.a(entityliving.dJ().poison, 1.0f);
            }
        } else if (this == MobEffects.t) {
            entityliving.a(entityliving.dJ().p(), 1.0f);
        } else if (this == MobEffects.q && entityliving instanceof EntityHuman) {
            ((EntityHuman)entityliving).causeFoodExhaustion(0.005f * (float)(i2 + 1), EntityExhaustionEvent.ExhaustionReason.HUNGER_EFFECT);
        } else if (this == MobEffects.w && entityliving instanceof EntityHuman) {
            if (!entityliving.dI().B) {
                EntityHuman entityhuman = (EntityHuman)entityliving;
                int oldFoodLevel = entityhuman.fX().a;
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityhuman, i2 + 1 + oldFoodLevel);
                if (!event.isCancelled()) {
                    entityhuman.fX().a(event.getFoodLevel() - oldFoodLevel, 1.0f);
                }
                ((EntityPlayer)entityhuman).c.a(new PacketPlayOutUpdateHealth(((EntityPlayer)entityhuman).getBukkitEntity().getScaledHealth(), entityhuman.fX().a, entityhuman.fX().b));
            }
        } else if (!(this == MobEffects.f && !entityliving.eq() || this == MobEffects.g && entityliving.eq())) {
            if (this == MobEffects.g && !entityliving.eq() || this == MobEffects.f && entityliving.eq()) {
                entityliving.a(entityliving.dJ().o(), (float)(6 << i2));
            }
        } else {
            entityliving.heal(Math.max(4 << i2, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public void a(@Nullable Entity entity, @Nullable Entity entity1, EntityLiving entityliving, int i2, double d0) {
        if (!(this == MobEffects.f && !entityliving.eq() || this == MobEffects.g && entityliving.eq())) {
            if (!(this == MobEffects.g && !entityliving.eq() || this == MobEffects.f && entityliving.eq())) {
                this.a(entityliving, i2);
            } else {
                int j2 = (int)(d0 * (double)(6 << i2) + 0.5);
                if (entity == null) {
                    entityliving.a(entityliving.dJ().o(), (float)j2);
                } else {
                    entityliving.a(entityliving.dJ().c(entity, entity1), (float)j2);
                }
            }
        } else {
            int j3 = (int)(d0 * (double)(4 << i2) + 0.5);
            entityliving.heal(j3, EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public boolean a(int i2, int j2) {
        if (this == MobEffects.j) {
            int k2 = 50 >> j2;
            return k2 > 0 ? i2 % k2 == 0 : true;
        }
        if (this == MobEffects.s) {
            int k3 = 25 >> j2;
            return k3 > 0 ? i2 % k3 == 0 : true;
        }
        if (this == MobEffects.t) {
            int k4 = 40 >> j2;
            return k4 > 0 ? i2 % k4 == 0 : true;
        }
        return this == MobEffects.q;
    }

    public boolean a() {
        return false;
    }

    protected String c() {
        if (this.d == null) {
            this.d = SystemUtils.a("effect", BuiltInRegistries.e.b(this));
        }
        return this.d;
    }

    public String d() {
        return this.c();
    }

    public IChatBaseComponent e() {
        return IChatBaseComponent.c(this.d());
    }

    public MobEffectInfo f() {
        return this.b;
    }

    public int g() {
        return this.c;
    }

    public MobEffectList a(AttributeBase attributebase, String s2, double d0, AttributeModifier.Operation attributemodifier_operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(s2), this::d, d0, attributemodifier_operation);
        this.a.put(attributebase, attributemodifier);
        return this;
    }

    public MobEffectList a(Supplier<MobEffect.a> supplier) {
        this.e = supplier;
        return this;
    }

    public Map<AttributeBase, AttributeModifier> h() {
        return this.a;
    }

    public void a(EntityLiving entityliving, AttributeMapBase attributemapbase, int i2) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributemapbase.a(entry.getKey());
            if (attributemodifiable == null) continue;
            attributemodifiable.d(entry.getValue());
        }
    }

    public void b(EntityLiving entityliving, AttributeMapBase attributemapbase, int i2) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributemapbase.a(entry.getKey());
            if (attributemodifiable == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            attributemodifiable.d(attributemodifier);
            attributemodifiable.c(new AttributeModifier(attributemodifier.a(), String.valueOf(this.d()) + " " + i2, this.a(i2, attributemodifier), attributemodifier.c()));
        }
    }

    public double a(int i2, AttributeModifier attributemodifier) {
        return attributemodifier.d() * (double)(i2 + 1);
    }

    public boolean i() {
        return this.b == MobEffectInfo.a;
    }
}

