/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    private static final Logger c = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final AtomicInteger d = new AtomicInteger();
    private static final List<ItemStack> e = Collections.emptyList();
    public static final int x = 60;
    public static final int y = 300;
    public static final int z = 1024;
    public static final float A = 0.2f;
    public static final double B = 0.500001;
    public static final double C = 0.999999;
    public static final float D = 0.11111111f;
    public static final int E = 140;
    public static final int F = 40;
    private static final AxisAlignedBB k = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double l = 0.014;
    private static final double m = 0.007;
    private static final double n = 0.0023333333333333335;
    public static final String G = "UUID";
    private static double o = 1.0;
    private final EntityTypes<?> p;
    private int q;
    public boolean H;
    public ImmutableList<Entity> r;
    protected int I;
    @Nullable
    private Entity s;
    private net.minecraft.world.level.World t;
    public double J;
    public double K;
    public double L;
    private Vec3D u;
    private BlockPosition aD;
    private ChunkCoordIntPair aE;
    private Vec3D aF;
    private float aG;
    private float aH;
    public float M;
    public float N;
    private AxisAlignedBB aI;
    public boolean aJ;
    public boolean O;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    protected Vec3D T;
    @Nullable
    private RemovalReason aK;
    public static final float U = 0.6f;
    public static final float V = 1.8f;
    public float W;
    public float X;
    public float Y;
    public float Z;
    public float aa;
    private float aL = 1.0f;
    public double ab;
    public double ac;
    public double ad;
    private float aM;
    public boolean ae;
    protected final RandomSource af;
    public int ag;
    private int aN;
    public boolean ah;
    protected Object2DoubleMap<TagKey<FluidType>> ai;
    protected boolean aj;
    private final Set<TagKey<FluidType>> aO;
    public int ak;
    protected boolean al = true;
    protected final DataWatcher am;
    protected static final DataWatcherObject<Byte> an = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int ao = 0;
    private static final int aP = 1;
    private static final int aQ = 3;
    private static final int aR = 4;
    private static final int aS = 5;
    protected static final int ap = 6;
    protected static final int aq = 7;
    private static final DataWatcherObject<Integer> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aW = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aX = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> ar = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    private static final DataWatcherObject<Integer> aY = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aZ;
    private final VecDeltaCodec ba;
    public boolean as;
    public boolean at;
    public int bb;
    protected boolean au;
    protected int av;
    protected BlockPosition aw;
    private boolean bc;
    protected UUID ax;
    protected String ay;
    private boolean bd;
    private final Set<String> be;
    private final double[] bf;
    private long bg;
    private EntitySize bh;
    private float bi;
    public boolean az;
    public boolean aA;
    public boolean aB;
    public Optional<BlockPosition> aC;
    private boolean bj = false;
    private float bk;
    private int bl;
    public boolean bm;
    @Nullable
    private IBlockData bn = null;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.t.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.aG;
    }

    public boolean isChunkLoaded() {
        return this.t.b((int)Math.floor(this.dn()) >> 4, (int)Math.floor(this.dt()) >> 4);
    }

    public Entity(EntityTypes<?> entitytypes, net.minecraft.world.level.World world) {
        this.q = d.incrementAndGet();
        this.r = ImmutableList.of();
        this.aF = Vec3D.b;
        this.aI = k;
        this.T = Vec3D.b;
        this.af = RandomSource.a();
        this.aN = -this.cZ();
        this.ai = new Object2DoubleArrayMap(2);
        this.aO = new HashSet<TagKey<FluidType>>();
        this.aZ = EntityInLevelCallback.a;
        this.ba = new VecDeltaCodec();
        this.ax = MathHelper.a(this.af);
        this.ay = this.ax.toString();
        this.be = Sets.newHashSet();
        this.bf = new double[]{0.0, 0.0, 0.0};
        this.aC = Optional.empty();
        this.p = entitytypes;
        this.t = world;
        this.bh = entitytypes.n();
        this.u = Vec3D.b;
        this.aD = BlockPosition.b;
        this.aE = ChunkCoordIntPair.b;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        this.am = new DataWatcher(this);
        this.am.a(an, (byte)0);
        this.am.a(aT, this.ce());
        this.am.a(aV, false);
        this.am.a(aU, Optional.empty());
        this.am.a(aW, false);
        this.am.a(aX, false);
        this.am.a(ar, EntityPose.a);
        this.am.a(aY, 0);
        this.a_();
        this.aj().registrationLocked = true;
        this.e(0.0, 0.0, 0.0);
        this.bi = this.a(EntityPose.a, this.bh);
    }

    public boolean a(BlockPosition blockposition, IBlockData iblockdata) {
        VoxelShape voxelshape = iblockdata.b((IBlockAccess)this.dI(), blockposition, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cE()), OperatorBoolean.i);
    }

    public int k_() {
        ScoreboardTeamBase scoreboardteambase = this.cd();
        return scoreboardteambase != null && scoreboardteambase.n().f() != null ? scoreboardteambase.n().f() : 0xFFFFFF;
    }

    public boolean G_() {
        return false;
    }

    public final void ac() {
        if (this.bN()) {
            this.bz();
        }
        if (this.bM()) {
            this.Y();
        }
    }

    public void f(double d0, double d1, double d2) {
        this.ba.e(new Vec3D(d0, d1, d2));
    }

    public VecDeltaCodec ad() {
        return this.ba;
    }

    public EntityTypes<?> ae() {
        return this.p;
    }

    @Override
    public int af() {
        return this.q;
    }

    public void e(int i2) {
        this.q = i2;
    }

    public Set<String> ag() {
        return this.be;
    }

    public boolean a(String s2) {
        return this.be.size() >= 1024 ? false : this.be.add(s2);
    }

    public boolean b(String s2) {
        return this.be.remove(s2);
    }

    public void ah() {
        this.a(RemovalReason.a);
        this.a(GameEvent.p);
    }

    public final void ai() {
        this.a(RemovalReason.b);
    }

    protected abstract void a_();

    public DataWatcher aj() {
        return this.am;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).q == this.q : false;
    }

    public int hashCode() {
        return this.q;
    }

    public void a(RemovalReason entity_removalreason) {
        this.b(entity_removalreason);
    }

    public void ak() {
    }

    public void b(EntityPose entitypose) {
        if (entitypose == this.al()) {
            return;
        }
        this.t.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[entitypose.ordinal()]));
        this.am.b(ar, entitypose);
    }

    public EntityPose al() {
        return this.am.b(ar);
    }

    public boolean c(EntityPose entitypose) {
        return this.al() == entitypose;
    }

    public boolean a(Entity entity, double d0) {
        return this.dg().a((IPosition)entity.dg(), d0);
    }

    public boolean a(Entity entity, double d0, double d1) {
        double d2 = entity.dn() - this.dn();
        double d3 = entity.dp() - this.dp();
        double d4 = entity.dt() - this.dt();
        return MathHelper.e(d2, d4) < MathHelper.k(d0) && MathHelper.k(d3) < MathHelper.k(d1);
    }

    protected void a(float f2, float f1) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(String.valueOf(this.cv()) + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(String.valueOf(this.cv()) + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.a_(f2 % 360.0f);
        this.b_(f1 % 360.0f);
    }

    public final void a(Vec3D vec3d) {
        this.e(vec3d.a(), vec3d.b(), vec3d.c());
    }

    public void e(double d0, double d1, double d2) {
        this.p(d0, d1, d2);
        this.a(this.am());
    }

    protected AxisAlignedBB am() {
        return this.bh.a(this.u);
    }

    protected void an() {
        this.e(this.u.c, this.u.d, this.u.e);
    }

    public void b(double d0, double d1) {
        float f2 = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.b_(this.dA() + f2);
        this.a_(this.dy() + f1);
        this.b_(MathHelper.a(this.dA(), -90.0f, 90.0f));
        this.N += f2;
        this.M += f1;
        this.N = MathHelper.a(this.N, -90.0f, 90.0f);
        if (this.s != null) {
            this.s.j(this);
        }
    }

    public void l() {
        this.ao();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer)) {
            this.bG();
        }
    }

    public void ao() {
        this.dI().ad().a("entityBaseTick");
        this.bn = null;
        if (this.bM() && this.cW().dD()) {
            this.Y();
        }
        if (this.I > 0) {
            --this.I;
        }
        this.W = this.X;
        this.N = this.dA();
        this.M = this.dy();
        if (this instanceof EntityPlayer) {
            this.bG();
        }
        if (this.bg()) {
            this.bh();
        }
        this.aA = this.az;
        this.az = false;
        this.bb();
        this.q();
        this.ba();
        if (this.dI().B) {
            this.aw();
        } else if (this.aN > 0) {
            if (this.aU()) {
                this.h(this.aN - 4);
                if (this.aN < 0) {
                    this.aw();
                }
            } else {
                if (this.aN % 20 == 0 && !this.bi()) {
                    this.a(this.dJ().c(), 1.0f);
                }
                this.h(this.aN - 1);
            }
            if (this.cg() > 0) {
                this.k(0);
                this.dI().a(null, 1009, this.aD, 1);
            }
        }
        if (this.bi()) {
            this.au();
            this.aa *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.ap();
        if (!this.dI().B) {
            this.a_(this.aN > 0);
        }
        this.al = false;
        this.dI().ad().c();
    }

    public void a_(boolean flag) {
        this.b(0, flag || this.bm);
    }

    public void ap() {
        if (this.dp() < (double)(this.dI().C_() - 64)) {
            this.ax();
        }
    }

    public void aq() {
        this.bb = this.bH();
    }

    public void f(int i2) {
        this.bb = i2;
    }

    public int ar() {
        return this.bb;
    }

    public boolean as() {
        return this.bb > 0;
    }

    protected void H() {
        if (this.as()) {
            --this.bb;
        }
    }

    public int at() {
        return 0;
    }

    public void au() {
        if (!this.aU()) {
            if (this instanceof EntityLiving && this.aN <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.t, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.t.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.setSecondsOnFire(combustEvent.getDuration(), false);
                }
            } else {
                this.setSecondsOnFire(15, false);
            }
            CraftBlock craftBlock = CraftEventFactory.blockDamage = this.lastLavaContact == null ? null : CraftBlock.at(this.t, this.lastLavaContact);
            if (this.a(this.dJ().d(), 4.0f)) {
                this.a(SoundEffects.iT, 0.4f, 2.0f + this.af.i() * 0.4f);
            }
            CraftEventFactory.blockDamage = null;
        }
    }

    public void g(int i2) {
        this.setSecondsOnFire(i2, true);
    }

    public void setSecondsOnFire(int i2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDuration();
        }
        int j2 = i2 * 20;
        if (this instanceof EntityLiving) {
            j2 = EnchantmentProtection.a((EntityLiving)this, j2);
        }
        if (this.aN < j2) {
            this.h(j2);
        }
    }

    public void h(int i2) {
        this.aN = i2;
    }

    public int av() {
        return this.aN;
    }

    public void aw() {
        this.h(0);
    }

    protected void ax() {
        this.ai();
    }

    public boolean g(double d0, double d1, double d2) {
        return this.b(this.cE().d(d0, d1, d2));
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        return this.dI().a(this, axisalignedbb) && !this.dI().d(axisalignedbb);
    }

    public void c(boolean flag) {
        this.aJ = flag;
        this.b(flag, null);
    }

    public void a(boolean flag, Vec3D vec3d) {
        this.aJ = flag;
        this.b(flag, vec3d);
    }

    public boolean d(BlockPosition blockposition) {
        return this.aC.isPresent() && this.aC.get().equals(blockposition);
    }

    protected void b(boolean flag, @Nullable Vec3D vec3d) {
        if (flag) {
            AxisAlignedBB axisalignedbb = this.cE();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.t.f(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bj) {
                if (vec3d != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-vec3d.c, 0.0, -vec3d.e);
                    optional = this.t.f(this, axisalignedbb2);
                    this.aC = optional;
                }
            } else {
                this.aC = optional;
            }
            this.bj = optional.isEmpty();
        } else {
            this.bj = false;
            if (this.aC.isPresent()) {
                this.aC = Optional.empty();
            }
        }
    }

    public boolean ay() {
        return this.aJ;
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.ae) {
            this.e(this.dn() + vec3d.c, this.dp() + vec3d.d, this.dt() + vec3d.e);
        } else {
            Vec3D vec3d1;
            double d0;
            this.aB = this.bL();
            if (enummovetype == EnumMoveType.c && (vec3d = this.c(vec3d)).equals(Vec3D.b)) {
                return;
            }
            this.dI().ad().a("move");
            if (this.T.g() > 1.0E-7) {
                vec3d = vec3d.h(this.T);
                this.T = Vec3D.b;
                this.f(Vec3D.b);
            }
            if ((d0 = (vec3d1 = this.h(vec3d = this.a(vec3d, enummovetype))).g()) > 1.0E-7) {
                MovingObjectPositionBlock movingobjectpositionblock;
                if (this.aa != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.dI().a(new RayTrace(this.dg(), this.dg().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                    this.n();
                }
                this.e(this.dn() + vec3d1.c, this.dp() + vec3d1.d, this.dt() + vec3d1.e);
            }
            this.dI().ad().c();
            this.dI().ad().a("rest");
            boolean flag = !MathHelper.b(vec3d.c, vec3d1.c);
            boolean flag1 = !MathHelper.b(vec3d.e, vec3d1.e);
            this.O = flag || flag1;
            this.P = vec3d.d != vec3d1.d;
            this.Q = this.P && vec3d.d < 0.0;
            this.R = this.O ? this.b(vec3d1) : false;
            this.a(this.Q, vec3d1);
            BlockPosition blockposition = this.aD();
            IBlockData iblockdata = this.dI().a_(blockposition);
            this.a(vec3d1.d, this.ay(), iblockdata, blockposition);
            if (this.dD()) {
                this.dI().ad().c();
            } else {
                MovementEmission entity_movementemission;
                if (this.O) {
                    Vec3D vec3d2 = this.dl();
                    this.o(flag ? 0.0 : vec3d2.c, vec3d2.d, flag1 ? 0.0 : vec3d2.e);
                }
                Block block = iblockdata.b();
                if (vec3d.d != vec3d1.d) {
                    block.a(this.dI(), this);
                }
                if (this.O && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl = this.t.getWorld().getBlockAt(MathHelper.a(this.dn()), MathHelper.a(this.dp()), MathHelper.a(this.dt()));
                    if (vec3d.c > vec3d1.c) {
                        bl = bl.getRelative(BlockFace.EAST);
                    } else if (vec3d.c < vec3d1.c) {
                        bl = bl.getRelative(BlockFace.WEST);
                    } else if (vec3d.e > vec3d1.e) {
                        bl = bl.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.e < vec3d1.e) {
                        bl = bl.getRelative(BlockFace.NORTH);
                    }
                    if (!bl.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl);
                        this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if (this.ay()) {
                    block.a(this.dI(), blockposition, iblockdata, this);
                }
                if ((entity_movementemission = this.aS()).a() && !this.bM()) {
                    double d1 = vec3d1.c;
                    double d2 = vec3d1.d;
                    double d3 = vec3d1.e;
                    this.Z += (float)(vec3d1.f() * 0.6);
                    BlockPosition blockposition1 = this.aF();
                    IBlockData iblockdata1 = this.dI().a_(blockposition1);
                    boolean flag2 = this.c(iblockdata1);
                    if (!flag2) {
                        d2 = 0.0;
                    }
                    this.X += (float)vec3d1.h() * 0.6f;
                    this.Y += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.Y > this.aL && !iblockdata1.i()) {
                        boolean flag3 = blockposition1.equals(blockposition);
                        boolean flag4 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag3, vec3d);
                        if (!flag3) {
                            flag4 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), vec3d);
                        }
                        if (flag4) {
                            this.aL = this.aI();
                        } else if (this.aV()) {
                            this.aL = this.aI();
                            if (entity_movementemission.c()) {
                                this.aN();
                            }
                            if (entity_movementemission.b()) {
                                this.a(GameEvent.R);
                            }
                        }
                    } else if (iblockdata1.i()) {
                        this.aC();
                    }
                }
                this.az();
                float f2 = this.aH();
                this.f(this.dl().d(f2, 1.0, f2));
                if (this.dI().c(this.cE().h(1.0E-6)).noneMatch(iblockdata2 -> iblockdata2.a(TagsBlock.aI) || iblockdata2.a(Blocks.H))) {
                    if (this.aN <= 0) {
                        this.h(-this.cZ());
                    }
                    if (this.aB && (this.az || this.aX())) {
                        this.aA();
                    }
                }
                if (this.bL() && (this.az || this.aX())) {
                    this.h(-this.cZ());
                }
                this.dI().ad().c();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private boolean c(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.aN) || iblockdata.a(Blocks.qC);
    }

    private boolean a(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, Vec3D vec3d) {
        if (iblockdata.i()) {
            return false;
        }
        boolean flag2 = this.c(iblockdata);
        if ((this.ay() || flag2 || this.bU() && vec3d.d == 0.0 || this.cc()) && !this.bW()) {
            if (flag) {
                this.c(blockposition, iblockdata);
            }
            if (flag1) {
                this.dI().a(GameEvent.Q, this.dg(), GameEvent.a.a(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean b(Vec3D vec3d) {
        return false;
    }

    protected void az() {
        try {
            this.aM();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void aA() {
        this.a(SoundEffects.iY, 0.7f, 1.6f + (this.af.i() - this.af.i()) * 0.4f);
    }

    public void aB() {
        if (!this.dI().B && this.aB) {
            this.aA();
        }
        this.aw();
    }

    protected void aC() {
        if (this.aP()) {
            this.aO();
            if (this.aS().b()) {
                this.a(GameEvent.y);
            }
        }
    }

    @Deprecated
    public BlockPosition aD() {
        return this.d(0.2f);
    }

    protected BlockPosition aE() {
        return this.d(0.500001f);
    }

    public BlockPosition aF() {
        return this.d(1.0E-5f);
    }

    protected BlockPosition d(float f2) {
        if (this.aC.isPresent()) {
            BlockPosition blockposition = this.aC.get();
            if (f2 <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dI().a_(blockposition);
            return ((double)f2 > 0.5 || !iblockdata.a(TagsBlock.S)) && !iblockdata.a(TagsBlock.L) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.u.d - (double)f2)) : blockposition;
        }
        int i2 = MathHelper.a(this.u.c);
        int j2 = MathHelper.a(this.u.d - (double)f2);
        int k2 = MathHelper.a(this.u.e);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aG() {
        float f2 = this.dI().a_(this.di()).b().j();
        float f1 = this.dI().a_(this.aE()).b().j();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aH() {
        IBlockData iblockdata = this.dI().a_(this.di());
        float f2 = iblockdata.b().i();
        return !iblockdata.a(Blocks.G) && !iblockdata.a(Blocks.nd) ? ((double)f2 == 1.0 ? this.dI().a_(this.aE()).b().i() : f2) : f2;
    }

    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        return vec3d;
    }

    protected Vec3D c(Vec3D vec3d) {
        if (vec3d.g() <= 1.0E-7) {
            return vec3d;
        }
        long i2 = this.dI().V();
        if (i2 != this.bg) {
            Arrays.fill(this.bf, 0.0);
            this.bg = i2;
        }
        if (vec3d.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, vec3d.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(d0, 0.0, 0.0);
        }
        if (vec3d.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, vec3d.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, d0, 0.0);
        }
        if (vec3d.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, vec3d.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.b;
    }

    private double a(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        int i2 = enumdirection_enumaxis.ordinal();
        double d1 = MathHelper.a(d0 + this.bf[i2], -0.51, 0.51);
        d0 = d1 - this.bf[i2];
        this.bf[i2] = d1;
        return d0;
    }

    private Vec3D h(Vec3D vec3d) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.cE();
        List<VoxelShape> list = this.dI().b(this, axisalignedbb.b(vec3d));
        Vec3D vec3d1 = vec3d.g() == 0.0 ? vec3d : Entity.a(this, vec3d, axisalignedbb, this.dI(), list);
        boolean flag = vec3d.c != vec3d1.c;
        boolean flag1 = vec3d.d != vec3d1.d;
        boolean flag2 = vec3d.e != vec3d1.e;
        boolean bl = flag3 = this.ay() || flag1 && vec3d.d < 0.0;
        if (this.dC() > 0.0f && flag3 && (flag || flag2)) {
            Vec3D vec3d4;
            Vec3D vec3d2 = Entity.a(this, new Vec3D(vec3d.c, this.dC(), vec3d.e), axisalignedbb, this.dI(), list);
            Vec3D vec3d3 = Entity.a(this, new Vec3D(0.0, this.dC(), 0.0), axisalignedbb.b(vec3d.c, 0.0, vec3d.e), this.dI(), list);
            if (vec3d3.d < (double)this.dC() && (vec3d4 = Entity.a(this, new Vec3D(vec3d.c, 0.0, vec3d.e), axisalignedbb.c(vec3d3), this.dI(), list).e(vec3d3)).i() > vec3d2.i()) {
                vec3d2 = vec3d4;
            }
            if (vec3d2.i() > vec3d1.i()) {
                return vec3d2.e(Entity.a(this, new Vec3D(0.0, -vec3d2.d + vec3d.d, 0.0), axisalignedbb.c(vec3d2), this.dI(), list));
            }
        }
        return vec3d1;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec3d, AxisAlignedBB axisalignedbb, net.minecraft.world.level.World world, List<VoxelShape> list) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            builder.addAll(list);
        }
        WorldBorder worldborder = world.w_();
        boolean bl = flag = entity != null && worldborder.a(entity, axisalignedbb.b(vec3d));
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.d(entity, axisalignedbb.b(vec3d)));
        return Entity.a(vec3d, axisalignedbb, (List<VoxelShape>)builder.build());
    }

    private static Vec3D a(Vec3D vec3d, AxisAlignedBB axisalignedbb, List<VoxelShape> list) {
        boolean flag;
        if (list.isEmpty()) {
            return vec3d;
        }
        double d0 = vec3d.c;
        double d1 = vec3d.d;
        double d2 = vec3d.e;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, axisalignedbb, list, d1)) != 0.0) {
            axisalignedbb = axisalignedbb.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, axisalignedbb, list, d2)) != 0.0) {
            axisalignedbb = axisalignedbb.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, axisalignedbb, list, d0);
            if (!flag && d0 != 0.0) {
                axisalignedbb = axisalignedbb.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, axisalignedbb, list, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aI() {
        return (int)this.Y + 1;
    }

    protected SoundEffect aJ() {
        return SoundEffects.jc;
    }

    protected SoundEffect aK() {
        return SoundEffects.jb;
    }

    protected SoundEffect aL() {
        return SoundEffects.jb;
    }

    public SoundEffect getSwimSound0() {
        return this.aJ();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aK();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aL();
    }

    protected void aM() {
        AxisAlignedBB axisalignedbb = this.cE();
        BlockPosition blockposition = BlockPosition.a(axisalignedbb.a + 1.0E-7, axisalignedbb.b + 1.0E-7, axisalignedbb.c + 1.0E-7);
        BlockPosition blockposition1 = BlockPosition.a(axisalignedbb.d - 1.0E-7, axisalignedbb.e - 1.0E-7, axisalignedbb.f - 1.0E-7);
        if (this.dI().a(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = blockposition.u();
            while (i2 <= blockposition1.u()) {
                int j2 = blockposition.v();
                while (j2 <= blockposition1.v()) {
                    int k2 = blockposition.w();
                    while (k2 <= blockposition1.w()) {
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.dI().a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.dI(), (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.dI(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
        }
    }

    protected void a(IBlockData iblockdata) {
    }

    public void a(GameEvent gameevent, @Nullable Entity entity) {
        this.dI().a(entity, gameevent, this.u);
    }

    public void a(GameEvent gameevent) {
        this.a(gameevent, this);
    }

    private void c(BlockPosition blockposition, IBlockData iblockdata) {
        this.b(blockposition, iblockdata);
        if (this.d(iblockdata)) {
            this.k();
        }
    }

    protected void aN() {
        Entity object = this.bN() && this.cL() != null ? this.cL() : this;
        float f2 = object == this ? 0.35f : 0.4f;
        Vec3D vec3d = object.dl();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        this.e(f1);
    }

    protected BlockPosition e(BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.c();
        IBlockData iblockdata = this.dI().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bl) && !iblockdata.a(TagsBlock.bm) ? blockposition : blockposition1;
    }

    protected void a(IBlockData iblockdata, IBlockData iblockdata1) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(iblockdata1);
    }

    protected void b(IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bk) && this.ag >= this.bl + 20;
    }

    private void k() {
        this.bk *= (float)Math.pow(0.997, this.ag - this.bl);
        this.bk = Math.min(1.0f, this.bk + 0.07f);
        float f2 = 0.5f + this.bk * this.af.i() * 1.2f;
        float f1 = 0.1f + this.bk * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bl = this.ag;
    }

    protected void e(float f2) {
        this.a(this.aJ(), f2, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
    }

    protected void aO() {
    }

    protected boolean aP() {
        return false;
    }

    public void a(SoundEffect soundeffect, float f2, float f1) {
        if (!this.aQ()) {
            this.dI().a(null, this.dn(), this.dp(), this.dt(), soundeffect, this.cY(), f2, f1);
        }
    }

    public void a(SoundEffect soundeffect) {
        if (!this.aQ()) {
            this.a(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean aQ() {
        return this.am.b(aW);
    }

    public void d(boolean flag) {
        this.am.b(aW, flag);
    }

    public boolean aR() {
        return this.am.b(aX);
    }

    public void e(boolean flag) {
        this.am.b(aX, flag);
    }

    protected MovementEmission aS() {
        return MovementEmission.d;
    }

    public boolean aT() {
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (flag) {
            if (this.aa > 0.0f) {
                iblockdata.b().a(this.dI(), iblockdata, blockposition, this, this.aa);
                this.dI().a(GameEvent.B, this.u, GameEvent.a.a(this, this.aC.map(blockposition1 -> this.dI().a_((BlockPosition)blockposition1)).orElse(iblockdata)));
            }
            this.n();
        } else if (d0 < 0.0) {
            this.aa -= (float)d0;
        }
    }

    public boolean aU() {
        return this.ae().d();
    }

    public boolean a(float f2, float f1, DamageSource damagesource) {
        if (this.p.a(TagsEntity.l)) {
            return false;
        }
        if (this.bN()) {
            for (Entity entity : this.cN()) {
                entity.a(f2, f1, damagesource);
            }
        }
        return false;
    }

    public boolean aV() {
        return this.ah;
    }

    private boolean o() {
        BlockPosition blockposition = this.di();
        return this.dI().q(blockposition) || this.dI().q(BlockPosition.a((double)blockposition.u(), this.cE().e, (double)blockposition.w()));
    }

    private boolean p() {
        return this.dI().a_(this.di()).a(Blocks.nd);
    }

    public boolean aW() {
        return this.aV() || this.o();
    }

    public boolean aX() {
        return this.aV() || this.o() || this.p();
    }

    public boolean aY() {
        return this.aV() || this.p();
    }

    public boolean aZ() {
        return this.aj && this.aV();
    }

    public void ba() {
        if (this.bW()) {
            this.h(this.bV() && this.aV() && !this.bM());
        } else {
            this.h(this.bV() && this.aZ() && !this.bM() && this.dI().b_(this.aD).a(TagsFluid.a));
        }
    }

    protected boolean bb() {
        this.ai.clear();
        this.bc();
        double d0 = this.dI().x_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.aV() || flag;
    }

    void bc() {
        EntityBoat entityboat;
        Entity entity = this.cW();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aZ()) {
            this.ah = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ah && !this.al) {
                this.bd();
            }
            this.n();
            this.ah = true;
            this.aw();
        } else {
            this.ah = false;
        }
    }

    private void q() {
        EntityBoat entityboat;
        this.aj = this.a(TagsFluid.a);
        this.aO.clear();
        double d0 = this.dr() - 0.1111111119389534;
        Entity entity = this.cW();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aZ() && entityboat.cE().e >= d0 && entityboat.cE().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dn(), d0, this.dt());
        Fluid fluid = this.dI().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.dI(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aO;
            Objects.requireNonNull(this.aO);
            stream.forEach(set::add);
        }
    }

    protected void bd() {
        double d1;
        double d0;
        Entity object = this.bN() && this.cL() != null ? this.cL() : this;
        float f2 = object == this ? 0.2f : 0.9f;
        Vec3D vec3d = object.dl();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aK(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        } else {
            this.a(this.aL(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dp());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dI().a(Particles.e, this.dn() + d0, (double)(f22 + 1.0f), this.dt() + d1, vec3d.c, vec3d.d - this.af.j() * (double)0.2f, vec3d.e);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dI().a(Particles.ag, this.dn() + d0, (double)(f22 + 1.0f), this.dt() + d1, vec3d.c, vec3d.d, vec3d.e);
            ++i2;
        }
        this.a(GameEvent.P);
    }

    @Deprecated
    protected IBlockData be() {
        return this.dI().a_(this.aD());
    }

    public IBlockData bf() {
        return this.dI().a_(this.aF());
    }

    public boolean bg() {
        return this.bV() && !this.aV() && !this.G_() && !this.bU() && !this.bi() && this.bs();
    }

    protected void bh() {
        BlockPosition blockposition = this.aD();
        IBlockData iblockdata = this.dI().a_(blockposition);
        if (iblockdata.l() != EnumRenderType.a) {
            Vec3D vec3d = this.dl();
            BlockPosition blockposition1 = this.di();
            double d0 = this.dn() + (this.af.j() - 0.5) * (double)this.bh.a;
            double d1 = this.dt() + (this.af.j() - 0.5) * (double)this.bh.a;
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dI().a(new ParticleParamBlock(Particles.c, iblockdata), d0, this.dp() + 0.1, d1, vec3d.c * -4.0, 1.5, vec3d.e * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> tagkey) {
        return this.aO.contains(tagkey);
    }

    public boolean bi() {
        return !this.al && this.ai.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float f2, Vec3D vec3d) {
        Vec3D vec3d1 = Entity.a(vec3d, f2, this.dy());
        this.f(this.dl().e(vec3d1));
    }

    private static Vec3D a(Vec3D vec3d, float f2, float f1) {
        double d0 = vec3d.g();
        if (d0 < 1.0E-7) {
            return Vec3D.b;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? vec3d.d() : vec3d).a((double)f2);
        float f22 = MathHelper.a(f1 * ((float)Math.PI / 180));
        float f3 = MathHelper.b(f1 * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.c * (double)f3 - vec3d1.e * (double)f22, vec3d1.d, vec3d1.e * (double)f3 + vec3d1.c * (double)f22);
    }

    @Deprecated
    public float bj() {
        return this.dI().f(this.dm(), this.ds()) ? this.dI().w(BlockPosition.a(this.dn(), this.dr(), this.dt())) : 0.0f;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.h(d0, d1, d2);
        this.a_(f2 % 360.0f);
        this.b_(MathHelper.a(f1, -90.0f, 90.0f) % 360.0f);
        this.M = this.dy();
        this.N = this.dA();
    }

    public void h(double d0, double d1, double d2) {
        double d3 = MathHelper.a(d0, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(d2, -3.0E7, 3.0E7);
        this.J = d3;
        this.K = d1;
        this.L = d4;
        this.e(d3, d1, d4);
        if (this.valid) {
            this.t.d((int)Math.floor(this.dn()) >> 4, (int)Math.floor(this.dt()) >> 4);
        }
    }

    public void d(Vec3D vec3d) {
        this.d(vec3d.c, vec3d.d, vec3d.e);
    }

    public void d(double d0, double d1, double d2) {
        this.b(d0, d1, d2, this.dy(), this.dA());
    }

    public void a(BlockPosition blockposition, float f2, float f1) {
        this.b((double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, f2, f1);
    }

    public void b(double d0, double d1, double d2, float f2, float f1) {
        this.p(d0, d1, d2);
        this.a_(f2);
        this.b_(f1);
        this.bk();
        this.an();
    }

    public final void bk() {
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        this.J = d0;
        this.K = d1;
        this.L = d2;
        this.ab = d0;
        this.ac = d1;
        this.ad = d2;
        this.M = this.dy();
        this.N = this.dA();
    }

    public float e(Entity entity) {
        float f2 = (float)(this.dn() - entity.dn());
        float f1 = (float)(this.dp() - entity.dp());
        float f22 = (float)(this.dt() - entity.dt());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double d0, double d1, double d2) {
        double d3 = this.dn() - d0;
        double d4 = this.dp() - d1;
        double d5 = this.dt() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double f(Entity entity) {
        return this.e(entity.dg());
    }

    public double e(Vec3D vec3d) {
        double d0 = this.dn() - vec3d.c;
        double d1 = this.dp() - vec3d.d;
        double d2 = this.dt() - vec3d.e;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b_(EntityHuman entityhuman) {
    }

    public void g(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.v(entity) && !entity.ae && !this.ae && (d2 = MathHelper.a(d0 = entity.dn() - this.dn(), d1 = entity.dt() - this.dt())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.bN() && this.bp()) {
                this.j(-d0, 0.0, -d1);
            }
            if (!entity.bN() && entity.bp()) {
                entity.j(d0, 0.0, d1);
            }
        }
    }

    public void j(double d0, double d1, double d2) {
        this.f(this.dl().b(d0, d1, d2));
        this.at = true;
    }

    protected void bl() {
        this.S = true;
    }

    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        this.bl();
        return false;
    }

    public final Vec3D f(float f2) {
        return this.b(this.g(f2), this.h(f2));
    }

    public float g(float f2) {
        return f2 == 1.0f ? this.dA() : MathHelper.i(f2, this.N, this.dA());
    }

    public float h(float f2) {
        return f2 == 1.0f ? this.dy() : MathHelper.i(f2, this.M, this.dy());
    }

    protected final Vec3D b(float f2, float f1) {
        float f22 = f2 * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f22);
        float f7 = MathHelper.a(f22);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D i(float f2) {
        return this.c(this.g(f2), this.h(f2));
    }

    protected final Vec3D c(float f2, float f1) {
        return this.b(f2 - 90.0f, f1);
    }

    public final Vec3D bm() {
        return new Vec3D(this.dn(), this.dr(), this.dt());
    }

    public final Vec3D j(float f2) {
        double d0 = MathHelper.d((double)f2, this.J, this.dn());
        double d1 = MathHelper.d((double)f2, this.K, this.dp()) + (double)this.cF();
        double d2 = MathHelper.d((double)f2, this.L, this.dt());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D k(float f2) {
        return this.j(f2);
    }

    public final Vec3D l(float f2) {
        double d0 = MathHelper.d((double)f2, this.J, this.dn());
        double d1 = MathHelper.d((double)f2, this.K, this.dp());
        double d2 = MathHelper.d((double)f2, this.L, this.dt());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double d0, float f2, boolean flag) {
        Vec3D vec3d = this.j(f2);
        Vec3D vec3d1 = this.f(f2);
        Vec3D vec3d2 = vec3d.b(vec3d1.c * d0, vec3d1.d * d0, vec3d1.e * d0);
        return this.dI().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, flag ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bn() {
        return this.bs() && this.bo();
    }

    public boolean bo() {
        return false;
    }

    public boolean bp() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bp();
    }

    public void a(Entity entity, int i2, DamageSource damagesource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.c.a((EntityPlayer)entity, this, damagesource);
        }
    }

    public boolean k(double d0, double d1, double d2) {
        double d3 = this.dn() - d0;
        double d4 = this.dp() - d1;
        double d5 = this.dt() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double d0) {
        double d1 = this.cE().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * o) * d1;
    }

    public boolean d(NBTTagCompound nbttagcompound) {
        if (this.aK != null && !this.aK.b()) {
            return false;
        }
        String s2 = this.br();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.a(v, s2);
        this.f(nbttagcompound);
        return true;
    }

    public boolean e(NBTTagCompound nbttagcompound) {
        return this.bM() ? false : this.d(nbttagcompound);
    }

    public NBTTagCompound f(NBTTagCompound nbttagcompound) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (this.s != null) {
                nbttagcompound.a("Pos", this.a(new double[]{this.s.dn(), this.dp(), this.s.dt()}));
            } else {
                nbttagcompound.a("Pos", this.a(new double[]{this.dn(), this.dp(), this.dt()}));
            }
            Vec3D vec3d = this.dl();
            nbttagcompound.a("Motion", this.a(new double[]{vec3d.c, vec3d.d, vec3d.e}));
            if (Float.isNaN(this.aG)) {
                this.aG = 0.0f;
            }
            if (Float.isNaN(this.aH)) {
                this.aH = 0.0f;
            }
            nbttagcompound.a("Rotation", this.a(new float[]{this.dy(), this.dA()}));
            nbttagcompound.a("FallDistance", this.aa);
            nbttagcompound.a("Fire", (short)this.aN);
            nbttagcompound.a("Air", (short)this.cf());
            nbttagcompound.a("OnGround", this.ay());
            nbttagcompound.a("Invulnerable", this.bc);
            nbttagcompound.a("PortalCooldown", this.bb);
            nbttagcompound.a(G, this.ct());
            nbttagcompound.a("WorldUUIDLeast", ((WorldServer)this.t).getWorld().getUID().getLeastSignificantBits());
            nbttagcompound.a("WorldUUIDMost", ((WorldServer)this.t).getWorld().getUID().getMostSignificantBits());
            nbttagcompound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.a("Bukkit.MaxAirSupply", this.ce());
            }
            nbttagcompound.a("Spigot.ticksLived", this.ag);
            IChatBaseComponent ichatbasecomponent = this.ab();
            if (ichatbasecomponent != null) {
                nbttagcompound.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
            }
            if (this.cy()) {
                nbttagcompound.a("CustomNameVisible", this.cy());
            }
            if (this.aQ()) {
                nbttagcompound.a("Silent", this.aQ());
            }
            if (this.aR()) {
                nbttagcompound.a("NoGravity", this.aR());
            }
            if (this.bd) {
                nbttagcompound.a("Glowing", true);
            }
            if ((i2 = this.cg()) > 0) {
                nbttagcompound.a("TicksFrozen", this.cg());
            }
            if (this.bm) {
                nbttagcompound.a("HasVisualFire", this.bm);
            }
            if (!this.be.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.be) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbttagcompound.a("Tags", nbttaglist);
            }
            this.b(nbttagcompound);
            if (this.bN()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cN()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.d(nbttagcompound1 = new NBTTagCompound())) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.a(w, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbttagcompound) {
        try {
            NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
            NBTTagList nbttaglist1 = nbttagcompound.c("Motion", 6);
            NBTTagList nbttaglist2 = nbttagcompound.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.o(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.p(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.a_(nbttaglist2.i(0));
            this.b_(nbttaglist2.i(1));
            this.bk();
            this.n(this.dy());
            this.o(this.dy());
            this.aa = nbttagcompound.j("FallDistance");
            this.aN = nbttagcompound.g("Fire");
            if (nbttagcompound.e("Air")) {
                this.j(nbttagcompound.g("Air"));
            }
            this.aJ = nbttagcompound.q("OnGround");
            this.bc = nbttagcompound.q("Invulnerable");
            this.bb = nbttagcompound.h("PortalCooldown");
            if (nbttagcompound.b(G)) {
                this.ax = nbttagcompound.a(G);
                this.ay = this.ax.toString();
            }
            if (!Double.isFinite(this.dn()) || !Double.isFinite(this.dp()) || !Double.isFinite(this.dt())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dy()) || !Double.isFinite(this.dA())) throw new IllegalStateException("Entity has invalid rotation");
            this.an();
            this.a(this.dy(), this.dA());
            if (nbttagcompound.b("CustomName", 8)) {
                String s2 = nbttagcompound.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2));
                }
                catch (Exception exception) {
                    c.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.n(nbttagcompound.q("CustomNameVisible"));
            this.d(nbttagcompound.q("Silent"));
            this.e(nbttagcompound.q("NoGravity"));
            this.i(nbttagcompound.q("Glowing"));
            this.k(nbttagcompound.h("TicksFrozen"));
            this.bm = nbttagcompound.q("HasVisualFire");
            if (nbttagcompound.b("Tags", 9)) {
                this.be.clear();
                NBTTagList nbttaglist3 = nbttagcompound.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                int j2 = 0;
                while (j2 < i2) {
                    this.be.add(nbttaglist3.j(j2));
                    ++j2;
                }
            }
            this.a(nbttagcompound);
            if (this.bq()) {
                this.an();
            }
            if (this instanceof EntityLiving) {
                this.ag = nbttagcompound.h("Spigot.ticksLived");
            }
            this.persist = !nbttagcompound.e("Bukkit.persist") || nbttagcompound.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbttagcompound.e("Bukkit.visibleByDefault") || nbttagcompound.q("Bukkit.visibleByDefault");
            if (nbttagcompound.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbttagcompound.h("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbttagcompound.l("world");
                if (nbttagcompound.e("WorldUUIDMost") && nbttagcompound.e("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbttagcompound.i("WorldUUIDMost"), nbttagcompound.i("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().a(net.minecraft.world.level.World.h).getWorld();
                }
                ((EntityPlayer)this).a((net.minecraft.world.level.World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
            this.getBukkitEntity().readBukkitValues(nbttagcompound);
            if (!nbttagcompound.e("Bukkit.invisible")) return;
            boolean bukkitInvisible = nbttagcompound.q("Bukkit.invisible");
            this.j(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bq() {
        return true;
    }

    @Nullable
    public final String br() {
        EntityTypes<?> entitytypes = this.ae();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... adouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = adouble;
        int i2 = adouble.length;
        int j2 = 0;
        while (j2 < i2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
            ++j2;
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... afloat) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = afloat;
        int i2 = afloat.length;
        int j2 = 0;
        while (j2 < i2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
            ++j2;
        }
        return nbttaglist;
    }

    @Nullable
    public EntityItem a(IMaterial imaterial) {
        return this.a(imaterial, 0);
    }

    @Nullable
    public EntityItem a(IMaterial imaterial, int i2) {
        return this.a(new ItemStack(imaterial), (float)i2);
    }

    @Nullable
    public EntityItem b(ItemStack itemstack) {
        return this.a(itemstack, 0.0f);
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, float f2) {
        if (itemstack.b()) {
            return null;
        }
        if (this.dI().B) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.dI(), this.dn(), this.dp() + (double)f2, this.dt(), itemstack);
        entityitem.o();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.dI().b(entityitem);
        return entityitem;
    }

    public boolean bs() {
        return !this.dD();
    }

    public boolean bt() {
        if (this.ae) {
            return false;
        }
        float f2 = this.bh.a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bm(), f2, 1.0E-6, f2);
        return BlockPosition.a(axisalignedbb).anyMatch(blockposition -> {
            IBlockData iblockdata = this.dI().a_((BlockPosition)blockposition);
            return !iblockdata.i() && iblockdata.o(this.dI(), (BlockPosition)blockposition) && VoxelShapes.c(iblockdata.k(this.dI(), (BlockPosition)blockposition).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()), VoxelShapes.a(axisalignedbb), OperatorBoolean.i);
        });
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.d;
    }

    public boolean h(Entity entity) {
        return entity.bu() && !this.v(entity);
    }

    public boolean bu() {
        return false;
    }

    public void bv() {
        this.f(Vec3D.b);
        this.l();
        if (this.bM()) {
            this.cW().i(this);
        }
    }

    public final void i(Entity entity) {
        this.a(entity, Entity::e);
    }

    protected void a(Entity entity, MoveFunction entity_movefunction) {
        if (this.u(entity)) {
            double d0 = this.dp() + this.bx() + entity.bw();
            entity_movefunction.accept(entity, this.dn(), d0, this.dt());
        }
    }

    public void j(Entity entity) {
    }

    public double bw() {
        return 0.0;
    }

    public double bx() {
        return (double)this.bh.b * 0.75;
    }

    public boolean k(Entity entity) {
        return this.a(entity, false);
    }

    public boolean by() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean flag) {
        if (entity == this.s) {
            return false;
        }
        if (!entity.bB()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.s != null) {
            if (entity1.s == this) {
                return false;
            }
            entity1 = entity1.s;
        }
        if (!(flag || this.l(entity) && entity.o(this))) {
            return false;
        }
        if (this.bM()) {
            this.Y();
        }
        this.b(EntityPose.a);
        this.s = entity;
        if (!this.s.addPassenger(this)) {
            this.s = null;
        }
        entity.t().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.R.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean l(Entity entity) {
        return !this.bP() && this.I <= 0;
    }

    protected boolean d(EntityPose entitypose) {
        return this.dI().a(this, this.e(entitypose).h(1.0E-7));
    }

    public void bz() {
        int i2 = this.r.size() - 1;
        while (i2 >= 0) {
            ((Entity)this.r.get(i2)).Y();
            --i2;
        }
    }

    public void bA() {
        if (this.s != null) {
            Entity entity = this.s;
            this.s = null;
            if (!entity.removePassenger(this)) {
                this.s = entity;
            }
        }
    }

    public void Y() {
        this.bA();
    }

    protected boolean addPassenger(Entity entity) {
        EntityMountEvent event;
        Entity orig;
        if (entity.cW() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        Preconditions.checkState((!entity.r.contains((Object)this) ? 1 : 0) != 0, (String)"Circular entity riding! %s %s", (Object)this, (Object)entity);
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleEnterEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.r.isEmpty()) {
            this.r = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.r);
            if (!this.dI().B && entity instanceof EntityHuman && !(this.cO() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.r = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, entity);
        return true;
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.cW() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.r = this.r.size() == 1 && this.r.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.r.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.I = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean o(Entity entity) {
        return this.r.isEmpty();
    }

    protected boolean bB() {
        return true;
    }

    public void a(double d0, double d1, double d2, float f2, float f1, int i2, boolean flag) {
        this.e(d0, d1, d2);
        this.a(f2, f1);
    }

    public void a(float f2, int i2) {
        this.n(f2);
    }

    public float bC() {
        return 0.0f;
    }

    public Vec3D bD() {
        return this.b(this.dA(), this.dy());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        if (!(this instanceof EntityHuman)) {
            return Vec3D.b;
        }
        EntityHuman entityhuman = (EntityHuman)this;
        boolean flag = entityhuman.eP().a(item) && !entityhuman.eO().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fh().d() : entityhuman.fh();
        return this.b(0.0f, this.dy() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bE() {
        return new Vec2F(this.dA(), this.dy());
    }

    public Vec3D bF() {
        return Vec3D.a(this.bE());
    }

    public void f(BlockPosition blockposition) {
        if (this.as()) {
            this.aq();
        } else {
            if (!this.dI().B && !blockposition.equals(this.aw)) {
                this.aw = blockposition.i();
            }
            this.au = true;
        }
    }

    protected void bG() {
        if (this.dI() instanceof WorldServer) {
            int i2 = this.at();
            WorldServer worldserver = (WorldServer)this.dI();
            if (this.au) {
                MinecraftServer minecraftserver = worldserver.n();
                ResourceKey<net.minecraft.world.level.World> resourcekey = this.dI().getTypeKey() == WorldDimension.c ? net.minecraft.world.level.World.h : net.minecraft.world.level.World.i;
                WorldServer worldserver1 = minecraftserver.a(resourcekey);
                if (!this.bM() && this.av++ >= i2) {
                    this.dI().ad().a("portal");
                    this.av = i2;
                    this.aq();
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).changeDimension(worldserver1, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                    } else {
                        this.b(worldserver1);
                    }
                    this.dI().ad().c();
                }
                this.au = false;
            } else {
                if (this.av > 0) {
                    this.av -= 4;
                }
                if (this.av < 0) {
                    this.av = 0;
                }
            }
            this.H();
        }
    }

    public int bH() {
        return 300;
    }

    public void l(double d0, double d1, double d2) {
        this.o(d0, d1, d2);
    }

    public void c(DamageSource damagesource) {
    }

    public void b(byte b0) {
        switch (b0) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void m(float f2) {
    }

    public Iterable<ItemStack> bI() {
        return e;
    }

    public Iterable<ItemStack> bJ() {
        return e;
    }

    public Iterable<ItemStack> bK() {
        return Iterables.concat(this.bI(), this.bJ());
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
    }

    public boolean bL() {
        boolean flag;
        boolean bl = flag = this.dI() != null && this.dI().B;
        return !this.aU() && (this.aN > 0 || flag && this.i(0));
    }

    public boolean bM() {
        return this.cW() != null;
    }

    public boolean bN() {
        return !this.r.isEmpty();
    }

    public boolean bO() {
        return this.ae().a(TagsEntity.m);
    }

    public void f(boolean flag) {
        this.b(1, flag);
    }

    public boolean bP() {
        return this.i(1);
    }

    public boolean bQ() {
        return this.bP();
    }

    public boolean bR() {
        return this.bP();
    }

    public boolean bS() {
        return this.bP();
    }

    public boolean bT() {
        return this.bP();
    }

    public boolean bU() {
        return this.c(EntityPose.f);
    }

    public boolean bV() {
        return this.i(3);
    }

    public void g(boolean flag) {
        this.b(3, flag);
    }

    public boolean bW() {
        return this.i(4);
    }

    public boolean bX() {
        return this.c(EntityPose.d);
    }

    public boolean bY() {
        return this.bX() && !this.aV();
    }

    public void h(boolean flag) {
        if (this.valid && this.bW() != flag && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, flag).isCancelled()) {
            return;
        }
        this.b(4, flag);
    }

    public final boolean bZ() {
        return this.bd;
    }

    public final void i(boolean flag) {
        this.bd = flag;
        this.b(6, this.ca());
    }

    public boolean ca() {
        return this.dI().r_() ? this.i(6) : this.bd;
    }

    public boolean cb() {
        return this.i(5);
    }

    public boolean d(EntityHuman entityhuman) {
        if (entityhuman.G_()) {
            return false;
        }
        ScoreboardTeamBase scoreboardteambase = this.cd();
        return scoreboardteambase != null && entityhuman != null && entityhuman.cd() == scoreboardteambase && scoreboardteambase.i() ? false : this.cb();
    }

    public boolean cc() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
    }

    @Nullable
    public ScoreboardTeamBase cd() {
        return this.dI().I().i(this.cv());
    }

    public boolean p(Entity entity) {
        return this.a(entity.cd());
    }

    public boolean a(ScoreboardTeamBase scoreboardteambase) {
        return this.cd() != null ? this.cd().a(scoreboardteambase) : false;
    }

    public void j(boolean flag) {
        if (!this.persistentInvisibility) {
            this.b(5, flag);
        }
    }

    public boolean i(int i2) {
        return (this.am.b(an) & 1 << i2) != 0;
    }

    public void b(int i2, boolean flag) {
        byte b0 = this.am.b(an);
        if (flag) {
            this.am.b(an, (byte)(b0 | 1 << i2));
        } else {
            this.am.b(an, (byte)(b0 & ~(1 << i2)));
        }
    }

    public int ce() {
        return this.maxAirTicks;
    }

    public int cf() {
        return this.am.b(aT);
    }

    public void j(int i2) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cf() != i2) {
            this.am.markDirty(aT);
            return;
        }
        this.am.b(aT, event.getAmount());
    }

    public int cg() {
        return this.am.b(aY);
    }

    public void k(int i2) {
        this.am.b(aY, i2);
    }

    public float ch() {
        int i2 = this.cj();
        return (float)Math.min(this.cg(), i2) / (float)i2;
    }

    public boolean ci() {
        return this.cg() >= this.cj();
    }

    public int cj() {
        return 140;
    }

    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        this.h(this.aN + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aN == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.setSecondsOnFire(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.aU()) {
            return;
        }
        CraftEventFactory.entityDamage = entitylightning;
        if (!this.a(this.dJ().b(), 5.0f)) {
            CraftEventFactory.entityDamage = null;
            return;
        }
    }

    public void k(boolean flag) {
        Vec3D vec3d = this.dl();
        double d0 = flag ? Math.max(-0.9, vec3d.d - 0.03) : Math.min(1.8, vec3d.d + 0.1);
        this.o(vec3d.c, d0, vec3d.e);
    }

    public void l(boolean flag) {
        Vec3D vec3d = this.dl();
        double d0 = flag ? Math.max(-0.3, vec3d.d - 0.03) : Math.min(0.7, vec3d.d + 0.06);
        this.o(vec3d.c, d0, vec3d.e);
        this.n();
    }

    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        return true;
    }

    public void ck() {
        if (this.dl().b() > -0.5 && this.aa > 1.0f) {
            this.aa = 1.0f;
        }
    }

    public void n() {
        this.aa = 0.0f;
    }

    protected void m(double d0, double d1, double d2) {
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        Vec3D vec3d = new Vec3D(d0 - (double)blockposition.u(), d1 - (double)blockposition.v(), d2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        EnumDirection[] aenumdirection = new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b};
        int i2 = aenumdirection.length;
        int j2 = 0;
        while (j2 < i2) {
            EnumDirection enumdirection1 = aenumdirection[j2];
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (!this.dI().a_(blockposition_mutableblockposition).r(this.dI(), blockposition_mutableblockposition)) {
                double d5;
                double d4 = vec3d.a(enumdirection1.o());
                double d6 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
                if (d5 < d3) {
                    d3 = d5;
                    enumdirection = enumdirection1;
                }
            }
            ++j2;
        }
        float f2 = this.af.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dl().a(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.o(f1 * f2, vec3d1.d, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.o(vec3d1.c, f1 * f2, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.o(vec3d1.c, vec3d1.d, f1 * f2);
        }
    }

    public void a(IBlockData iblockdata, Vec3D vec3d) {
        this.n();
        this.T = vec3d;
    }

    private static IChatBaseComponent c(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatmutablecomponent = ichatbasecomponent.d().b(ichatbasecomponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.c()) {
            ichatmutablecomponent.b(Entity.c(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? Entity.c(ichatbasecomponent) : this.cl();
    }

    protected IChatBaseComponent cl() {
        return this.p.h();
    }

    public boolean q(Entity entity) {
        return this == entity;
    }

    public float cm() {
        return 0.0f;
    }

    public void n(float f2) {
    }

    public void o(float f2) {
    }

    public boolean cn() {
        return true;
    }

    public boolean r(Entity entity) {
        return false;
    }

    public String toString() {
        String s2 = this.dI() == null ? "~NULL~" : this.dI().toString();
        return this.aK != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.Z().getString(), this.q, s2, this.dn(), this.dp(), this.dt(), this.aK}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.Z().getString(), this.q, s2, this.dn(), this.dp(), this.dt());
    }

    public boolean b(DamageSource damagesource) {
        return this.dD() || this.bc && !damagesource.a(DamageTypeTags.d) && !damagesource.g() || damagesource.a(DamageTypeTags.i) && this.aU() || damagesource.a(DamageTypeTags.m) && this.ae().a(TagsEntity.l);
    }

    public boolean co() {
        return this.bc;
    }

    public void m(boolean flag) {
        this.bc = flag;
    }

    public void s(Entity entity) {
        this.b(entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA());
    }

    public void t(Entity entity) {
        NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.bb = entity.bb;
        this.aw = entity.aw;
    }

    @Nullable
    public Entity b(WorldServer worldserver) {
        return this.teleportTo(worldserver, null);
    }

    @Nullable
    public Entity teleportTo(WorldServer worldserver, Position location) {
        if (this.dI() instanceof WorldServer && !this.dD()) {
            ShapeDetectorShape shapedetectorshape;
            this.dI().ad().a("changeDimension");
            if (worldserver == null) {
                return null;
            }
            this.dI().ad().a("reposition");
            ShapeDetectorShape shapeDetectorShape = shapedetectorshape = location == null ? this.a(worldserver) : new ShapeDetectorShape(new Vec3D(location.a(), location.b(), location.c()), Vec3D.b, this.aG, this.aH, worldserver, null);
            if (shapedetectorshape == null) {
                return null;
            }
            worldserver = shapedetectorshape.world;
            if (worldserver == this.t) {
                this.b(shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.a.e, shapedetectorshape.c, shapedetectorshape.d);
                this.f(shapedetectorshape.b);
                return this;
            }
            this.ac();
            this.dI().ad().b("reloading");
            Object entity = this.ae().a(worldserver);
            if (entity != null) {
                ((Entity)entity).t(this);
                ((Entity)entity).b(shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.a.e, shapedetectorshape.c, ((Entity)entity).dA());
                ((Entity)entity).f(shapedetectorshape.b);
                worldserver.d((Entity)entity);
                if (worldserver.getTypeKey() == WorldDimension.d) {
                    WorldServer.makeObsidianPlatform(worldserver, this);
                }
                this.getBukkitEntity().setHandle((Entity)entity);
                ((Entity)entity).bukkitEntity = this.getBukkitEntity();
                if (this instanceof EntityInsentient) {
                    ((EntityInsentient)this).a(true, false);
                }
            }
            this.cp();
            this.dI().ad().c();
            ((WorldServer)this.dI()).g();
            worldserver.g();
            this.dI().ad().c();
            return entity;
        }
        return null;
    }

    protected void cp() {
        this.b(RemovalReason.e);
    }

    @Nullable
    protected ShapeDetectorShape a(WorldServer worldserver) {
        boolean flag1;
        if (worldserver == null) {
            return null;
        }
        boolean flag = this.dI().getTypeKey() == WorldDimension.d && worldserver.getTypeKey() == WorldDimension.b;
        boolean bl = flag1 = worldserver.getTypeKey() == WorldDimension.d;
        if (!flag && !flag1) {
            boolean flag2;
            boolean bl2 = flag2 = worldserver.getTypeKey() == WorldDimension.c;
            if (this.dI().getTypeKey() != WorldDimension.c && !flag2) {
                return null;
            }
            WorldBorder worldborder = worldserver.w_();
            double d0 = DimensionManager.a(this.dI().x_(), worldserver.x_());
            BlockPosition blockposition = worldborder.b(this.dn() * d0, this.dp(), this.dt() * d0);
            CraftPortalEvent event = this.callPortalEvent(this, worldserver, new Position(blockposition.u(), blockposition.v(), blockposition.w()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, flag2 ? 16 : 128, 16);
            if (event == null) {
                return null;
            }
            WorldServer worldserverFinal = worldserver = ((CraftWorld)event.getTo().getWorld()).getHandle();
            worldborder = worldserverFinal.w_();
            blockposition = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            return this.getExitPortal(worldserver, blockposition, flag2, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius()).map(blockutil_rectangle -> {
                Vec3D vec3d;
                EnumDirection.EnumAxis enumdirection_enumaxis;
                IBlockData iblockdata = this.dI().a_(this.aw);
                if (iblockdata.b(BlockProperties.H)) {
                    enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
                    BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(this.aw, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, blockposition1 -> this.dI().a_((BlockPosition)blockposition1) == iblockdata);
                    vec3d = this.a(enumdirection_enumaxis, blockutil_rectangle1);
                } else {
                    enumdirection_enumaxis = EnumDirection.EnumAxis.a;
                    vec3d = new Vec3D(0.5, 0.0, 0.0);
                }
                return BlockPortalShape.createPortalInfo(worldserverFinal, blockutil_rectangle, enumdirection_enumaxis, vec3d, this, this.dl(), this.dy(), this.dA(), event);
            }).orElse(null);
        }
        BlockPosition blockposition1 = flag1 ? WorldServer.a : worldserver.a(HeightMap.Type.f, worldserver.R());
        CraftPortalEvent event = this.callPortalEvent(this, worldserver, new Position((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        return new ShapeDetectorShape(new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ()), this.dl(), this.dy(), this.dA(), ((CraftWorld)event.getTo().getWorld()).getHandle(), event);
    }

    protected Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return BlockPortalShape.a(blockutil_rectangle, enumdirection_enumaxis, this.dg(), this.a(this.al()));
    }

    protected CraftPortalEvent callPortalEvent(Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld());
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bs()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        return worldserver.o().findPortalAround(blockposition, worldborder, searchRadius);
    }

    public boolean cq() {
        return !this.bM() && !this.bN();
    }

    public float a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return f2;
    }

    public boolean a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, float f2) {
        return true;
    }

    public int cr() {
        return 3;
    }

    public boolean c_() {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Entity Type", () -> {
            MinecraftKey minecraftkey = EntityTypes.a(this.ae());
            return minecraftkey + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.a("Entity ID", this.q);
        crashreportsystemdetails.a("Entity Name", () -> this.Z().getString());
        crashreportsystemdetails.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dn(), this.dp(), this.dt()));
        crashreportsystemdetails.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dI(), MathHelper.a(this.dn()), MathHelper.a(this.dp()), MathHelper.a(this.dt())));
        Vec3D vec3d = this.dl();
        crashreportsystemdetails.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.c, vec3d.d, vec3d.e));
        crashreportsystemdetails.a("Entity's Passengers", () -> this.cN().toString());
        crashreportsystemdetails.a("Entity's Vehicle", () -> String.valueOf(this.cW()));
    }

    public boolean cs() {
        return this.bL() && !this.G_();
    }

    public void a_(UUID uuid) {
        this.ax = uuid;
        this.ay = this.ax.toString();
    }

    @Override
    public UUID ct() {
        return this.ax;
    }

    public String cu() {
        return this.ay;
    }

    public String cv() {
        return this.ay;
    }

    public boolean cw() {
        return true;
    }

    public static double cx() {
        return o;
    }

    public static void b(double d0) {
        o = d0;
    }

    @Override
    public IChatBaseComponent H_() {
        return ScoreboardTeam.a(this.cd(), this.Z()).a(chatmodifier -> chatmodifier.a(this.cD()).a(this.cu()));
    }

    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.am.b(aU, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    @Nullable
    public IChatBaseComponent ab() {
        return this.am.b(aU).orElse(null);
    }

    @Override
    public boolean aa() {
        return this.am.b(aU).isPresent();
    }

    public void n(boolean flag) {
        this.am.b(aV, flag);
    }

    public boolean cy() {
        return this.am.b(aV);
    }

    public final void n(double d0, double d1, double d2) {
        if (this.dI() instanceof WorldServer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
            ((WorldServer)this.dI()).k().a(TicketType.g, chunkcoordintpair, 0, this.af());
            this.dI().d(chunkcoordintpair.e, chunkcoordintpair.f);
            this.b(d0, d1, d2);
        }
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1) {
        float f22 = MathHelper.a(f1, -90.0f, 90.0f);
        if (worldserver == this.dI()) {
            this.b(d0, d1, d2, f2, f22);
            this.s();
            this.n(f2);
        } else {
            this.ac();
            Object entity = this.ae().a(worldserver);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).t(this);
            ((Entity)entity).b(d0, d1, d2, f2, f22);
            ((Entity)entity).n(f2);
            this.b(RemovalReason.e);
            worldserver.d((Entity)entity);
        }
        return true;
    }

    public void a(double d0, double d1, double d2) {
        this.b(d0, d1, d2);
    }

    public void b(double d0, double d1, double d2) {
        if (this.dI() instanceof WorldServer) {
            this.b(d0, d1, d2, this.dy(), this.dA());
            this.s();
        }
    }

    private void s() {
        this.cP().forEach(entity -> {
            for (Entity entity1 : entity.r) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double d0, double d1, double d2) {
        this.b(this.dn() + d0, this.dp() + d1, this.dt() + d2);
    }

    public boolean cz() {
        return this.cy();
    }

    public void a(List<DataWatcher.b<?>> list) {
    }

    public void a(DataWatcherObject<?> datawatcherobject) {
        if (ar.equals(datawatcherobject)) {
            this.d_();
        }
    }

    @Deprecated
    protected void cA() {
        EntitySize entitysize;
        EntityPose entitypose = this.al();
        this.bh = entitysize = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize);
    }

    public void d_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bh;
        EntityPose entitypose = this.al();
        this.bh = entitysize1 = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize1);
        this.an();
        boolean bl = flag = (double)entitysize1.a <= 4.0 && (double)entitysize1.b <= 4.0;
        if (!(this.dI().B || this.al || this.ae || !flag || !(entitysize1.a > entitysize.a) && !(entitysize1.b > entitysize.b) || this instanceof EntityHuman)) {
            Vec3D vec3d = this.dg().b(0.0, (double)entitysize.b / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitysize1.a - entitysize.a) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitysize1.b - entitysize.b) + 1.0E-6;
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, d1, d0));
            this.dI().a(this, voxelshape, vec3d, (double)entitysize1.a, (double)entitysize1.b, (double)entitysize1.a).ifPresent(vec3d1 -> this.a(vec3d1.b(0.0, (double)(-entitySize.b) / 2.0, 0.0)));
        }
    }

    public EnumDirection cB() {
        return EnumDirection.a(this.dy());
    }

    public EnumDirection cC() {
        return this.cB();
    }

    protected ChatHoverable cD() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.ae(), this.ct(), this.Z()));
    }

    public boolean a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public final AxisAlignedBB cE() {
        return this.aI;
    }

    public AxisAlignedBB j_() {
        return this.cE();
    }

    protected AxisAlignedBB e(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        float f2 = entitysize.a / 2.0f;
        Vec3D vec3d = new Vec3D(this.dn() - (double)f2, this.dp(), this.dt() - (double)f2);
        Vec3D vec3d1 = new Vec3D(this.dn() + (double)f2, this.dp() + (double)entitysize.b, this.dt() + (double)f2);
        return new AxisAlignedBB(vec3d, vec3d1);
    }

    public final void a(AxisAlignedBB axisalignedbb) {
        double minX = axisalignedbb.a;
        double minY = axisalignedbb.b;
        double minZ = axisalignedbb.c;
        double maxX = axisalignedbb.d;
        double maxY = axisalignedbb.e;
        double maxZ = axisalignedbb.f;
        double len = axisalignedbb.d - axisalignedbb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.e - axisalignedbb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.f - axisalignedbb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aI = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float a(EntityPose entitypose, EntitySize entitysize) {
        return entitysize.b * 0.85f;
    }

    public float f(EntityPose entitypose) {
        return this.a(entitypose, this.a(entitypose));
    }

    public final float cF() {
        return this.bi;
    }

    public Vec3D p(float f2) {
        return this.cG();
    }

    protected Vec3D cG() {
        return new Vec3D(0.0, this.cF(), this.dd() * 0.4f);
    }

    public SlotAccess a_(int i2) {
        return SlotAccess.b;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
    }

    public net.minecraft.world.level.World cH() {
        return this.dI();
    }

    @Nullable
    public MinecraftServer cI() {
        return this.dI().n();
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.d;
    }

    public boolean cJ() {
        return false;
    }

    public void a(EntityLiving entityliving, Entity entity) {
        if (entity instanceof EntityLiving) {
            EnchantmentManager.a((EntityLiving)entity, (Entity)entityliving);
        }
        EnchantmentManager.b(entityliving, entity);
    }

    public void c(EntityPlayer entityplayer) {
    }

    public void d(EntityPlayer entityplayer) {
    }

    public float a(EnumBlockRotation enumblockrotation) {
        float f2 = MathHelper.g(this.dy());
        switch (enumblockrotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror enumblockmirror) {
        float f2 = MathHelper.g(this.dy());
        switch (enumblockmirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cK() {
        return false;
    }

    @Nullable
    public EntityLiving cL() {
        return null;
    }

    public final boolean cM() {
        return this.cL() != null;
    }

    public final List<Entity> cN() {
        return this.r;
    }

    @Nullable
    public Entity cO() {
        return this.r.isEmpty() ? null : (Entity)this.r.get(0);
    }

    public boolean u(Entity entity) {
        return this.r.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.r.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> t() {
        return this.r.stream().flatMap(Entity::cP);
    }

    public Stream<Entity> cP() {
        return Stream.concat(Stream.of(this), this.t());
    }

    public Stream<Entity> cQ() {
        return Stream.concat(this.r.stream().flatMap(Entity::cQ), Stream.of(this));
    }

    public Iterable<Entity> cR() {
        return () -> this.t().iterator();
    }

    public boolean cS() {
        return this.t().filter(entity -> entity instanceof EntityHuman).count() == 1L;
    }

    public Entity cT() {
        Entity entity = this;
        while (entity.bM()) {
            entity = entity.cW();
        }
        return entity;
    }

    public boolean v(Entity entity) {
        return this.cT() == entity.cT();
    }

    public boolean w(Entity entity) {
        if (!entity.bM()) {
            return false;
        }
        Entity entity1 = entity.cW();
        return entity1 == this ? true : this.w(entity1);
    }

    public boolean cU() {
        EntityLiving entityliving = this.cL();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.g();
        }
        return this.cV();
    }

    public boolean cV() {
        return !this.dI().B;
    }

    protected static Vec3D a(double d0, double d1, float f2) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(f2 * ((float)Math.PI / 180));
        float f22 = MathHelper.b(f2 * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f22));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f22 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving entityliving) {
        return new Vec3D(this.dn(), this.cE().e, this.dt());
    }

    @Nullable
    public Entity cW() {
        return this.s;
    }

    @Nullable
    public Entity cX() {
        return this.s != null && this.s.cL() == this ? this.s : null;
    }

    public EnumPistonReaction l_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory cY() {
        return SoundCategory.g;
    }

    public int cZ() {
        return 1;
    }

    public CommandListenerWrapper da() {
        return new CommandListenerWrapper(this, this.dg(), this.bE(), this.dI() instanceof WorldServer ? (WorldServer)this.dI() : null, this.B(), this.Z().getString(), this.H_(), this.dI().n(), this);
    }

    protected int B() {
        return 0;
    }

    public boolean l(int i2) {
        return this.B() >= i2;
    }

    @Override
    public boolean e_() {
        return this.dI().X().b(GameRules.o);
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public boolean N_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        Vec3D vec3d1 = argumentanchor_anchor.a(this);
        double d0 = vec3d.c - vec3d1.c;
        double d1 = vec3d.d - vec3d1.d;
        double d2 = vec3d.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.b_(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.a_(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.n(this.dy());
        this.N = this.dA();
        this.M = this.dy();
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        if (this.db()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cE().h(0.001);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.e);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cw();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.b;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int l1 = i2;
        while (l1 < j2) {
            int i22 = k2;
            while (i22 < l2) {
                int j22 = i1;
                while (j22 < j1) {
                    double d2;
                    blockposition_mutableblockposition.d(l1, i22, j22);
                    Fluid fluid = this.dI().b_(blockposition_mutableblockposition);
                    if (fluid.a(tagkey) && (d2 = (double)((float)i22 + fluid.a((IBlockAccess)this.dI(), (BlockPosition)blockposition_mutableblockposition))) >= axisalignedbb.b) {
                        flag1 = true;
                        d1 = Math.max(d2 - axisalignedbb.b, d1);
                        if (flag) {
                            Vec3D vec3d1 = fluid.c(this.dI(), blockposition_mutableblockposition);
                            if (d1 < 0.4) {
                                vec3d1 = vec3d1.a(d1);
                            }
                            vec3d = vec3d.e(vec3d1);
                            ++k1;
                        }
                        if (tagkey == TagsFluid.b) {
                            this.lastLavaContact = blockposition_mutableblockposition.i();
                        }
                    }
                    ++j22;
                }
                ++i22;
            }
            ++l1;
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dl();
            vec3d = vec3d.a(d0 * 1.0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.c) < 0.003 && Math.abs(vec3d2.e) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.f(this.dl().e(vec3d));
        }
        this.ai.put(tagkey, d1);
        return flag1;
    }

    public boolean db() {
        AxisAlignedBB axisalignedbb = this.cE().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dI().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> tagkey) {
        return this.ai.getDouble(tagkey);
    }

    public double dc() {
        return (double)this.cF() < 0.4 ? 0.0 : 0.4;
    }

    public final float dd() {
        return this.bh.a;
    }

    public final float de() {
        return this.bh.b;
    }

    public float df() {
        return this.de() + 0.5f;
    }

    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntitySize a(EntityPose entitypose) {
        return this.p.n();
    }

    public Vec3D dg() {
        return this.u;
    }

    public Vec3D dh() {
        return this.dg();
    }

    @Override
    public BlockPosition di() {
        return this.aD;
    }

    public IBlockData dj() {
        if (this.bn == null) {
            this.bn = this.dI().a_(this.di());
        }
        return this.bn;
    }

    public ChunkCoordIntPair dk() {
        return this.aE;
    }

    public Vec3D dl() {
        return this.aF;
    }

    public void f(Vec3D vec3d) {
        this.aF = vec3d;
    }

    public void g(Vec3D vec3d) {
        this.f(this.dl().e(vec3d));
    }

    public void o(double d0, double d1, double d2) {
        this.f(new Vec3D(d0, d1, d2));
    }

    public final int dm() {
        return this.aD.u();
    }

    public final double dn() {
        return this.u.c;
    }

    public double c(double d0) {
        return this.u.c + (double)this.dd() * d0;
    }

    public double d(double d0) {
        return this.c((2.0 * this.af.j() - 1.0) * d0);
    }

    public final int do() {
        return this.aD.v();
    }

    public final double dp() {
        return this.u.d;
    }

    public double e(double d0) {
        return this.u.d + (double)this.de() * d0;
    }

    public double dq() {
        return this.e(this.af.j());
    }

    public double dr() {
        return this.u.d + (double)this.bi;
    }

    public final int ds() {
        return this.aD.w();
    }

    public final double dt() {
        return this.u.e;
    }

    public double f(double d0) {
        return this.u.e + (double)this.dd() * d0;
    }

    public double g(double d0) {
        return this.f((2.0 * this.af.j() - 1.0) * d0);
    }

    public final void p(double d0, double d1, double d2) {
        if (this.u.c != d0 || this.u.d != d1 || this.u.e != d2) {
            this.u = new Vec3D(d0, d1, d2);
            int i2 = MathHelper.a(d0);
            int j2 = MathHelper.a(d1);
            int k2 = MathHelper.a(d2);
            if (i2 != this.aD.u() || j2 != this.aD.v() || k2 != this.aD.w()) {
                this.aD = new BlockPosition(i2, j2, k2);
                this.bn = null;
                if (SectionPosition.a(i2) != this.aE.e || SectionPosition.a(k2) != this.aE.f) {
                    this.aE = new ChunkCoordIntPair(this.aD);
                }
            }
            this.aZ.a();
        }
    }

    public void du() {
    }

    public Vec3D q(float f2) {
        return this.l(f2).b(0.0, (double)this.bi * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        int i2 = packetplayoutspawnentity.a();
        double d0 = packetplayoutspawnentity.e();
        double d1 = packetplayoutspawnentity.f();
        double d2 = packetplayoutspawnentity.g();
        this.f(d0, d1, d2);
        this.d(d0, d1, d2);
        this.b_(packetplayoutspawnentity.k());
        this.a_(packetplayoutspawnentity.l());
        this.e(i2);
        this.a_(packetplayoutspawnentity.c());
    }

    @Nullable
    public ItemStack dv() {
        return null;
    }

    public void o(boolean flag) {
        this.az = flag;
    }

    public boolean dw() {
        return !this.ae().a(TagsEntity.i);
    }

    public boolean dx() {
        return (this.az || this.aA) && this.dw();
    }

    public float dy() {
        return this.aG;
    }

    public float dz() {
        return this.dy();
    }

    public void a_(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.a("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aG = f2;
        }
    }

    public float dA() {
        return this.aH;
    }

    public void b_(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.a("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aH = f2;
        }
    }

    public boolean dB() {
        return false;
    }

    public float dC() {
        return this.aM;
    }

    public void r(float f2) {
        this.aM = f2;
    }

    public final boolean dD() {
        return this.aK != null;
    }

    @Nullable
    public RemovalReason dE() {
        return this.aK;
    }

    @Override
    public final void b(RemovalReason entity_removalreason) {
        if (this.aK == null) {
            this.aK = entity_removalreason;
        }
        if (this.aK.a()) {
            this.Y();
        }
        this.cN().forEach(Entity::Y);
        this.aZ.a(entity_removalreason);
    }

    public void dF() {
        this.aK = null;
    }

    @Override
    public void a(EntityInLevelCallback entityinlevelcallback) {
        this.aZ = entityinlevelcallback;
    }

    @Override
    public boolean dG() {
        return this.aK != null && !this.aK.b() ? false : (this.bM() ? false : !this.bN() || !this.cS());
    }

    @Override
    public boolean dH() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        return true;
    }

    public net.minecraft.world.level.World dI() {
        return this.t;
    }

    protected void a(net.minecraft.world.level.World world) {
        this.t = world;
    }

    public DamageSources dJ() {
        return this.dI().ag();
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }
}

