/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityInsentient
extends EntityLiving
implements Targeting {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    protected static final int f = 1;
    private static final BaseBlockPosition bS = new BaseBlockPosition(1, 0, 1);
    public static final float g = 0.15f;
    public static final float bB = 0.55f;
    public static final float bC = 0.5f;
    public static final float bD = 0.25f;
    public static final String bE = "Leash";
    public static final float bF = 0.085f;
    public static final int bG = 2;
    public static final int bH = 2;
    public int bI;
    protected int bJ;
    protected ControllerLook bK;
    protected ControllerMove bL;
    protected ControllerJump bM;
    private final EntityAIBodyControl bT;
    protected NavigationAbstract bN;
    public PathfinderGoalSelector bO;
    public PathfinderGoalSelector bP;
    @Nullable
    private EntityLiving bU;
    private final EntitySenses bV;
    private final NonNullList<ItemStack> bW = NonNullList.a(2, ItemStack.b);
    public final float[] bQ = new float[2];
    private final NonNullList<ItemStack> bX = NonNullList.a(4, ItemStack.b);
    public final float[] bR = new float[4];
    private boolean bY;
    private boolean bZ;
    private final Map<PathType, Float> ca = Maps.newEnumMap(PathType.class);
    @Nullable
    public MinecraftKey cb;
    public long cc;
    @Nullable
    private Entity cd;
    private int ce;
    @Nullable
    private NBTTagCompound cf;
    private BlockPosition cg = BlockPosition.b;
    private float ch = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.bO = new PathfinderGoalSelector(world.ae());
        this.bP = new PathfinderGoalSelector(world.ae());
        this.bK = new ControllerLook(this);
        this.bL = new ControllerMove(this);
        this.bM = new ControllerJump(this);
        this.bT = this.D();
        this.bN = this.b(world);
        this.bV = new EntitySenses(this);
        Arrays.fill(this.bR, 0.085f);
        Arrays.fill(this.bQ, 0.085f);
        if (world != null && !world.B) {
            this.x();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.bZ = persistenceRequired;
    }

    protected void x() {
    }

    public static AttributeProvider.Builder y() {
        return EntityLiving.dM().a(GenericAttributes.b, 16.0).a(GenericAttributes.g);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean z() {
        return false;
    }

    public float a(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.cX();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).z() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.ca.get((Object)pathtype);
        return ofloat == null ? pathtype.a() : ofloat.floatValue();
    }

    public void a(PathType pathtype, float f2) {
        this.ca.put(pathtype, Float.valueOf(f2));
    }

    public void A() {
    }

    public void C() {
    }

    protected EntityAIBodyControl D() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook E() {
        return this.bK;
    }

    public ControllerMove G() {
        Entity entity = this.cX();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.G();
        }
        return this.bL;
    }

    public ControllerJump I() {
        return this.bM;
    }

    public NavigationAbstract J() {
        Entity entity = this.cX();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.J();
        }
        return this.bN;
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        Entity entity;
        if (!this.fQ() && (entity = this.cO()) instanceof EntityInsentient) {
            EntityInsentient entityinsentient1;
            EntityInsentient entityinsentient = entityinsentient1 = (EntityInsentient)entity;
            return entityinsentient;
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses K() {
        return this.bV;
    }

    @Override
    @Nullable
    public EntityLiving j() {
        return this.bU;
    }

    public void h(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.j() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.j() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.j().bs() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dI().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bU = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.Q;
    }

    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return false;
    }

    public void L() {
        this.a(GameEvent.m);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)0);
    }

    public int M() {
        return 80;
    }

    public void N() {
        SoundEffect soundeffect = this.s();
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    @Override
    public void ao() {
        super.ao();
        this.dI().ad().a("mobBaseTick");
        if (this.bs() && this.af.a(1000) < this.bI++) {
            this.q();
            this.N();
        }
        this.dI().ad().c();
    }

    @Override
    protected void e(DamageSource damagesource) {
        this.q();
        super.e(damagesource);
    }

    private void q() {
        this.bI = -this.M();
    }

    @Override
    public int ea() {
        if (this.bJ > 0) {
            int i2 = this.bJ;
            int j2 = 0;
            while (j2 < this.bX.size()) {
                if (!this.bX.get(j2).b() && this.bR[j2] <= 1.0f) {
                    i2 += 1 + this.af.a(3);
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < this.bW.size()) {
                if (!this.bW.get(j2).b() && this.bQ[j2] <= 1.0f) {
                    i2 += 1 + this.af.a(3);
                }
                ++j2;
            }
            return i2;
        }
        return this.bJ;
    }

    public void O() {
        if (this.dI().B) {
            int i2 = 0;
            while (i2 < 20) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                double d3 = 10.0;
                this.dI().a(Particles.W, this.c(1.0) - d0 * 10.0, this.dq() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
                ++i2;
            }
        } else {
            this.dI().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 20) {
            this.O();
        } else {
            super.b(b0);
        }
    }

    @Override
    public void l() {
        super.l();
        if (!this.dI().B) {
            this.fN();
            if (this.ag % 5 == 0) {
                this.P();
            }
        }
    }

    protected void P() {
        boolean flag = !(this.cL() instanceof EntityInsentient);
        boolean flag1 = !(this.cW() instanceof EntityBoat);
        this.bO.a(PathfinderGoal.Type.a, flag);
        this.bO.a(PathfinderGoal.Type.c, flag && flag1);
        this.bO.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float e(float f2, float f1) {
        this.bT.a();
        return f1;
    }

    @Nullable
    protected SoundEffect s() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.s();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound2;
        super.b(nbttagcompound);
        nbttagcompound.a("CanPickUpLoot", this.fG());
        nbttagcompound.a("PersistenceRequired", this.bZ);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.bX) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.bW) {
            nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbttagcompound.a("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        float[] afloat = this.bR;
        int i2 = afloat.length;
        int j2 = 0;
        while (j2 < i2) {
            float f2 = afloat[j2];
            nbttaglist2.add(NBTTagFloat.a(f2));
            ++j2;
        }
        nbttagcompound.a("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        float[] afloat1 = this.bQ;
        j2 = afloat1.length;
        int k2 = 0;
        while (k2 < j2) {
            float f1 = afloat1[k2];
            nbttaglist3.add(NBTTagFloat.a(f1));
            ++k2;
        }
        nbttagcompound.a("HandDropChances", nbttaglist3);
        if (this.cd != null) {
            nbttagcompound2 = new NBTTagCompound();
            if (this.cd instanceof EntityLiving) {
                UUID uuid = this.cd.ct();
                nbttagcompound2.a("UUID", uuid);
            } else if (this.cd instanceof EntityHanging) {
                BlockPosition blockposition = ((EntityHanging)this.cd).y();
                nbttagcompound2.a("X", blockposition.u());
                nbttagcompound2.a("Y", blockposition.v());
                nbttagcompound2.a("Z", blockposition.w());
            }
            nbttagcompound.a(bE, nbttagcompound2);
        } else if (this.cf != null) {
            nbttagcompound.a(bE, this.cf.h());
        }
        nbttagcompound.a("LeftHanded", this.fR());
        if (this.cb != null) {
            nbttagcompound.a("DeathLootTable", this.cb.toString());
            if (this.cc != 0L) {
                nbttagcompound.a("DeathLootTableSeed", this.cc);
            }
        }
        if (this.fQ()) {
            nbttagcompound.a("NoAI", this.fQ());
        }
        nbttagcompound.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbttagcompound);
        if (nbttagcompound.b("CanPickUpLoot", 1)) {
            data = nbttagcompound.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
                this.s(data);
            }
        }
        data = nbttagcompound.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
            this.bZ = data;
        }
        if (nbttagcompound.b("ArmorItems", 9)) {
            nbttaglist = nbttagcompound.c("ArmorItems", 10);
            i2 = 0;
            while (i2 < this.bX.size()) {
                this.bX.set(i2, ItemStack.a(nbttaglist.a(i2)));
                ++i2;
            }
        }
        if (nbttagcompound.b("HandItems", 9)) {
            nbttaglist = nbttagcompound.c("HandItems", 10);
            i2 = 0;
            while (i2 < this.bW.size()) {
                this.bW.set(i2, ItemStack.a(nbttaglist.a(i2)));
                ++i2;
            }
        }
        if (nbttagcompound.b("ArmorDropChances", 9)) {
            nbttaglist = nbttagcompound.c("ArmorDropChances", 5);
            i2 = 0;
            while (i2 < nbttaglist.size()) {
                this.bR[i2] = nbttaglist.i(i2);
                ++i2;
            }
        }
        if (nbttagcompound.b("HandDropChances", 9)) {
            nbttaglist = nbttagcompound.c("HandDropChances", 5);
            i2 = 0;
            while (i2 < nbttaglist.size()) {
                this.bQ[i2] = nbttaglist.i(i2);
                ++i2;
            }
        }
        if (nbttagcompound.b(bE, 10)) {
            this.cf = nbttagcompound.p(bE);
        }
        this.u(nbttagcompound.q("LeftHanded"));
        if (nbttagcompound.b("DeathLootTable", 8)) {
            this.cb = new MinecraftKey(nbttagcompound.l("DeathLootTable"));
            this.cc = nbttagcompound.i("DeathLootTableSeed");
        }
        this.t(nbttagcompound.q("NoAI"));
        if (nbttagcompound.e("Bukkit.Aware")) {
            this.aware = nbttagcompound.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource damagesource, boolean flag) {
        super.a(damagesource, flag);
        this.cb = null;
    }

    @Override
    public final MinecraftKey ew() {
        return this.cb == null ? this.Q() : this.cb;
    }

    public MinecraftKey Q() {
        return super.ew();
    }

    @Override
    public long ex() {
        return this.cc;
    }

    public void z(float f2) {
        this.bn = f2;
    }

    public void A(float f2) {
        this.bm = f2;
    }

    public void B(float f2) {
        this.bl = f2;
    }

    @Override
    public void w(float f2) {
        super.w(f2);
        this.z(f2);
    }

    @Override
    public void b_() {
        super.b_();
        this.dI().ad().a("looting");
        if (!this.dI().B && this.fG() && this.bs() && !this.bb && this.dI().X().b(GameRules.c)) {
            BaseBlockPosition baseblockposition = this.R();
            List<EntityItem> list = this.dI().a(EntityItem.class, this.cE().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
            for (EntityItem entityitem : list) {
                if (entityitem.dD() || entityitem.j().b() || entityitem.r() || !this.k(entityitem.j())) continue;
                this.b(entityitem);
            }
        }
        this.dI().ad().c();
    }

    protected BaseBlockPosition R() {
        return bS;
    }

    protected void b(EntityItem entityitem) {
        ItemStack itemstack = entityitem.j();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.p(), entityitem);
        if (!itemstack1.b()) {
            this.a(entityitem);
            this.a((Entity)entityitem, itemstack1.L());
            itemstack.h(itemstack1.L());
            if (itemstack.b()) {
                entityitem.ai();
            }
        }
    }

    public ItemStack i(ItemStack itemstack) {
        return this.equipItemIfPossible(itemstack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        ItemStack itemstack1 = this.c(enumitemslot);
        boolean flag = this.b(itemstack, itemstack1);
        if (enumitemslot.e() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.c(enumitemslot);
            flag = itemstack1.b();
        }
        boolean bl = canPickup = flag && this.j(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.af.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            if (enumitemslot.e() && itemstack.L() > 1) {
                ItemStack itemstack2 = itemstack.c(1);
                this.b(enumitemslot, itemstack2);
                return itemstack2;
            }
            this.b(enumitemslot, itemstack);
            return itemstack;
        }
        return ItemStack.b;
    }

    protected void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.a(enumitemslot, itemstack);
        this.e(enumitemslot);
        this.bZ = true;
    }

    public void e(EnumItemSlot enumitemslot) {
        switch (enumitemslot.a()) {
            case a: {
                this.bQ[enumitemslot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bR[enumitemslot.b()] = 2.0f;
            }
        }
    }

    protected boolean b(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack1.b()) {
            return true;
        }
        if (itemstack.d() instanceof ItemSword) {
            if (!(itemstack1.d() instanceof ItemSword)) {
                return true;
            }
            ItemSword itemsword = (ItemSword)itemstack.d();
            ItemSword itemsword1 = (ItemSword)itemstack1.d();
            return itemsword.h() != itemsword1.h() ? itemsword.h() > itemsword1.h() : this.c(itemstack, itemstack1);
        }
        if (itemstack.d() instanceof ItemBow && itemstack1.d() instanceof ItemBow) {
            return this.c(itemstack, itemstack1);
        }
        if (itemstack.d() instanceof ItemCrossbow && itemstack1.d() instanceof ItemCrossbow) {
            return this.c(itemstack, itemstack1);
        }
        if (itemstack.d() instanceof ItemArmor) {
            if (EnchantmentManager.d(itemstack1)) {
                return false;
            }
            if (!(itemstack1.d() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor = (ItemArmor)itemstack.d();
            ItemArmor itemarmor1 = (ItemArmor)itemstack1.d();
            return itemarmor.e() != itemarmor1.e() ? itemarmor.e() > itemarmor1.e() : (itemarmor.f() != itemarmor1.f() ? itemarmor.f() > itemarmor1.f() : this.c(itemstack, itemstack1));
        }
        if (itemstack.d() instanceof ItemTool) {
            if (itemstack1.d() instanceof ItemBlock) {
                return true;
            }
            if (itemstack1.d() instanceof ItemTool) {
                ItemTool itemtool = (ItemTool)itemstack.d();
                ItemTool itemtool1 = (ItemTool)itemstack1.d();
                if (itemtool.d() != itemtool1.d()) {
                    return itemtool.d() > itemtool1.d();
                }
                return this.c(itemstack, itemstack1);
            }
        }
        return false;
    }

    public boolean c(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.k() >= itemstack1.k() && (!itemstack.u() || itemstack1.u()) ? (itemstack.u() && itemstack1.u() ? itemstack.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) && !itemstack1.v().e().stream().anyMatch(s2 -> !s2.equals("Damage")) : false) : true;
    }

    public boolean j(ItemStack itemstack) {
        return true;
    }

    public boolean k(ItemStack itemstack) {
        return this.j(itemstack);
    }

    public boolean h(double d0) {
        return true;
    }

    public boolean T() {
        return this.bM();
    }

    protected boolean U() {
        return false;
    }

    @Override
    public void du() {
        if (this.dI().ai() == EnumDifficulty.a && this.U()) {
            this.ai();
        } else if (!this.fH() && !this.T()) {
            EntityHuman entityhuman = this.dI().a((Entity)this, -1.0);
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.f((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.ae().f().f()) * i2) && this.h(d0)) {
                    this.ai();
                }
                int k2 = this.ae().f().g();
                int l2 = k2 * k2;
                if (this.bc > 600 && this.af.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.ai();
                } else if (d0 < (double)l2) {
                    this.bc = 0;
                }
            }
        } else {
            this.bc = 0;
        }
    }

    @Override
    protected final void fc() {
        ++this.bc;
        if (!this.aware) {
            return;
        }
        this.dI().ad().a("sensing");
        this.bV.a();
        this.dI().ad().c();
        int i2 = this.dI().n().ag() + this.af();
        if (i2 % 2 != 0 && this.ag > 1) {
            this.dI().ad().a("targetSelector");
            this.bP.a(false);
            this.dI().ad().c();
            this.dI().ad().a("goalSelector");
            this.bO.a(false);
            this.dI().ad().c();
        } else {
            this.dI().ad().a("targetSelector");
            this.bP.a();
            this.dI().ad().c();
            this.dI().ad().a("goalSelector");
            this.bO.a();
            this.dI().ad().c();
        }
        this.dI().ad().a("navigation");
        this.bN.c();
        this.dI().ad().c();
        this.dI().ad().a("mob tick");
        this.W();
        this.dI().ad().c();
        this.dI().ad().a("controls");
        this.dI().ad().a("move");
        this.bL.a();
        this.dI().ad().b("look");
        this.bK.a();
        this.dI().ad().b("jump");
        this.bM.b();
        this.dI().ad().c();
        this.dI().ad().c();
        this.V();
    }

    protected void V() {
        PacketDebug.a(this.dI(), this, this.bO);
    }

    protected void W() {
    }

    public int X() {
        return 40;
    }

    public int fC() {
        return 75;
    }

    public int fD() {
        return 10;
    }

    public void a(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.dn() - this.dn();
        double d1 = entity.dt() - this.dt();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.dr() - this.dr();
        } else {
            d2 = (entity.cE().b + entity.cE().e) / 2.0 - this.dr();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.b_(this.a(this.dA(), f3, f1));
        this.a_(this.a(this.dy(), f22, f2));
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.g(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.d();
        return enummobspawn == EnumMobSpawn.c || generatoraccess.a_(blockposition1).a((IBlockAccess)generatoraccess, blockposition1, entitytypes);
    }

    public boolean a(GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn) {
        return true;
    }

    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cE()) && iworldreader.f(this);
    }

    public int fE() {
        return 4;
    }

    public boolean d(int i2) {
        return false;
    }

    @Override
    public int cr() {
        if (this.j() == null) {
            return 3;
        }
        int i2 = (int)(this.er() - this.eI() * 0.33f);
        if ((i2 -= (3 - this.dI().ai().a()) * 4) < 0) {
            i2 = 0;
        }
        return i2 + 3;
    }

    @Override
    public Iterable<ItemStack> bI() {
        return this.bW;
    }

    @Override
    public Iterable<ItemStack> bJ() {
        return this.bX;
    }

    @Override
    public ItemStack c(EnumItemSlot enumitemslot) {
        switch (enumitemslot.a()) {
            case a: {
                return this.bW.get(enumitemslot.b());
            }
            case b: {
                return this.bX.get(enumitemslot.b());
            }
        }
        return ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.a(enumitemslot, this.bW.set(enumitemslot.b(), itemstack), itemstack);
                break;
            }
            case b: {
                this.a(enumitemslot, this.bX.set(enumitemslot.b(), itemstack), itemstack);
            }
        }
    }

    @Override
    protected void a(DamageSource damagesource, int i2, boolean flag) {
        super.a(damagesource, i2, flag);
        EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
        int j2 = aenumitemslot.length;
        int k2 = 0;
        while (k2 < j2) {
            boolean flag1;
            EnumItemSlot enumitemslot = aenumitemslot[k2];
            ItemStack itemstack = this.c(enumitemslot);
            float f2 = this.f(enumitemslot);
            boolean bl = flag1 = f2 > 1.0f;
            if (!itemstack.b() && !EnchantmentManager.e(itemstack) && (flag || flag1) && Math.max(this.af.i() - (float)i2 * 0.01f, 0.0f) < f2) {
                if (!flag1 && itemstack.i()) {
                    itemstack.b(itemstack.l() - this.af.a(1 + this.af.a(Math.max(itemstack.l() - 3, 1))));
                }
                this.b(itemstack);
                this.a(enumitemslot, ItemStack.b);
            }
            ++k2;
        }
    }

    protected float f(EnumItemSlot enumitemslot) {
        return switch (enumitemslot.a()) {
            case EnumItemSlot.Function.a -> this.bQ[enumitemslot.b()];
            case EnumItemSlot.Function.b -> this.bR[enumitemslot.b()];
            default -> 0.0f;
        };
    }

    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.15f * difficultydamagescaler.d()) {
            float f2;
            int i2 = randomsource.a(2);
            float f3 = f2 = this.dI().ai() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
            int j2 = aenumitemslot.length;
            int k2 = 0;
            while (k2 < j2) {
                EnumItemSlot enumitemslot = aenumitemslot[k2];
                if (enumitemslot.a() == EnumItemSlot.Function.b) {
                    Item item;
                    ItemStack itemstack = this.c(enumitemslot);
                    if (!flag && randomsource.i() < f2) break;
                    flag = false;
                    if (itemstack.b() && (item = EntityInsentient.a(enumitemslot, i2)) != null) {
                        this.a(enumitemslot, new ItemStack(item));
                    }
                }
                ++k2;
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case f: {
                if (i2 == 0) {
                    return Items.oK;
                }
                if (i2 == 1) {
                    return Items.pa;
                }
                if (i2 == 2) {
                    return Items.oO;
                }
                if (i2 == 3) {
                    return Items.oS;
                }
                if (i2 == 4) {
                    return Items.oW;
                }
            }
            case e: {
                if (i2 == 0) {
                    return Items.oL;
                }
                if (i2 == 1) {
                    return Items.pb;
                }
                if (i2 == 2) {
                    return Items.oP;
                }
                if (i2 == 3) {
                    return Items.oT;
                }
                if (i2 == 4) {
                    return Items.oX;
                }
            }
            case d: {
                if (i2 == 0) {
                    return Items.oM;
                }
                if (i2 == 1) {
                    return Items.pc;
                }
                if (i2 == 2) {
                    return Items.oQ;
                }
                if (i2 == 3) {
                    return Items.oU;
                }
                if (i2 == 4) {
                    return Items.oY;
                }
            }
            case c: {
                if (i2 == 0) {
                    return Items.oN;
                }
                if (i2 == 1) {
                    return Items.pd;
                }
                if (i2 == 2) {
                    return Items.oR;
                }
                if (i2 == 3) {
                    return Items.oV;
                }
                if (i2 != 4) break;
                return Items.oZ;
            }
        }
        return null;
    }

    protected void b(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        float f2 = difficultydamagescaler.d();
        this.a(randomsource, f2);
        EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
        int i2 = aenumitemslot.length;
        int j2 = 0;
        while (j2 < i2) {
            EnumItemSlot enumitemslot = aenumitemslot[j2];
            if (enumitemslot.a() == EnumItemSlot.Function.b) {
                this.a(randomsource, f2, enumitemslot);
            }
            ++j2;
        }
    }

    protected void a(RandomSource randomsource, float f2) {
        if (!this.eO().b() && randomsource.i() < 0.25f * f2) {
            this.a(EnumItemSlot.a, EnchantmentManager.a(randomsource, this.eO(), (int)(5.0f + f2 * (float)randomsource.a(18)), false));
        }
    }

    protected void a(RandomSource randomsource, float f2, EnumItemSlot enumitemslot) {
        ItemStack itemstack = this.c(enumitemslot);
        if (!itemstack.b() && randomsource.i() < 0.5f * f2) {
            this.a(enumitemslot, EnchantmentManager.a(randomsource, itemstack, (int)(5.0f + f2 * (float)randomsource.a(18)), false));
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        RandomSource randomsource = worldaccess.y_();
        this.a(GenericAttributes.b).c(new AttributeModifier("Random spawn bonus", randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        if (randomsource.i() < 0.05f) {
            this.u(true);
        } else {
            this.u(false);
        }
        return groupdataentity;
    }

    public void fF() {
        this.bZ = true;
    }

    public void a(EnumItemSlot enumitemslot, float f2) {
        switch (enumitemslot.a()) {
            case a: {
                this.bQ[enumitemslot.b()] = f2;
                break;
            }
            case b: {
                this.bR[enumitemslot.b()] = f2;
            }
        }
    }

    public boolean fG() {
        return this.bY;
    }

    public void s(boolean flag) {
        this.bY = flag;
    }

    @Override
    public boolean f(ItemStack itemstack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        return this.c(enumitemslot).b() && this.fG();
    }

    public boolean fH() {
        return this.bZ;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.bs()) {
            return EnumInteractionResult.d;
        }
        if (this.fP() == entityhuman) {
            if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                ((EntityPlayer)entityhuman).c.a(new PacketPlayOutAttachEntity(this, this.fP()));
                return EnumInteractionResult.d;
            }
            this.a(true, !entityhuman.fO().d);
            this.a(GameEvent.r, (Entity)entityhuman);
            return EnumInteractionResult.a(this.dI().B);
        }
        EnumInteractionResult enuminteractionresult = this.c(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        enuminteractionresult = this.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        return super.a(entityhuman, enumhand);
    }

    private EnumInteractionResult c(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.tQ) && this.a(entityhuman)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                ((EntityPlayer)entityhuman).c.a(new PacketPlayOutAttachEntity(this, this.fP()));
                return EnumInteractionResult.d;
            }
            this.b((Entity)entityhuman, true);
            itemstack.h(1);
            return EnumInteractionResult.a(this.dI().B);
        }
        if (itemstack.a(Items.tR) && (enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.d() instanceof ItemMonsterEgg) {
            if (this.dI() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.d();
                Optional<EntityInsentient> optional = itemmonsteregg.a(entityhuman, this, this.ae(), (WorldServer)this.dI(), this.dg(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(entityhuman, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.d;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.d;
    }

    public boolean fI() {
        return this.a(this.di());
    }

    public boolean a(BlockPosition blockposition) {
        return this.ch == -1.0f ? true : this.cg.j(blockposition) < (double)(this.ch * this.ch);
    }

    public void a(BlockPosition blockposition, int i2) {
        this.cg = blockposition;
        this.ch = i2;
    }

    public BlockPosition fJ() {
        return this.cg;
    }

    public float fK() {
        return this.ch;
    }

    public void fL() {
        this.ch = -1.0f;
    }

    public boolean fM() {
        return this.ch != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, boolean flag) {
        return this.convertTo(entitytypes, flag, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dD()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dI());
        if (t0 == null) {
            return null;
        }
        t0.s(this);
        t0.a(this.h_());
        t0.t(this.fQ());
        if (this.aa()) {
            t0.b(this.ab());
            t0.n(this.cy());
        }
        if (this.fH()) {
            t0.fF();
        }
        t0.m(this.co());
        if (flag) {
            t0.s(this.fG());
            EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
            int i2 = aenumitemslot.length;
            int j2 = 0;
            while (j2 < i2) {
                EnumItemSlot enumitemslot = aenumitemslot[j2];
                ItemStack itemstack = this.c(enumitemslot);
                if (!itemstack.b()) {
                    t0.a(enumitemslot, itemstack.c());
                    t0.a(enumitemslot, this.f(enumitemslot));
                }
                ++j2;
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.dI().addFreshEntity(t0, spawnReason);
        if (this.bM()) {
            Entity entity = this.cW();
            this.Y();
            t0.a(entity, true);
        }
        this.ai();
        return (T)t0;
    }

    protected void fN() {
        if (this.cf != null) {
            this.fV();
        }
        if (!(this.cd == null || this.bs() && this.cd.bs())) {
            this.dI().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.bs() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE));
            this.a(true, true);
        }
    }

    public void a(boolean flag, boolean flag1) {
        if (this.cd != null) {
            this.cd = null;
            this.cf = null;
            if (!this.dI().B && flag1) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tQ);
                this.forceDrops = false;
            }
            if (!this.dI().B && flag && this.dI() instanceof WorldServer) {
                ((WorldServer)this.dI()).k().b(this, new PacketPlayOutAttachEntity(this, null));
            }
        }
    }

    public boolean a(EntityHuman entityhuman) {
        return !this.fO() && !(this instanceof IMonster);
    }

    public boolean fO() {
        return this.cd != null;
    }

    @Nullable
    public Entity fP() {
        if (this.cd == null && this.ce != 0 && this.dI().B) {
            this.cd = this.dI().a(this.ce);
        }
        return this.cd;
    }

    public void b(Entity entity, boolean flag) {
        this.cd = entity;
        this.cf = null;
        if (!this.dI().B && flag && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).k().b(this, new PacketPlayOutAttachEntity(this, this.cd));
        }
        if (this.bM()) {
            this.Y();
        }
    }

    public void r(int i2) {
        this.ce = i2;
        this.a(false, false);
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        boolean flag1 = super.a(entity, flag);
        if (flag1 && this.fO()) {
            this.dI().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.a(true, true);
        }
        return flag1;
    }

    private void fV() {
        if (this.cf != null && this.dI() instanceof WorldServer) {
            if (this.cf.b("UUID")) {
                UUID uuid = this.cf.a("UUID");
                Entity entity = ((WorldServer)this.dI()).a(uuid);
                if (entity != null) {
                    this.b(entity, true);
                    return;
                }
            } else if (this.cf.b("X", 99) && this.cf.b("Y", 99) && this.cf.b("Z", 99)) {
                BlockPosition blockposition = GameProfileSerializer.b(this.cf);
                this.b(EntityLeash.b(this.dI(), blockposition), true);
                return;
            }
            if (this.ag > 100) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tQ);
                this.forceDrops = false;
                this.cf = null;
            }
        }
    }

    @Override
    public boolean cV() {
        return super.cV() && !this.fQ();
    }

    public void t(boolean flag) {
        byte b0 = this.am.b(b);
        this.am.b(b, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void u(boolean flag) {
        byte b0 = this.am.b(b);
        this.am.b(b, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void v(boolean flag) {
        byte b0 = this.am.b(b);
        this.am.b(b, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fQ() {
        return (this.am.b(b) & 1) != 0;
    }

    public boolean fR() {
        return (this.am.b(b) & 2) != 0;
    }

    public boolean fS() {
        return (this.am.b(b) & 4) != 0;
    }

    public void a(boolean flag) {
    }

    @Override
    public EnumMainHand fh() {
        return this.fR() ? EnumMainHand.a : EnumMainHand.b;
    }

    public double i(EntityLiving entityliving) {
        return this.dd() * 2.0f * this.dd() * 2.0f + entityliving.dd();
    }

    public double j(EntityLiving entityliving) {
        return Math.max(this.e(entityliving.eA()), this.e(entityliving.dg()));
    }

    public boolean k(EntityLiving entityliving) {
        double d0 = this.j(entityliving);
        return d0 <= this.i(entityliving);
    }

    @Override
    public boolean z(Entity entity) {
        boolean flag;
        int i2;
        float f2 = (float)this.b(GenericAttributes.f);
        float f1 = (float)this.b(GenericAttributes.g);
        if (entity instanceof EntityLiving) {
            f2 += EnchantmentManager.a(this.eO(), ((EntityLiving)entity).eN());
            f1 += (float)EnchantmentManager.c(this);
        }
        if ((i2 = EnchantmentManager.d(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), i2 * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = entity.a(this.dJ().b(this), f2)) {
            if (f1 > 0.0f && entity instanceof EntityLiving) {
                ((EntityLiving)entity).q(f1 * 0.5f, MathHelper.a(this.dy() * ((float)Math.PI / 180)), -MathHelper.b(this.dy() * ((float)Math.PI / 180)));
                this.f(this.dl().d(0.6, 1.0, 0.6));
            }
            if (entity instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity;
                this.a(entityhuman, this.eO(), entityhuman.fi() ? entityhuman.fk() : ItemStack.b);
            }
            this.a((EntityLiving)this, entity);
            this.x(entity);
        }
        return flag;
    }

    private void a(EntityHuman entityhuman, ItemStack itemstack, ItemStack itemstack1) {
        if (!itemstack.b() && !itemstack1.b() && itemstack.d() instanceof ItemAxe && itemstack1.a(Items.uy)) {
            float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
            if (this.af.i() < f2) {
                entityhuman.gi().a(Items.uy, 100);
                this.dI().a((Entity)entityhuman, (byte)30);
            }
        }
    }

    protected boolean fT() {
        if (this.dI().N() && !this.dI().B) {
            boolean flag;
            float f2 = this.bj();
            BlockPosition blockposition = BlockPosition.a(this.dn(), this.dr(), this.dt());
            boolean bl = flag = this.aX() || this.az || this.aA;
            if (f2 > 0.5f && this.af.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dI().g(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        if (this.J().q()) {
            super.c(tagkey);
        } else {
            this.f(this.dl().b(0.0, 0.3, 0.0));
        }
    }

    public void fU() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.dK().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bO.a(predicate);
    }

    @Override
    protected void cp() {
        super.cp();
        this.dI().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
        this.a(true, false);
        this.bK().forEach(itemstack -> {
            if (!itemstack.b()) {
                itemstack.f(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dv() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ae());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

