/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_20_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger b = LogUtils.getLogger();
    private static final UUID c = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID d = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID e = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier bB = new AttributeModifier(c, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.c);
    public static final int h = 2;
    public static final int i = 4;
    public static final int j = 98;
    public static final int k = 100;
    public static final int l = 6;
    public static final int m = 100;
    private static final int bC = 40;
    public static final double n = 0.003;
    public static final double o = 0.08;
    public static final int p = 20;
    private static final int bD = 7;
    private static final int bE = 10;
    private static final int bF = 2;
    public static final int q = 4;
    private static final float bG = 0.42f;
    private static final double bH = 128.0;
    protected static final int r = 1;
    protected static final int s = 2;
    protected static final int t = 4;
    protected static final DataWatcherObject<Byte> u = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bI = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> bJ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bN = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.o);
    protected static final float aD = 1.74f;
    protected static final EntitySize aE = EntitySize.c(0.2f, 0.2f);
    public static final float aF = 0.5f;
    private static final int bO = 50;
    private final AttributeMapBase bP;
    public CombatTracker bQ = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> bR = Maps.newHashMap();
    private final NonNullList<ItemStack> bS;
    private final NonNullList<ItemStack> bT;
    public boolean aG;
    private boolean bU = false;
    public EnumHand aH;
    public int aI;
    public int aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public float aO;
    public float aP;
    protected int aQ;
    public final WalkAnimationState aR;
    public int aS = 20;
    public final float aT;
    public final float aU;
    public float aV;
    public float aW;
    public float aX;
    public float aY;
    @Nullable
    public EntityHuman aZ;
    protected int ba;
    protected boolean bb;
    protected int bc;
    protected float bd;
    protected float be;
    protected float bf;
    protected float bg;
    protected float bh;
    protected int bi;
    public float bj;
    protected boolean bk;
    public float bl;
    public float bm;
    public float bn;
    protected int bo;
    protected double bp;
    protected double bq;
    protected double br;
    protected double bs;
    protected double bt;
    protected double bu;
    protected int bv;
    public boolean bV = true;
    @Nullable
    public EntityLiving bW;
    public int bX;
    private EntityLiving bY;
    private int bZ;
    private float ca;
    private int cb;
    private float cc;
    protected ItemStack bw;
    protected int bx;
    protected int by;
    private BlockPosition cd;
    private Optional<BlockPosition> ce;
    @Nullable
    private DamageSource cf;
    private long cg;
    protected int bz;
    private float ch;
    private float ci;
    protected BehaviorController<?> bA;
    private boolean cj;
    public int expToDrop;
    public boolean forceDrops;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.cm();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bc;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.bS = NonNullList.a(2, ItemStack.b);
        this.bT = NonNullList.a(4, ItemStack.b);
        this.aR = new WalkAnimationState();
        this.bw = ItemStack.b;
        this.ce = Optional.empty();
        this.bP = new AttributeMapBase(AttributeDefaults.a(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.bP);
        this.am.b(bI, Float.valueOf((float)this.a(GenericAttributes.a).f()));
        this.H = true;
        this.aU = (float)((Math.random() + 1.0) * (double)0.01f);
        this.an();
        this.aT = (float)Math.random() * 12398.0f;
        this.a_((float)(Math.random() * 6.2831854820251465));
        this.aX = this.dy();
        this.r(0.6f);
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bA = this.a(new Dynamic((DynamicOps)dynamicopsnbt, (Object)((NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap()))))));
    }

    public BehaviorController<?> dK() {
        return this.bA;
    }

    protected BehaviorController.b<?> dL() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.dL().a(dynamic);
    }

    @Override
    public void ah() {
        this.a(this.dJ().w(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void a_() {
        this.am.a(u, (byte)0);
        this.am.a(bJ, 0);
        this.am.a(bK, false);
        this.am.a(bL, 0);
        this.am.a(bM, 0);
        this.am.a(bI, Float.valueOf(1.0f));
        this.am.a(bN, Optional.empty());
    }

    public static AttributeProvider.Builder dM() {
        return AttributeProvider.a().a(GenericAttributes.a).a(GenericAttributes.c).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.j);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (!this.aV()) {
            this.bc();
        }
        if (!this.dI().B && flag && this.aa > 0.0f) {
            this.dR();
            this.dS();
        }
        if (!this.dI().B && this.aa > 3.0f && flag && !iblockdata.i()) {
            double d1 = this.dn();
            double d2 = this.dp();
            double d3 = this.dt();
            BlockPosition blockposition1 = this.di();
            if (blockposition.u() != blockposition1.u() || blockposition.w() != blockposition1.w()) {
                double d4 = d1 - (double)blockposition.u() - 0.5;
                double d5 = d3 - (double)blockposition.w() - 0.5;
                double d6 = Math.max(Math.abs(d4), Math.abs(d5));
                d1 = (double)blockposition.u() + 0.5 + d4 / d6 * 0.5;
                d3 = (double)blockposition.w() + 0.5 + d5 / d6 * 0.5;
            }
            float f2 = MathHelper.f(this.aa - 3.0f);
            double d7 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
            int i2 = (int)(150.0 * d7);
            if (this instanceof EntityPlayer) {
                ((WorldServer)this.dI()).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.c, iblockdata), this.dn(), this.dp(), this.dt(), i2, 0.0, 0.0, 0.0, 0.15f, false);
            } else {
                ((WorldServer)this.dI()).a(new ParticleParamBlock(Particles.c, iblockdata), d1, d2, d3, i2, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.a(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.ce = Optional.empty();
        }
    }

    public boolean dN() {
        return this.eN() == EnumMonsterType.b;
    }

    public float a(float f2) {
        return MathHelper.i(f2, this.ci, this.ch);
    }

    @Override
    public void ao() {
        this.aO = this.aP;
        if (this.al) {
            this.fw().ifPresent(this::a);
        }
        if (this.dO()) {
            this.dP();
        }
        super.ao();
        this.dI().ad().a("livingEntityBaseTick");
        if (this.aU() || this.dI().B) {
            this.aw();
        }
        if (this.bs()) {
            BlockPosition blockposition;
            boolean flag = this instanceof EntityHuman;
            if (!this.dI().B) {
                double d1;
                double d0;
                if (this.bt()) {
                    this.a(this.dJ().f(), 1.0f);
                } else if (flag && !this.dI().w_().a(this.cE()) && (d0 = this.dI().w_().a(this) + this.dI().w_().n()) < 0.0 && (d1 = this.dI().w_().o()) > 0.0) {
                    this.a(this.dJ().v(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.dI().a_(BlockPosition.a(this.dn(), this.dr(), this.dt())).a(Blocks.nd)) {
                boolean flag1;
                boolean bl = flag1 = !this.dN() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).fO().a);
                if (flag1) {
                    this.j(this.m(this.cf()));
                    if (this.cf() == -20) {
                        this.j(0);
                        Vec3D vec3d = this.dl();
                        int i2 = 0;
                        while (i2 < 8) {
                            double d2 = this.af.j() - this.af.j();
                            double d3 = this.af.j() - this.af.j();
                            double d4 = this.af.j() - this.af.j();
                            this.dI().a(Particles.e, this.dn() + d2, this.dp() + d3, this.dt() + d4, vec3d.c, vec3d.d, vec3d.e);
                            ++i2;
                        }
                        this.a(this.dJ().h(), 2.0f);
                    }
                }
                if (!this.dI().B && this.bM() && this.cW() != null && this.cW().bO()) {
                    this.Y();
                }
            } else if (this.cf() < this.ce()) {
                this.j(this.n(this.cf()));
            }
            if (!this.dI().B && !com.google.common.base.Objects.equal((Object)this.cd, (Object)(blockposition = this.di()))) {
                this.cd = blockposition;
                this.c(blockposition);
            }
        }
        if (this.bs() && (this.aX() || this.az)) {
            this.aB();
        }
        if (this.aL > 0) {
            --this.aL;
        }
        if (this.ak > 0 && !(this instanceof EntityPlayer)) {
            --this.ak;
        }
        if (this.es() && this.dI().h(this)) {
            this.dX();
        }
        if (this.ba > 0) {
            --this.ba;
        } else {
            this.aZ = null;
        }
        if (this.bY != null && !this.bY.bs()) {
            this.bY = null;
        }
        if (this.bW != null) {
            if (!this.bW.bs()) {
                this.a((EntityLiving)null);
            } else if (this.ag - this.bX > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ej();
        this.bg = this.bf;
        this.aW = this.aV;
        this.aY = this.aX;
        this.M = this.dy();
        this.N = this.dA();
        this.dI().ad().c();
    }

    public boolean dO() {
        return this.ag % 5 == 0 && this.dl().c != 0.0 && this.dl().e != 0.0 && !this.G_() && EnchantmentManager.k(this) && this.dQ();
    }

    protected void dP() {
        Vec3D vec3d = this.dl();
        this.dI().a(Particles.I, this.dn() + (this.af.j() - 0.5) * (double)this.dd(), this.dp() + 0.1, this.dt() + (this.af.j() - 0.5) * (double)this.dd(), vec3d.c * -0.2, 0.1, vec3d.e * -0.2);
        float f2 = this.af.i() * 0.4f + this.af.i() > 0.9f ? 0.6f : 0.0f;
        this.a(SoundEffects.wd, f2, 0.6f + this.af.i() * 0.4f);
    }

    protected boolean dQ() {
        return this.dI().a_(this.aE()).a(TagsBlock.aL);
    }

    @Override
    protected float aH() {
        return this.dQ() && EnchantmentManager.a(Enchantments.l, this) > 0 ? 1.0f : super.aH();
    }

    protected boolean c(IBlockData iblockdata) {
        return !iblockdata.i() || this.fr();
    }

    protected void dR() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(d) != null) {
            attributemodifiable.b(d);
        }
    }

    protected void dS() {
        int i2;
        if (!this.be().i() && (i2 = EnchantmentManager.a(Enchantments.l, this)) > 0 && this.dQ()) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            attributemodifiable.b(new AttributeModifier(d, "Soul speed boost", (double)(0.03f * (1.0f + (float)i2 * 0.35f)), AttributeModifier.Operation.a));
            if (this.ec().i() < 0.04f) {
                ItemStack itemstack = this.c(EnumItemSlot.c);
                itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.c));
            }
        }
    }

    protected void dT() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(e) != null) {
            attributemodifiable.b(e);
        }
    }

    protected void dU() {
        int i2;
        if (!this.be().i() && (i2 = this.cg()) > 0) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.ch();
            attributemodifiable.b(new AttributeModifier(e, "Powder snow slow", (double)f2, AttributeModifier.Operation.a));
        }
    }

    protected void c(BlockPosition blockposition) {
        int i2 = EnchantmentManager.a(Enchantments.j, this);
        if (i2 > 0) {
            EnchantmentFrostWalker.a(this, this.dI(), blockposition, i2);
        }
        if (this.c(this.be())) {
            this.dR();
        }
        this.dS();
    }

    public boolean h_() {
        return false;
    }

    public float dV() {
        return this.h_() ? 0.5f : 1.0f;
    }

    protected boolean dW() {
        return true;
    }

    protected void dX() {
        ++this.aN;
        if (this.aN >= 20 && !this.dI().r_() && !this.dD()) {
            this.dI().a((Entity)this, (byte)60);
            this.a(Entity.RemovalReason.a);
        }
    }

    public boolean dY() {
        return !this.h_();
    }

    protected boolean dZ() {
        return !this.h_();
    }

    protected int m(int i2) {
        int j2 = EnchantmentManager.e(this);
        return j2 > 0 && this.af.a(j2 + 1) > 0 ? i2 : i2 - 1;
    }

    protected int n(int i2) {
        return Math.min(i2 + 4, this.ce());
    }

    public int ea() {
        return 0;
    }

    protected boolean eb() {
        return false;
    }

    public RandomSource ec() {
        return this.af;
    }

    @Nullable
    public EntityLiving ed() {
        return this.bW;
    }

    @Override
    public EntityLiving M_() {
        return this.ed();
    }

    public int ee() {
        return this.bX;
    }

    public void c(@Nullable EntityHuman entityhuman) {
        this.aZ = entityhuman;
        this.ba = this.ag;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.bW = entityliving;
        this.bX = this.ag;
    }

    @Nullable
    public EntityLiving ef() {
        return this.bY;
    }

    public int eg() {
        return this.bZ;
    }

    public void x(Entity entity) {
        this.bY = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.bZ = this.ag;
    }

    public int eh() {
        return this.bc;
    }

    public void o(int i2) {
        this.bc = i2;
    }

    public boolean ei() {
        return this.bU;
    }

    public void p(boolean flag) {
        this.bU = flag;
    }

    protected boolean a(EnumItemSlot enumitemslot) {
        return true;
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        Equipable equipable;
        boolean flag;
        boolean bl = flag = itemstack1.b() && itemstack.b();
        if (!(flag || ItemStack.c(itemstack, itemstack1) || this.al || (equipable = Equipable.c_(itemstack1)) == null || this.G_() || equipable.g() != enumitemslot)) {
            if (!(this.dI().r_() || this.aQ() || silent)) {
                this.dI().a(null, this.dn(), this.dp(), this.dt(), equipable.ak_(), this.cY(), 1.0f, 1.0f);
            }
            if (this.a(enumitemslot)) {
                this.a(GameEvent.w);
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        super.a(entity_removalreason);
        this.bA.a();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", this.er());
        nbttagcompound.a("HurtTime", (short)this.aL);
        nbttagcompound.a("HurtByTimestamp", this.bX);
        nbttagcompound.a("DeathTime", (short)this.aN);
        nbttagcompound.a("AbsorptionAmount", this.ff());
        nbttagcompound.a("Attributes", this.eM().c());
        if (!this.bR.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bR.values()) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbttagcompound.a("ActiveEffects", nbttaglist);
        }
        nbttagcompound.a("FallFlying", this.fr());
        this.fw().ifPresent(blockposition -> {
            nbttagcompound.a("SleepingX", blockposition.u());
            nbttagcompound.a("SleepingY", blockposition.v());
            nbttagcompound.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.bA.a(DynamicOpsNBT.a);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.y(nbttagcompound.j("AbsorptionAmount"));
        if (nbttagcompound.b("Attributes", 9) && this.dI() != null && !this.dI().B) {
            this.eM().a(nbttagcompound.c("Attributes", 10));
        }
        if (nbttagcompound.b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("ActiveEffects", 10);
            int i2 = 0;
            while (i2 < nbttaglist.size()) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.b(nbttagcompound1);
                if (mobeffect != null) {
                    this.bR.put(mobeffect.c(), mobeffect);
                }
                ++i2;
            }
        }
        if (nbttagcompound.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbttagcompound.c("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.a(GenericAttributes.a).a(((NBTTagFloat)nbtbase).j());
            } else if (nbtbase.b() == 3) {
                this.a(GenericAttributes.a).a(((NBTTagInt)nbtbase).j());
            }
        }
        if (nbttagcompound.b("Health", 99)) {
            this.t(nbttagcompound.j("Health"));
        }
        this.aL = nbttagcompound.g("HurtTime");
        this.aN = nbttagcompound.g("DeathTime");
        this.bX = nbttagcompound.h("HurtByTimestamp");
        if (nbttagcompound.b("Team", 8)) {
            boolean flag;
            String s2 = nbttagcompound.l("Team");
            ScoreboardTeam scoreboardteam = this.dI().I().f(s2);
            boolean bl = flag = scoreboardteam != null && this.dI().I().a(this.cu(), scoreboardteam);
            if (!flag) {
                b.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbttagcompound.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbttagcompound.b("SleepingX", 99) && nbttagcompound.b("SleepingY", 99) && nbttagcompound.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbttagcompound.h("SleepingX"), nbttagcompound.h("SleepingY"), nbttagcompound.h("SleepingZ"));
            this.g(blockposition);
            this.am.b(ar, EntityPose.c);
            if (!this.al) {
                this.a(blockposition);
            }
        }
        if (nbttagcompound.b("Brain", 10)) {
            this.bA = this.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("Brain")));
        }
    }

    protected void ej() {
        Iterator<MobEffectList> iterator = this.bR.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                MobEffectList mobeffectlist = iterator.next();
                MobEffect mobeffect = this.bR.get(mobeffectlist);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, null))) {
                    EntityPotionEffectEvent event;
                    if (this.dI().B || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.a(mobeffect);
                    continue;
                }
                if (mobeffect.d() % 600 != 0) continue;
                this.a(mobeffect, false, null);
            }
        }
        catch (ConcurrentModificationException mobeffectlist) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bV) {
            if (!this.dI().B) {
                this.F();
                this.q();
            }
            this.bV = false;
        }
        int i2 = this.am.b(bJ);
        boolean flag = this.am.b(bK);
        if (i2 > 0) {
            boolean flag1 = this.cb() ? this.af.a(15) == 0 : this.af.h();
            if (flag) {
                flag1 &= this.af.a(5) == 0;
            }
            if (flag1 && i2 > 0) {
                double d0 = (double)(i2 >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i2 >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i2 >> 0 & 0xFF) / 255.0;
                this.dI().a(flag ? Particles.a : Particles.v, this.d(0.5), this.dq(), this.g(0.5), d0, d1, d2);
            }
        }
    }

    protected void F() {
        if (this.bR.isEmpty()) {
            this.em();
            this.j(false);
        } else {
            Collection<MobEffect> collection = this.bR.values();
            this.am.b(bK, EntityLiving.c(collection));
            this.am.b(bJ, PotionUtil.a(collection));
            this.j(this.a(MobEffects.n));
        }
    }

    private void q() {
        boolean flag = this.ca();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double y(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.bS()) {
            d0 *= 0.8;
        }
        if (this.cb()) {
            float f2 = this.eQ();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.c(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ae();
            if (entitytypes == EntityTypes.aJ && itemstack.a(Items.tr) || entitytypes == EntityTypes.bp && itemstack.a(Items.tu) || entitytypes == EntityTypes.aw && itemstack.a(Items.tx) || entitytypes == EntityTypes.ax && itemstack.a(Items.tx) || entitytypes == EntityTypes.u && itemstack.a(Items.tv)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.dI().ai() == EnumDifficulty.a ? false : entityliving.ek();
    }

    public boolean a(EntityLiving entityliving, PathfinderTargetCondition pathfindertargetcondition) {
        return pathfindertargetcondition.a(this, entityliving);
    }

    public boolean ek() {
        return !this.co() && this.el();
    }

    public boolean el() {
        return !this.G_() && this.bs();
    }

    public static boolean c(Collection<MobEffect> collection) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = collection.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).g() || mobeffect.f());
        return false;
    }

    protected void em() {
        this.am.b(bK, false);
        this.am.b(bJ, 0);
    }

    public boolean en() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dI().B) {
            return false;
        }
        Iterator<MobEffect> iterator = this.bR.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.a(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> eo() {
        return this.bR.values();
    }

    public Map<MobEffectList, MobEffect> ep() {
        return this.bR;
    }

    public boolean a(MobEffectList mobeffectlist) {
        return this.bR.containsKey(mobeffectlist);
    }

    @Nullable
    public MobEffect b(MobEffectList mobeffectlist) {
        return this.bR.get(mobeffectlist);
    }

    public final boolean b(MobEffect mobeffect) {
        return this.b(mobeffect, null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.c(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bR.get(mobeffect.c());
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.bR.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            return true;
        }
        if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            return true;
        }
        return false;
    }

    public boolean c(MobEffect mobeffect) {
        MobEffectList mobeffectlist;
        return this.eN() != EnumMonsterType.b || (mobeffectlist = mobeffect.c()) != MobEffects.j && mobeffectlist != MobEffects.s;
    }

    public void c(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.c(mobeffect)) {
            MobEffect mobeffect1 = this.bR.put(mobeffect.c(), mobeffect);
            if (mobeffect1 == null) {
                this.a(mobeffect, entity);
            } else {
                this.a(mobeffect, true, entity);
            }
        }
    }

    public boolean eq() {
        return this.eN() == EnumMonsterType.b;
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist) {
        return this.c(mobeffectlist, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffectlist, cause));
            return null;
        }
        MobEffect effect = this.bR.get(mobeffectlist);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bR.remove(mobeffectlist);
    }

    public boolean d(MobEffectList mobeffectlist) {
        return this.removeEffect(mobeffectlist, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.c(mobeffectlist, cause);
        if (mobeffect != null) {
            this.a(mobeffect);
            return true;
        }
        return false;
    }

    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        this.bV = true;
        if (!this.dI().B) {
            mobeffect.c().b(this, this.eM(), mobeffect.e());
            this.d(mobeffect);
        }
    }

    public void d(MobEffect mobeffect) {
        for (Entity entity : this.cN()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.c.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        }
    }

    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        this.bV = true;
        if (flag && !this.dI().B) {
            MobEffectList mobeffectlist = mobeffect.c();
            mobeffectlist.a(this, this.eM(), mobeffect.e());
            mobeffectlist.b(this, this.eM(), mobeffect.e());
        }
        if (!this.dI().B) {
            this.d(mobeffect);
        }
    }

    protected void a(MobEffect mobeffect) {
        this.bV = true;
        if (!this.dI().B) {
            mobeffect.c().a(this, this.eM(), mobeffect.e());
            for (Entity entity : this.cN()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.c.a(new PacketPlayOutRemoveEntityEffect(this.af(), mobeffect.c()));
            }
        }
    }

    public void s(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.er();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.t((float)((double)this.er() + event.getAmount()));
            }
        }
    }

    public float er() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.am.b(bI).floatValue();
    }

    public void t(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.am.b(bI, Float.valueOf(MathHelper.a(f2, 0.0f, this.eI())));
    }

    public boolean es() {
        return this.er() <= 0.0f;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        boolean flag2;
        Entity entity1;
        if (this.b(damagesource)) {
            return false;
        }
        if (this.dI().B) {
            return false;
        }
        if (this.dD() || this.bb || this.er() <= 0.0f) {
            return false;
        }
        if (damagesource.a(DamageTypeTags.i) && this.a(MobEffects.l)) {
            return false;
        }
        if (this.fy() && !this.dI().B) {
            this.fz();
        }
        this.bc = 0;
        float f1 = f2;
        boolean flag = f2 > 0.0f && this.f(damagesource);
        float f22 = 0.0f;
        if (damagesource.a(DamageTypeTags.o) && this.ae().a(TagsEntity.j)) {
            f2 *= 5.0f;
        }
        this.aR.a(1.5f);
        boolean flag1 = true;
        if ((float)this.ak > (float)this.aS / 2.0f && !damagesource.a(DamageTypeTags.e)) {
            if (f2 <= this.bj) {
                return false;
            }
            if (!this.damageEntity0(damagesource, f2 - this.bj)) {
                return false;
            }
            this.bj = f2;
            flag1 = false;
        } else {
            if (!this.damageEntity0(damagesource, f2)) {
                return false;
            }
            this.bj = f2;
            this.ak = this.aS;
            this.aL = this.aM = 10;
        }
        if (this instanceof EntityAnimal) {
            ((EntityAnimal)this).gd();
            if (this instanceof EntityTameableAnimal) {
                ((EntityTameableAnimal)this).z(false);
            }
        }
        if ((entity1 = damagesource.d()) != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!damagesource.a(DamageTypeTags.q)) {
                    this.a(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.ba = 100;
                this.aZ = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).q()) {
                EntityHuman entityhuman1;
                this.ba = 100;
                EntityLiving entityliving2 = entitywolf.I_();
                this.aZ = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.dI().a((Entity)this, (byte)29);
            } else {
                this.dI().a((Entity)this, damagesource);
            }
            if (!(damagesource.a(DamageTypeTags.r) || flag && !(f2 > 0.0f))) {
                this.bl();
            }
            if (entity1 != null && !damagesource.a(DamageTypeTags.l)) {
                double d0 = entity1.dn() - this.dn();
                double d1 = entity1.dt() - this.dt();
                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                    d0 = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.q(0.4f, d0, d1);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.es()) {
            if (!this.h(damagesource)) {
                SoundEffect soundeffect = this.g_();
                if (flag1 && soundeffect != null) {
                    this.a(soundeffect, this.eR(), this.eS());
                }
                this.a(damagesource);
            }
        } else if (flag1) {
            this.e(damagesource);
        }
        boolean bl = flag2 = !flag || f2 > 0.0f;
        if (flag2) {
            this.cf = damagesource;
            this.cg = this.dI().V();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.h.a((EntityPlayer)this, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                ((EntityPlayer)this).a(StatisticList.K, Math.round(f22 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.g.a((EntityPlayer)entity1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    protected void d(EntityLiving entityliving) {
        entityliving.e(this);
    }

    protected void e(EntityLiving entityliving) {
        entityliving.q(0.5, entityliving.dn() - this.dn(), entityliving.dt() - this.dt());
    }

    private boolean h(DamageSource damagesource) {
        if (damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.b;
        int j2 = 0;
        while (j2 < i2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            if (itemstack1.a(Items.uz)) {
                hand = enumhand;
                itemstack = itemstack1.p();
                break;
            }
            ++j2;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.b()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(Items.uz));
                CriterionTriggers.B.a(entityplayer, itemstack);
            }
            this.t(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.j, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.v, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.l, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.dI().a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource et() {
        if (this.dI().V() - this.cg > 40L) {
            this.cf = null;
        }
        return this.cf;
    }

    protected void e(DamageSource damagesource) {
        SoundEffect soundeffect = this.d(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    public boolean f(DamageSource damagesource) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = damagesource.c();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).w() > 0) {
            flag = true;
        }
        if (!damagesource.a(DamageTypeTags.c) && this.fp() && !flag && (vec3d = damagesource.h()) != null) {
            Vec3D vec3d1 = this.f(1.0f);
            Vec3D vec3d2 = vec3d.a(this.dg()).d();
            vec3d2 = new Vec3D(vec3d2.c, 0.0, vec3d2.e);
            if (vec3d2.b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void i(ItemStack itemstack) {
        if (!itemstack.b()) {
            if (!this.aQ()) {
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.lZ, this.cY(), 0.8f, 0.8f + this.dI().z.i() * 0.4f, false);
            }
            this.a(itemstack, 5);
        }
    }

    public void a(DamageSource damagesource) {
        if (!this.dD() && !this.bb) {
            Entity entity = damagesource.d();
            EntityLiving entityliving = this.eH();
            if (this.bi >= 0 && entityliving != null) {
                entityliving.a((Entity)this, this.bi, damagesource);
            }
            if (this.fy()) {
                this.fz();
            }
            if (!this.dI().B && this.aa() && SpigotConfig.logNamedDeaths) {
                b.info("Named entity {} died: {}", (Object)this, (Object)this.eG().a().getString());
            }
            this.bb = true;
            this.eG().c();
            net.minecraft.world.level.World world = this.dI();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.a(worldserver, this)) {
                    this.a(GameEvent.p);
                    this.g(damagesource);
                    this.f(entityliving);
                }
                this.dI().a((Entity)this, (byte)3);
            }
            this.b(EntityPose.h);
        }
    }

    protected void f(@Nullable EntityLiving entityliving) {
        if (!this.dI().B) {
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (this.dI().X().b(GameRules.c)) {
                    BlockPosition blockposition = this.di();
                    IBlockData iblockdata = Blocks.cd.n();
                    if (this.dI().a_(blockposition).i() && iblockdata.a((IWorldReader)this.dI(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.dI(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.dI(), this.dn(), this.dp(), this.dt(), new ItemStack(Items.da));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dI().b(entityitem);
                }
            }
        }
    }

    protected void g(DamageSource damagesource) {
        Entity entity = damagesource.d();
        int i2 = entity instanceof EntityHuman ? EnchantmentManager.h((EntityLiving)entity) : 0;
        boolean flag = this.ba > 0;
        this.eu();
        if (this.dZ() && this.dI().X().b(GameRules.f)) {
            this.a(damagesource, flag);
            this.a(damagesource, i2, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, this.drops);
        this.drops = new ArrayList();
        this.ev();
    }

    protected void eu() {
    }

    public int getExpReward() {
        if (this.dI() instanceof WorldServer && !this.ez() && (this.eb() || this.ba > 0 && this.dY() && this.dI().X().b(GameRules.f))) {
            int i2 = this.ea();
            return i2;
        }
        return 0;
    }

    protected void ev() {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.a((WorldServer)this.dI(), this.dg(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void a(DamageSource damagesource, int i2, boolean flag) {
    }

    public MinecraftKey ew() {
        return this.ae().j();
    }

    public long ex() {
        return 0L;
    }

    protected void a(DamageSource damagesource, boolean flag) {
        MinecraftKey minecraftkey = this.ew();
        LootTable loottable = this.dI().n().aH().getLootTable(minecraftkey);
        LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dI()).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dg()).a(LootContextParameters.c, damagesource).b(LootContextParameters.d, damagesource.d()).b(LootContextParameters.e, damagesource.c());
        if (flag && this.aZ != null) {
            lootparams_a = lootparams_a.a(LootContextParameters.b, this.aZ).a(this.aZ.gj());
        }
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.f);
        loottable.a(lootparams, this.ex(), this::b);
    }

    public void q(double d0, double d1, double d2) {
        if ((d0 *= 1.0 - this.b(GenericAttributes.c)) > 0.0) {
            this.at = true;
            Vec3D vec3d = this.dl();
            Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().a(d0);
            this.o(vec3d.c / 2.0 - vec3d1.c, this.ay() ? Math.min(0.4, vec3d.d / 2.0 + d0) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
        }
    }

    public void a(double d0, double d1) {
    }

    @Nullable
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.iZ;
    }

    @Nullable
    protected SoundEffect g_() {
        return SoundEffects.iU;
    }

    private SoundEffect d(int i2) {
        return i2 > 4 ? this.eC().b() : this.eC().a();
    }

    public void ey() {
        this.cj = true;
    }

    public boolean ez() {
        return this.cj;
    }

    protected Vec3D eA() {
        Entity entity = this.cW();
        if (entity instanceof RiderShieldingMount) {
            RiderShieldingMount ridershieldingmount = (RiderShieldingMount)((Object)entity);
            return this.dg().b(0.0, ridershieldingmount.d(), 0.0);
        }
        return this.dg();
    }

    public float eB() {
        return 0.0f;
    }

    public a eC() {
        return new a(SoundEffects.ja, SoundEffects.iS);
    }

    protected SoundEffect c(ItemStack itemstack) {
        return itemstack.N();
    }

    public SoundEffect d(ItemStack itemstack) {
        return itemstack.O();
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.d(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.g_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.d(fallHeight);
    }

    public SoundEffect getDrinkingSound0(ItemStack itemstack) {
        return this.c(itemstack);
    }

    public SoundEffect getEatingSound0(ItemStack itemstack) {
        return this.d(itemstack);
    }

    public Optional<BlockPosition> eD() {
        return this.ce;
    }

    public boolean i_() {
        if (this.G_()) {
            return false;
        }
        BlockPosition blockposition = this.di();
        IBlockData iblockdata = this.dj();
        if (iblockdata.a(TagsBlock.aN)) {
            this.ce = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.ce = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1;
        return iblockdata.c(BlockTrapdoor.a) != false && (iblockdata1 = this.dI().a_(blockposition.d())).a(Blocks.cO) && iblockdata1.c(BlockLadder.a) == iblockdata.c(BlockTrapdoor.aC);
    }

    @Override
    public boolean bs() {
        return !this.dD() && this.er() > 0.0f;
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        boolean flag = super.a(f2, f1, damagesource);
        int i2 = this.d(f2, f1);
        if (i2 > 0) {
            if (!this.a(damagesource, (float)i2)) {
                return true;
            }
            this.a(this.d(i2), 1.0f, 1.0f);
            this.eE();
            return true;
        }
        return flag;
    }

    protected int d(float f2, float f1) {
        if (this.ae().a(TagsEntity.l)) {
            return 0;
        }
        MobEffect mobeffect = this.b(MobEffects.h);
        float f22 = mobeffect == null ? 0.0f : (float)(mobeffect.e() + 1);
        return MathHelper.f((f2 - 3.0f - f22) * f1);
    }

    protected void eE() {
        if (!this.aQ()) {
            int i2 = MathHelper.a(this.dn());
            int j2 = MathHelper.a(this.dp() - (double)0.2f);
            int k2 = MathHelper.a(this.dt());
            IBlockData iblockdata = this.dI().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.i()) {
                SoundEffectType soundeffecttype = iblockdata.w();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void m(float f2) {
        this.aL = this.aM = 10;
    }

    public int eF() {
        return MathHelper.a(this.b(GenericAttributes.i));
    }

    protected void b(DamageSource damagesource, float f2) {
    }

    protected void c(DamageSource damagesource, float f2) {
    }

    protected void u(float f2) {
    }

    protected float d(DamageSource damagesource, float f2) {
        if (!damagesource.a(DamageTypeTags.b)) {
            f2 = CombatMath.a(f2, this.eF(), (float)this.b(GenericAttributes.j));
        }
        return f2;
    }

    protected float e(DamageSource damagesource, float f2) {
        if (damagesource.a(DamageTypeTags.f)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.a(DamageTypeTags.h)) {
            return f2;
        }
        int i2 = EnchantmentManager.a(this.bJ(), damagesource);
        if (i2 > 0) {
            f2 = CombatMath.a(f2, i2);
        }
        return f2;
    }

    protected boolean damageEntity0(final DamageSource damagesource, float f2) {
        if (!this.b(damagesource)) {
            Entity entity;
            float f3;
            boolean human = this instanceof EntityHuman;
            float originalDamage = f2;
            Function<Double, Double> hardHat = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.c(EnumItemSlot.f).b()) {
                        return -(f2 - f2 * 0.75);
                    }
                    return -0.0;
                }
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)f2)).floatValue();
            Function<Double, Double> blocking = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(EntityLiving.this.f(damagesource) ? f2 : 0.0);
                }
            };
            float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
            Function<Double, Double> armor = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.d(damagesource, f2.floatValue()));
                }
            };
            float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
            Function<Double, Double> resistance = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.a(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                        int i2 = (EntityLiving.this.b(MobEffects.k).e() + 1) * 5;
                        int j2 = 25 - i2;
                        float f1 = f2.floatValue() * (float)j2;
                        return -(f2 - (double)(f1 / 25.0f));
                    }
                    return -0.0;
                }
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
            Function<Double, Double> magic = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
                }
            };
            float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
            Function<Double, Double> absorption = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.ff(), 0.0), 0.0);
                }
            };
            float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.d() instanceof EntityHuman) {
                ((EntityHuman)damagesource.d()).gh();
            }
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.c(EnumItemSlot.f).b()) {
                this.c(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.b(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.dI().a((Entity)this, (byte)29);
                this.u((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.c();
                if (entity2 instanceof EntityLiving) {
                    this.d((EntityLiving)entity2);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.y(Math.max(this.ff() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                this.eG().a(damagesource, f2);
                this.t(this.er() - f2);
                if (!human) {
                    this.y(this.ff() - f2);
                }
                this.a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.g.a((EntityPlayer)damagesource.d(), this, damagesource, f2, originalDamage, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eG() {
        return this.bQ;
    }

    @Nullable
    public EntityLiving eH() {
        return this.aZ != null ? this.aZ : (this.bW != null ? this.bW : null);
    }

    public final float eI() {
        return (float)this.b(GenericAttributes.a);
    }

    public final int eJ() {
        return this.am.b(bL);
    }

    public final void p(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eJ(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.am.b(bL, event.getNewAmount());
    }

    public final int eK() {
        return this.am.b(bM);
    }

    public final void q(int i2) {
        this.am.b(bM, i2);
    }

    private int s() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.a(MobEffects.d) ? 6 + (1 + this.b(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand enumhand) {
        this.a(enumhand, false);
    }

    public void a(EnumHand enumhand, boolean flag) {
        if (!this.aG || this.aI >= this.s() / 2 || this.aI < 0) {
            this.aI = -1;
            this.aG = true;
            this.aH = enumhand;
            if (this.dI() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.dI()).k();
                if (flag) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damagesource) {
        this.aR.a(1.5f);
        this.ak = 20;
        this.aL = this.aM = 10;
        SoundEffect soundeffect = this.d(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
        }
        this.a(this.dJ().n(), 0.0f);
        this.cf = damagesource;
        this.cg = this.dI().V();
    }

    @Override
    public void b(byte b0) {
        switch (b0) {
            case 3: {
                SoundEffect soundeffect = this.g_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.eR(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.t(0.0f);
                this.a(this.dJ().n());
                break;
            }
            case 29: {
                this.a(SoundEffects.uQ, 1.0f, 0.8f + this.dI().z.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.uR, 0.8f, 0.8f + this.dI().z.i() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                int i2 = 0;
                while (i2 < 128) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.af.i() - 0.5f) * 0.2f;
                    float f1 = (this.af.i() - 0.5f) * 0.2f;
                    float f22 = (this.af.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.J, this.dn()) + (this.af.j() - 0.5) * (double)this.dd() * 2.0;
                    double d2 = MathHelper.d(d0, this.K, this.dp()) + this.af.j() * (double)this.de();
                    double d3 = MathHelper.d(d0, this.L, this.dt()) + (this.af.j() - 0.5) * (double)this.dd() * 2.0;
                    this.dI().a(Particles.X, d1, d2, d3, (double)f2, (double)f1, f22);
                    ++i2;
                }
                return;
            }
            case 47: {
                this.i(this.c(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.i(this.c(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.i(this.c(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.i(this.c(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.i(this.c(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.i(this.c(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.y();
                break;
            }
            case 60: {
                this.x();
                break;
            }
            default: {
                super.b(b0);
            }
        }
    }

    private void x() {
        int i2 = 0;
        while (i2 < 20) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(Particles.W, this.d(1.0), this.dq(), this.g(1.0), d0, d1, d2);
            ++i2;
        }
    }

    private void y() {
        ItemStack itemstack = this.c(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.c(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void ax() {
        this.a(this.dJ().m(), 4.0f);
    }

    protected void eL() {
        int i2 = this.s();
        if (this.aG) {
            ++this.aI;
            if (this.aI >= i2) {
                this.aI = 0;
                this.aG = false;
            }
        } else {
            this.aI = 0;
        }
        this.aP = (float)this.aI / (float)i2;
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attributebase) {
        return this.eM().a(attributebase);
    }

    public double a(Holder<AttributeBase> holder) {
        return this.b(holder.a());
    }

    public double b(AttributeBase attributebase) {
        return this.eM().c(attributebase);
    }

    public double b(Holder<AttributeBase> holder) {
        return this.c(holder.a());
    }

    public double c(AttributeBase attributebase) {
        return this.eM().d(attributebase);
    }

    public AttributeMapBase eM() {
        return this.bP;
    }

    public EnumMonsterType eN() {
        return EnumMonsterType.a;
    }

    public ItemStack eO() {
        return this.c(EnumItemSlot.a);
    }

    public ItemStack eP() {
        return this.c(EnumItemSlot.b);
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eO()) || predicate.test(this.eP());
    }

    public ItemStack b(EnumHand enumhand) {
        if (enumhand == EnumHand.a) {
            return this.c(EnumItemSlot.a);
        }
        if (enumhand == EnumHand.b) {
            return this.c(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + (Object)((Object)enumhand));
    }

    public void a(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.a) {
            this.a(EnumItemSlot.a, itemstack);
        } else {
            if (enumhand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + (Object)((Object)enumhand));
            }
            this.a(EnumItemSlot.b, itemstack);
        }
    }

    public boolean b(EnumItemSlot enumitemslot) {
        return !this.c(enumitemslot).b();
    }

    @Override
    public abstract Iterable<ItemStack> bJ();

    public abstract ItemStack c(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    @Override
    public abstract void a(EnumItemSlot var1, ItemStack var2);

    protected void e(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = itemstack.v();
        if (nbttagcompound != null) {
            itemstack.d().b(nbttagcompound);
        }
    }

    public float eQ() {
        Iterable<ItemStack> iterable = this.bJ();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.b()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void g(boolean flag) {
        super.g(flag);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable.a(c) != null) {
            attributemodifiable.d(bB);
        }
        if (flag) {
            attributemodifiable.b(bB);
        }
    }

    protected float eR() {
        return 1.0f;
    }

    public float eS() {
        return this.h_() ? (this.af.i() - this.af.i()) * 0.2f + 1.5f : (this.af.i() - this.af.i()) * 0.2f + 1.0f;
    }

    protected boolean eT() {
        return this.es();
    }

    @Override
    public void g(Entity entity) {
        if (!this.fy()) {
            super.g(entity);
        }
    }

    private void a(Entity entity) {
        Vec3D vec3d;
        if (this.dD()) {
            vec3d = this.dg();
        } else if (!entity.dD() && !this.dI().a_(entity.di()).a(TagsBlock.aH)) {
            vec3d = entity.b(this);
        } else {
            double d0 = Math.max(this.dp(), entity.dp());
            vec3d = new Vec3D(this.dn(), d0, this.dt());
        }
        this.a(vec3d.c, vec3d.d, vec3d.e);
    }

    @Override
    public boolean cz() {
        return this.cy();
    }

    protected float eU() {
        return 0.42f * this.aG() + this.eV();
    }

    public float eV() {
        return this.a(MobEffects.h) ? 0.1f * ((float)this.b(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    protected void eW() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c, this.eU(), vec3d.e);
        if (this.bV()) {
            float f2 = this.dy() * ((float)Math.PI / 180);
            this.f(this.dl().b(-MathHelper.a(f2) * 0.2f, 0.0, MathHelper.b(f2) * 0.2f));
        }
        this.at = true;
    }

    protected void eX() {
        this.f(this.dl().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> tagkey) {
        this.f(this.dl().b(0.0, 0.04f, 0.0));
    }

    protected float eY() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    public void h(Vec3D vec3d) {
        if (this.cU()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.dl().d <= 0.0;
            if (flag && this.a(MobEffects.B)) {
                d0 = 0.01;
            }
            Fluid fluid = this.dI().b_(this.di());
            if (this.aV() && this.dW() && !this.a(fluid)) {
                double d1 = this.dp();
                float f2 = this.bV() ? 0.9f : this.eY();
                float f1 = 0.02f;
                float f22 = EnchantmentManager.f(this);
                if (f22 > 3.0f) {
                    f22 = 3.0f;
                }
                if (!this.ay()) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22 / 3.0f;
                    f1 += (this.fa() - f1) * f22 / 3.0f;
                }
                if (this.a(MobEffects.D)) {
                    f2 = 0.96f;
                }
                this.a(f1, vec3d);
                this.a(EnumMoveType.a, this.dl());
                Vec3D vec3d1 = this.dl();
                if (this.O && this.i_()) {
                    vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
                }
                this.f(vec3d1.d(f2, 0.8f, f2));
                Vec3D vec3d2 = this.a(d0, flag, this.dl());
                this.f(vec3d2);
                if (this.O && this.g(vec3d2.c, vec3d2.d + (double)0.6f - this.dp() + d1, vec3d2.e)) {
                    this.o(vec3d2.c, 0.3f, vec3d2.e);
                }
            } else if (this.bi() && this.dW() && !this.a(fluid)) {
                Vec3D vec3d3;
                double d1 = this.dp();
                this.a(0.02f, vec3d);
                this.a(EnumMoveType.a, this.dl());
                if (this.b(TagsFluid.b) <= this.dc()) {
                    this.f(this.dl().d(0.5, 0.8f, 0.5));
                    vec3d3 = this.a(d0, flag, this.dl());
                    this.f(vec3d3);
                } else {
                    this.f(this.dl().a(0.5));
                }
                if (!this.aR()) {
                    this.f(this.dl().b(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.dl();
                if (this.O && this.g(vec3d3.c, vec3d3.d + (double)0.6f - this.dp() + d1, vec3d3.e)) {
                    this.o(vec3d3.c, 0.3f, vec3d3.e);
                }
            } else if (this.fr()) {
                double d7;
                float f3;
                double d6;
                this.ck();
                Vec3D vec3d4 = this.dl();
                Vec3D vec3d5 = this.bD();
                float f4 = this.dA() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.c * vec3d5.c + vec3d5.e * vec3d5.e);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.dl().b(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.d < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.d * -0.1 * d5;
                    vec3d4 = vec3d4.b(vec3d5.c * d6 / d2, d6, vec3d5.e * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.a(f4)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.c * d6 / d2, d6 * 3.2, -vec3d5.e * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.c / d2 * d3 - vec3d4.c) * 0.1, 0.0, (vec3d5.e / d2 * d3 - vec3d4.e) * 0.1);
                }
                this.f(vec3d4.d(0.99f, 0.98f, 0.99f));
                this.a(EnumMoveType.a, this.dl());
                if (this.O && !this.dI().B && (f3 = (float)((d7 = d3 - (d6 = this.dl().h())) * 10.0 - 3.0)) > 0.0f) {
                    this.a(this.d((int)f3), 1.0f, 1.0f);
                    this.a(this.dJ().l(), f3);
                }
                if (this.ay() && !this.dI().B && this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
            } else {
                BlockPosition blockposition = this.aE();
                float f4 = this.dI().a_(blockposition).b().h();
                float f5 = this.ay() ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.a(vec3d, f4);
                double d8 = vec3d6.d;
                if (this.a(MobEffects.y)) {
                    d8 += (0.05 * (double)(this.b(MobEffects.y).e() + 1) - vec3d6.d) * 0.2;
                } else if (this.dI().B && !this.dI().A(blockposition)) {
                    d8 = this.dp() > (double)this.dI().C_() ? -0.1 : 0.0;
                } else if (!this.aR()) {
                    d8 -= d0;
                }
                if (this.ei()) {
                    this.o(vec3d6.c, d8, vec3d6.e);
                } else {
                    this.o(vec3d6.c * (double)f5, d8 * (double)0.98f, vec3d6.e * (double)f5);
                }
            }
        }
        this.q(this instanceof EntityBird);
    }

    private void c(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.b(entityhuman, vec3d);
        this.a(entityhuman, vec3d1);
        if (this.cU()) {
            this.w(this.e(entityhuman));
            this.h(vec3d1);
        } else {
            this.q(false);
            this.f(Vec3D.b);
            this.az();
        }
    }

    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float e(EntityHuman entityhuman) {
        return this.fa();
    }

    public void q(boolean flag) {
        float f2 = (float)MathHelper.f(this.dn() - this.J, flag ? this.dp() - this.K : 0.0, this.dt() - this.L);
        this.v(f2);
    }

    protected void v(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.aR.a(f1, 0.4f);
    }

    public Vec3D a(Vec3D vec3d, float f2) {
        this.a(this.z(f2), vec3d);
        this.f(this.j(this.dl()));
        this.a(EnumMoveType.a, this.dl());
        Vec3D vec3d1 = this.dl();
        if ((this.O || this.bk) && (this.i_() || this.dj().a(Blocks.qC) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (!this.aR() && !this.bV()) {
            double d1 = flag && Math.abs(vec3d.d - 0.005) >= 0.003 && Math.abs(vec3d.d - d0 / 16.0) < 0.003 ? -0.003 : vec3d.d - d0 / 16.0;
            return new Vec3D(vec3d.c, d1, vec3d.e);
        }
        return vec3d;
    }

    private Vec3D j(Vec3D vec3d) {
        if (this.i_()) {
            this.n();
            float f2 = 0.15f;
            double d0 = MathHelper.a(vec3d.c, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(vec3d.e, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.d, (double)-0.15f);
            if (d2 < 0.0 && !this.dj().a(Blocks.nS) && this.fq() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float z(float f2) {
        return this.ay() ? this.fa() * (0.21600002f / (f2 * f2 * f2)) : this.eZ();
    }

    protected float eZ() {
        return this.cL() instanceof EntityHuman ? this.fa() * 0.1f : 0.02f;
    }

    public float fa() {
        return this.ca;
    }

    public void w(float f2) {
        this.ca = f2;
    }

    public boolean z(Entity entity) {
        this.x(entity);
        return false;
    }

    @Override
    public void l() {
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.l();
        this.D();
        this.G();
        if (!this.dI().B) {
            int j2;
            int i2 = this.eJ();
            if (i2 > 0) {
                if (this.aJ <= 0) {
                    this.aJ = 20 * (30 - i2);
                }
                --this.aJ;
                if (this.aJ <= 0) {
                    this.p(i2 - 1);
                }
            }
            if ((j2 = this.eK()) > 0) {
                if (this.aK <= 0) {
                    this.aK = 20 * (30 - j2);
                }
                --this.aK;
                if (this.aK <= 0) {
                    this.q(j2 - 1);
                }
            }
            this.z();
            if (this.ag % 20 == 0) {
                this.eG().c();
            }
            if (this.fy() && !this.I()) {
                this.fz();
            }
        }
        if (!this.dD()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.b_();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.dn() - this.J;
        double d1 = this.dt() - this.L;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aV;
        float f22 = 0.0f;
        this.bd = this.be;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.e(MathHelper.g(this.dy()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aP > 0.0f) {
            f1 = this.dy();
        }
        if (!this.ay()) {
            f3 = 0.0f;
        }
        this.be += (f3 - this.be) * 0.3f;
        this.dI().ad().a("headTurn");
        f22 = this.e(f1, f22);
        this.dI().ad().c();
        this.dI().ad().a("rangeChecks");
        while (this.dy() - this.M < -180.0f) {
            this.M -= 360.0f;
        }
        while (this.dy() - this.M >= 180.0f) {
            this.M += 360.0f;
        }
        while (this.aV - this.aW < -180.0f) {
            this.aW -= 360.0f;
        }
        while (this.aV - this.aW >= 180.0f) {
            this.aW += 360.0f;
        }
        while (this.dA() - this.N < -180.0f) {
            this.N -= 360.0f;
        }
        while (this.dA() - this.N >= 180.0f) {
            this.N += 360.0f;
        }
        while (this.aX - this.aY < -180.0f) {
            this.aY -= 360.0f;
        }
        while (this.aX - this.aY >= 180.0f) {
            this.aY += 360.0f;
        }
        this.dI().ad().c();
        this.bf += f22;
        this.by = this.fr() ? ++this.by : 0;
        if (this.fy()) {
            this.b_(0.0f);
        }
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public void z() {
        Map<EnumItemSlot, ItemStack> map = this.A();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> A() {
        EnumMap map = null;
        EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
        int i2 = aenumitemslot.length;
        int j2 = 0;
        while (j2 < i2) {
            block9: {
                ItemStack itemstack;
                EnumItemSlot enumitemslot = aenumitemslot[j2];
                switch (enumitemslot.a()) {
                    case a: {
                        itemstack = this.f(enumitemslot);
                        break;
                    }
                    case b: {
                        itemstack = this.e(enumitemslot);
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                ItemStack itemstack1 = this.c(enumitemslot);
                if (this.a(itemstack, itemstack1)) {
                    if (map == null) {
                        map = Maps.newEnumMap(EnumItemSlot.class);
                    }
                    map.put(enumitemslot, itemstack1);
                    if (!itemstack.b()) {
                        this.eM().a(itemstack.a(enumitemslot));
                    }
                    if (!itemstack1.b()) {
                        this.eM().b(itemstack1.a(enumitemslot));
                    }
                }
            }
            ++j2;
        }
        return map;
    }

    public boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.a(itemstack1, itemstack);
    }

    private void a(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get((Object)EnumItemSlot.a);
        ItemStack itemstack1 = map.get((Object)EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.f(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.f(EnumItemSlot.a))) {
            ((WorldServer)this.dI()).k().b(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove((Object)EnumItemSlot.a);
            map.remove((Object)EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.p());
            this.c(EnumItemSlot.b, itemstack1.p());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.p();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)((Object)enumitemslot), itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)((Object)enumitemslot), itemstack1);
                }
            }
        });
        ((WorldServer)this.dI()).k().b(this, new PacketPlayOutEntityEquipment(this.af(), list));
    }

    private ItemStack e(EnumItemSlot enumitemslot) {
        return this.bT.get(enumitemslot.b());
    }

    private void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.bT.set(enumitemslot.b(), itemstack);
    }

    private ItemStack f(EnumItemSlot enumitemslot) {
        return this.bS.get(enumitemslot.b());
    }

    private void c(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.bS.set(enumitemslot.b(), itemstack);
    }

    protected float e(float f2, float f1) {
        boolean flag;
        float f22 = MathHelper.g(f2 - this.aV);
        this.aV += f22 * 0.3f;
        float f3 = MathHelper.g(this.dy() - this.aV);
        if (Math.abs(f3) > 50.0f) {
            this.aV += f3 - (float)(MathHelper.j((double)f3) * 50);
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            f1 *= -1.0f;
        }
        return f1;
    }

    /*
     * Unable to fully structure code
     */
    public void b_() {
        if (this.cb > 0) {
            --this.cb;
        }
        if (this.cU()) {
            this.bo = 0;
            this.f(this.dn(), this.dp(), this.dt());
        }
        if (this.bo > 0) {
            d0 = this.dn() + (this.bp - this.dn()) / (double)this.bo;
            d1 = this.dp() + (this.bq - this.dp()) / (double)this.bo;
            d2 = this.dt() + (this.br - this.dt()) / (double)this.bo;
            d3 = MathHelper.d(this.bs - (double)this.dy());
            this.a_(this.dy() + (float)d3 / (float)this.bo);
            this.b_(this.dA() + (float)(this.bt - (double)this.dA()) / (float)this.bo);
            --this.bo;
            this.e(d0, d1, d2);
            this.a(this.dy(), this.dA());
        } else if (!this.cV()) {
            this.f(this.dl().a(0.98));
        }
        if (this.bv > 0) {
            this.aX += (float)MathHelper.d(this.bu - (double)this.aX) / (float)this.bv;
            --this.bv;
        }
        vec3d = this.dl();
        d4 = vec3d.c;
        d5 = vec3d.d;
        d6 = vec3d.e;
        if (Math.abs(vec3d.c) < 0.003) {
            d4 = 0.0;
        }
        if (Math.abs(vec3d.d) < 0.003) {
            d5 = 0.0;
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d6 = 0.0;
        }
        this.o(d4, d5, d6);
        this.dI().ad().a("ai");
        SpigotTimings.timerEntityAI.startTiming();
        if (this.eT()) {
            this.bk = false;
            this.bl = 0.0f;
            this.bn = 0.0f;
        } else if (this.cV()) {
            this.dI().ad().a("newAi");
            this.fc();
            this.dI().ad().c();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        this.dI().ad().c();
        this.dI().ad().a("jump");
        if (this.bk && this.dW()) {
            d7 = this.bi() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.aV() != false && d7 > 0.0;
            d8 = this.dc();
            if (flag && (!this.ay() || d7 > d8)) {
                this.c(TagsFluid.a);
            } else if (this.bi() && (!this.ay() || d7 > d8)) {
                this.c(TagsFluid.b);
            } else if ((this.ay() || flag && d7 <= d8) && this.cb == 0) {
                this.eW();
                this.cb = 10;
            }
        } else {
            this.cb = 0;
        }
        this.dI().ad().c();
        this.dI().ad().a("travel");
        this.bl *= 0.98f;
        this.bn *= 0.98f;
        this.C();
        axisalignedbb = this.cE();
        vec3d1 = new Vec3D(this.bl, this.bm, this.bn);
        if (this.a(MobEffects.B) || this.a(MobEffects.y)) {
            this.n();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.cL();
        if (!(entityliving instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bs()) {
            this.c(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.h(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        this.dI().ad().c();
        this.dI().ad().a("freezing");
        if (!this.dI().B && !this.es()) {
            i = this.cg();
            if (this.az && this.dw()) {
                this.k(Math.min(this.cj(), i + 1));
            } else {
                this.k(Math.max(0, i - 2));
            }
        }
        this.dT();
        this.dU();
        if (!this.dI().B && this.ag % 40 == 0 && this.ci() && this.dw()) {
            this.a(this.dJ().t(), 1.0f);
        }
        this.dI().ad().c();
        this.dI().ad().a("push");
        if (this.bz > 0) {
            --this.bz;
            this.a(axisalignedbb, this.cE());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.fd();
        SpigotTimings.timerEntityAICollision.stopTiming();
        this.dI().ad().c();
        if (!this.dI().B && this.fb() && this.aX()) {
            this.a(this.dJ().h(), 1.0f);
        }
    }

    public boolean fb() {
        return false;
    }

    private void C() {
        boolean flag = this.i(7);
        if (flag && !this.ay() && !this.bM() && !this.a(MobEffects.y)) {
            ItemStack itemstack = this.c(EnumItemSlot.e);
            if (itemstack.a(Items.nh) && ItemElytra.d(itemstack)) {
                flag = true;
                int i2 = this.by + 1;
                if (!this.dI().B && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.e));
                    }
                    this.a(GameEvent.n);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.dI().B && flag != this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.b(7, flag);
        }
    }

    protected void fc() {
    }

    protected void fd() {
        if (this.dI().r_()) {
            this.dI().a(EntityTypeTest.a(EntityHuman.class), this.cE(), IEntitySelector.a(this)).forEach(this::A);
        } else {
            List<Entity> list = this.dI().a((Entity)this, this.cE(), IEntitySelector.a(this));
            if (!list.isEmpty()) {
                int j2;
                int i2 = this.dI().X().c(GameRules.t);
                if (i2 > 0 && list.size() > i2 - 1 && this.af.a(4) == 0) {
                    j2 = 0;
                    int k2 = 0;
                    while (k2 < list.size()) {
                        if (!list.get(k2).bM()) {
                            ++j2;
                        }
                        ++k2;
                    }
                    if (j2 > i2 - 1) {
                        this.a(this.dJ().g(), 6.0f);
                    }
                }
                j2 = 0;
                while (j2 < list.size()) {
                    Entity entity = list.get(j2);
                    this.A(entity);
                    ++j2;
                }
            }
        }
    }

    protected void a(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.b(axisalignedbb1);
        List<Entity> list = this.dI().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            int i2 = 0;
            while (i2 < list.size()) {
                Entity entity = list.get(i2);
                if (entity instanceof EntityLiving) {
                    this.g((EntityLiving)entity);
                    this.bz = 0;
                    this.f(this.dl().a(-0.2));
                    break;
                }
                ++i2;
            }
        } else if (this.O) {
            this.bz = 0;
        }
        if (!this.dI().B && this.bz <= 0) {
            this.c(4, false);
        }
    }

    protected void A(Entity entity) {
        entity.g(this);
    }

    protected void g(EntityLiving entityliving) {
    }

    public boolean fe() {
        return (this.am.b(u) & 4) != 0;
    }

    @Override
    public void Y() {
        Entity entity = this.cW();
        super.Y();
        if (entity != null && entity != this.cW() && !this.dI().B) {
            this.a(entity);
        }
    }

    @Override
    public void bv() {
        super.bv();
        this.bd = this.be;
        this.be = 0.0f;
        this.n();
    }

    @Override
    public void a(double d0, double d1, double d2, float f2, float f1, int i2, boolean flag) {
        this.bp = d0;
        this.bq = d1;
        this.br = d2;
        this.bs = f2;
        this.bt = f1;
        this.bo = i2;
    }

    @Override
    public void a(float f2, int i2) {
        this.bu = f2;
        this.bv = i2;
    }

    public void r(boolean flag) {
        this.bk = flag;
    }

    public void a(EntityItem entityitem) {
        Entity entity = entityitem.v();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.O.a((EntityPlayer)entity, entityitem.j(), this);
        }
    }

    public void a(Entity entity, int i2) {
        if (!entity.dD() && !this.dI().B && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dI()).k().b(entity, new PacketPlayOutCollect(entity.af(), this.af(), i2));
        }
    }

    public boolean B(Entity entity) {
        if (entity.dI() != this.dI()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dn(), this.dr(), this.dt());
        Vec3D vec3d1 = new Vec3D(entity.dn(), entity.dr(), entity.dt());
        return vec3d1.f(vec3d) > 128.0 ? false : this.dI().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float h(float f2) {
        return f2 == 1.0f ? this.aX : MathHelper.i(f2, this.aY, this.aX);
    }

    public float x(float f2) {
        float f1 = this.aP - this.aO;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aO + f1 * f2;
    }

    @Override
    public boolean bo() {
        return !this.dD() && this.collides;
    }

    @Override
    public boolean bp() {
        return this.bs() && !this.G_() && !this.i_() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bp() && this.collides != this.collidableExemptions.contains(entity.ct());
    }

    @Override
    public float cm() {
        return this.aX;
    }

    @Override
    public void n(float f2) {
        this.aX = f2;
    }

    @Override
    public void o(float f2) {
        this.aV = f2;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.i(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D i(Vec3D vec3d) {
        return new Vec3D(vec3d.c, vec3d.d, 0.0);
    }

    public float ff() {
        return this.cc;
    }

    public void y(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.cc = f2;
    }

    public void Q_() {
    }

    public void F_() {
    }

    protected void fg() {
        this.bV = true;
    }

    public abstract EnumMainHand fh();

    public boolean fi() {
        return (this.am.b(u) & 1) > 0;
    }

    public EnumHand fj() {
        return (this.am.b(u) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void D() {
        if (this.fi()) {
            if (ItemStack.b(this.b(this.fj()), this.bw)) {
                this.bw = this.b(this.fj());
                this.a(this.bw);
            } else {
                this.fo();
            }
        }
    }

    protected void a(ItemStack itemstack) {
        itemstack.b(this.dI(), this, this.fl());
        if (this.E()) {
            this.b(itemstack, 5);
        }
        if (--this.bx == 0 && !this.dI().B && !itemstack.t()) {
            this.Z_();
        }
    }

    private boolean E() {
        int i2 = this.fl();
        FoodInfo foodinfo = this.bw.d().v();
        boolean flag = foodinfo != null && foodinfo.e();
        return (flag |= i2 <= this.bw.r() - 7) && i2 % 4 == 0;
    }

    private void G() {
        this.ci = this.ch;
        this.ch = this.bX() ? Math.min(1.0f, this.ch + 0.09f) : Math.max(0.0f, this.ch - 0.09f);
    }

    protected void c(int i2, boolean flag) {
        byte b0 = this.am.b(u);
        int j2 = flag ? b0 | i2 : b0 & ~i2;
        this.am.b(u, (byte)j2);
    }

    public void c(EnumHand enumhand) {
        ItemStack itemstack = this.b(enumhand);
        if (!itemstack.b() && !this.fi()) {
            this.bw = itemstack;
            this.bx = itemstack.r();
            if (!this.dI().B) {
                this.c(1, true);
                this.c(2, enumhand == EnumHand.b);
                this.a(GameEvent.E);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (bN.equals(datawatcherobject)) {
            if (this.dI().B) {
                this.fw().ifPresent(this::a);
            }
        } else if (u.equals(datawatcherobject) && this.dI().B) {
            if (this.fi() && this.bw.b()) {
                this.bw = this.b(this.fj());
                if (!this.bw.b()) {
                    this.bx = this.bw.r();
                }
            } else if (!this.fi() && !this.bw.b()) {
                this.bw = ItemStack.b;
                this.bx = 0;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.aY = this.aX;
        this.aW = this.aV = this.aX;
    }

    protected void b(ItemStack itemstack, int i2) {
        if (!itemstack.b() && this.fi()) {
            if (itemstack.s() == EnumAnimation.c) {
                this.a(this.c(itemstack), 0.5f, this.dI().z.i() * 0.1f + 0.9f);
            }
            if (itemstack.s() == EnumAnimation.b) {
                this.a(itemstack, i2);
                this.a(this.d(itemstack), 0.5f + 0.5f * (float)this.af.a(2), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
            }
        }
    }

    private void a(ItemStack itemstack, int i2) {
        int j2 = 0;
        while (j2 < i2) {
            Vec3D vec3d = new Vec3D(((double)this.af.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dA() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dy() * ((float)Math.PI / 180));
            double d0 = (double)(-this.af.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.af.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dA() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dy() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dn(), this.dr(), this.dt());
            this.dI().a(new ParticleParamItem(Particles.O, itemstack), vec3d1.c, vec3d1.d, vec3d1.e, vec3d.c, vec3d.d + 0.05, vec3d.e);
            ++j2;
        }
    }

    protected void Z_() {
        if (!this.dI().B || this.fi()) {
            EnumHand enumhand = this.fj();
            if (!this.bw.equals(this.b(enumhand))) {
                this.fn();
            } else if (!this.bw.b() && this.fi()) {
                ItemStack itemstack;
                this.b(this.bw, 16);
                if (this instanceof EntityPlayer) {
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bw);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        ((EntityPlayer)this).getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bw.a(this.dI(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dI(), this);
                } else {
                    itemstack = this.bw.a(this.dI(), this);
                }
                if (itemstack != this.bw) {
                    this.a(enumhand, itemstack);
                }
                this.fo();
            }
        }
    }

    public ItemStack fk() {
        return this.bw;
    }

    public int fl() {
        return this.bx;
    }

    public int fm() {
        return this.fi() ? this.bw.r() - this.fl() : 0;
    }

    public void fn() {
        if (!this.bw.b()) {
            this.bw.a(this.dI(), this, this.fl());
            if (this.bw.t()) {
                this.D();
            }
        }
        this.fo();
    }

    public void fo() {
        if (!this.dI().B) {
            boolean flag = this.fi();
            this.c(1, false);
            if (flag) {
                this.a(GameEvent.D);
            }
        }
        this.bw = ItemStack.b;
        this.bx = 0;
    }

    public boolean fp() {
        if (this.fi() && !this.bw.b()) {
            net.minecraft.world.item.Item item = this.bw.d();
            return item.c(this.bw) != EnumAnimation.d ? false : item.b(this.bw) - this.bx >= 5;
        }
        return false;
    }

    public boolean fq() {
        return this.bP();
    }

    public boolean fr() {
        return this.i(7);
    }

    @Override
    public boolean bX() {
        return super.bX() || !this.fr() && this.c(EntityPose.b);
    }

    public int fs() {
        return this.by;
    }

    public boolean b(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dn();
        double d4 = this.dp();
        double d5 = this.dt();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.dI();
        if (world.A(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.C_()) {
                BlockPosition blockposition1 = blockposition.d();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.e(d0, d6, d2);
                if (world.g(this) && !world.d(this.cE())) {
                    flag1 = true;
                }
                this.e(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dI().getWorld(), d3, d4, d5), new Location((World)this.dI().getWorld(), d0, d6, d2));
                        this.dI().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (((EntityPlayer)this).c.teleport(d0, d6, d2, this.dy(), this.dA(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        ((EntityCreature)this).J().n();
        return Optional.of(true);
    }

    public boolean ft() {
        return true;
    }

    public boolean fu() {
        return true;
    }

    public void a(BlockPosition blockposition, boolean flag) {
    }

    public boolean f(ItemStack itemstack) {
        return false;
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.c ? aE : super.a(entitypose).a(this.dV());
    }

    public ImmutableList<EntityPose> fv() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB g(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        return new AxisAlignedBB(-entitysize.a / 2.0f, 0.0, -entitysize.a / 2.0f, entitysize.a / 2.0f, entitysize.b, entitysize.a / 2.0f);
    }

    @Override
    public boolean cq() {
        return super.cq() && !this.fy();
    }

    public Optional<BlockPosition> fw() {
        return this.am.b(bN);
    }

    public void g(BlockPosition blockposition) {
        this.am.b(bN, Optional.of(blockposition));
    }

    public void fx() {
        this.am.b(bN, Optional.empty());
    }

    public boolean fy() {
        return this.fw().isPresent();
    }

    public void b(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.bM()) {
            this.Y();
        }
        if ((iblockdata = this.dI().a_(blockposition)).b() instanceof BlockBed) {
            this.dI().a(blockposition, (IBlockData)iblockdata.a(BlockBed.b, true), 3);
        }
        this.b(EntityPose.c);
        this.a(blockposition);
        this.g(blockposition);
        this.f(Vec3D.b);
        this.at = true;
    }

    private void a(BlockPosition blockposition) {
        this.e((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.6875, (double)blockposition.w() + 0.5);
    }

    private boolean I() {
        return this.fw().map(blockposition -> this.dI().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fz() {
        Optional<BlockPosition> optional = this.fw();
        net.minecraft.world.level.World world = this.dI();
        Objects.requireNonNull(world);
        optional.filter(world::A).ifPresent(blockposition -> {
            IBlockData iblockdata = this.dI().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.c(BlockBed.aC);
                this.dI().a((BlockPosition)blockposition, (IBlockData)iblockdata.a(BlockBed.b, false), 3);
                Vec3D vec3d = BlockBed.a(this.ae(), (ICollisionAccess)this.dI(), blockposition, enumdirection, this.dy()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.c();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                this.e(vec3d.c, vec3d.d, vec3d.e);
                this.a_(f2);
                this.b_(0.0f);
            }
        });
        Vec3D vec3d = this.dg();
        this.b(EntityPose.a);
        this.e(vec3d.c, vec3d.d, vec3d.e);
        this.fx();
    }

    @Nullable
    public EnumDirection fA() {
        BlockPosition blockposition = this.fw().orElse(null);
        return blockposition != null ? BlockBed.a(this.dI(), blockposition) : null;
    }

    @Override
    public boolean bt() {
        return !this.fy() && super.bt();
    }

    @Override
    protected final float a(EntityPose entitypose, EntitySize entitysize) {
        return entitypose == EntityPose.c ? 0.2f : this.b(entitypose, entitysize);
    }

    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return super.a(entitypose, entitysize);
    }

    public ItemStack g(ItemStack itemstack) {
        return ItemStack.b;
    }

    public ItemStack a(net.minecraft.world.level.World world, ItemStack itemstack) {
        if (itemstack.M()) {
            world.a(null, this.dn(), this.dp(), this.dt(), this.d(itemstack), SoundCategory.g, 1.0f, 1.0f + (world.z.i() - world.z.i()) * 0.4f);
            this.a(itemstack, world, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).fO().d) {
                itemstack.h(1);
            }
            this.a(GameEvent.m);
        }
        return itemstack;
    }

    private void a(ItemStack itemstack, net.minecraft.world.level.World world, EntityLiving entityliving) {
        net.minecraft.world.item.Item item = itemstack.d();
        if (item.u()) {
            List<Pair<MobEffect, Float>> list = item.v().f();
            for (Pair<MobEffect, Float> pair : list) {
                if (world.B || pair.getFirst() == null || !(world.z.i() < ((Float)pair.getSecond()).floatValue())) continue;
                entityliving.addEffect(new MobEffect((MobEffect)pair.getFirst()), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    private static byte g(EnumItemSlot enumitemslot) {
        switch (enumitemslot) {
            case a: {
                return 47;
            }
            case b: {
                return 48;
            }
            case f: {
                return 49;
            }
            case e: {
                return 50;
            }
            case c: {
                return 52;
            }
            case d: {
                return 51;
            }
        }
        return 47;
    }

    public void d(EnumItemSlot enumitemslot) {
        this.dI().a((Entity)this, EntityLiving.g(enumitemslot));
    }

    public void d(EnumHand enumhand) {
        this.d(enumhand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b);
    }

    @Override
    public AxisAlignedBB j_() {
        if (this.c(EnumItemSlot.f).a(Items.tw)) {
            float f2 = 0.5f;
            return this.cE().c(0.5, 0.5, 0.5);
        }
        return super.j_();
    }

    public static EnumItemSlot h(ItemStack itemstack) {
        Equipable equipable = Equipable.c_(itemstack);
        return equipable != null ? equipable.g() : EnumItemSlot.a;
    }

    private static SlotAccess a(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.f && enumitemslot != EnumItemSlot.a && enumitemslot != EnumItemSlot.b ? SlotAccess.a(entityliving, enumitemslot, itemstack -> itemstack.b() || EntityInsentient.h(itemstack) == enumitemslot) : SlotAccess.a(entityliving, enumitemslot);
    }

    @Nullable
    private static EnumItemSlot r(int i2) {
        return i2 == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (i2 == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (i2 == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (i2 == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (i2 == 98 ? EnumItemSlot.a : (i2 == 99 ? EnumItemSlot.b : null)))));
    }

    @Override
    public SlotAccess a_(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.r(i2);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(i2);
    }

    @Override
    public boolean dw() {
        boolean flag;
        if (this.G_()) {
            return false;
        }
        boolean bl = flag = !this.c(EnumItemSlot.f).a(TagsItem.az) && !this.c(EnumItemSlot.e).a(TagsItem.az) && !this.c(EnumItemSlot.d).a(TagsItem.az) && !this.c(EnumItemSlot.c).a(TagsItem.az);
        return flag && super.dw();
    }

    @Override
    public boolean ca() {
        return !this.dI().r_() && this.a(MobEffects.x) || super.ca();
    }

    @Override
    public float dz() {
        return this.aV;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.e();
        double d1 = packetplayoutspawnentity.f();
        double d2 = packetplayoutspawnentity.g();
        float f2 = packetplayoutspawnentity.l();
        float f1 = packetplayoutspawnentity.k();
        this.f(d0, d1, d2);
        this.aV = packetplayoutspawnentity.m();
        this.aX = packetplayoutspawnentity.m();
        this.aW = this.aV;
        this.aY = this.aX;
        this.e(packetplayoutspawnentity.a());
        this.a_(packetplayoutspawnentity.c());
        this.a(d0, d1, d2, f2, f1);
        this.o(packetplayoutspawnentity.h(), packetplayoutspawnentity.i(), packetplayoutspawnentity.j());
    }

    public boolean fB() {
        return this.eO().d() instanceof ItemAxe;
    }

    @Override
    public float dC() {
        float f2 = super.dC();
        return this.cL() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    private static class ProcessableEffect {
        private MobEffectList type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(MobEffectList type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, object);
        }
    }
}

